/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.mqtt;

import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.data.Device;
import de.kosmos_lab.platform.exceptions.DeviceAlreadyExistsException;
import de.kosmos_lab.platform.exceptions.DeviceNotFoundException;
import de.kosmos_lab.platform.exceptions.NoAccessToScope;
import de.kosmos_lab.platform.exceptions.SchemaNotFoundException;
import de.kosmos_lab.platform.smarthome.CommandInterface;
import de.kosmos_lab.platform.smarthome.CommandSourceName;
import de.kosmos_lab.web.data.IUser;
import de.kosmos_lab.web.exceptions.ParameterNotFoundException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.moquette.broker.Server;
import io.moquette.broker.config.IConfig;
import io.moquette.broker.config.MemoryConfig;
import io.moquette.broker.security.IAuthenticator;
import io.moquette.broker.security.IAuthorizatorPolicy;
import io.moquette.broker.subscriptions.Topic;
import io.moquette.interception.AbstractInterceptHandler;
import io.moquette.interception.messages.InterceptPublishMessage;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.mqtt.MqttMessageBuilders;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.everit.json.schema.ValidationException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MQTTBroker
implements CommandInterface,
IAuthenticator,
IAuthorizatorPolicy {
    private static final String pre = "kosmos/";
    private static final Logger logger = LoggerFactory.getLogger((String)"MQTTBroker");
    private static final Pattern re_set = Pattern.compile("^kosmos/(?<uuid>[\\w ]*)/set$");
    private static final Pattern re_state = Pattern.compile("^kosmos/(?<uuid>[\\w ]*)/state$");
    private static final Pattern re_config = Pattern.compile("^kosmos/(?<uuid>[\\w ]*)/config$");
    private static final Pattern re_location = Pattern.compile("^kosmos/(?<uuid>[\\w ]*)/location$");
    private static final Pattern re_key_set = Pattern.compile("^kosmos/(?<uuid>.*)/(?<key>.*)/set$");
    private static final Pattern re_key_state = Pattern.compile("^kosmos/(?<uuid>.*)/(?<key>.*)/state$");
    private static IController controller;
    private static Server mqttBroker;
    private int port;
    public HashMap<Device, String> stateTopic = new HashMap();
    public HashMap<Device, String> setTopic = new HashMap();

    public MQTTBroker() {
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD", "ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public MQTTBroker(IController c) throws IOException {
        controller = c;
        MemoryConfig config = new MemoryConfig(new Properties());
        config.setProperty("allow_anonymous", "false");
        config.setProperty("authenticator_class", "de.kosmos_lab.kosmos.controller.mqtt.MQTTBroker");
        config.setProperty("authorizator_class", "de.kosmos_lab.kosmos.controller.mqtt.MQTTBroker");
        this.port = controller.getConfig().getJSONObject("mqtt").getInt("port");
        config.setProperty("port", String.valueOf(this.port));
        mqttBroker = new Server();
        List<PublisherListener> userHandlers = Collections.singletonList(new PublisherListener(this));
        mqttBroker.startServer((IConfig)config, userHandlers);
        c.addCommandInterface(this);
    }

    public void addDeviceTopics(Device device, String setTopic, String stateTopic) {
        this.stateTopic.put(device, stateTopic);
        this.setTopic.put(device, setTopic);
    }

    public boolean canRead(Topic topic, String user, String client) {
        logger.info("check if {} can read {} ", (Object)user, (Object)topic.toString());
        Matcher m = re_state.matcher(topic.toString());
        if (m.matches()) {
            try {
                Device d = controller.getDevice(m.group("uuid"));
                try {
                    if (d.canWrite(controller.getUser(user))) {
                        return true;
                    }
                }
                catch (NoAccessToScope noAccessToScope) {}
            }
            catch (DeviceNotFoundException d) {
                // empty catch block
            }
            return false;
        }
        m = re_key_state.matcher(topic.toString());
        if (m.matches()) {
            try {
                Device d = controller.getDevice(m.group("uuid"));
                try {
                    if (d.canWrite(controller.getUser(user))) {
                        return true;
                    }
                }
                catch (NoAccessToScope noAccessToScope) {}
            }
            catch (DeviceNotFoundException d) {
                // empty catch block
            }
            return false;
        }
        m = re_location.matcher(topic.toString());
        if (m.matches()) {
            try {
                Device d = controller.getDevice(m.group("uuid"));
                try {
                    if (d.canWrite(controller.getUser(user))) {
                        return true;
                    }
                }
                catch (NoAccessToScope noAccessToScope) {}
            }
            catch (DeviceNotFoundException deviceNotFoundException) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public boolean canWrite(Topic topic, String user, String client) {
        if (topic.equals((Object)"device/locations")) {
            return true;
        }
        Matcher m = re_set.matcher(topic.toString());
        if (m.matches()) {
            try {
                Device d = controller.getDevice(m.group("uuid"));
                try {
                    if (d.canWrite(controller.getUser(user))) {
                        return true;
                    }
                }
                catch (NoAccessToScope noAccessToScope) {
                    logger.warn("User {} tried to write to topic {}", (Object)user, (Object)topic);
                }
            }
            catch (DeviceNotFoundException d) {
                // empty catch block
            }
            return false;
        }
        m = re_key_set.matcher(topic.toString());
        if (m.matches()) {
            try {
                Device d = controller.getDevice(m.group("uuid"));
                try {
                    if (d.canWrite(controller.getUser(user))) {
                        return true;
                    }
                }
                catch (NoAccessToScope noAccessToScope) {
                    logger.warn("User {} tried to write to topic {}", (Object)user, (Object)topic);
                }
            }
            catch (DeviceNotFoundException d) {
                // empty catch block
            }
            return false;
        }
        m = re_config.matcher(topic.toString());
        if (m.matches()) {
            try {
                Device d = controller.getDevice(m.group("uuid"));
                try {
                    if (d.canWrite(controller.getUser(user))) {
                        return true;
                    }
                }
                catch (NoAccessToScope noAccessToScope) {
                    logger.warn("User {} tried to write to topic {}", (Object)user, (Object)topic);
                }
                return false;
            }
            catch (DeviceNotFoundException d) {
                // empty catch block
            }
        }
        if ((m = re_location.matcher(topic.toString())).matches()) {
            try {
                Device d = controller.getDevice(m.group("uuid"));
                try {
                    if (d.canWrite(controller.getUser(user))) {
                        return true;
                    }
                }
                catch (NoAccessToScope noAccessToScope) {
                    logger.warn("User {} tried to write to topic {}", (Object)user, (Object)topic);
                }
                return true;
            }
            catch (DeviceNotFoundException deviceNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean checkValid(String clientid, String username, byte[] bytes) {
        String password = new String(bytes, StandardCharsets.UTF_8);
        try {
            IUser u = controller.tryLogin(username, password);
            if (u != null) {
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    @Override
    public void deviceAdded(@CheckForNull CommandInterface from, Device device, CommandSourceName source) {
        String topic = pre + device.getUniqueID() + "/config";
        JSONObject obj = new JSONObject();
        obj.put("schema", (Object)device.getSchema().getId());
        String setTopic = pre + device.getUniqueID() + "/set";
        String stateTopic = pre + device.getUniqueID() + "/state";
        this.addDeviceTopics(device, setTopic, stateTopic);
        obj.put("set_topic", (Object)setTopic);
        obj.put("state_topic", (Object)stateTopic);
        this.publish(topic, obj.toString());
    }

    @Override
    public void deviceRemoved(@CheckForNull CommandInterface from, Device device, CommandSourceName source) {
        String topic = pre + device.getUniqueID() + "/config";
        this.publish(topic, "");
    }

    @Override
    public void deviceUpdate(@CheckForNull CommandInterface from, Device device, String key, CommandSourceName source) {
        String topic = pre + device.getUniqueID() + "/state";
        this.publish(topic, device.toJSON().toString());
        if (key != null) {
            Object value = device.opt(key);
            if (value != null) {
                this.publish(pre + device.getUniqueID() + "/" + key + "/state", value.toString());
            } else {
                this.publish(pre + device.getUniqueID() + "/" + key + "/state", "");
            }
        }
    }

    private IController getController() {
        return controller;
    }

    @Override
    public String getSourceName() {
        return "MQTTBroker";
    }

    private void publish(String topic, String payload) {
        MqttPublishMessage message = MqttMessageBuilders.publish().topicName(topic).retained(false).qos(MqttQoS.EXACTLY_ONCE).payload(Unpooled.copiedBuffer((byte[])payload.getBytes(StandardCharsets.UTF_8))).build();
        mqttBroker.internalPublish(message, "KosmoS");
    }

    @Override
    public void stop() {
        mqttBroker.stopServer();
    }

    public String toString() {
        return "MQTTBroker";
    }

    public int getPort() {
        return this.port;
    }

    static class PublisherListener
    extends AbstractInterceptHandler {
        private final MQTTBroker broker;

        public PublisherListener(MQTTBroker mqttBroker) {
            this.broker = mqttBroker;
        }

        public String getID() {
            return "EmbeddedLauncherPublishListener";
        }

        public CommandSourceName getSource(InterceptPublishMessage msg) {
            return this.broker.getController().getSource("MQTT:" + msg.getUsername());
        }

        private IUser getUser(InterceptPublishMessage msg) {
            return controller.getUser(msg.getUsername());
        }

        public void onPublish(InterceptPublishMessage msg) {
            try {
                JSONObject json;
                String uuid;
                Matcher m;
                String payload = msg.getPayload().toString(StandardCharsets.UTF_8);
                String topic = msg.getTopicName();
                logger.info("Received on topic: " + topic + " content: " + payload);
                if (topic.equals("device/locations")) {
                    try {
                        IUser user = this.getUser(msg);
                        for (Device device : controller.getAllDevices()) {
                            try {
                                Device.Location loc;
                                if (!device.canRead(user) || (loc = device.getLocation()) == null) continue;
                                this.broker.publish("device/" + device.getUniqueID() + "/location", loc.toJSON().toString());
                            }
                            catch (NoAccessToScope loc) {}
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if ((m = re_key_set.matcher(topic)).matches()) {
                    uuid = m.group("uuid");
                    String key = m.group("key");
                    Device device = controller.getDevice(uuid);
                    logger.info("matched set for {} {} {}", new Object[]{uuid, key, payload});
                    if (device != null) {
                        controller.updateFromSource((CommandInterface)this.broker, this.getSource(msg), device, m.group("key"), (Object)payload);
                    }
                    return;
                }
                m = re_set.matcher(topic);
                if (m.matches()) {
                    Device device;
                    uuid = m.group("uuid");
                    device = controller.getDevice(uuid);
                    if (device != null && payload.startsWith("{")) {
                        device.updateFromJSON(this.broker, new JSONObject(payload), this.getSource(msg));
                    }
                    return;
                }
                m = re_config.matcher(topic);
                if (m.matches()) {
                    uuid = m.group("uuid");
                    if (payload.startsWith("{")) {
                        json = new JSONObject(payload);
                        json.put("uuid", (Object)uuid);
                        try {
                            controller.parseAddDevice(this.broker, json, this.getSource(msg), this.getUser(msg));
                        }
                        catch (DeviceAlreadyExistsException e) {
                            e.printStackTrace();
                        }
                        catch (ParameterNotFoundException e) {
                            e.printStackTrace();
                        }
                        catch (SchemaNotFoundException e) {
                            e.printStackTrace();
                        }
                        catch (ValidationException e) {
                            e.printStackTrace();
                        }
                    }
                    return;
                }
                m = re_location.matcher(topic);
                if (m.matches()) {
                    uuid = m.group("uuid");
                    if (payload.startsWith("{")) {
                        json = new JSONObject(payload);
                        json.put("uuid", (Object)uuid);
                        try {
                            controller.setLocation(this.getUser(msg), json, this.getSource(msg));
                        }
                        catch (ParameterNotFoundException e) {
                            e.printStackTrace();
                        }
                        catch (ValidationException e) {
                            e.printStackTrace();
                        }
                        catch (NoAccessToScope noAccessToScope) {
                            noAccessToScope.printStackTrace();
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

