/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.web;

import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.client.HTTPClient;
import de.kosmos_lab.platform.web.IAuthProvider;
import de.kosmos_lab.web.data.IUser;
import de.kosmos_lab.web.exceptions.LoginFailedException;
import javax.annotation.Nonnull;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthAuthelia
implements IAuthProvider {
    public static final Logger logger = LoggerFactory.getLogger((String)"AuthAuthelia");
    private final IController controller;

    public AuthAuthelia(IController controller) {
        this.controller = controller;
    }

    public static IAuthProvider getInstance(IController controller) {
        JSONObject authelia = controller.getConfig().optJSONObject("authelia");
        if (authelia != null) {
            return new AuthAuthelia(controller);
        }
        throw new IllegalArgumentException("did not contain authelia configuration");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IUser tryLogin(@Nonnull String user, @Nonnull String password) throws LoginFailedException {
        logger.info("trying to login as {} with authelia", (Object)user);
        JSONObject authelia = this.controller.getConfig().optJSONObject("authelia");
        if (authelia == null) throw new IllegalArgumentException("did not contain authelia configuration");
        try {
            HTTPClient client = new HTTPClient();
            JSONObject ljson = new JSONObject();
            ljson.put("username", (Object)user);
            ljson.put("password", (Object)password);
            client.getProtocolHandlers().remove("www-authenticate");
            ContentResponse response = client.getResponse(String.format("%s/api/firstfactor", authelia.getString("server")), HttpMethod.POST, ljson);
            if (response == null) return null;
            String s = response.getContentAsString();
            JSONObject json = new JSONObject(s);
            if (!json.getString("status").equalsIgnoreCase("OK")) throw new LoginFailedException(json.getString("message"));
            return this.controller.getUserCreateIfUnavailable(String.format("authelia:%s", user));
        }
        catch (LoginFailedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

