/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.web.servlets.gesture;

import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.exceptions.GestureNotFoundException;
import de.kosmos_lab.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.platform.web.KosmoSWebServer;
import de.kosmos_lab.platform.web.servlets.KosmoSAuthedServlet;
import de.kosmos_lab.platform.web.servlets.gesture.GestureListServlet;
import de.kosmos_lab.web.annotations.Operation;
import de.kosmos_lab.web.annotations.enums.SchemaType;
import de.kosmos_lab.web.annotations.media.Content;
import de.kosmos_lab.web.annotations.media.ExampleObject;
import de.kosmos_lab.web.annotations.media.Schema;
import de.kosmos_lab.web.annotations.media.SchemaProperty;
import de.kosmos_lab.web.annotations.parameters.RequestBody;
import de.kosmos_lab.web.annotations.responses.ApiResponse;
import de.kosmos_lab.web.doc.openapi.ApiEndpoint;
import de.kosmos_lab.web.doc.openapi.ResponseCode;
import de.kosmos_lab.web.exceptions.ParameterNotFoundException;
import de.kosmos_lab.web.exceptions.UnauthorizedException;
import de.kosmos_lab.web.server.servlets.BaseServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.json.JSONArray;

@ApiEndpoint(path="/gesture/rename", userLevel=1)
public class GestureRenameServlet
extends KosmoSAuthedServlet {
    public GestureRenameServlet(KosmoSWebServer webServer, IController controller, int level) {
        super(webServer, controller, level);
    }

    @Override
    @Operation(tags={"gesture"}, summary="rename", description="Renames all instances of a gesture to a new name", requestBody=@RequestBody(required=true, content={@Content(mediaType="application/json", schemaProperties={@SchemaProperty(name="from", schema=@Schema(description="The old name of this gesture", type=SchemaType.STRING, minLength=1, required=true)), @SchemaProperty(name="to", schema=@Schema(description="The new name to use for this gesture", type=SchemaType.STRING, minLength=1, required=true))}, examples={@ExampleObject(name="from 'T' to 'capitalT'", value="{\"from\":\"T:\",\"to\":\"capitalT\"}")})}), responses={@ApiResponse(responseCode=@ResponseCode(statusCode=200), description="The gesture was added successfully", ref="#/components/responses/gestureList")})
    public void post(KosmoSHttpServletRequest request, HttpServletResponse response) throws IOException, ParameterNotFoundException, GestureNotFoundException, UnauthorizedException {
        String from = request.getString("from");
        String to = request.getString("to");
        if (this.controller.getGestureProvider().renameGesture(from, to)) {
            GestureRenameServlet.sendJSON((BaseServletRequest)request, (HttpServletResponse)response, (JSONArray)GestureListServlet.getGestureList(this.controller));
            return;
        }
        throw new GestureNotFoundException(from);
    }
}

