/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.web.servlets.scope;

import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.data.Scope;
import de.kosmos_lab.platform.exceptions.NoAccessToScope;
import de.kosmos_lab.platform.exceptions.ScopeNotFoundException;
import de.kosmos_lab.platform.persistence.Constants;
import de.kosmos_lab.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.platform.web.KosmoSWebServer;
import de.kosmos_lab.platform.web.servlets.KosmoSAuthedServlet;
import de.kosmos_lab.web.annotations.Operation;
import de.kosmos_lab.web.annotations.Parameter;
import de.kosmos_lab.web.annotations.enums.ParameterIn;
import de.kosmos_lab.web.annotations.enums.SchemaType;
import de.kosmos_lab.web.annotations.media.ArraySchema;
import de.kosmos_lab.web.annotations.media.Content;
import de.kosmos_lab.web.annotations.media.ExampleObject;
import de.kosmos_lab.web.annotations.media.Schema;
import de.kosmos_lab.web.annotations.media.SchemaProperty;
import de.kosmos_lab.web.annotations.responses.ApiResponse;
import de.kosmos_lab.web.doc.openapi.ApiEndpoint;
import de.kosmos_lab.web.doc.openapi.ResponseCode;
import de.kosmos_lab.web.exceptions.ParameterNotFoundException;
import de.kosmos_lab.web.exceptions.UnauthorizedException;
import de.kosmos_lab.web.persistence.exceptions.NotFoundInPersistenceException;
import de.kosmos_lab.web.server.servlets.BaseServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.json.JSONObject;

@ApiEndpoint(path="/scope/get", userLevel=1)
@ApiResponse(componentName="scopeGet", responseCode=@ResponseCode(statusCode=204), description="Details about the scope", content={@Content(mediaType="application/json", examples={@ExampleObject(name="testScope", value="{\"name\":\"testScope\",\"id\":18,\"users\":[{\"name\":\"user7\",\"id\":7}],\"admins\":[{\"name\":\"admin\",\"id\":1}],\"adminGroups\":[],\"userGroups\":[{\"name\":\"testGroup2\",\"id\":2}]}")}, schemaProperties={@SchemaProperty(name="name", schema=@Schema(type=SchemaType.STRING, description="The name of the scope")), @SchemaProperty(name="id", schema=@Schema(type=SchemaType.INTEGER, description="The ID of the scope")), @SchemaProperty(name="admins", array=@ArraySchema(uniqueItems=true, arraySchema=@Schema(description="List of users with admin level access to the scope", ref="#/components/schemas/userNameID"))), @SchemaProperty(name="users", array=@ArraySchema(uniqueItems=true, arraySchema=@Schema(description="List of users with user level access to the scope", ref="#/components/schemas/userNameID"))), @SchemaProperty(name="userGroups", array=@ArraySchema(uniqueItems=true, arraySchema=@Schema(description="List of groups with user level access to the scope", ref="#/components/schemas/groupNameID"))), @SchemaProperty(name="adminGroups", array=@ArraySchema(uniqueItems=true, arraySchema=@Schema(description="List of groups with admin level access to the scope", ref="#/components/schemas/groupNameID")))})})
public class ScopeGetServlet
extends KosmoSAuthedServlet {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_ID = "id";

    public ScopeGetServlet(KosmoSWebServer webServer, IController controller, int level) {
        super(webServer, controller, level);
    }

    @Override
    @Operation(tags={"scope"}, summary="get", description="get information about the scope", parameters={@Parameter(in=ParameterIn.QUERY, name="name", schema=@Schema(type=SchemaType.STRING)), @Parameter(description="The ID of the scope to delete. Use either 'name' or 'id'.", in=ParameterIn.QUERY, name="id", schema=@Schema(type=SchemaType.INTEGER))}, responses={@ApiResponse(responseCode=@ResponseCode(statusCode=200), ref="#/components/responses/scopeGet")})
    public void get(KosmoSHttpServletRequest request, HttpServletResponse response) throws NoAccessToScope, ScopeNotFoundException, ParameterNotFoundException, UnauthorizedException, IOException {
        try {
            String sname = request.getString(FIELD_NAME);
            try {
                Scope scope = this.controller.getScope(sname, Constants.CacheMode.CACHE_AND_PERSISTENCE);
                ScopeGetServlet.sendJSON((BaseServletRequest)request, (HttpServletResponse)response, (JSONObject)scope.toJSON());
                return;
            }
            catch (NotFoundInPersistenceException ex) {
                throw new ScopeNotFoundException(sname);
            }
        }
        catch (ParameterNotFoundException sname) {
            int id = request.getInt(FIELD_ID);
            try {
                Scope scope = this.controller.getScope(id, Constants.CacheMode.CACHE_AND_PERSISTENCE);
                ScopeGetServlet.sendJSON((BaseServletRequest)request, (HttpServletResponse)response, (JSONObject)scope.toJSON());
            }
            catch (NotFoundInPersistenceException ex) {
                throw new ScopeNotFoundException("" + id);
            }
            return;
        }
    }
}

