/*
 * Decompiled with CFR 0.152.
 */
package de.kysy.simplefiledb;

import de.kysy.simplefiledb.DatabaseConfig;
import de.kysy.simplefiledb.DatabaseException;
import de.kysy.simplefiledb.IDatabase;
import de.kysy.simplefiledb.internal.Database;
import java.io.File;

public class DatabaseFactory {
    private DatabaseFactory() {
    }

    public static IDatabase getDatabase(File directory) throws DatabaseException {
        return DatabaseFactory.getDatabase(directory, DatabaseConfig.createDefault());
    }

    public static IDatabase getDatabase(File directory, DatabaseConfig config) throws DatabaseException {
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            throw new DatabaseException("Database directory is invalid");
        }
        return new Database(directory, config);
    }
}

