/*
 * Decompiled with CFR 0.152.
 */
package de.kysy.simplefiledb.internal;

import com.google.common.base.MoreObjects;
import de.kysy.simplefiledb.DatabaseException;
import de.kysy.simplefiledb.IEntity;
import de.kysy.simplefiledb.ITable;
import de.kysy.simplefiledb.internal.Table;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;

public class Entity
implements IEntity {
    private final Table table;
    private final Map<String, String> fields;
    private boolean modified;

    public Entity(Table table, Map<String, String> fields) {
        this.table = table;
        this.fields = fields;
    }

    @Override
    public <T> T beanify(Class<T> clazz) throws DatabaseException {
        try {
            T bean = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            for (String column : this.getTable().getColumns()) {
                PropertyUtils.setSimpleProperty(bean, (String)column, (Object)this.getValue(column));
            }
            return bean;
        }
        catch (InstantiationException e) {
            throw new DatabaseException("Beanify failed", e);
        }
        catch (IllegalAccessException e) {
            throw new DatabaseException("Beanify failed", e);
        }
        catch (NoSuchMethodException e) {
            throw new DatabaseException("Beanify failed", e);
        }
        catch (InvocationTargetException e) {
            throw new DatabaseException("Beanify failed", e);
        }
    }

    @Override
    public ITable getTable() {
        return this.table;
    }

    @Override
    public String getValue(String column) {
        if (!this.isColumnInTable(column)) {
            if (this.getTable().getDatabase().getConfig().getRequireColumnDeclaration()) {
                throw new RuntimeException("Column " + column + " does no exist in table");
            }
            return null;
        }
        return this.fields.get(column);
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void setModified(boolean modified) {
        this.modified = modified;
    }

    @Override
    public void setValue(String column, String value) {
        String oldValue;
        if (!this.isColumnInTable(column)) {
            if (this.getTable().getDatabase().getConfig().getRequireColumnDeclaration()) {
                throw new RuntimeException("Column " + column + " does no exist in table");
            }
            this.getTable().addColumn(column);
        }
        if ((oldValue = this.fields.put(column, value)) != null && !oldValue.equals(value) || oldValue == null && value != null) {
            this.modified = true;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Table", (Object)this.table).toString();
    }

    protected boolean isColumnInTable(String column) {
        return Arrays.asList(this.table.getColumns()).contains(column);
    }
}

