/*
 * Decompiled with CFR 0.152.
 */
package de.kysy.simplefiledb.internal;

import com.google.common.base.MoreObjects;
import de.kysy.simplefiledb.DatabaseException;
import de.kysy.simplefiledb.IDatabase;
import de.kysy.simplefiledb.IEntity;
import de.kysy.simplefiledb.ITable;
import de.kysy.simplefiledb.internal.Database;
import de.kysy.simplefiledb.internal.DatabaseUtil;
import de.kysy.simplefiledb.internal.Entity;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class Table
implements ITable {
    private final File file;
    private List<Entity> entityList;
    private String[] columns;
    private String name;
    private final IDatabase database;
    private boolean entityCountModified;
    private boolean columnsModified;

    public Table(Database database, File file) throws DatabaseException {
        this.database = database;
        this.file = file;
        this.columns = new String[0];
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new DatabaseException("Could not create table file", e);
            }
        }
        this.name = file.getName().replaceAll(".simplefiledb", "");
        this.entityList = new ArrayList<Entity>();
        try {
            String s;
            InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(file), this.getDatabase().getConfig().getEncoding());
            BufferedReader br = new BufferedReader(isr);
            boolean first = true;
            while ((s = br.readLine()) != null) {
                String splitter = Pattern.quote(this.getDatabase().getConfig().getFieldSeparator());
                String[] fields = s.split(splitter);
                if (first) {
                    this.columns = fields;
                    first = false;
                    continue;
                }
                this.entityList.add(new Entity(this, this.createEntityMap(fields)));
            }
            isr.close();
        }
        catch (FileNotFoundException e) {
            throw new DatabaseException("Table file not found", e);
        }
        catch (IOException e) {
            throw new DatabaseException("Table file access failed", e);
        }
    }

    @Override
    public void addColumn(String column) {
        this.columns = DatabaseUtil.concat(this.columns, new String[]{column});
        this.columnsModified = true;
    }

    @Override
    public IEntity createEntity() {
        Entity entity = new Entity(this, new HashMap<String, String>());
        this.entityList.add(entity);
        this.entityCountModified = true;
        return entity;
    }

    @Override
    public void ensureColumnsExist(String[] newColumns) {
        for (String newColumn : newColumns) {
            if (this.isColumnInTable(newColumn)) continue;
            this.addColumn(newColumn);
        }
    }

    @Override
    public IEntity[] getAll() {
        return this.entityList.toArray(new IEntity[0]);
    }

    @Override
    public IDatabase getDatabase() {
        return this.database;
    }

    @Override
    public String[] getColumns() {
        return this.columns;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IEntity simpleQuery(String column, String value) {
        if (!this.isColumnInTable(column)) {
            if (this.getDatabase().getConfig().getRequireColumnDeclaration()) {
                throw new RuntimeException("Column " + column + " does no exist in table");
            }
            this.addColumn(column);
        }
        for (Entity entity : this.entityList) {
            boolean comparisonByQValue;
            String queryValue = entity.getValue(column);
            boolean areBothNull = queryValue == null && value == null;
            boolean comparisonByValue = value != null && value.equals(queryValue);
            boolean bl = comparisonByQValue = queryValue != null && queryValue.equals(value);
            if (!areBothNull && !comparisonByValue && !comparisonByQValue) continue;
            return entity;
        }
        return null;
    }

    @Override
    public void flush() throws DatabaseException {
        try {
            FileWriter writer = new FileWriter(this.file);
            PrintWriter bw = new PrintWriter(writer);
            bw.println(this.makeColumnRow());
            for (IEntity iEntity : this.entityList) {
                bw.println(this.makeRow(iEntity));
                iEntity.setModified(false);
            }
            bw.close();
            this.entityCountModified = false;
            this.columnsModified = false;
        }
        catch (IOException e) {
            throw new DatabaseException("Failed to save table " + this.name, e);
        }
    }

    @Override
    public boolean isModified() {
        if (this.columnsModified) {
            return true;
        }
        if (this.entityCountModified) {
            return true;
        }
        for (Entity entity : this.entityList) {
            if (!entity.isModified()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Name", (Object)this.name).toString();
    }

    protected boolean isColumnInTable(String column) {
        return Arrays.asList(this.columns).contains(column);
    }

    private Map<String, String> createEntityMap(String[] fields) {
        int length = Math.min(this.columns.length, fields.length);
        if (fields.length > length) {
            // empty if block
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < length; ++i) {
            map.put(this.columns[i], fields[i]);
        }
        return map;
    }

    private String makeRow(IEntity entity) {
        String row = "";
        for (int i = 0; i < this.columns.length; ++i) {
            String field = entity.getValue(this.columns[i]);
            if (field == null) {
                field = "";
            }
            row = i == 0 ? field : row + this.getDatabase().getConfig().getFieldSeparator() + field;
        }
        return row;
    }

    private String makeColumnRow() {
        String row = "";
        for (int i = 0; i < this.columns.length; ++i) {
            row = i == 0 ? this.columns[i] : row + this.getDatabase().getConfig().getFieldSeparator() + this.columns[i];
        }
        return row;
    }
}

