/*
 * Decompiled with CFR 0.152.
 */
package de.kysy.simplefiledb.internal;

import com.google.common.base.MoreObjects;
import de.kysy.simplefiledb.DatabaseConfig;
import de.kysy.simplefiledb.DatabaseException;
import de.kysy.simplefiledb.IDatabase;
import de.kysy.simplefiledb.ITable;
import de.kysy.simplefiledb.internal.Table;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Map;

public class Database
implements IDatabase {
    public static final String EXTENSION = ".simplefiledb";
    private Map<String, Table> tableMap;
    private final File directory;
    private DatabaseConfig config;

    public Database(File directory, DatabaseConfig config) {
        File[] tableFiles;
        this.directory = directory;
        this.config = config;
        this.tableMap = new HashMap<String, Table>();
        for (File tableFile : tableFiles = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name != null && name.endsWith(Database.EXTENSION);
            }
        })) {
            try {
                Table table = new Table(this, tableFile);
                this.tableMap.put(table.getName(), table);
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
    }

    @Override
    public DatabaseConfig getConfig() {
        return this.config;
    }

    public File getDirectory() {
        return this.directory;
    }

    @Override
    public ITable[] getTables() {
        return this.tableMap.values().toArray(new ITable[0]);
    }

    @Override
    public ITable getTable(String name, boolean create) {
        Table table = this.tableMap.get(name);
        if (table == null && create) {
            File tableFile = new File(this.directory, name + EXTENSION);
            try {
                table = new Table(this, tableFile);
                this.tableMap.put(name, table);
            }
            catch (DatabaseException e) {
                return null;
            }
        }
        return table;
    }

    @Override
    public void flush() throws DatabaseException {
        for (Table table : this.tableMap.values()) {
            if (!table.isModified()) continue;
            table.flush();
        }
    }

    @Override
    public boolean isModified() {
        for (Table table : this.tableMap.values()) {
            if (!table.isModified()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Path", (Object)this.directory.getAbsolutePath()).add("Table count", this.tableMap.size()).toString();
    }
}

