/*
 * Decompiled with CFR 0.152.
 */
package de.labathome;

import de.labathome.namelist_variable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FortranNamelist {
    private String namelist;
    private String groupName;
    private Object parseInto;
    public boolean _debug = false;

    public FortranNamelist(String _namelist, String _groupName, Object _parseInto) {
        this.namelist = _namelist;
        this.groupName = _groupName.toLowerCase();
        this.parseInto = _parseInto;
    }

    public Object getParsed() {
        this.parseIt();
        return this.parseInto;
    }

    private void parseIt() {
        int lineEnd;
        if (this.namelist == null || this.namelist.equals("") || this.groupName == null || this.groupName.equals("") || this.parseInto == null) {
            throw new RuntimeException("FortranNamelist needs namelist and groupName and parseInto to be set!");
        }
        HashMap<String, String> names = new HashMap<String, String>();
        HashMap<String, String> types = new HashMap<String, String>();
        HashMap<String, Integer> dim0min = new HashMap<String, Integer>();
        HashMap<String, Integer> dim1min = new HashMap<String, Integer>();
        for (Field field : this.parseInto.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                for (Annotation annotation : field.getAnnotations()) {
                    String defaultName;
                    if (!(annotation instanceof namelist_variable)) continue;
                    namelist_variable nmlAnnotation = (namelist_variable)annotation;
                    String name = nmlAnnotation.name().toLowerCase();
                    if (name.equals((defaultName = (String)namelist_variable.class.getDeclaredMethod("name", new Class[0]).getDefaultValue()).toLowerCase())) {
                        name = field.getName().toLowerCase();
                    }
                    names.put(name, field.getName());
                    int dim0min_val = nmlAnnotation.dim0min();
                    int dim1min_val = nmlAnnotation.dim1min();
                    dim0min.put(name, dim0min_val);
                    dim1min.put(name, dim1min_val);
                    if (field.getType().equals(Integer.TYPE)) {
                        types.put(name, "0d:int");
                        continue;
                    }
                    if (field.getType().equals(int[].class)) {
                        types.put(name, "1d:int");
                        continue;
                    }
                    if (field.getType().equals(int[][].class)) {
                        types.put(name, "2d:int");
                        continue;
                    }
                    if (field.getType().equals(Double.TYPE)) {
                        types.put(name, "0d:double");
                        continue;
                    }
                    if (field.getType().equals(double[].class)) {
                        types.put(name, "1d:double");
                        continue;
                    }
                    if (field.getType().equals(double[][].class)) {
                        types.put(name, "2d:double");
                        continue;
                    }
                    if (field.getType().equals(String.class)) {
                        types.put(name, "0d:String");
                        continue;
                    }
                    if (field.getType().equals(String[].class)) {
                        types.put(name, "1d:String");
                        continue;
                    }
                    if (field.getType().equals(String[][].class)) {
                        types.put(name, "2d:String");
                        continue;
                    }
                    if (field.getType().equals(Boolean.TYPE)) {
                        types.put(name, "0d:boolean");
                        continue;
                    }
                    if (field.getType().equals(boolean[].class)) {
                        types.put(name, "1d:boolean");
                        continue;
                    }
                    if (field.getType().equals(boolean[][].class)) {
                        types.put(name, "2d:boolean");
                        continue;
                    }
                    System.out.println("Type of \"" + name + "\" was not recognized: " + field.getAnnotatedType());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this._debug) {
            System.out.println("Variable names to look for:");
            System.out.println(names.keySet());
            System.out.println("Types to parse them into:");
            System.out.println(types.values());
        }
        while (this.namelist.indexOf("!") > -1) {
            String commentRemoved;
            int commentStart = this.namelist.indexOf("!");
            lineEnd = this.namelist.indexOf("\n", commentStart);
            if (this._debug) {
                System.out.println("INFO: found !-comment from " + commentStart + " to " + lineEnd + ":");
                System.out.println(this.namelist.substring(commentStart, lineEnd + 1));
            }
            this.namelist = commentRemoved = this.namelist.substring(0, commentStart) + this.namelist.substring(lineEnd + 1);
        }
        while (this.namelist.indexOf("\nc ") > -1 || this.namelist.indexOf("\nc\r\n") > -1 || this.namelist.indexOf("\nc\n") > -1) {
            String commentRemoved;
            int commentStart = this.namelist.indexOf("\nc\n");
            lineEnd = commentStart + 1;
            if (commentStart < 0) {
                commentStart = this.namelist.indexOf("\nc\r\n");
                lineEnd = commentStart + 2;
            }
            if (commentStart < 0) {
                commentStart = this.namelist.indexOf("\nc ") + 1;
                lineEnd = this.namelist.indexOf("\n", commentStart);
            }
            if (this._debug) {
                System.out.println("INFO: found c-comment from " + commentStart + " to " + lineEnd + ":");
                System.out.println(this.namelist.substring(commentStart, lineEnd + 1));
            }
            this.namelist = commentRemoved = this.namelist.substring(0, commentStart) + this.namelist.substring(lineEnd + 1);
        }
        this.namelist = this.namelist.replace("\"", "'");
        int namelistStart = 0;
        int nameEnd = -1;
        boolean foundNamelist = false;
        while (!foundNamelist && namelistStart < this.namelist.length()) {
            if (this.namelist.substring(namelistStart = this.namelist.indexOf("&", namelistStart) + 1, nameEnd = this.namelist.indexOf("\n", namelistStart)).contains(" ")) {
                nameEnd = this.namelist.indexOf(" ", namelistStart);
            }
            String namelistName = this.namelist.substring(namelistStart, nameEnd).trim().toLowerCase();
            if (this._debug) {
                System.out.println("found namelist: " + namelistName);
            }
            if (namelistName.equals(this.groupName)) {
                foundNamelist = true;
                continue;
            }
            ++namelistStart;
        }
        if (foundNamelist) {
            int namelistEnd;
            boolean insideString = false;
            for (namelistEnd = nameEnd; namelistEnd < this.namelist.length(); ++namelistEnd) {
                String currentChar = this.namelist.substring(namelistEnd, namelistEnd + 1);
                if (currentChar.equals("'")) {
                    boolean bl = insideString = !insideString;
                }
                if (!insideString && currentChar.equals("/")) break;
            }
            String contents = this.namelist.substring(nameEnd, namelistEnd);
            Pattern floatingPointNumberPattern = Pattern.compile("^[-+]?[0-9]*(\\.)?[0-9]+([dDeE][-+]?[0-9]+)?");
            Pattern nextVarNamePattern = Pattern.compile("([a-z]+[0-9_]*[a-z_]*)\\s*(\\((\\s*[-+]?\\s*[0-9]+(\\s*:(\\s*[-+]?\\s*[0-9]+))*)?\\s*(,?(\\s*[-+]?\\s*[0-9]+(\\s*:(\\s*[-+]?\\s*[0-9]+))*))\\s*\\))?$");
            int i = 0;
            int last_i = 0;
            int var_counter = 0;
            String name = "";
            String val = "";
            while (i < contents.length()) {
                last_i = i;
                while (i < contents.length() && contents.charAt(i) != '=') {
                    ++i;
                }
                if (var_counter == 0) {
                    name = contents.substring(last_i, i).trim().toLowerCase();
                } else {
                    Field field;
                    String part = contents.substring(last_i, i).trim();
                    if (part.contains("'")) {
                        int begin = part.indexOf("'");
                        int end = part.indexOf("'", begin + 1);
                        String stringPart = part.substring(begin + 1, end);
                        if (part.substring(0, begin).trim().length() > 0) {
                            System.out.println("Something is wrong, why is there something between a \"=\" and a string start in the input file ?" + part.substring(0, begin));
                        } else {
                            val = stringPart.trim();
                            if (this._debug) {
                                System.out.println(name + " => \"" + val + "\"");
                            }
                            if (names.containsKey(name)) {
                                String fieldName = (String)names.get(name);
                                String type = (String)types.get(name);
                                if (this._debug) {
                                    System.out.println("interpret " + name + " as " + type);
                                }
                                if (type.equals("0d:String")) {
                                    try {
                                        field = this.parseInto.getClass().getDeclaredField(fieldName);
                                        field.setAccessible(true);
                                        field.set(this.parseInto, val);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                            if (end < part.length()) {
                                name = part.substring(end + 1).trim().toLowerCase();
                                if (name.startsWith(",")) {
                                    name = name.substring(1).trim();
                                }
                                if (this._debug) {
                                    System.out.println("next name: " + name);
                                }
                            }
                        }
                    } else if (part.toLowerCase().startsWith(".t") || part.toLowerCase().startsWith(".f")) {
                        String logicalPart;
                        int end = part.indexOf(".", 1);
                        val = logicalPart = part.substring(0, end + 1);
                        if (this._debug) {
                            System.out.println(name + " => \"" + val + "\"");
                        }
                        if (names.containsKey(name)) {
                            String fieldName = (String)names.get(name);
                            String type = (String)types.get(name);
                            if (this._debug) {
                                System.out.println("interpret " + name + " as " + type);
                            }
                            if (type.equals("0d:boolean")) {
                                boolean value = val.toLowerCase().startsWith(".t");
                                try {
                                    field = this.parseInto.getClass().getDeclaredField(fieldName);
                                    field.setAccessible(true);
                                    field.set(this.parseInto, value);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        if (end < part.length()) {
                            name = part.substring(end + 1).trim().toLowerCase();
                            if (name.startsWith(",")) {
                                name = name.substring(1).trim();
                            }
                            if (this._debug) {
                                System.out.println("next name: " + name);
                            }
                        }
                    } else if (part.toLowerCase().startsWith("t") || part.toLowerCase().startsWith("f")) {
                        val = part.toLowerCase().substring(0, 1);
                        if (this._debug) {
                            System.out.println(name + " => \"" + val + "\"");
                        }
                        if (names.containsKey(name)) {
                            String fieldName = (String)names.get(name);
                            String type = (String)types.get(name);
                            if (this._debug) {
                                System.out.println("interpret " + name + " as " + type);
                            }
                            if (type.equals("0d:boolean")) {
                                boolean value = val.toLowerCase().startsWith("t");
                                try {
                                    Field field2 = this.parseInto.getClass().getDeclaredField(fieldName);
                                    field2.setAccessible(true);
                                    field2.set(this.parseInto, value);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        if ((name = part.substring(1).trim().toLowerCase()).startsWith(",")) {
                            name = name.substring(1).trim();
                        }
                        if (this._debug) {
                            System.out.println("next name: " + name);
                        }
                    } else if (floatingPointNumberPattern.matcher(part.toLowerCase()).find()) {
                        int end;
                        block200: {
                            part = part.replace("\n", " ");
                            part = part.replace("\r", " ");
                            if (this._debug) {
                                System.out.println("found number(s) as value: " + part.toLowerCase());
                            }
                            end = part.length();
                            Matcher m = nextVarNamePattern.matcher(part.toLowerCase());
                            if (m.find()) {
                                end = m.start() - 1;
                                if (this._debug) {
                                    System.out.println("found next var name: " + part.substring(end));
                                }
                            }
                            if (end < 0) {
                                end = part.length();
                            }
                            val = part.toLowerCase().substring(0, end).trim();
                            val = val.replace("d", "e");
                            if ((val = val.replace("D", "e")).endsWith(",")) {
                                val = val.substring(0, val.length() - 1).trim();
                            }
                            if (val.endsWith(";")) {
                                val = val.substring(0, val.length() - 1).trim();
                            }
                            if (this._debug) {
                                System.out.println(name + " => \"" + val + "\"");
                            }
                            boolean multiIndex = val.contains("*");
                            boolean arrayIndexSpecifierFound = name.contains("(") && name.substring(name.indexOf("(") + 1).contains(")");
                            String indexString = "";
                            if (arrayIndexSpecifierFound) {
                                indexString = name.substring(name.indexOf("(") + 1, name.indexOf(")"));
                                name = name.substring(0, name.indexOf("(")).trim();
                                if (this._debug) {
                                    System.out.println(" ==> index in array \"" + indexString + "\"");
                                }
                            }
                            if (names.containsKey(name)) {
                                String fieldName = (String)names.get(name);
                                String type = (String)types.get(name);
                                if (this._debug) {
                                    System.out.println("interpret " + name + " as " + type);
                                }
                                try {
                                    int row;
                                    boolean atEnd;
                                    int idx;
                                    int numValues;
                                    int idx_col;
                                    int col;
                                    int col_end;
                                    int row_end;
                                    int cnt;
                                    int mi;
                                    int idx2;
                                    Object[] value;
                                    Field field3;
                                    if (type.equals("0d:int")) {
                                        int value2 = Integer.valueOf(val);
                                        Field field4 = this.parseInto.getClass().getDeclaredField(fieldName);
                                        field4.setAccessible(true);
                                        field4.set(this.parseInto, value2);
                                        break block200;
                                    }
                                    if (type.equals("0d:double")) {
                                        double value3 = Double.valueOf(val);
                                        field3 = this.parseInto.getClass().getDeclaredField(fieldName);
                                        field3.setAccessible(true);
                                        field3.set(this.parseInto, value3);
                                        break block200;
                                    }
                                    if (type.equals("1d:int")) {
                                        int dim0min_val = (Integer)dim0min.get(name);
                                        Field field5 = this.parseInto.getClass().getDeclaredField(fieldName);
                                        field5.setAccessible(true);
                                        value = (int[])field5.get(this.parseInto);
                                        if (arrayIndexSpecifierFound) {
                                            if (indexString.contains(",")) {
                                                if (this._debug) {
                                                    System.out.println("error: try to put value into 1d " + name + " at location indicated by more than one index: " + indexString);
                                                }
                                            } else if (indexString.contains(":")) {
                                                int idxEnd;
                                                String[] rowRangeParts = indexString.split(":");
                                                int idxStart = Integer.valueOf(rowRangeParts[0].trim());
                                                if (idxStart >= (idxEnd = Integer.valueOf(rowRangeParts[1].trim()).intValue())) {
                                                    System.out.println("error: start index >= end index in range specification for " + name + ": " + indexString);
                                                } else if (FortranNamelist.allowedArrayIndex(dim0min_val, value.length - 1 + dim0min_val, idxStart, name) && FortranNamelist.allowedArrayIndex(dim0min_val, value.length - 1 + dim0min_val, idxEnd, name)) {
                                                    for (idx2 = idxStart; idx2 <= idxEnd; ++idx2) {
                                                        value[idx2 - dim0min_val] = Integer.valueOf(val);
                                                    }
                                                }
                                            } else {
                                                int idx3 = Integer.valueOf(indexString.trim());
                                                if (FortranNamelist.allowedArrayIndex(dim0min_val, value.length - 1 + dim0min_val, idx3, name)) {
                                                    value[idx3 - dim0min_val] = Integer.valueOf(val);
                                                }
                                            }
                                        } else {
                                            int idx4;
                                            int[] flattened_value = null;
                                            if (multiIndex) {
                                                String[] inValues = val.split("[\\s,]+");
                                                int numValues2 = inValues.length;
                                                LinkedList<Integer> tempValues = new LinkedList<Integer>();
                                                for (int idx5 = 0; idx5 < numValues2; ++idx5) {
                                                    if (inValues[idx5].contains("*")) {
                                                        mi = Integer.valueOf(inValues[idx5].split("\\*")[0]);
                                                        int repeatedValue = Integer.valueOf(inValues[idx5].split("\\*")[1]);
                                                        for (int cnt2 = 0; cnt2 < mi; ++cnt2) {
                                                            tempValues.add(repeatedValue);
                                                        }
                                                        continue;
                                                    }
                                                    tempValues.add(Integer.valueOf(inValues[idx5]));
                                                }
                                                flattened_value = tempValues.stream().mapToInt(myint -> myint).toArray();
                                            } else {
                                                String[] arrayValues = val.split("[\\s,]+");
                                                flattened_value = new int[arrayValues.length];
                                                for (idx4 = 0; idx4 < arrayValues.length; ++idx4) {
                                                    flattened_value[idx4] = Integer.valueOf(arrayValues[idx4].trim());
                                                }
                                            }
                                            if (flattened_value.length <= value.length) {
                                                boolean atEnd2 = false;
                                                for (idx4 = 0; idx4 < value.length && !atEnd2; ++idx4) {
                                                    if (idx4 < flattened_value.length) {
                                                        value[idx4] = flattened_value[idx4];
                                                        continue;
                                                    }
                                                    atEnd2 = true;
                                                }
                                            } else {
                                                System.out.println("ERROR: too many values specified for " + name + ": " + flattened_value.length + " instead of " + value.length);
                                            }
                                        }
                                        field5.set(this.parseInto, value);
                                        break block200;
                                    }
                                    if (type.equals("1d:double")) {
                                        int dim0min_val = (Integer)dim0min.get(name);
                                        Field field6 = this.parseInto.getClass().getDeclaredField(fieldName);
                                        field6.setAccessible(true);
                                        value = (double[])field6.get(this.parseInto);
                                        if (arrayIndexSpecifierFound) {
                                            if (indexString.contains(",")) {
                                                if (this._debug) {
                                                    System.out.println("error: try to put value into 1d " + name + " at location indicated by more than one index: " + indexString);
                                                }
                                            } else if (indexString.contains(":")) {
                                                int idxEnd;
                                                String[] rowRangeParts = indexString.split(":");
                                                int idxStart = Integer.valueOf(rowRangeParts[0].trim());
                                                if (idxStart >= (idxEnd = Integer.valueOf(rowRangeParts[1].trim()).intValue())) {
                                                    System.out.println("error: start index >= end index in range specification for " + name + ": " + indexString);
                                                } else if (FortranNamelist.allowedArrayIndex(dim0min_val, value.length - 1 + dim0min_val, idxStart, name) && FortranNamelist.allowedArrayIndex(dim0min_val, value.length - 1 + dim0min_val, idxEnd, name)) {
                                                    for (idx2 = idxStart; idx2 <= idxEnd; ++idx2) {
                                                        value[idx2 - dim0min_val] = (int)Double.valueOf(val).doubleValue();
                                                    }
                                                }
                                            } else {
                                                int idx6 = Integer.valueOf(indexString.trim());
                                                if (FortranNamelist.allowedArrayIndex(dim0min_val, value.length - 1 + dim0min_val, idx6, name)) {
                                                    value[idx6 - dim0min_val] = (int)Double.valueOf(val).doubleValue();
                                                }
                                            }
                                        } else {
                                            int idx7;
                                            double[] flattened_value = null;
                                            if (multiIndex) {
                                                String[] inValues = val.split("[\\s,]+");
                                                int numValues3 = inValues.length;
                                                LinkedList<Double> tempValues = new LinkedList<Double>();
                                                for (int idx8 = 0; idx8 < numValues3; ++idx8) {
                                                    if (inValues[idx8].contains("*")) {
                                                        if (this._debug) {
                                                            System.out.println("INFO: found multi-index value: " + inValues[idx8]);
                                                        }
                                                        mi = Integer.valueOf(inValues[idx8].split("\\*")[0]);
                                                        double repeatedValue = Double.valueOf(inValues[idx8].split("\\*")[1]);
                                                        for (cnt = 0; cnt < mi; ++cnt) {
                                                            tempValues.add(repeatedValue);
                                                        }
                                                        continue;
                                                    }
                                                    tempValues.add(Double.valueOf(inValues[idx8]));
                                                }
                                                flattened_value = tempValues.stream().mapToDouble(mydbl -> mydbl).toArray();
                                            } else {
                                                String[] arrayValues = val.split("[\\s,]+");
                                                flattened_value = new double[arrayValues.length];
                                                for (idx7 = 0; idx7 < arrayValues.length; ++idx7) {
                                                    flattened_value[idx7] = Double.valueOf(arrayValues[idx7].trim());
                                                }
                                            }
                                            if (flattened_value.length <= value.length) {
                                                boolean atEnd3 = false;
                                                for (idx7 = 0; idx7 < value.length && !atEnd3; ++idx7) {
                                                    if (idx7 < flattened_value.length) {
                                                        value[idx7] = (int)flattened_value[idx7];
                                                        continue;
                                                    }
                                                    atEnd3 = true;
                                                }
                                            } else {
                                                System.out.println("ERROR: too many values specified for " + name + ": " + flattened_value.length + " instead of " + value.length);
                                            }
                                        }
                                        field6.set(this.parseInto, value);
                                        break block200;
                                    }
                                    if (type.equals("2d:int")) {
                                        int dim0min_val = (Integer)dim0min.get(name);
                                        int dim1min_val = (Integer)dim1min.get(name);
                                        field3 = this.parseInto.getClass().getDeclaredField(fieldName);
                                        field3.setAccessible(true);
                                        int[][] value4 = (int[][])field3.get(this.parseInto);
                                        if (arrayIndexSpecifierFound) {
                                            String[] strIndices = indexString.split("[\\s]*,");
                                            if (strIndices.length != 2) {
                                                if (this._debug) {
                                                    System.out.println("error: try to put value into 2d " + name + " at location indicated by more than two indices: " + indexString);
                                                }
                                            } else if (strIndices[0].contains(":") || strIndices[1].contains(":")) {
                                                int row_start = 0;
                                                row_end = 0;
                                                int col_start = 0;
                                                col_end = 0;
                                                if (strIndices[0].contains(":")) {
                                                    String[] rowRangeParts = strIndices[0].split(":");
                                                    row_start = Integer.valueOf(rowRangeParts[0].trim());
                                                    row_end = Integer.valueOf(rowRangeParts[1].trim());
                                                } else {
                                                    row_start = Integer.valueOf(strIndices[0].trim());
                                                    row_end = Integer.valueOf(strIndices[0].trim());
                                                }
                                                if (strIndices[1].contains(":")) {
                                                    String[] colRangeParts = strIndices[1].split(":");
                                                    col_start = Integer.valueOf(colRangeParts[0].trim());
                                                    col_end = Integer.valueOf(colRangeParts[1].trim());
                                                } else {
                                                    col_start = Integer.valueOf(strIndices[1].trim());
                                                    col_end = Integer.valueOf(strIndices[1].trim());
                                                }
                                                if (row_start >= row_end || col_start >= col_end) {
                                                    System.out.println("error: start index >= end index in range specification for " + name + ": " + indexString);
                                                } else if (FortranNamelist.allowedArrayIndex(dim0min_val, value4.length - 1 + dim0min_val, row_start, name) && FortranNamelist.allowedArrayIndex(dim0min_val, value4.length - 1 + dim0min_val, row_end, name) && FortranNamelist.allowedArrayIndex(dim1min_val, value4[0].length - 1 + dim1min_val, col_start, name) && FortranNamelist.allowedArrayIndex(dim1min_val, value4[0].length - 1 + dim1min_val, col_end, name)) {
                                                    for (int row2 = row_start; row2 <= row_end; ++row2) {
                                                        for (col = col_start; col <= col_end; ++col) {
                                                            value4[row2 - dim0min_val][col - dim1min_val] = Integer.valueOf(val);
                                                        }
                                                    }
                                                }
                                            } else {
                                                int idx_row = Integer.valueOf(strIndices[0].trim());
                                                idx_col = Integer.valueOf(strIndices[1].trim());
                                                if (FortranNamelist.allowedArrayIndex(dim0min_val, value4.length - 1 + dim0min_val, idx_row, name) && FortranNamelist.allowedArrayIndex(dim1min_val, value4[0].length - 1 + dim1min_val, idx_col, name)) {
                                                    value4[idx_row - dim0min_val][idx_col - dim1min_val] = Integer.valueOf(val);
                                                }
                                            }
                                        } else {
                                            int[] flattened_value = null;
                                            if (multiIndex) {
                                                String[] inValues = val.split("[\\s,]+");
                                                numValues = inValues.length;
                                                LinkedList<Integer> tempValues = new LinkedList<Integer>();
                                                for (idx = 0; idx < numValues; ++idx) {
                                                    if (inValues[idx].contains("*")) {
                                                        if (this._debug) {
                                                            System.out.println("INFO: found multi-index value: " + inValues[idx]);
                                                        }
                                                        int mi2 = Integer.valueOf(inValues[idx].split("\\*")[0]);
                                                        int repeatedValue = Integer.valueOf(inValues[idx].split("\\*")[1]);
                                                        for (cnt = 0; cnt < mi2; ++cnt) {
                                                            tempValues.add(repeatedValue);
                                                        }
                                                        continue;
                                                    }
                                                    tempValues.add(Integer.valueOf(inValues[idx]));
                                                }
                                                flattened_value = tempValues.stream().mapToInt(myint -> myint).toArray();
                                            } else {
                                                String[] arrayValues = val.split("[\\s,]+");
                                                flattened_value = new int[arrayValues.length];
                                                for (idx2 = 0; idx2 < arrayValues.length; ++idx2) {
                                                    flattened_value[idx2] = Integer.valueOf(arrayValues[idx2].trim());
                                                }
                                            }
                                            if (flattened_value.length <= value4.length * value4[0].length) {
                                                int flatIdx = 0;
                                                atEnd = false;
                                                for (int col2 = 0; col2 < value4[0].length && !atEnd; ++col2) {
                                                    for (row = 0; row < value4.length && !atEnd; ++row) {
                                                        if (flatIdx < flattened_value.length) {
                                                            value4[row][col2] = flattened_value[flatIdx++];
                                                            continue;
                                                        }
                                                        atEnd = true;
                                                    }
                                                }
                                            } else {
                                                System.out.println("ERROR: too many values specified for " + name + ": " + flattened_value.length + " instead of " + value4.length * value4[0].length);
                                            }
                                        }
                                        field3.set(this.parseInto, value4);
                                        break block200;
                                    }
                                    if (type.equals("2d:double")) {
                                        int dim0min_val = (Integer)dim0min.get(name);
                                        int dim1min_val = (Integer)dim1min.get(name);
                                        field3 = this.parseInto.getClass().getDeclaredField(fieldName);
                                        field3.setAccessible(true);
                                        double[][] value5 = (double[][])field3.get(this.parseInto);
                                        if (arrayIndexSpecifierFound) {
                                            String[] strIndices = indexString.split("[\\s]*,");
                                            if (strIndices.length != 2) {
                                                if (this._debug) {
                                                    System.out.println("error: try to put value into 2d " + name + " at location indicated by more than two indices: " + indexString);
                                                }
                                            } else if (strIndices[0].contains(":") || strIndices[1].contains(":")) {
                                                int row_start = 0;
                                                row_end = 0;
                                                int col_start = 0;
                                                col_end = 0;
                                                if (strIndices[0].contains(":")) {
                                                    String[] rowRangeParts = strIndices[0].split(":");
                                                    row_start = Integer.valueOf(rowRangeParts[0].trim());
                                                    row_end = Integer.valueOf(rowRangeParts[1].trim());
                                                } else {
                                                    row_start = Integer.valueOf(strIndices[0].trim());
                                                    row_end = Integer.valueOf(strIndices[0].trim());
                                                }
                                                if (strIndices[1].contains(":")) {
                                                    String[] colRangeParts = strIndices[1].split(":");
                                                    col_start = Integer.valueOf(colRangeParts[0].trim());
                                                    col_end = Integer.valueOf(colRangeParts[1].trim());
                                                } else {
                                                    col_start = Integer.valueOf(strIndices[1].trim());
                                                    col_end = Integer.valueOf(strIndices[1].trim());
                                                }
                                                if (row_start >= row_end || col_start >= col_end) {
                                                    System.out.println("error: start index >= end index in range specification for " + name + ": " + indexString);
                                                } else if (FortranNamelist.allowedArrayIndex(dim0min_val, value5.length - 1 + dim0min_val, row_start, name) && FortranNamelist.allowedArrayIndex(dim0min_val, value5.length - 1 + dim0min_val, row_end, name) && FortranNamelist.allowedArrayIndex(dim1min_val, value5[0].length - 1 + dim1min_val, col_start, name) && FortranNamelist.allowedArrayIndex(dim1min_val, value5[0].length - 1 + dim1min_val, col_end, name)) {
                                                    for (int row3 = row_start; row3 <= row_end; ++row3) {
                                                        for (col = col_start; col <= col_end; ++col) {
                                                            value5[row3 - dim0min_val][col - dim1min_val] = Double.valueOf(val);
                                                        }
                                                    }
                                                }
                                            } else {
                                                int idx_row = Integer.valueOf(strIndices[0].trim());
                                                idx_col = Integer.valueOf(strIndices[1].trim());
                                                if (FortranNamelist.allowedArrayIndex(0, value5.length - 1, idx_row - dim0min_val, name) && FortranNamelist.allowedArrayIndex(0, value5[0].length - 1, idx_col - dim1min_val, name)) {
                                                    value5[idx_row - dim0min_val][idx_col - dim1min_val] = Double.valueOf(val);
                                                }
                                            }
                                        } else {
                                            double[] flattened_value = null;
                                            if (multiIndex) {
                                                String[] inValues = val.split("[\\s,]+");
                                                numValues = inValues.length;
                                                LinkedList<Double> tempValues = new LinkedList<Double>();
                                                for (idx = 0; idx < numValues; ++idx) {
                                                    if (inValues[idx].contains("*")) {
                                                        if (this._debug) {
                                                            System.out.println("INFO: found multi-index value: " + inValues[idx]);
                                                        }
                                                        int mi3 = Integer.valueOf(inValues[idx].split("\\*")[0]);
                                                        double repeatedValue = Double.valueOf(inValues[idx].split("\\*")[1]);
                                                        for (int cnt3 = 0; cnt3 < mi3; ++cnt3) {
                                                            tempValues.add(repeatedValue);
                                                        }
                                                        continue;
                                                    }
                                                    tempValues.add(Double.valueOf(inValues[idx]));
                                                }
                                                flattened_value = tempValues.stream().mapToDouble(mydbl -> mydbl).toArray();
                                            } else {
                                                String[] arrayValues = val.split("[\\s,]+");
                                                flattened_value = new double[arrayValues.length];
                                                for (idx2 = 0; idx2 < arrayValues.length; ++idx2) {
                                                    flattened_value[idx2] = Double.valueOf(arrayValues[idx2].trim());
                                                }
                                            }
                                            if (flattened_value.length <= value5.length * value5[0].length) {
                                                int flatIdx = 0;
                                                atEnd = false;
                                                for (int col3 = 0; col3 < value5[0].length && !atEnd; ++col3) {
                                                    for (row = 0; row < value5.length && !atEnd; ++row) {
                                                        if (flatIdx < flattened_value.length) {
                                                            value5[row][col3] = flattened_value[flatIdx++];
                                                            continue;
                                                        }
                                                        atEnd = true;
                                                    }
                                                }
                                            } else {
                                                System.out.println("ERROR: too many values specified for " + name + ": " + flattened_value.length + " instead of " + value5.length * value5[0].length);
                                            }
                                        }
                                        field3.set(this.parseInto, value5);
                                        break block200;
                                    }
                                    throw new RuntimeException("Type " + type + " is not implemented yet in FortranNamelist parser!");
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        if (end < part.length()) {
                            name = part.substring(end + 1).trim().toLowerCase();
                            if (name.startsWith(",")) {
                                name = name.substring(1).trim();
                            }
                            if (this._debug) {
                                System.out.println("next name: " + name);
                            }
                        }
                    } else if (names.containsKey(part.toLowerCase())) {
                        System.out.println("INFO: probably forgot value for \"" + name + "\"? [only found next variable name \"" + part.toLowerCase() + "\"] ==> will use default values");
                    } else {
                        System.out.println("last name: " + name.toLowerCase());
                        System.out.println("part from " + last_i + " to " + i + " : \"" + part + "\"");
                    }
                }
                ++i;
                ++var_counter;
            }
        } else {
            throw new RuntimeException("namelist '" + this.groupName + "' not found in the given input");
        }
    }

    public static boolean allowedArrayIndex(int minIdx, int maxIdx, int idxToCheck, String varname) {
        if (idxToCheck < minIdx || idxToCheck > maxIdx) {
            System.out.println("ERROR: try to insert value into " + varname + " at " + idxToCheck + ", allowed: [" + minIdx + ":" + maxIdx + "]");
            return false;
        }
        return true;
    }
}

