/*
 * Decompiled with CFR 0.152.
 */
package examples;

import de.labathome.FortranNamelist;
import de.labathome.namelist_variable;

public class FortranNamelistExamples {
    public static void main(String[] args) {
        FortranNamelistExamples.run_example_1();
        FortranNamelistExamples.run_example_2();
    }

    public static void run_example_1() {
        class MgridParameters {
            @namelist_variable
            String mgrid_ext = "";
            @namelist_variable
            String mgrid_mode = "";
            @namelist_variable(name="lstell_sym")
            boolean stellaratorSymmetric;
            @namelist_variable
            double Rmin;
            @namelist_variable
            double Rmax;
            @namelist_variable
            double Zmin;
            @namelist_variable
            double Zmax;
            @namelist_variable(name="ir")
            int numR;
            @namelist_variable(name="jz")
            int numZ;
            @namelist_variable(name="kp")
            int numPhi;
        }
        MgridParameters testClass = new MgridParameters();
        String namelist = "&MGRID_NLI\r\n   MGRID_EXT = 'w7x_conf17_rev'\r\n   MGRID_MODE = 'R'\r\n   LSTELL_SYM = .TRUE.\r\n   RMIN = 4.30\r\n   RMAX = 6.30\r\n   ZMIN = -1.20\r\n   ZMAX = 1.20\r\n   IR = 211\r\n   JZ = 241\r\n   KP = 36\r\n/";
        FortranNamelist parser = new FortranNamelist(namelist, "mgrid_nli", testClass);
        testClass = (MgridParameters)parser.getParsed();
    }

    public static void run_example_2() {
        class VmecInputNamelist {
            public static final int mpold = 101;
            public static final int ntord = 101;
            @namelist_variable
            String mgrid_file = "NONE";
            @namelist_variable(dim0min=0)
            double[] ac = new double[21];
            @namelist_variable(dim0min=-101, dim1min=0)
            double[][] rbc = new double[203][102];
        }
        VmecInputNamelist vmecInput = new VmecInputNamelist();
        String namelist = "&indata\r\n   mgrid_file = 'w7x_conf17_rev.nc'\n   AC = 1.0, 2.0, 3.0, 4.0, 42.0\n   RBC( 0,0) =  5.52    ZBS(0,0) = -0.0\n   RBC( 1,0) =  0.28143 ZBS(1,0) = -0.23796\n   RBC( 0,1) =  0.48552 ZBS(0,1) =  0.62135\n   RBC( 1,1) = -0.23402 ZBS(1,1) =  0.1838\n/";
        FortranNamelist parser = new FortranNamelist(namelist, "indata", vmecInput);
        vmecInput = (VmecInputNamelist)parser.getParsed();
    }
}

