/*
 * Decompiled with CFR 0.152.
 */
package de.labathome.gears;

import java.util.List;
import org.apache.commons.math3.fraction.Fraction;

public class GearsOutput {
    protected Fraction[] solution;
    protected List<int[][]> teethCounts;

    public GearsOutput(Fraction[] solution, List<int[][]> teethCounts) {
        this.solution = solution;
        this.teethCounts = teethCounts;
    }

    public String toJson() {
        String json = "{";
        if (this.solution != null) {
            json = json + this.solutionToJson();
            if (this.teethCounts != null) {
                json = json + ",";
                json = json + this.teethCountsToJson();
            }
        }
        json = json + "}";
        return json;
    }

    private String solutionToJson() {
        String json = "\"solution\":[";
        for (int idxRatio = 0; idxRatio < this.solution.length; ++idxRatio) {
            json = json + "[";
            json = json + Integer.toString(this.solution[idxRatio].getNumerator()) + ",";
            json = json + Integer.toString(this.solution[idxRatio].getDenominator());
            json = idxRatio < this.solution.length - 1 ? json + "]," : json + "]";
        }
        json = json + "]";
        return json;
    }

    private String teethCountsToJson() {
        String json = "\"teethCounts\":[";
        for (int i = 0; i < this.teethCounts.size(); ++i) {
            int[][] teethCount = this.teethCounts.get(i);
            json = json + "[";
            for (int idxRatio = 0; idxRatio < teethCount.length; ++idxRatio) {
                json = json + "[";
                json = json + Integer.toString(teethCount[idxRatio][0]) + ",";
                json = json + Integer.toString(teethCount[idxRatio][1]);
                json = idxRatio < teethCount.length - 1 ? json + "]," : json + "]";
            }
            json = i < this.teethCounts.size() - 1 ? json + "]," : json + "]";
        }
        json = json + "]";
        return json;
    }
}

