/*
 * Decompiled with CFR 0.152.
 */
package aliceinnets.python;

import aliceinnets.python.PythonCode;
import aliceinnets.python.Supplier;
import java.lang.reflect.Array;

public class Parser {
    public static final String[] KEYWORDS = new String[]{"False", "class", "finally", "is", "return", "None", "continue", "for", "lambda", "try", "True", "def", "from", "nonlocal", "while", "and", "del", "global", "not", "with", "as", "elif", "if", "or", "yield", "assert", "else", "import", "pass", "break", "except", "in", "raise"};
    public static final String False = "False";
    public static final String None = "None";
    public static final String True = "True";
    public static final String[] STRING_PREFIX = new String[]{"r", "u", "R", "U", "f", "F", "fr", "Fr", "fR", "FR", "rf", "rF", "Rf", "RF"};
    public static final String[] STRING_QUOTATION_MARKS = new String[]{"'", "\"", "'''", "\"\"\""};
    public static final String NUMPY = "np";
    public static final String NaN = String.format("%s.nan", "np");
    public static final String POSITIVE_INFINITY = String.format("%s.inf", "np");
    public static final String NEGATIVE_INFINITY = String.format("-%s.inf", "np");

    public static final boolean isKeyword(String string) {
        for (String keyword : KEYWORDS) {
            if (!keyword.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isBoolean(String string) {
        return False.equals(string) || True.equals(string);
    }

    public static final boolean isNone(String string) {
        return None.equals(string);
    }

    public static final boolean isTuple(String string) {
        return string.startsWith("(") && string.endsWith(")");
    }

    public static final boolean isDictionary(String string) {
        return string.startsWith("{") && string.endsWith("}");
    }

    public static final boolean isList(String string) {
        return string.startsWith("[") && string.endsWith("]");
    }

    public static final boolean isValidName(String string) {
        return string.matches("[a-zA-Z_]\\w*") && !Parser.isKeyword(string);
    }

    public static final boolean isString(String string) {
        int i;
        for (i = 0; i < STRING_PREFIX.length; ++i) {
            if (!string.startsWith(STRING_PREFIX[i])) continue;
            string = string.substring(STRING_PREFIX[i].length());
        }
        for (i = 0; i < STRING_QUOTATION_MARKS.length; ++i) {
            if (!string.startsWith(STRING_QUOTATION_MARKS[i]) || !string.endsWith(STRING_QUOTATION_MARKS[i])) continue;
            return true;
        }
        return false;
    }

    public static final String toPythonArgs(Object obj) {
        if (obj == null) {
            return Parser.toPythonExpression(obj);
        }
        if (obj.getClass().isArray()) {
            Class<?> componentType = obj.getClass().getComponentType();
            if (componentType.equals(Object.class)) {
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < Array.getLength(obj) - 1; ++i) {
                    buffer.append(Parser.toPythonExpression(Array.get(obj, i)));
                    buffer.append(", ");
                }
                buffer.append(Parser.toPythonExpression(Array.get(obj, Array.getLength(obj) - 1)));
                return buffer.toString();
            }
            return Parser.toPythonExpression(obj);
        }
        return Parser.toPythonExpression(obj);
    }

    public static final String toPythonExpression(Object obj) {
        if (obj == null) {
            return None;
        }
        if (!obj.getClass().isArray()) {
            if (obj instanceof Boolean) {
                if (((Boolean)obj).booleanValue()) {
                    return True;
                }
                return False;
            }
            if (obj instanceof Double) {
                if (obj.equals(Double.NaN)) {
                    return NaN;
                }
                if (obj.equals(Double.NEGATIVE_INFINITY)) {
                    return NEGATIVE_INFINITY;
                }
                if (obj.equals(Double.POSITIVE_INFINITY)) {
                    return POSITIVE_INFINITY;
                }
                return String.valueOf(obj);
            }
            if (obj instanceof Float) {
                if (obj.equals(Float.valueOf(Float.NaN))) {
                    return NaN;
                }
                if (obj.equals(Float.valueOf(Float.NEGATIVE_INFINITY))) {
                    return NEGATIVE_INFINITY;
                }
                if (obj.equals(Float.valueOf(Float.POSITIVE_INFINITY))) {
                    return POSITIVE_INFINITY;
                }
                return String.valueOf(obj);
            }
            if (obj instanceof String) {
                String string = (String)obj;
                if (Parser.isString(string) || Parser.isTuple(string) || Parser.isDictionary(string) || Parser.isList(string)) {
                    return string;
                }
                String[] strings = string.split("\\s*[=]\\s*");
                if (strings.length > 1 && Parser.isValidName(strings[0])) {
                    return string;
                }
                if (string.contains("\\")) {
                    return "r'" + String.valueOf(obj) + "'";
                }
                return "'" + String.valueOf(obj) + "'";
            }
            if (obj instanceof Supplier) {
                return Parser.toPythonExpression(((Supplier)obj).get());
            }
            if (obj instanceof PythonCode) {
                return obj.toString();
            }
            return String.valueOf(obj);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        for (int i = 0; i < Array.getLength(obj) - 1; ++i) {
            buffer.append(Parser.toPythonExpression(Array.get(obj, i)));
            buffer.append(", ");
        }
        buffer.append(Parser.toPythonExpression(Array.get(obj, Array.getLength(obj) - 1)));
        buffer.append("]");
        return buffer.toString();
    }
}

