/*
 * Decompiled with CFR 0.152.
 */
package aliceinnets.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.Scanner;

public class OneLiners {
    public static final String userDir() {
        return System.getProperty("user.dir");
    }

    public static final void printUserDir() {
        System.out.println(System.getProperty("user.dir"));
    }

    public static final String getFileName(String pathname) {
        int index = pathname.lastIndexOf(File.separator);
        return pathname.substring(index + 1);
    }

    public static final String getPath(String pathname) {
        int index = pathname.lastIndexOf(File.separator);
        return pathname.substring(0, index + 1);
    }

    public static final String date() {
        return new Date(System.currentTimeMillis()).toString();
    }

    public static final String date(long currentTimeMillis) {
        return new Date(currentTimeMillis).toString();
    }

    public static final String[] exec(String command) {
        try {
            Process process = Runtime.getRuntime().exec(command);
            String input = "";
            String buffer = null;
            BufferedReader inputStreamReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((buffer = inputStreamReader.readLine()) != null) {
                input = input + buffer + "\n";
            }
            String error = "";
            BufferedReader errorStreamReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((buffer = errorStreamReader.readLine()) != null) {
                error = error + buffer + "\n";
            }
            process.waitFor();
            return new String[]{input, error};
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final void println(boolean[][] a) {
        for (int i = 0; i < a.length; ++i) {
            System.out.println(Arrays.toString(a[i]));
        }
    }

    public static final void println(byte[][] a) {
        for (int i = 0; i < a.length; ++i) {
            System.out.println(Arrays.toString(a[i]));
        }
    }

    public static final void println(char[][] a) {
        for (int i = 0; i < a.length; ++i) {
            System.out.println(Arrays.toString(a[i]));
        }
    }

    public static final void println(double[][] a) {
        for (int i = 0; i < a.length; ++i) {
            System.out.println(Arrays.toString(a[i]));
        }
    }

    public static final void println(float[][] a) {
        for (int i = 0; i < a.length; ++i) {
            System.out.println(Arrays.toString(a[i]));
        }
    }

    public static final void println(int[][] a) {
        for (int i = 0; i < a.length; ++i) {
            System.out.println(Arrays.toString(a[i]));
        }
    }

    public static final void println(long[][] a) {
        for (int i = 0; i < a.length; ++i) {
            System.out.println(Arrays.toString(a[i]));
        }
    }

    public static final void println(Object[][] a) {
        for (int i = 0; i < a.length; ++i) {
            System.out.println(Arrays.toString(a[i]));
        }
    }

    public static final void println(short[][] a) {
        for (int i = 0; i < a.length; ++i) {
            System.out.println(Arrays.toString(a[i]));
        }
    }

    public static final void println(boolean[] a) {
        System.out.println(Arrays.toString(a));
    }

    public static final void println(byte[] a) {
        System.out.println(Arrays.toString(a));
    }

    public static final void println(char[] a) {
        System.out.println(Arrays.toString(a));
    }

    public static final void println(double[] a) {
        System.out.println(Arrays.toString(a));
    }

    public static final void println(float[] a) {
        System.out.println(Arrays.toString(a));
    }

    public static final void println(int[] a) {
        System.out.println(Arrays.toString(a));
    }

    public static final void println(long[] a) {
        System.out.println(Arrays.toString(a));
    }

    public static final void println(Object[] a) {
        System.out.println(Arrays.toString(a));
    }

    public static final void println(short[] a) {
        System.out.println(Arrays.toString(a));
    }

    public static final void rmdirs(String path) {
        File dir = new File(path);
        if (dir.exists()) {
            if (dir.isDirectory()) {
                for (String subpath : dir.list()) {
                    OneLiners.rmdirs(path + File.separator + subpath);
                }
            }
            dir.delete();
        }
    }

    public static final boolean mkdirs(String path) {
        File dir = new File(path);
        if (dir.exists() && !dir.isDirectory()) {
            throw new RuntimeException(String.format("A file is exist already at %s", path));
        }
        return dir.mkdirs();
    }

    public static final String[] getFileNames(String dir) {
        File[] directories = OneLiners.getFiles(dir);
        String[] name = new String[directories.length];
        for (int i = 0; i < name.length; ++i) {
            name[i] = directories[i].getName();
        }
        return name;
    }

    public static final String[] getFilePaths(String dir) {
        File[] directories = OneLiners.getFiles(dir);
        String[] name = new String[directories.length];
        for (int i = 0; i < name.length; ++i) {
            name[i] = directories[i].getPath() + "/";
        }
        return name;
    }

    public static final File[] getFiles(String dir) {
        return new File(dir).listFiles(File::isFile);
    }

    public static final String[] getSubdirNames(String dir) {
        File[] directories = OneLiners.getSubdirs(dir);
        String[] name = new String[directories.length];
        for (int i = 0; i < name.length; ++i) {
            name[i] = directories[i].getName();
        }
        return name;
    }

    public static final String[] getSubdirPaths(String dir) {
        File[] directories = OneLiners.getSubdirs(dir);
        String[] name = new String[directories.length];
        for (int i = 0; i < name.length; ++i) {
            name[i] = directories[i].getPath();
        }
        return name;
    }

    public static final File[] getSubdirs(String dir) {
        return new File(dir).listFiles(File::isDirectory);
    }

    public static final Object extractElems(Object array, boolean[] keep) {
        LinkedList<Object> ret = new LinkedList<Object>();
        for (int i = 0; i < Array.getLength(array); ++i) {
            if (!keep[i]) continue;
            ret.add(Array.get(array, i));
        }
        Class<?> type = OneLiners.getElementType(array.getClass());
        try {
            return OneLiners.castToPrimitiveTypeArray(ret.toArray(), type);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final Object extractElems(Object array, int fromIndex, int step, int toIndex) {
        boolean[] keep = new boolean[Array.getLength(array)];
        for (int i = fromIndex; i <= toIndex; i += step) {
            keep[i] = true;
        }
        return OneLiners.extractElems(array, keep);
    }

    public static final Object extractElems(Object array, int[] keepIndicies) {
        boolean[] keep = new boolean[keepIndicies.length];
        for (int i = 0; i < keep.length; ++i) {
            keep[keepIndicies[i]] = true;
        }
        return OneLiners.extractElems(array, keep);
    }

    public static final Object cloneNonStructuredObject(Object object) {
        if (!object.getClass().isArray()) {
            return object;
        }
        Object ret = Array.newInstance(object.getClass().getComponentType(), Array.getLength(object));
        for (int i = 0; i < Array.getLength(object); ++i) {
            Array.set(ret, i, OneLiners.cloneNonStructuredObject(Array.get(object, i)));
        }
        return ret;
    }

    public static final Object castToPrimitiveTypeArray(Object object, Class<?> componentType) throws ClassNotFoundException {
        return OneLiners.castToPrimitiveType(object, OneLiners.getArrayType(componentType, OneLiners.getArrayDimensions(object.getClass())));
    }

    public static final Object castToPrimitiveType(Object object, Class<?> type) {
        if (!type.isArray()) {
            if (type.equals(Double.TYPE) || type.equals(Double.class)) {
                return Double.parseDouble(object.toString());
            }
            if (type.equals(Float.TYPE)) {
                return Float.valueOf(Float.parseFloat(object.toString()));
            }
            if (type.equals(Long.TYPE)) {
                return Long.parseLong(object.toString().split("\\.")[0]);
            }
            if (type.equals(Integer.TYPE)) {
                return Integer.parseInt(object.toString().split("\\.")[0]);
            }
            if (type.equals(Short.TYPE)) {
                return Short.parseShort(object.toString().split("\\.")[0]);
            }
            if (type.equals(Byte.TYPE)) {
                return Byte.parseByte(object.toString().split("\\.")[0]);
            }
            if (type.equals(Boolean.TYPE)) {
                return Boolean.parseBoolean(object.toString());
            }
            if (type.equals(Character.TYPE)) {
                return Character.valueOf(object.toString().charAt(0));
            }
            if (type.equals(String.class)) {
                return object.toString();
            }
            throw new RuntimeException(String.format("type to cast(%s) is neither primitive nor string", type));
        }
        Object ret = Array.newInstance(type.getComponentType(), Array.getLength(object));
        for (int i = 0; i < Array.getLength(object); ++i) {
            Array.set(ret, i, OneLiners.castToPrimitiveType(Array.get(object, i), type.getComponentType()));
        }
        return ret;
    }

    public static final int getArrayDimensions(Class<?> type) {
        if (type.getComponentType() == null) {
            return 0;
        }
        return OneLiners.getArrayDimensions(type.getComponentType()) + 1;
    }

    public static final Class<?> getElementType(Class<?> type) {
        if (type.getComponentType() == null) {
            return type;
        }
        return OneLiners.getElementType(type.getComponentType());
    }

    public static final Class<?> getArrayType(Class<?> elementType, int dimension) throws ClassNotFoundException {
        if (dimension == 0) {
            return elementType;
        }
        String className = elementType.getName();
        className = className.equals("byte") ? "B" : (className.equals("char") ? "C" : (className.equals("double") ? "D" : (className.equals("float") ? "F" : (className.equals("int") ? "I" : (className.equals("long") ? "J" : (className.equals("short") ? "S" : (className.equals("boolean") ? "Z" : "L" + className + ";")))))));
        for (int i = 0; i < dimension; ++i) {
            className = "[" + className;
        }
        return Class.forName(className);
    }

    public static final void setArrayElement(Object array, Object element, int ... indices) {
        if (indices.length == 1) {
            Array.set(array, indices[0], element);
        } else {
            int[] subindices = new int[indices.length - 1];
            for (int i = 0; i < subindices.length; ++i) {
                subindices[i] = indices[i + 1];
            }
            Object subarray = Array.get(array, indices[0]);
            OneLiners.setArrayElement(subarray, element, subindices);
        }
    }

    public static final void setArrayElements(Object array, Object[] elements, int[][] indices) {
        if (elements.length != indices.length) {
            throw new RuntimeException(String.format("the dimensions should be same, elements (%s), indices (%s)", elements.length, indices.length));
        }
        for (int i = 0; i < elements.length; ++i) {
            OneLiners.setArrayElement(array, elements[i], indices[i]);
        }
    }

    public static final void TextToFile(String fileName, String[] text) {
        OneLiners.mkdirs(fileName);
        try {
            FileOutputStream fOut = new FileOutputStream(fileName);
            fOut.write(String.join((CharSequence)"\n", text).getBytes());
            fOut.close();
        }
        catch (IOException err) {
            throw new RuntimeException(err);
        }
    }

    public static final int[][] meshGrid(int[] ... values) {
        if (values.length == 1) {
            return OneLiners.transpose(values);
        }
        int[][] subvalues = new int[values.length - 1][];
        for (int i = 0; i < subvalues.length; ++i) {
            subvalues[i] = values[i + 1];
        }
        int[][] subgrid = OneLiners.meshGrid(subvalues);
        LinkedList<int[]> ret = new LinkedList<int[]>();
        for (int i = 0; i < values[0].length; ++i) {
            for (int j = 0; j < subgrid.length; ++j) {
                int[] array = new int[subgrid[0].length + 1];
                array[0] = values[0][i];
                for (int k = 0; k < subgrid[0].length; ++k) {
                    array[k + 1] = subgrid[j][k];
                }
                ret.add(array);
            }
        }
        return (int[][])ret.toArray((T[])new int[ret.size()][]);
    }

    public static final int[][] transpose(int[][] dIn) {
        int ni = dIn.length;
        if (ni <= 0) {
            return new int[0][0];
        }
        int nj = dIn[0].length;
        int[][] dOut = new int[nj][ni];
        for (int i = 0; i < ni; ++i) {
            for (int j = 0; j < nj; ++j) {
                dOut[j][i] = dIn[i][j];
            }
        }
        return dOut;
    }

    public static final int[] linspaceInt(int x0, int x1, int dx) {
        int n = (int)((double)((x1 - x0) / dx) + 1.0);
        int[] f = new int[n];
        for (int i = 0; i < n; ++i) {
            f[i] = x0 + i * dx;
        }
        return f;
    }

    public static final long[] linspaceLong(long x0, long x1, long dx) {
        int n = (int)((double)((x1 - x0) / dx) + 1.0);
        long[] f = new long[n];
        for (int i = 0; i < n; ++i) {
            f[i] = x0 + (long)i * dx;
        }
        return f;
    }

    public static final String getAbsoluteDir(Class<?> clazz) {
        return clazz.getResource(clazz.getName() + ".java").getPath().replace(clazz.getSimpleName() + ".java", "");
    }

    public static final String read(Reader in) {
        Scanner scanner = new Scanner(in);
        scanner.useDelimiter("\\Z");
        String s = scanner.next();
        scanner.close();
        return s;
    }

    public static final String read(File file, boolean printStackTrace) {
        try {
            return OneLiners.read(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            if (printStackTrace) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static final String read(File file) {
        return OneLiners.read(file, false);
    }

    public static final String read(String pathname, boolean printStackTrace) {
        return OneLiners.read(new File(pathname), printStackTrace);
    }

    public static final String read(String pathname) {
        return OneLiners.read(new File(pathname), false);
    }

    public static final void write(String s, Writer writer) {
        PrintWriter out = new PrintWriter(writer);
        out.write(s);
        out.close();
    }

    public static final boolean write(String s, File file, boolean printStackTrace) {
        try {
            OneLiners.write(s, new FileWriter(file));
            return true;
        }
        catch (IOException e) {
            if (printStackTrace) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public static final boolean write(String s, File file) {
        return OneLiners.write(s, file, false);
    }

    public static final boolean write(String s, String pathname, boolean printStackTrace) {
        return OneLiners.write(s, new File(pathname), printStackTrace);
    }

    public static final boolean write(String s, String pathname) {
        return OneLiners.write(s, new File(pathname), false);
    }

    public static final double[] linspace(double x0, double x1, int n) {
        if (n == 1) {
            return new double[]{(x0 + x1) / 2.0};
        }
        double[] f = new double[n];
        double dx = (x1 - x0) / ((double)n - 1.0);
        for (int i = 0; i < n; ++i) {
            f[i] = x0 + (double)i * dx;
        }
        return f;
    }

    public static final double[][] transpose(double[][] dIn) {
        int ni = dIn.length;
        if (ni <= 0) {
            return new double[0][0];
        }
        int nj = dIn[0].length;
        double[][] dOut = new double[nj][ni];
        for (int i = 0; i < ni; ++i) {
            for (int j = 0; j < nj; ++j) {
                dOut[j][i] = dIn[i][j];
            }
        }
        return dOut;
    }

    public static final double[][] meshGrid(double[] ... values) {
        if (values.length == 1) {
            return OneLiners.transpose(values);
        }
        double[][] subvalues = new double[values.length - 1][];
        for (int i = 0; i < subvalues.length; ++i) {
            subvalues[i] = values[i + 1];
        }
        double[][] subgrid = OneLiners.meshGrid(subvalues);
        LinkedList<double[]> ret = new LinkedList<double[]>();
        for (int i = 0; i < values[0].length; ++i) {
            for (int j = 0; j < subgrid.length; ++j) {
                double[] array = new double[subgrid[0].length + 1];
                array[0] = values[0][i];
                for (int k = 0; k < subgrid[0].length; ++k) {
                    array[k + 1] = subgrid[j][k];
                }
                ret.add(array);
            }
        }
        return (double[][])ret.toArray((T[])new double[ret.size()][]);
    }

    public static final int countWordUsingScanner(String document, String word) {
        return OneLiners.countWordUsingScanner(document, word, false, false, false);
    }

    public static final int countWordUsingScanner(String document, String word, boolean caseSensitive) {
        return OneLiners.countWordUsingScanner(document, word, caseSensitive, false, false);
    }

    public static final int countWordUsingScanner(String document, String word, boolean caseSensitive, boolean wholeWord) {
        return OneLiners.countWordUsingScanner(document, word, caseSensitive, wholeWord, false);
    }

    public static final int countWordUsingScanner(String document, String word, boolean caseSensitive, boolean wholeWord, boolean excludeNonWordChars) {
        int count = 0;
        if (!caseSensitive) {
            document = document.toLowerCase();
        }
        if (excludeNonWordChars) {
            word = word.replaceAll("\\W", "");
        }
        Scanner scanner = new Scanner(document);
        if (wholeWord) {
            if (excludeNonWordChars) {
                while (scanner.hasNext()) {
                    if (!scanner.next().equals(word)) continue;
                    ++count;
                }
            } else {
                while (scanner.hasNext()) {
                    if (!scanner.next().replaceAll("\\W", "").equals(word)) continue;
                    ++count;
                }
            }
        } else if (excludeNonWordChars) {
            while (scanner.hasNext()) {
                if (!scanner.next().contains(word)) continue;
                ++count;
            }
        } else {
            while (scanner.hasNext()) {
                if (!scanner.next().replaceAll("\\W", "").contains(word)) continue;
                ++count;
            }
        }
        scanner.close();
        return count;
    }

    public static final int[] countWords(String document, String[] words) {
        return OneLiners.countWords(document, words, false, false, false);
    }

    public static final int[] countWords(String document, String[] words, boolean caseSensitive) {
        return OneLiners.countWords(document, words, caseSensitive, false, false);
    }

    public static final int[] countWords(String document, String[] words, boolean caseSensitive, boolean wholeWord) {
        return OneLiners.countWords(document, words, caseSensitive, wholeWord, false);
    }

    public static final int[] countWords(String document, String[] words, boolean caseSensitive, boolean wholeWord, boolean excludeNonWordChars) {
        int[] wordCounts = new int[words.length];
        for (int i = 0; i < wordCounts.length; ++i) {
            wordCounts[i] = OneLiners.countWord(document, words[i], caseSensitive, wholeWord, excludeNonWordChars);
        }
        return wordCounts;
    }

    public static final int countWord(String document, String word) {
        return OneLiners.countWord(document, word, false, false, false);
    }

    public static final int countWord(String document, String word, boolean caseSensitive) {
        return OneLiners.countWord(document, word, caseSensitive, false, false);
    }

    public static final int countWord(String document, String word, boolean caseSensitive, boolean wholeWord) {
        return OneLiners.countWord(document, word, caseSensitive, wholeWord, false);
    }

    public static final int countWord(String document, String word, boolean caseSensitive, boolean wholeWord, boolean excludeNonWordChars) {
        int count = 0;
        if (!caseSensitive) {
            document = document.toLowerCase();
        }
        String[] words = document.split("\\s+");
        if (wholeWord) {
            if (excludeNonWordChars) {
                for (int i = 0; i < words.length; ++i) {
                    if (!words[i].replaceAll("\\W", "").equals(word)) continue;
                    ++count;
                }
            } else {
                for (int i = 0; i < words.length; ++i) {
                    if (!words[i].equals(word)) continue;
                    ++count;
                }
            }
        } else if (excludeNonWordChars) {
            for (int i = 0; i < words.length; ++i) {
                if (!words[i].replaceAll("\\W", "").contains(word)) continue;
                ++count;
            }
        } else {
            for (int i = 0; i < words.length; ++i) {
                if (!words[i].contains(word)) continue;
                ++count;
            }
        }
        return count;
    }
}

