/*
 * Decompiled with CFR 0.152.
 */
package de.labathome;

import aliceinnets.python.jyplot.JyPlot;
import de.labathome.IrbBlockType;
import de.labathome.IrbFileType;
import de.labathome.IrbHeaderBlock;
import de.labathome.IrbImage;
import eu.hoefel.ArrayToPNG;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class IrbFile {
    private static final byte[] MAGIC_ID = new byte[]{-1, 73, 82, 66, 0};
    private IrbFileType fileType;
    private int flag1;
    private int blockCount;
    private int blockOffset;
    public List<IrbHeaderBlock> headerBlocks;
    public List<IrbImage> images;

    public IrbFile(ByteBuffer buf) {
        this.parseHeader(buf);
    }

    private void parseHeader(ByteBuffer buf) {
        byte[] magicBytes = new byte[5];
        buf.get(magicBytes);
        if (!Arrays.equals(magicBytes, MAGIC_ID)) {
            throw new RuntimeException("first 5 magic bytes invalid");
        }
        byte[] fileTypeBytes = new byte[8];
        buf.get(fileTypeBytes);
        this.fileType = IrbFileType.fromString(new String(fileTypeBytes));
        buf.get(fileTypeBytes);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        this.flag1 = buf.getInt();
        this.blockOffset = buf.getInt();
        this.blockCount = buf.getInt();
        this.headerBlocks = new LinkedList<IrbHeaderBlock>();
        buf.position(this.blockOffset);
        for (int i = 0; i < this.blockCount; ++i) {
            IrbHeaderBlock headerBlock = new IrbHeaderBlock(buf);
            this.headerBlocks.add(headerBlock);
        }
        this.images = new LinkedList<IrbImage>();
        for (IrbHeaderBlock block : this.headerBlocks) {
            if (block.blockType != IrbBlockType.IMAGE) continue;
            IrbImage image = new IrbImage(buf, block.offset, block.size);
            this.images.add(image);
        }
    }

    public IrbFileType fileType() {
        return this.fileType;
    }

    public static IrbFile fromFile(String filename) throws IOException {
        if (!new File(filename).exists()) {
            throw new RuntimeException("File '" + filename + "' does not exists!");
        }
        RandomAccessFile memoryFile = new RandomAccessFile(filename, "r");
        MappedByteBuffer buf = memoryFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, memoryFile.length());
        IrbFile file = new IrbFile(buf);
        memoryFile.close();
        return file;
    }

    public static void main(String[] args) {
        if (args != null && args.length > 0) {
            String filename = args[0];
            try {
                IrbFile irbFile = IrbFile.fromFile(filename);
                System.out.println("number of images: " + irbFile.images.size());
                int i = 0;
                for (IrbImage image : irbFile.images) {
                    System.out.println("\n\nimage " + i);
                    System.out.printf("            env temp: %g \u00b0C\n", Float.valueOf(image.environmentalTemp - 273.15f));
                    System.out.printf("           path temp: %g \u00b0C\n", Float.valueOf(image.pathTemperature - 273.15f));
                    System.out.printf("     calib range min: %g \u00b0C\n", Float.valueOf(image.calibRangeMin - 273.15f));
                    System.out.printf("     calib range max: %g \u00b0C\n", Float.valueOf(image.calibRangeMax - 273.15f));
                    System.out.printf("shot range start err: %g \u00b0C\n", Float.valueOf(image.shotRangeStartErr - 273.15f));
                    System.out.printf("     shot range size: %g  K\n", Float.valueOf(image.shotRangeSize));
                    try {
                        System.out.print("starting to export to text files... ");
                        image.exportImageData(String.format(filename + ".img_%d.dat", i));
                        image.exportMetaData(String.format(filename + ".meta_%d.json", i));
                        System.out.println("done");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        System.out.print("starting to dump image as PNG... ");
                        ArrayToPNG.dumpAsPng(image.getCelsiusImage(), String.format(filename + ".img_%d.png", i));
                        System.out.println("done");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        System.out.print("plot using JyPlot... ");
                        JyPlot plt = new JyPlot();
                        plt.figure();
                        plt.imshow(image.getCelsiusImage(), "cmap=plt.get_cmap('jet')");
                        plt.colorbar();
                        plt.title(String.format("image %d", i));
                        plt.show();
                        plt.exec();
                        System.out.println("done");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("usage: java -jar irb.jar /path/to/image.irb");
        }
    }
}

