/*
 * Decompiled with CFR 0.152.
 */
package aliceinnets.python;

import aliceinnets.python.Parser;
import aliceinnets.python.PythonCode;
import aliceinnets.python.PythonScriptUtil;
import aliceinnets.util.OneLiners;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

public class PythonModule3 {
    public static final String COMMENT_PREFIX = "#";
    public static final PythonCode DEFAULT_HEADLINE = new PythonCode("#Auto generated python script");
    public static final PythonCode DEFAULT_STARTLINE = new PythonCode("#Script body starts");
    public static final String NUMPY = "np";
    public static final String PYPLOT = "plt";
    protected File script;
    protected ArrayList<PythonCode> lineScript = new ArrayList();
    protected String python = PythonScriptUtil.getPythonPath();
    protected boolean print = true;
    protected boolean saveLog = false;

    public PythonModule3() {
        this(null);
    }

    public PythonModule3(String pathname) {
        if (pathname != null && !pathname.equals("")) {
            this.script = new File(pathname);
            OneLiners.mkdirs(this.script.getParent());
        } else {
            this.script = PythonScriptUtil.createNewFile();
        }
        this.write(DEFAULT_HEADLINE);
        this.write("#generated at " + OneLiners.date());
        this.write();
        this.write();
        this.write(DEFAULT_STARTLINE);
        this.write();
        this.importsAs("numpy", NUMPY);
        this.importsAs("matplotlib.pyplot", PYPLOT);
    }

    public String getLine(int lineNumber) {
        return this.lineScript.get(lineNumber).toString();
    }

    public int getStartlineNumber() {
        return this.lineScript.indexOf(DEFAULT_STARTLINE);
    }

    public void write() {
        this.write("");
    }

    public void write(String line) {
        this.write(new PythonCode(line));
    }

    public void write(int lineNumber, String line) {
        this.write(lineNumber, new PythonCode(line));
    }

    public void write(PythonCode format) {
        this.lineScript.add(format);
    }

    public void write(int lineNumber, PythonCode format) {
        this.lineScript.add(lineNumber, format);
    }

    public void writeHead(String line) {
        this.write(this.getStartlineNumber() - 1, line);
    }

    public void imports(String module) {
        this.writeHead(String.format("import %s", module));
    }

    public void imports(String ... modules) {
        Object[] codes = Arrays.asList(modules).stream().map(PythonCode::new).collect(Collectors.toList()).toArray(new Object[modules.length]);
        this.writeHead(String.format("import %s ", Parser.toPythonArgs(codes)));
    }

    public void importsAs(String module, String name) {
        this.writeHead(String.format("import %s as %s", module, name));
    }

    public void fromImports(String module, String identifier) {
        this.writeHead(String.format("from %s import %s", module, identifier));
    }

    public void fromImports(String module, String ... identifiers) {
        Object[] codes = Arrays.asList(identifiers).stream().map(PythonCode::new).collect(Collectors.toList()).toArray(new Object[identifiers.length]);
        this.writeHead(String.format("from %s import %s", module, Parser.toPythonArgs(codes)));
    }

    public void fromImportsAs(String module, String identifier, String name) {
        this.writeHead(String.format("from %s import %s as %s", module, identifier, name));
    }

    public void saveScript(File script) {
        OneLiners.mkdirs(script.getParent());
        OneLiners.write(this.getScript(), script);
    }

    public void saveScript(String pathname) {
        this.saveScript(new File(pathname));
    }

    public void saveScript() {
        this.saveScript(this.script);
    }

    public void exec(File script) {
        this.saveScript(script);
        PythonScriptUtil.exec(this.python, script.getAbsolutePath(), this.print, this.saveLog);
        if (script.getParentFile().equals(new File(PythonScriptUtil.PATH))) {
            script.delete();
        }
    }

    public void exec(String pathname) {
        this.exec(new File(pathname));
    }

    public void exec() {
        this.exec(this.script);
    }

    public String getPathname() {
        return this.script.getAbsolutePath();
    }

    public void setPathname(String pathname) {
        this.script = new File(pathname);
        OneLiners.mkdirs(this.script.getParent());
    }

    public ArrayList<PythonCode> getLineScript() {
        return this.lineScript;
    }

    public String getScript() {
        return String.join((CharSequence)"\n", this.lineScript.stream().map(PythonCode::toString).collect(Collectors.toList()));
    }

    public boolean isPrint() {
        return this.print;
    }

    public void setPrint(boolean print) {
        this.print = print;
    }

    public boolean isSaveLog() {
        return this.saveLog;
    }

    public void setSaveLog(boolean saveLog) {
        this.saveLog = saveLog;
    }

    public static void setPythonPath(String pythonPath) {
        PythonScriptUtil.setPythonPath(pythonPath);
    }
}

