/*
 * Decompiled with CFR 0.152.
 */
package aliceinnets.python;

import aliceinnets.util.OneLiners;
import java.io.File;
import java.io.IOException;

public class PythonScriptUtil {
    public static final String DEFAULT_PATH;
    public static final String COMMENT = "#";
    public static String PATH;
    public static String PYTHON_PATH_FILE;
    public static String LOG_HEADER;
    public static String LOG_FOOTER;

    public static final File createNewFile() {
        OneLiners.mkdirs(PATH);
        long suffix = 0L;
        try {
            while (true) {
                File file;
                if ((file = new File(PATH, System.currentTimeMillis() + "_" + suffix + ".py")).createNewFile()) {
                    return file;
                }
                ++suffix;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final void setPythonPath(String pythonPath) {
        OneLiners.mkdirs(PATH);
        OneLiners.write(pythonPath, PYTHON_PATH_FILE);
    }

    public static final String getPythonPath() {
        String python = OneLiners.read(PYTHON_PATH_FILE);
        return python == null ? "python" : python;
    }

    public static final boolean exec(String pathname) {
        return PythonScriptUtil.exec(PythonScriptUtil.getPythonPath(), pathname, false, false);
    }

    public static final boolean exec(String pathname, boolean print) {
        return PythonScriptUtil.exec(PythonScriptUtil.getPythonPath(), pathname, print, false);
    }

    public static final boolean exec(String python, String pathname, boolean print, boolean saveLog) {
        long time = System.currentTimeMillis();
        String[] results = OneLiners.exec(python + " " + pathname);
        if (print && !results[0].equals("")) {
            System.out.println(results[0]);
        }
        boolean error = false;
        if (!results[1].equals("")) {
            error = true;
            System.err.println(results[1]);
        }
        if (saveLog) {
            StringBuffer log = new StringBuffer();
            log.append(LOG_HEADER);
            log.append(COMMENT + String.format(" exec: %s %s\n", python, pathname));
            log.append(COMMENT + String.format(" started at %s\n", OneLiners.date(time)));
            log.append(COMMENT + String.format(" ended at %s\n", OneLiners.date()));
            log.append("\n");
            log.append(results[0]);
            log.append(results[1]);
            OneLiners.write(log.toString(), PATH + OneLiners.getFileName(pathname) + "_" + time + ".txt");
        }
        return !error;
    }

    static {
        PATH = DEFAULT_PATH = System.getProperty("user.home") + File.separator + "PythonScript" + File.separator;
        PYTHON_PATH_FILE = DEFAULT_PATH + "PYTHON_PATH.txt";
        LOG_HEADER = "#logging from " + PythonScriptUtil.class.getName() + "\n";
        LOG_FOOTER = "";
    }
}

