/*
 * Decompiled with CFR 0.152.
 */
package de.labathome;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Locale;

public class IrbImage {
    private static final int FLAGS_OFFSET = 1084;
    public static final float CELSIUS_OFFSET = 273.15f;
    @Expose(serialize=true)
    public int width;
    @Expose(serialize=true)
    public int height;
    @Expose(serialize=true)
    public short bytePerPixel;
    @Expose(serialize=true)
    public short compressed;
    @Expose(serialize=true)
    public float emissivity;
    @Expose(serialize=true)
    public float distance;
    @Expose(serialize=true)
    public float environmentalTemp;
    @Expose(serialize=true)
    public float pathTemperature;
    @Expose(serialize=true)
    public float centerWavelength;
    @Expose(serialize=true)
    public float calibRangeMin;
    @Expose(serialize=true)
    public float calibRangeMax;
    @Expose(serialize=true)
    public String device;
    @Expose(serialize=true)
    public String deviceSerial;
    @Expose(serialize=true)
    public String optics;
    @Expose(serialize=true)
    public String opticsResolution;
    @Expose(serialize=true)
    public String opticsText;
    @Expose(serialize=true)
    public float shotRangeStartErr;
    @Expose(serialize=true)
    public float shotRangeSize;
    @Expose(serialize=true)
    public double timestampRaw;
    @Expose(serialize=true)
    public int timestampMillisecond;
    @Expose(serialize=true)
    public Date timestamp;
    @Expose(serialize=true)
    public float[] palette;
    @Expose(serialize=true)
    public float minData;
    @Expose(serialize=true)
    public float maxData;
    @Expose(serialize=false)
    public float[][] data;

    public IrbImage(ByteBuffer buf, int offset, int size) {
        int oldPos = buf.position();
        buf.position(offset);
        this.bytePerPixel = buf.getShort();
        this.compressed = buf.getShort();
        this.width = buf.getShort();
        this.height = buf.getShort();
        IrbImage.checkIs(0, buf.getInt());
        IrbImage.checkIs(0, buf.getShort());
        short widthM1 = buf.getShort();
        if (this.width - 1 != widthM1) {
            System.out.printf("width-1 != widthM1 (%d) ???\n", widthM1);
        }
        IrbImage.checkIs(0, buf.getShort());
        short heightM1 = buf.getShort();
        if (this.height - 1 != heightM1) {
            System.out.printf("height-1 != heightM1 (%d) ???\n", heightM1);
        }
        IrbImage.checkIs(0, buf.getShort());
        IrbImage.checkIs(0, buf.getShort());
        this.emissivity = buf.getFloat();
        this.distance = buf.getFloat();
        this.environmentalTemp = buf.getFloat();
        IrbImage.checkIs(0, buf.getShort());
        IrbImage.checkIs(0, buf.getShort());
        this.pathTemperature = buf.getFloat();
        IrbImage.checkIs(101, buf.getShort());
        IrbImage.checkIs(0, buf.getShort());
        this.centerWavelength = buf.getFloat();
        IrbImage.checkIs(0, buf.getShort());
        IrbImage.checkIs(16512, buf.getShort());
        IrbImage.checkIs(9, buf.getShort());
        IrbImage.checkIs(257, buf.getShort());
        if (this.width > 10000 || this.height > 10000) {
            System.out.printf("error: width (%d) or height (%d) out-of-range!\n", this.width, this.height);
            this.width = 1;
            this.height = 1;
            return;
        }
        int flagsPosition = offset + 1084;
        this.readImageFlags(buf, flagsPosition);
        int bindataOffset = 1728;
        int paletteOffset = 60;
        boolean useCompression = this.compressed != 0;
        this.readImageData(buf, offset, bindataOffset, this.width, this.height, paletteOffset, useCompression);
        buf.position(oldPos);
    }

    private void readImageFlags(ByteBuffer buf, int position) {
        int oldPos = buf.position();
        this.calibRangeMin = buf.getFloat(position + 92);
        this.calibRangeMax = buf.getFloat(position + 96);
        this.device = IrbImage.readNullTerminatedString(buf, position + 142, 12);
        this.deviceSerial = IrbImage.readNullTerminatedString(buf, position + 450, 16);
        this.optics = IrbImage.readNullTerminatedString(buf, position + 202, 32);
        this.opticsResolution = IrbImage.readNullTerminatedString(buf, position + 234, 32);
        this.opticsText = IrbImage.readNullTerminatedString(buf, position + 554, 48);
        this.shotRangeStartErr = buf.getFloat(position + 532);
        this.shotRangeSize = buf.getFloat(position + 536);
        this.timestampRaw = buf.getDouble(position + 540);
        this.timestampMillisecond = buf.getInt(position + 548);
        this.timestamp = IrbImage.fromDoubleToDateTime(this.timestampRaw);
        buf.position(oldPos);
    }

    private void readImageData(ByteBuffer buf, int offset, int bindataOffset, int width, int height, int paletteOffset, boolean useCompression) {
        float f;
        int i;
        int dataSize;
        int pixelCount = dataSize = width * height;
        float[] matrixData = new float[pixelCount];
        int matrixDataPos = 0;
        int v1_pos = bindataOffset;
        int v2_pos = v1_pos + pixelCount;
        int v1 = 0;
        int v2 = 0;
        this.palette = this.readPalette(buf, offset + paletteOffset);
        int v2_count = 0;
        float v = 0.0f;
        int v1Min = 1000;
        int v1Max = -1000;
        if (useCompression) {
            for (i = pixelCount; i > 0; --i) {
                if (v2_count-- < 1) {
                    v2_count = buf.get(offset + v2_pos) - 1;
                    v2 = buf.get(offset + ++v2_pos);
                    ++v2_pos;
                    if (v2 < 0) {
                        v2 += 256;
                    }
                }
                v1 = buf.get(offset + v1_pos);
                ++v1_pos;
                if (v1 < 0) {
                    v1 += 256;
                }
                v1Min = Math.min(v1Min, v1);
                v1Max = Math.max(v1Max, v1);
                f = (float)v1 / 256.0f;
                v = this.palette[v2 + 1] * f + this.palette[v2] * (1.0f - f);
                if (v < 0.0f) {
                    v = 0.0f;
                }
                matrixData[matrixDataPos] = v;
                ++matrixDataPos;
            }
        } else {
            for (i = pixelCount; i > 0; --i) {
                v1 = buf.get(offset + v1_pos);
                v2 = buf.get(offset + ++v1_pos);
                ++v1_pos;
                if (v1 < 0) {
                    v1 += 256;
                }
                if (v2 < 0) {
                    v2 += 256;
                }
                v1Min = Math.min(v1Min, v1);
                v1Max = Math.max(v1Max, v1);
                f = (float)v1 / 256.0f;
                v = this.palette[v2 + 1] * f + this.palette[v2] * (1.0f - f);
                if (v < 0.0f) {
                    v = 0.0f;
                }
                matrixData[matrixDataPos] = v;
                ++matrixDataPos;
            }
        }
        System.out.println("v1 min " + v1Min);
        System.out.println("v1 max " + v1Max);
        this.minData = Float.POSITIVE_INFINITY;
        this.maxData = Float.NEGATIVE_INFINITY;
        this.data = new float[height][width];
        for (i = 0; i < pixelCount; ++i) {
            int row = i / width;
            int col = i % width;
            this.data[row][col] = matrixData[i];
            this.minData = Math.min(this.minData, matrixData[i]);
            this.maxData = Math.max(this.maxData, matrixData[i]);
        }
        System.out.println("data min: " + this.minData);
        System.out.println("data max: " + this.maxData);
    }

    public float[][] getCelsiusImage() {
        float[][] celsiusData = new float[this.height][this.width];
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                celsiusData[i][j] = this.data[i][j] - 273.15f;
            }
        }
        return celsiusData;
    }

    private float[] readPalette(ByteBuffer buf, int offset) {
        int oldPos = buf.position();
        float[] palette = new float[256];
        buf.position(offset);
        for (int i = 0; i < 256; ++i) {
            palette[i] = buf.getFloat();
        }
        buf.position(oldPos);
        return palette;
    }

    private static void checkIs(int expected, int val) {
        if (expected != val) {
            System.out.printf("expected %d but got %d\n", expected, val);
        }
    }

    private static String readNullTerminatedString(ByteBuffer buf, int offset, int len) {
        byte[] strBytes = new byte[len];
        buf.position(offset);
        buf.get(strBytes);
        return new String(strBytes).trim();
    }

    private static Date fromDoubleToDateTime(double OADate) {
        long num = (long)(OADate * 8.64E7 + (OADate >= 0.0 ? 0.5 : -0.5));
        if (num < 0L) {
            num -= num % 86400000L * 2L;
        }
        num += 59926435200000L;
        return new Date(num -= 62135596800000L);
    }

    public void exportMetaData(String filename) {
        try (BufferedWriter w = new BufferedWriter(new FileWriter(filename));){
            Gson gson = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().create();
            String json = gson.toJson(this);
            w.write(json);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void exportImageData(String filename) {
        try (BufferedWriter w = new BufferedWriter(new FileWriter(filename));){
            float[][] celsiusData = this.getCelsiusImage();
            int height = celsiusData.length;
            int width = celsiusData[0].length;
            for (int i = height - 1; i >= 0; --i) {
                for (int j = 0; j < width; ++j) {
                    w.write(String.format(Locale.ENGLISH, "%8.6f ", Float.valueOf(celsiusData[i][j])));
                }
                w.write("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

