/*
 * Decompiled with CFR 0.152.
 */
package eu.hoefel;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.math3.analysis.interpolation.LinearInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;

public class ArrayToPNG {
    public static double[][] COLORMAP1 = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0625, 0.125, 0.1875, 0.25, 0.3125, 0.375, 0.4375, 0.5, 0.5625, 0.625, 0.6875, 0.75, 0.8125, 0.875, 0.9375, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.9375, 0.875, 0.8125, 0.75, 0.6875, 0.625, 0.5625, 0.5}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0625, 0.125, 0.1875, 0.25, 0.3125, 0.375, 0.4375, 0.5, 0.5625, 0.625, 0.6875, 0.75, 0.8125, 0.875, 0.9375, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.9375, 0.875, 0.8125, 0.75, 0.6875, 0.625, 0.5625, 0.5, 0.4375, 0.375, 0.3125, 0.25, 0.1875, 0.125, 0.0625, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.5625, 0.625, 0.6875, 0.75, 0.8125, 0.875, 0.9375, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.9375, 0.875, 0.8125, 0.75, 0.6875, 0.625, 0.5625, 0.5, 0.4375, 0.375, 0.3125, 0.25, 0.1875, 0.125, 0.0625, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};

    public static void dumpAsPng(float[][] a, String filename) {
        ArrayToPNG.dumpAsPng(a, null, null, filename, true);
    }

    public static void dumpAsPng(float[][] a, double[][] colormap, double[][] alpha, String filename, boolean interpolatedColors) {
        BufferedImage image = ArrayToPNG.array2Image(a, colormap, alpha, interpolatedColors);
        try (FileOutputStream file = new FileOutputStream(filename);){
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static BufferedImage array2Image(float[][] a, double[][] colormap, double[][] alpha, boolean interpolatedColors) {
        int i;
        double maxval = a[0][0];
        double minval = a[0][0];
        for (int i2 = 0; i2 < a.length; ++i2) {
            for (int j = 0; j < a[i2].length; ++j) {
                if ((double)a[i2][j] > maxval) {
                    maxval = a[i2][j];
                }
                if (!((double)a[i2][j] < minval)) continue;
                minval = a[i2][j];
            }
        }
        if (colormap == null) {
            colormap = COLORMAP1;
        }
        double[] rescaledRangeR = new double[colormap[0].length];
        double[] rescaledRangeG = new double[colormap[1].length];
        double[] rescaledRangeB = new double[colormap[2].length];
        double deltaValueR = (maxval - minval) / ((double)colormap[0].length - 1.0);
        double deltaValueG = (maxval - minval) / ((double)colormap[1].length - 1.0);
        double deltaValueB = (maxval - minval) / ((double)colormap[2].length - 1.0);
        for (i = 0; i < colormap[0].length; ++i) {
            rescaledRangeR[i] = minval + (double)i * deltaValueR;
        }
        for (i = 0; i < colormap[1].length; ++i) {
            rescaledRangeG[i] = minval + (double)i * deltaValueG;
        }
        for (i = 0; i < colormap[2].length; ++i) {
            rescaledRangeB[i] = minval + (double)i * deltaValueB;
        }
        LinearInterpolator linearInterpolator = new LinearInterpolator();
        PolynomialSplineFunction rmap = linearInterpolator.interpolate(rescaledRangeR, colormap[0]);
        PolynomialSplineFunction gmap = linearInterpolator.interpolate(rescaledRangeR, colormap[1]);
        PolynomialSplineFunction bmap = linearInterpolator.interpolate(rescaledRangeR, colormap[2]);
        BufferedImage image = new BufferedImage(a[0].length, a.length, 2);
        int MAXINT = 255;
        for (int i3 = 0; i3 < a.length; ++i3) {
            for (int j = 0; j < a[0].length; ++j) {
                boolean isNaN = Double.isNaN(a[i3][j]);
                double val = isNaN ? 0.0 : (double)a[i3][j];
                int r = 0;
                int g = 0;
                int b = 0;
                if (interpolatedColors) {
                    r = (int)(rmap.value(val) * (double)MAXINT);
                    g = (int)(gmap.value(val) * (double)MAXINT);
                    b = (int)(bmap.value(val) * (double)MAXINT);
                } else {
                    int indexR = 0;
                    int indexG = 0;
                    int indexB = 0;
                    if (isNaN) {
                        indexR = 0;
                        indexG = 0;
                        indexB = 0;
                    } else {
                        indexR = (int)Math.round(Math.abs((val - minval) / (maxval - minval) * (double)(colormap[0].length - 1)));
                        indexG = (int)Math.round(Math.abs((val - minval) / (maxval - minval) * (double)(colormap[1].length - 1)));
                        indexB = (int)Math.round(Math.abs((val - minval) / (maxval - minval) * (double)(colormap[2].length - 1)));
                    }
                    if (indexR >= colormap[0].length) {
                        indexR = colormap[0].length - 1;
                    }
                    if (indexG >= colormap[1].length) {
                        indexG = colormap[1].length - 1;
                    }
                    if (indexB >= colormap[2].length) {
                        indexB = colormap[2].length - 1;
                    }
                    r = (int)(colormap[0][indexR] * (double)MAXINT);
                    g = (int)(colormap[1][indexG] * (double)MAXINT);
                    b = (int)(colormap[2][indexB] * (double)MAXINT);
                }
                int al = (int)(alpha == null ? (double)MAXINT : alpha[i3][j] * (double)MAXINT);
                int color = al << 24 | r << 16 | g << 8 | b;
                image.setRGB(j, i3, color);
            }
        }
        return image;
    }
}

