/*
 * Decompiled with CFR 0.152.
 */
package de.labathome.cli;

import aliceinnets.python.jyplot.JyPlot;
import de.labathome.irb.IrbFile;
import de.labathome.irb.IrbImage;
import eu.hoefel.ArrayToPNG;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="irb", version={"irb 1.0.3"}, description={"Process *.irb files"})
public class IrbCli
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", description={"The *.irb file to read."})
    private String filename;
    @CommandLine.Option(names={"-h", "--headless"}, description={"Save the image to disk instead of displaying it."})
    private boolean runHeadless;

    @Override
    public Integer call() throws Exception {
        try {
            System.out.println("Processing file: " + this.filename);
            IrbFile irbFile = IrbFile.fromFile(this.filename);
            System.out.println("number of images: " + irbFile.images.size());
            int imageIndex = 0;
            for (IrbImage image : irbFile.images) {
                System.out.println("\n\nimage " + imageIndex);
                System.out.printf("            env temp: %g \u00b0C\n", Float.valueOf(image.environmentalTemp - 273.15f));
                System.out.printf("           path temp: %g \u00b0C\n", Float.valueOf(image.pathTemperature - 273.15f));
                System.out.printf("     calib range min: %g \u00b0C\n", Float.valueOf(image.calibRangeMin - 273.15f));
                System.out.printf("     calib range max: %g \u00b0C\n", Float.valueOf(image.calibRangeMax - 273.15f));
                System.out.printf("shot range start err: %g \u00b0C\n", Float.valueOf(image.shotRangeStartErr - 273.15f));
                System.out.printf("     shot range size: %g  K\n", Float.valueOf(image.shotRangeSize));
                try {
                    System.out.print("starting to export to text files... ");
                    image.exportImageData(String.format(this.filename + ".img_%d.dat", imageIndex));
                    image.exportMetaData(String.format(this.filename + ".meta_%d.json", imageIndex));
                    System.out.println("done");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    System.out.print("starting to dump image as PNG... ");
                    ArrayToPNG.dumpAsPng(image.getCelsiusImage(), String.format(this.filename + ".img_%d.png", imageIndex));
                    System.out.println("done");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!this.runHeadless) {
                    try {
                        System.out.print("plot using JyPlot... ");
                        JyPlot plt = new JyPlot();
                        plt.figure();
                        plt.imshow(image.getCelsiusImage(), "cmap=plt.get_cmap('jet')");
                        plt.colorbar();
                        plt.title(String.format("image %d", imageIndex));
                        plt.show();
                        plt.exec();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                System.out.println("done");
                ++imageIndex;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static void main(String[] args) {
        int exitCode = new CommandLine(new IrbCli()).execute(args);
        System.exit(exitCode);
    }
}

