/*
 * Decompiled with CFR 0.152.
 */
package de.labathome.irb;

import de.labathome.irb.IrbBlockType;
import de.labathome.irb.IrbFileType;
import de.labathome.irb.IrbHeaderBlock;
import de.labathome.irb.IrbImage;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class IrbFile {
    private static final byte[] MAGIC_ID = new byte[]{-1, 73, 82, 66, 0};
    private IrbFileType fileType;
    private int flag1;
    private int blockCount;
    private int blockOffset;
    public List<IrbHeaderBlock> headerBlocks;
    public List<IrbImage> images;

    public IrbFile(ByteBuffer buf) {
        this.parseHeader(buf);
    }

    private void parseHeader(ByteBuffer buf) {
        byte[] magicBytes = new byte[5];
        buf.get(magicBytes);
        if (!Arrays.equals(magicBytes, MAGIC_ID)) {
            throw new RuntimeException("first 5 magic bytes invalid");
        }
        byte[] fileTypeBytes = new byte[8];
        buf.get(fileTypeBytes);
        this.fileType = IrbFileType.fromString(new String(fileTypeBytes));
        buf.get(fileTypeBytes);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        this.flag1 = buf.getInt();
        this.blockOffset = buf.getInt();
        this.blockCount = buf.getInt();
        this.headerBlocks = new LinkedList<IrbHeaderBlock>();
        buf.position(this.blockOffset);
        for (int i = 0; i < this.blockCount; ++i) {
            IrbHeaderBlock headerBlock = new IrbHeaderBlock(buf);
            this.headerBlocks.add(headerBlock);
        }
        this.images = new LinkedList<IrbImage>();
        for (IrbHeaderBlock block : this.headerBlocks) {
            if (block.blockType != IrbBlockType.IMAGE) continue;
            IrbImage image = new IrbImage(buf, block.offset, block.size);
            this.images.add(image);
        }
    }

    public IrbFileType fileType() {
        return this.fileType;
    }

    public static IrbFile fromFile(String filename) throws IOException {
        if (!new File(filename).exists()) {
            throw new RuntimeException("File '" + filename + "' does not exists!");
        }
        RandomAccessFile memoryFile = new RandomAccessFile(filename, "r");
        MappedByteBuffer buf = memoryFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, memoryFile.length());
        IrbFile file = new IrbFile(buf);
        memoryFile.close();
        return file;
    }
}

