/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.plugins.enforcer.RequirePrerequisite;
import org.apache.maven.project.MavenProject;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;

@Ignore
public class RequirePrerequisiteTest {
    @Test(expected=EnforcerRuleException.class)
    public void testNoPrerequisite() throws Exception {
        RequirePrerequisite rule = new RequirePrerequisite();
        MavenProject project = (MavenProject)Mockito.mock(MavenProject.class);
        EnforcerRuleHelper helper = (EnforcerRuleHelper)Mockito.mock(EnforcerRuleHelper.class);
        Mockito.when((Object)helper.evaluate("${project}")).thenReturn((Object)project);
        rule.execute(helper);
    }

    @Test
    public void testNoSpecifiedPrerequisite() throws Exception {
        RequirePrerequisite rule = new RequirePrerequisite();
        MavenProject project = (MavenProject)Mockito.mock(MavenProject.class);
        Mockito.when((Object)project.getPrerequisites()).thenReturn((Object)new Prerequisites());
        EnforcerRuleHelper helper = (EnforcerRuleHelper)Mockito.mock(EnforcerRuleHelper.class);
        Mockito.when((Object)helper.evaluate("${project}")).thenReturn((Object)project);
        rule.execute(helper);
    }

    @Test(expected=EnforcerRuleException.class)
    public void testLowerMavenPrerequisite() throws Exception {
        RequirePrerequisite rule = new RequirePrerequisite();
        rule.setMavenVersion("3.0");
        MavenProject project = (MavenProject)Mockito.mock(MavenProject.class);
        Mockito.when((Object)project.getPrerequisites()).thenReturn((Object)new Prerequisites());
        EnforcerRuleHelper helper = (EnforcerRuleHelper)Mockito.mock(EnforcerRuleHelper.class);
        Mockito.when((Object)helper.evaluate("${project}")).thenReturn((Object)project);
        rule.execute(helper);
    }

    @Test(expected=EnforcerRuleException.class)
    public void testLowerMavenRangePrerequisite() throws Exception {
        RequirePrerequisite rule = new RequirePrerequisite();
        rule.setMavenVersion("[3.0,)");
        MavenProject project = (MavenProject)Mockito.mock(MavenProject.class);
        Mockito.when((Object)project.getPrerequisites()).thenReturn((Object)new Prerequisites());
        EnforcerRuleHelper helper = (EnforcerRuleHelper)Mockito.mock(EnforcerRuleHelper.class);
        Mockito.when((Object)helper.evaluate("${project}")).thenReturn((Object)project);
        rule.execute(helper);
    }

    @Test
    public void testValidPrerequisite() throws Exception {
        RequirePrerequisite rule = new RequirePrerequisite();
        rule.setMavenVersion("2.2.1");
        MavenProject project = (MavenProject)Mockito.mock(MavenProject.class);
        Prerequisites prerequisites = new Prerequisites();
        prerequisites.setMaven("3.0");
        Mockito.when((Object)project.getPrerequisites()).thenReturn((Object)prerequisites);
        EnforcerRuleHelper helper = (EnforcerRuleHelper)Mockito.mock(EnforcerRuleHelper.class);
        Mockito.when((Object)helper.evaluate("${project}")).thenReturn((Object)project);
        rule.execute(helper);
    }
}

