/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.plugin.testing.ArtifactStubFactory;
import org.apache.maven.plugins.enforcer.EnforcerTestUtils;
import org.apache.maven.plugins.enforcer.MockProject;
import org.apache.maven.plugins.enforcer.RequireFilesSize;

public class TestRequireFilesSize
extends TestCase {
    RequireFilesSize rule = new RequireFilesSize();

    public void testFileExists() throws EnforcerRuleException, IOException {
        File f = File.createTempFile("enforcer", "tmp");
        f.deleteOnExit();
        this.rule.files = new File[]{f};
        this.rule.execute(EnforcerTestUtils.getHelper());
        f.delete();
    }

    public void testEmptyFile() throws EnforcerRuleException, IOException {
        this.rule.files = new File[]{null};
        try {
            this.rule.execute(EnforcerTestUtils.getHelper());
            TestRequireFilesSize.fail((String)"Should get exception");
        }
        catch (EnforcerRuleException e) {
            TestRequireFilesSize.assertTrue((boolean)true);
        }
    }

    public void testEmptyFileAllowNull() throws EnforcerRuleException, IOException {
        this.rule.files = new File[]{null};
        this.rule.allowNulls = true;
        try {
            this.rule.execute(EnforcerTestUtils.getHelper());
        }
        catch (EnforcerRuleException e) {
            TestRequireFilesSize.fail((String)("Unexpected Exception:" + e.getLocalizedMessage()));
        }
    }

    public void testEmptyFileList() throws EnforcerRuleException, IOException {
        this.rule.files = new File[0];
        TestRequireFilesSize.assertEquals((int)0, (int)this.rule.files.length);
        MockProject project = new MockProject();
        File f = File.createTempFile("enforcer", "tmp");
        f.deleteOnExit();
        ArtifactStubFactory factory = new ArtifactStubFactory();
        Artifact a = factory.getReleaseArtifact();
        a.setFile(f);
        project.setArtifact(a);
        TestRequireFilesSize.assertSame((Object)f, (Object)project.getArtifact().getFile());
        this.rule.execute(EnforcerTestUtils.getHelper(project));
    }

    public void testFileDoesNotExist() throws EnforcerRuleException, IOException {
        File f = File.createTempFile("enforcer", "tmp");
        f.delete();
        TestRequireFilesSize.assertTrue((!f.exists() ? 1 : 0) != 0);
        this.rule.files = new File[]{f};
        try {
            this.rule.execute(EnforcerTestUtils.getHelper());
            TestRequireFilesSize.fail((String)"Should get exception");
        }
        catch (EnforcerRuleException e) {
            TestRequireFilesSize.assertTrue((boolean)true);
        }
    }

    public void testFileTooSmall() throws EnforcerRuleException, IOException {
        File f = File.createTempFile("enforcer", "tmp");
        f.deleteOnExit();
        this.rule.files = new File[]{f};
        this.rule.minsize = 10L;
        try {
            this.rule.execute(EnforcerTestUtils.getHelper());
            TestRequireFilesSize.fail((String)"Should get exception");
        }
        catch (EnforcerRuleException e) {
            TestRequireFilesSize.assertTrue((boolean)true);
        }
    }

    public void testFileTooBig() throws EnforcerRuleException, IOException {
        File f = File.createTempFile("enforcer", "tmp");
        f.deleteOnExit();
        try {
            FileWriter fstream = new FileWriter(f);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write("123456789101112131415");
            out.close();
            fstream.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
        this.rule.files = new File[]{f};
        this.rule.maxsize = 10L;
        TestRequireFilesSize.assertTrue((f.length() > 10L ? 1 : 0) != 0);
        try {
            this.rule.execute(EnforcerTestUtils.getHelper());
            TestRequireFilesSize.fail((String)"Should get exception");
        }
        catch (EnforcerRuleException e) {
            TestRequireFilesSize.assertTrue((boolean)true);
        }
    }

    public void testId() {
        this.rule.getCacheId();
    }
}

