/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.Collections;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugins.enforcer.EnforcerTestUtils;
import org.apache.maven.plugins.enforcer.MockProject;
import org.apache.maven.plugins.enforcer.RequireNoRepositories;
import org.codehaus.plexus.PlexusTestCase;

public class TestRequireNoRepositories
extends PlexusTestCase {
    private EnforcerRuleHelper helper;
    private RequireNoRepositories rule;
    private MockProject project;

    public void setUp() throws Exception {
        super.setUp();
        this.rule = new RequireNoRepositories();
        this.rule.setMessage("my message");
        this.project = new MockProject();
        this.project.setGroupId("org.apache.maven.plugins.enforcer.test");
        this.project.setVersion("1.0-SNAPSHOT");
        this.helper = EnforcerTestUtils.getHelper(this.project);
    }

    public void testAllBannedNoRepositories() throws EnforcerRuleException {
        this.project.setArtifactId("no-repositories-child");
        this.project.setBaseDir(TestRequireNoRepositories.getTestFile((String)"target/test-classes/requireNoRepositories/no-repositories/child"));
        this.rule.execute(this.helper);
    }

    public void testAllBannedWithRepositories() throws EnforcerRuleException {
        this.project.setArtifactId("with-repositories-child");
        this.project.setBaseDir(TestRequireNoRepositories.getTestFile((String)"target/test-classes/requireNoRepositories/with-repositories/child"));
        try {
            this.rule.execute(this.helper);
            TestRequireNoRepositories.fail((String)"Should have exception");
        }
        catch (EnforcerRuleException e) {
            TestRequireNoRepositories.assertTrue((boolean)true);
        }
    }

    public void testAllBannedWithAllowedRepositories() throws EnforcerRuleException {
        this.rule.setAllowedRepositories(Collections.singletonList("repo"));
        this.project.setArtifactId("with-repositories-child");
        this.project.setBaseDir(TestRequireNoRepositories.getTestFile((String)"target/test-classes/requireNoRepositories/with-repositories/child"));
        this.rule.execute(this.helper);
    }

    public void testAllBannedWithAllowedPluginRepositories() throws EnforcerRuleException {
        this.rule.setAllowedPluginRepositories(Collections.singletonList("repo"));
        this.project.setArtifactId("with-plugin-repositories-child");
        this.project.setBaseDir(TestRequireNoRepositories.getTestFile((String)"target/test-classes/requireNoRepositories/with-plugin-repositories/child"));
        this.rule.execute(this.helper);
    }

    public void testReposNotBannedNoRepositories() throws EnforcerRuleException {
        this.rule.setBanRepositories(false);
        this.project.setArtifactId("no-repositories-child");
        this.project.setBaseDir(TestRequireNoRepositories.getTestFile((String)"target/test-classes/requireNoRepositories/no-repositories/child"));
        this.rule.execute(this.helper);
    }

    public void testReposNotBannedWithRepositories() throws EnforcerRuleException {
        this.rule.setBanRepositories(false);
        this.project.setArtifactId("with-repositories-child");
        this.project.setBaseDir(TestRequireNoRepositories.getTestFile((String)"target/test-classes/requireNoRepositories/with-repositories/child"));
        this.rule.execute(this.helper);
    }

    public void testReposNotBannedWithPluginRepositories() throws EnforcerRuleException {
        this.rule.setBanRepositories(false);
        this.project.setArtifactId("with-plugin-repositories-child");
        this.project.setBaseDir(TestRequireNoRepositories.getTestFile((String)"target/test-classes/requireNoRepositories/with-plugin-repositories/child"));
        try {
            this.rule.execute(this.helper);
            TestRequireNoRepositories.fail((String)"Should have exception");
        }
        catch (EnforcerRuleException e) {
            TestRequireNoRepositories.assertTrue((boolean)true);
        }
    }

    public void testPluginReposNotBannedNoRepositories() throws EnforcerRuleException {
        this.rule.setBanPluginRepositories(false);
        this.project.setArtifactId("no-repositories-child");
        this.project.setBaseDir(TestRequireNoRepositories.getTestFile((String)"target/test-classes/requireNoRepositories/no-repositories/child"));
        this.rule.execute(this.helper);
    }

    public void testPluginReposNotBannedWithRepositories() throws EnforcerRuleException {
        this.rule.setBanPluginRepositories(false);
        this.project.setArtifactId("with-repositories-child");
        this.project.setBaseDir(TestRequireNoRepositories.getTestFile((String)"target/test-classes/requireNoRepositories/with-repositories/child"));
        try {
            this.rule.execute(this.helper);
            TestRequireNoRepositories.fail((String)"Should have exception");
        }
        catch (EnforcerRuleException e) {
            TestRequireNoRepositories.assertTrue((boolean)true);
        }
    }

    public void testPluginReposNotBannedWithPluginRepositories() throws EnforcerRuleException {
        this.rule.setBanPluginRepositories(false);
        this.project.setArtifactId("with-plugin-repositories-child");
        this.project.setBaseDir(TestRequireNoRepositories.getTestFile((String)"target/test-classes/requireNoRepositories/with-plugin-repositories/child"));
        this.rule.execute(this.helper);
    }

    public void testReposNotAllowedWithSnapshotRepositories() throws EnforcerRuleException {
        this.rule.setAllowSnapshotRepositories(true);
        this.project.setArtifactId("snapshot-plugin-repositories-child");
        this.project.setBaseDir(TestRequireNoRepositories.getTestFile((String)"target/test-classes/requireNoRepositories/snapshot-plugin-repositories/child"));
        try {
            this.rule.execute(this.helper);
            TestRequireNoRepositories.fail((String)"Should have exception");
        }
        catch (EnforcerRuleException e) {
            TestRequireNoRepositories.assertTrue((boolean)true);
        }
    }

    public void testReposAllowedWithSnapshotRepositories() throws EnforcerRuleException {
        this.rule.setAllowSnapshotRepositories(true);
        this.project.setArtifactId("snapshot-repositories-child");
        this.project.setBaseDir(TestRequireNoRepositories.getTestFile((String)"target/test-classes/requireNoRepositories/snapshot-repositories/child"));
        this.rule.execute(this.helper);
    }

    public void testPluginReposNotAllowedWithSnapshotRepositories() throws EnforcerRuleException {
        this.rule.setAllowSnapshotPluginRepositories(true);
        this.project.setArtifactId("snapshot-repositories-child");
        this.project.setBaseDir(TestRequireNoRepositories.getTestFile((String)"target/test-classes/requireNoRepositories/snapshot-repositories/child"));
        try {
            this.rule.execute(this.helper);
            TestRequireNoRepositories.fail((String)"Should have exception");
        }
        catch (EnforcerRuleException e) {
            TestRequireNoRepositories.assertTrue((boolean)true);
        }
    }

    public void testPluginReposAllowedWithSnapshotPluginRepositories() throws EnforcerRuleException {
        this.rule.setAllowSnapshotPluginRepositories(true);
        this.project.setArtifactId("snapshot-plugin-repositories-child");
        this.project.setBaseDir(TestRequireNoRepositories.getTestFile((String)"target/test-classes/requireNoRepositories/snapshot-plugin-repositories/child"));
        this.rule.execute(this.helper);
    }

    public void testId() {
        RequireNoRepositories rule = new RequireNoRepositories();
        rule.getCacheId();
    }
}

