/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.testing.AbstractMojoTestCase;
import org.apache.maven.plugins.enforcer.EnforcerTestUtils;
import org.apache.maven.plugins.enforcer.MockProject;
import org.apache.maven.plugins.enforcer.RequirePluginVersions;
import org.apache.maven.plugins.enforcer.utils.EnforcerRuleUtils;
import org.apache.maven.plugins.enforcer.utils.PluginWrapper;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRequirePluginVersions
extends AbstractMojoTestCase {
    public void testHasVersionSpecified() {
        Plugin source = new Plugin();
        source.setArtifactId("foo");
        source.setGroupId("group");
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        plugins.add(EnforcerTestUtils.newPlugin("group", "a-artifact", "1.0"));
        plugins.add(EnforcerTestUtils.newPlugin("group", "foo", null));
        plugins.add(EnforcerTestUtils.newPlugin("group", "foo", ""));
        plugins.add(EnforcerTestUtils.newPlugin("group", "b-artifact", "1.0"));
        plugins.add(EnforcerTestUtils.newPlugin("group", "foo", "1.0"));
        plugins.add(EnforcerTestUtils.newPlugin("group", "c-artifact", "LATEST"));
        plugins.add(EnforcerTestUtils.newPlugin("group", "c-artifact", "1.0"));
        plugins.add(EnforcerTestUtils.newPlugin("group", "d-artifact", "RELEASE"));
        plugins.add(EnforcerTestUtils.newPlugin("group", "d-artifact", "1.0"));
        plugins.add(EnforcerTestUtils.newPlugin("group", "e-artifact", "1.0"));
        plugins.add(EnforcerTestUtils.newPlugin("group", "e-artifact", "RELEASE"));
        plugins.add(EnforcerTestUtils.newPlugin("group", "f-artifact", "1.0"));
        plugins.add(EnforcerTestUtils.newPlugin("group", "f-artifact", "LATEST"));
        plugins.add(EnforcerTestUtils.newPlugin("group", "f-artifact", "1.0-SNAPSHOT"));
        plugins.add(EnforcerTestUtils.newPlugin("group", "g-artifact", "1.0-12345678.123456-1"));
        List pluginWrappers = PluginWrapper.addAll(plugins, (String)"unit");
        RequirePluginVersions rule = new RequirePluginVersions();
        rule.setBanLatest(false);
        rule.setBanRelease(false);
        rule.setBanSnapshots(false);
        EnforcerRuleHelper helper = EnforcerTestUtils.getHelper();
        TestRequirePluginVersions.assertTrue((boolean)rule.hasValidVersionSpecified(helper, source, pluginWrappers));
        source.setArtifactId("c-artifact");
        TestRequirePluginVersions.assertTrue((boolean)rule.hasValidVersionSpecified(helper, source, pluginWrappers));
        rule.setBanLatest(true);
        TestRequirePluginVersions.assertFalse((boolean)rule.hasValidVersionSpecified(helper, source, pluginWrappers));
        rule.setBanSnapshots(false);
        source.setArtifactId("f-artifact");
        TestRequirePluginVersions.assertFalse((boolean)rule.hasValidVersionSpecified(helper, source, pluginWrappers));
        rule.setBanLatest(false);
        rule.setBanSnapshots(true);
        TestRequirePluginVersions.assertFalse((boolean)rule.hasValidVersionSpecified(helper, source, pluginWrappers));
        rule.setBanTimestamps(false);
        source.setArtifactId("g-artifact");
        TestRequirePluginVersions.assertTrue((boolean)rule.hasValidVersionSpecified(helper, source, pluginWrappers));
        source.setArtifactId("d-artifact");
        TestRequirePluginVersions.assertTrue((boolean)rule.hasValidVersionSpecified(helper, source, pluginWrappers));
        rule.setBanRelease(true);
        TestRequirePluginVersions.assertFalse((boolean)rule.hasValidVersionSpecified(helper, source, pluginWrappers));
        source.setArtifactId("e-artifact");
        TestRequirePluginVersions.assertFalse((boolean)rule.hasValidVersionSpecified(helper, source, pluginWrappers));
    }

    public void testHasVersionSpecifiedWithProperties() {
        Plugin source = new Plugin();
        source.setGroupId("group");
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        plugins.add(EnforcerTestUtils.newPlugin("group", "a-artifact", "1.0-${SNAPSHOT}"));
        plugins.add(EnforcerTestUtils.newPlugin("group", "b-artifact", "${1.0}"));
        plugins.add(EnforcerTestUtils.newPlugin("group", "c-artifact", "${LATEST}"));
        plugins.add(EnforcerTestUtils.newPlugin("group", "d-artifact", "${RELEASE}"));
        plugins.add(EnforcerTestUtils.newPlugin("group", "e-artifact", "${}"));
        plugins.add(EnforcerTestUtils.newPlugin("group", "f-artifact", "${   }"));
        List pluginWrappers = PluginWrapper.addAll(plugins, (String)"unit");
        RequirePluginVersions rule = new RequirePluginVersions();
        rule.setBanLatest(false);
        rule.setBanRelease(false);
        rule.setBanSnapshots(false);
        EnforcerRuleHelper helper = EnforcerTestUtils.getHelper(true);
        source.setArtifactId("a-artifact");
        TestRequirePluginVersions.assertTrue((boolean)rule.hasValidVersionSpecified(helper, source, pluginWrappers));
        source.setArtifactId("b-artifact");
        TestRequirePluginVersions.assertTrue((boolean)rule.hasValidVersionSpecified(helper, source, pluginWrappers));
        source.setArtifactId("c-artifact");
        TestRequirePluginVersions.assertTrue((boolean)rule.hasValidVersionSpecified(helper, source, pluginWrappers));
        source.setArtifactId("d-artifact");
        TestRequirePluginVersions.assertTrue((boolean)rule.hasValidVersionSpecified(helper, source, pluginWrappers));
        source.setArtifactId("e-artifact");
        TestRequirePluginVersions.assertFalse((boolean)rule.hasValidVersionSpecified(helper, source, pluginWrappers));
        source.setArtifactId("f-artifact");
        TestRequirePluginVersions.assertFalse((boolean)rule.hasValidVersionSpecified(helper, source, pluginWrappers));
        rule.setBanLatest(true);
        source.setArtifactId("c-artifact");
        TestRequirePluginVersions.assertFalse((boolean)rule.hasValidVersionSpecified(helper, source, pluginWrappers));
        rule.setBanRelease(true);
        source.setArtifactId("d-artifact");
        TestRequirePluginVersions.assertFalse((boolean)rule.hasValidVersionSpecified(helper, source, pluginWrappers));
        rule.setBanSnapshots(true);
        source.setArtifactId("a-artifact");
        TestRequirePluginVersions.assertFalse((boolean)rule.hasValidVersionSpecified(helper, source, pluginWrappers));
        source.setArtifactId("b-artifact");
        TestRequirePluginVersions.assertTrue((boolean)rule.hasValidVersionSpecified(helper, source, pluginWrappers));
    }

    public void testGetAllPlugins() throws ArtifactResolutionException, ArtifactNotFoundException, IOException, XmlPullParserException {
        RequirePluginVersions rule = new RequirePluginVersions();
        String path = "target/test-classes/requirePluginVersions/getPomRecursively/b/c";
        StringUtils.replace((String)path, (String)"/", (String)File.separator);
        File projectDir = new File(TestRequirePluginVersions.getBasedir(), path);
        MockProject project = new MockProject();
        project.setArtifactId("c");
        project.setGroupId("group");
        project.setVersion("1.0");
        project.setBaseDir(projectDir);
        rule.setUtils(new EnforcerRuleUtils(EnforcerTestUtils.getHelper(project)));
        List plugins = rule.getAllPluginEntries((MavenProject)project);
        TestRequirePluginVersions.assertEquals((int)3, (int)plugins.size());
    }

    public void testGetAdditionalPluginsNull() throws MojoExecutionException {
        RequirePluginVersions rule = new RequirePluginVersions();
        rule.addAdditionalPlugins(null, null);
    }

    public void testGetAdditionalPluginsInvalidFormat() {
        RequirePluginVersions rule = new RequirePluginVersions();
        ArrayList<String> additional = new ArrayList<String>();
        additional.add("group");
        HashSet plugins = new HashSet();
        try {
            rule.addAdditionalPlugins(plugins, additional);
            TestRequirePluginVersions.fail((String)"Expected Exception because the format is invalid");
        }
        catch (MojoExecutionException e) {
            // empty catch block
        }
        additional.clear();
        additional.add("group:i:i");
        try {
            rule.addAdditionalPlugins(plugins, additional);
            TestRequirePluginVersions.fail((String)"Expected Exception because the format is invalid");
        }
        catch (MojoExecutionException e) {
            // empty catch block
        }
    }

    public void testGetAdditionalPluginsEmptySet() throws MojoExecutionException {
        RequirePluginVersions rule = new RequirePluginVersions();
        HashSet<Plugin> plugins = new HashSet<Plugin>();
        plugins.add(EnforcerTestUtils.newPlugin("group", "a-artifact", "1.0"));
        plugins.add(EnforcerTestUtils.newPlugin("group", "foo", null));
        plugins.add(EnforcerTestUtils.newPlugin("group", "foo2", ""));
        ArrayList<String> additional = new ArrayList<String>();
        additional.add("group:a-artifact");
        additional.add("group:another-artifact");
        Set results = rule.addAdditionalPlugins(null, additional);
        TestRequirePluginVersions.assertNotNull((Object)results);
        this.assertContainsPlugin("group", "a-artifact", results);
        this.assertContainsPlugin("group", "another-artifact", results);
    }

    public void testGetAdditionalPlugins() throws MojoExecutionException {
        RequirePluginVersions rule = new RequirePluginVersions();
        HashSet<Plugin> plugins = new HashSet<Plugin>();
        plugins.add(EnforcerTestUtils.newPlugin("group", "a-artifact", "1.0"));
        plugins.add(EnforcerTestUtils.newPlugin("group", "foo", null));
        plugins.add(EnforcerTestUtils.newPlugin("group", "foo2", ""));
        ArrayList<String> additional = new ArrayList<String>();
        additional.add("group:a-artifact");
        additional.add("group:another-artifact");
        Set results = rule.addAdditionalPlugins(plugins, additional);
        TestRequirePluginVersions.assertNotNull((Object)results);
        TestRequirePluginVersions.assertEquals((int)4, (int)results.size());
        this.assertContainsPlugin("group", "a-artifact", results);
        this.assertContainsPlugin("group", "another-artifact", results);
    }

    public void testGetUncheckedPlugins() throws MojoExecutionException {
        RequirePluginVersions rule = new RequirePluginVersions();
        HashSet<Plugin> plugins = new HashSet<Plugin>();
        plugins.add(EnforcerTestUtils.newPlugin("group", "a-artifact", "1.0"));
        plugins.add(EnforcerTestUtils.newPlugin("group", "foo", null));
        plugins.add(EnforcerTestUtils.newPlugin("group", "foo2", ""));
        ArrayList<String> unchecked = new ArrayList<String>();
        unchecked.add("group : a-artifact");
        Collection results = rule.removeUncheckedPlugins(unchecked, plugins);
        TestRequirePluginVersions.assertNotNull((Object)results);
        TestRequirePluginVersions.assertEquals((int)2, (int)results.size());
        this.assertContainsPlugin("group", "foo", results);
        this.assertContainsPlugin("group", "foo2", results);
        this.assertNotContainPlugin("group", "a-artifact", results);
    }

    public void testCombinePlugins() {
        RequirePluginVersions rule = new RequirePluginVersions();
        HashSet<String> plugins = new HashSet<String>();
        plugins.add("group:a-artifact");
        plugins.add("group:foo");
        plugins.add("group:foo2");
        Collection results = rule.combineUncheckedPlugins(plugins, "group2:a,group3:b");
        TestRequirePluginVersions.assertNotNull((Object)results);
        TestRequirePluginVersions.assertEquals((int)5, (int)results.size());
        TestRequirePluginVersions.assertTrue((boolean)results.contains("group:foo"));
        TestRequirePluginVersions.assertTrue((boolean)results.contains("group:foo2"));
        TestRequirePluginVersions.assertTrue((boolean)results.contains("group:a-artifact"));
        TestRequirePluginVersions.assertTrue((boolean)results.contains("group2:a"));
        TestRequirePluginVersions.assertTrue((boolean)results.contains("group3:b"));
    }

    public void testCombinePlugins1() {
        RequirePluginVersions rule = new RequirePluginVersions();
        HashSet plugins = new HashSet();
        Collection results = rule.combineUncheckedPlugins(plugins, "group2:a,group3:b");
        TestRequirePluginVersions.assertNotNull((Object)results);
        TestRequirePluginVersions.assertEquals((int)2, (int)results.size());
        TestRequirePluginVersions.assertTrue((boolean)results.contains("group2:a"));
        TestRequirePluginVersions.assertTrue((boolean)results.contains("group3:b"));
    }

    public void testCombinePlugins2() {
        RequirePluginVersions rule = new RequirePluginVersions();
        Collection results = rule.combineUncheckedPlugins(null, "group2:a,group3:b");
        TestRequirePluginVersions.assertNotNull((Object)results);
        TestRequirePluginVersions.assertEquals((int)2, (int)results.size());
        TestRequirePluginVersions.assertTrue((boolean)results.contains("group2:a"));
        TestRequirePluginVersions.assertTrue((boolean)results.contains("group3:b"));
    }

    public void testCombinePlugins3() {
        RequirePluginVersions rule = new RequirePluginVersions();
        HashSet<String> plugins = new HashSet<String>();
        plugins.add("group:a-artifact");
        plugins.add("group:foo");
        plugins.add("group:foo2");
        Collection results = rule.combineUncheckedPlugins(plugins, "");
        TestRequirePluginVersions.assertNotNull((Object)results);
        TestRequirePluginVersions.assertEquals((int)3, (int)results.size());
        TestRequirePluginVersions.assertTrue((boolean)results.contains("group:foo"));
        TestRequirePluginVersions.assertTrue((boolean)results.contains("group:foo2"));
        TestRequirePluginVersions.assertTrue((boolean)results.contains("group:a-artifact"));
    }

    public void testCombinePlugins4() {
        RequirePluginVersions rule = new RequirePluginVersions();
        HashSet<String> plugins = new HashSet<String>();
        plugins.add("group:a-artifact");
        plugins.add("group:foo");
        plugins.add("group:foo2");
        Collection results = rule.combineUncheckedPlugins(plugins, null);
        TestRequirePluginVersions.assertNotNull((Object)results);
        TestRequirePluginVersions.assertEquals((int)3, (int)results.size());
        TestRequirePluginVersions.assertTrue((boolean)results.contains("group:foo"));
        TestRequirePluginVersions.assertTrue((boolean)results.contains("group:foo2"));
        TestRequirePluginVersions.assertTrue((boolean)results.contains("group:a-artifact"));
    }

    public void testCombinePlugins5() {
        RequirePluginVersions rule = new RequirePluginVersions();
        HashSet<String> plugins = new HashSet<String>();
        plugins.add("group:a-artifact");
        plugins.add("group:foo");
        plugins.add("group:foo2");
        Collection results = rule.combineUncheckedPlugins(plugins, "a");
        TestRequirePluginVersions.assertNotNull((Object)results);
        TestRequirePluginVersions.assertEquals((int)4, (int)results.size());
        TestRequirePluginVersions.assertTrue((boolean)results.contains("group:foo"));
        TestRequirePluginVersions.assertTrue((boolean)results.contains("group:foo2"));
        TestRequirePluginVersions.assertTrue((boolean)results.contains("a"));
    }

    private void assertContainsPlugin(String group, String artifact, Collection<Plugin> theSet) {
        Plugin p = new Plugin();
        p.setGroupId(group);
        p.setArtifactId(artifact);
        TestRequirePluginVersions.assertTrue((boolean)theSet.contains(p));
    }

    private void assertNotContainPlugin(String group, String artifact, Collection<Plugin> theSet) {
        Plugin p = new Plugin();
        p.setGroupId(group);
        p.setArtifactId(artifact);
        TestRequirePluginVersions.assertFalse((boolean)theSet.contains(p));
    }

    public void testId() {
        RequirePluginVersions rule = new RequirePluginVersions();
        rule.getCacheId();
    }
}

