/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import junit.framework.TestCase;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugins.enforcer.EnforcerTestUtils;
import org.apache.maven.plugins.enforcer.MockProject;
import org.apache.maven.plugins.enforcer.RequireProperty;

public class TestRequireProperty
extends TestCase {
    public void testRule() throws EnforcerRuleException {
        MockProject project = new MockProject();
        project.setProperty("testProp", "This is a test.");
        EnforcerRuleHelper helper = EnforcerTestUtils.getHelper(project);
        RequireProperty rule = new RequireProperty();
        rule.setProperty("testPropJunk");
        try {
            rule.execute(helper);
            TestRequireProperty.fail((String)"Expected an exception.");
        }
        catch (EnforcerRuleException e) {
            // empty catch block
        }
        rule.setProperty("testProp");
        try {
            rule.execute(helper);
        }
        catch (EnforcerRuleException e) {
            TestRequireProperty.fail((String)"This should not throw an exception");
        }
    }

    public void testRuleWithRegex() throws EnforcerRuleException {
        MockProject project = new MockProject();
        project.setProperty("testProp", "This is a test.");
        EnforcerRuleHelper helper = EnforcerTestUtils.getHelper(project);
        RequireProperty rule = new RequireProperty();
        rule.setProperty("testProp");
        rule.setRegex("[^abc]");
        try {
            rule.execute(helper);
            TestRequireProperty.fail((String)"Expected an exception.");
        }
        catch (EnforcerRuleException e) {
            // empty catch block
        }
        rule.setRegex("[This].*[.]");
        try {
            rule.execute(helper);
        }
        catch (EnforcerRuleException e) {
            TestRequireProperty.fail((String)"This should not throw an exception");
        }
    }

    public void testId() {
        RequireProperty rule = new RequireProperty();
        rule.getCacheId();
    }
}

