/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer.utils;

import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugins.enforcer.utils.ArtifactMatcher;

public class TestArtifactMatcher
extends TestCase {
    private ArtifactMatcher matcher;
    Collection<String> patterns = new ArrayList<String>();
    Collection<String> ignorePatterns = new ArrayList<String>();

    public void testPatternInvalidInput() throws InvalidVersionSpecificationException {
        try {
            new ArtifactMatcher.Pattern(null);
            TestArtifactMatcher.fail((String)"NullPointerException expected.");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            new ArtifactMatcher.Pattern("a:b:c:d:e:f:g");
            TestArtifactMatcher.fail((String)"IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new ArtifactMatcher.Pattern("a::");
            TestArtifactMatcher.fail((String)"IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            ArtifactMatcher.Pattern p = new ArtifactMatcher.Pattern("*");
            p.match(null);
            TestArtifactMatcher.fail((String)"NullPointerException expected.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPattern() throws InvalidVersionSpecificationException {
        this.executePatternMatch("groupId:artifactId:1.0:jar:compile", "groupId", "artifactId", "1.0", "compile", "jar", true);
        this.executePatternMatch("groupId:artifactId:1.0:jar:compile", "groupId", "artifactId", "1.0", "", "", true);
        this.executePatternMatch("groupId:artifactId:1.0", "groupId", "artifactId", "1.0", "", "", true);
        this.executePatternMatch("groupId:artifactId:1.0", "groupId", "artifactId", "1.1", "", "", true);
        this.executePatternMatch("groupId:artifactId:[1.0]", "groupId", "artifactId", "1.1", "", "", false);
        this.executePatternMatch("groupId:*:1.0", "groupId", "artifactId", "1.0", "test", "", true);
        this.executePatternMatch("*:*:1.0", "groupId", "artifactId", "1.0", "", "", true);
        this.executePatternMatch("*:artifactId:*", "groupId", "artifactId", "1.0", "", "", true);
        this.executePatternMatch("*", "groupId", "artifactId", "1.0", "", "", true);
        this.executePatternMatch("*:*:*:jar:compile:tests", "groupId", "artifactId", "1.0", "", "", "tests", true);
        this.executePatternMatch("*upId", "groupId", "artifactId", "1.0", "", "", true);
        this.executePatternMatch("gr*pId:?rt?f?ct?d:1.0", "groupId", "artifactId", "1.0", "", "", true);
        this.executePatternMatch("org.apache.*:maven-*:*", "org.apache.maven", "maven-core", "3.0", "", "", true);
    }

    public void testMatch() throws InvalidVersionSpecificationException {
        this.patterns.add("groupId:artifactId:1.0");
        this.patterns.add("*:anotherArtifact");
        this.ignorePatterns.add("badGroup:*:*:test");
        this.ignorePatterns.add("*:anotherArtifact:1.1");
        this.matcher = new ArtifactMatcher(this.patterns, this.ignorePatterns);
        this.executeMatch(this.matcher, "groupId", "artifactId", "1.0", "", "", true);
        this.executeMatch(this.matcher, "groupId", "anotherArtifact", "1.0", "", "", true);
        this.executeMatch(this.matcher, "badGroup", "artifactId", "1.0", "", "test", false);
        this.executeMatch(this.matcher, "badGroup", "anotherArtifact", "1.0", "", "", true);
        this.executeMatch(this.matcher, "groupId", "anotherArtifact", "1.1", "", "", false);
    }

    private void executePatternMatch(String pattern, String groupId, String artifactId, String versionRange, String scope, String type, boolean expectedResult) throws InvalidVersionSpecificationException {
        this.executePatternMatch(pattern, groupId, artifactId, versionRange, scope, type, "", expectedResult);
    }

    private void executePatternMatch(String pattern, String groupId, String artifactId, String versionRange, String scope, String type, String classifier, boolean expectedResult) throws InvalidVersionSpecificationException {
        TestArtifactMatcher.assertEquals((boolean)expectedResult, (boolean)new ArtifactMatcher.Pattern(pattern).match(TestArtifactMatcher.createMockArtifact(groupId, artifactId, versionRange, scope, type, classifier)));
    }

    private void executeMatch(ArtifactMatcher matcher, String groupId, String artifactId, String versionRange, String scope, String type, boolean expectedResult) throws InvalidVersionSpecificationException {
        TestArtifactMatcher.assertEquals((boolean)expectedResult, (boolean)matcher.match(TestArtifactMatcher.createMockArtifact(groupId, artifactId, versionRange, scope, type, "")));
    }

    private static Artifact createMockArtifact(String groupId, String artifactId, String versionRange, String scope, String type, String classifier) {
        DefaultArtifactHandler artifactHandler = new DefaultArtifactHandler();
        VersionRange version = VersionRange.createFromVersion((String)versionRange);
        return new DefaultArtifact(groupId, artifactId, version, scope, type, classifier, (ArtifactHandler)artifactHandler);
    }
}

