/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer.utils;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.plugin.testing.AbstractMojoTestCase;
import org.apache.maven.plugins.enforcer.EnforcerTestUtils;
import org.apache.maven.plugins.enforcer.MockProject;
import org.apache.maven.plugins.enforcer.utils.EnforcerRuleUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class TestEnforcerRuleUtils
extends AbstractMojoTestCase {
    public void testCheckIfModelMatches() {
        EnforcerRuleUtils utils = new EnforcerRuleUtils(EnforcerTestUtils.getHelper());
        Model model = new Model();
        model.setArtifactId("");
        model.setGroupId("");
        model.setVersion("");
        TestEnforcerRuleUtils.assertTrue((boolean)utils.checkIfModelMatches("", "", "", model));
        TestEnforcerRuleUtils.assertFalse((boolean)utils.checkIfModelMatches("", "", "1.0", model));
        Parent parent = new Parent();
        parent.setArtifactId("foo");
        parent.setGroupId("foo-group");
        parent.setVersion("1.0");
        model.setParent(parent);
        TestEnforcerRuleUtils.assertFalse((boolean)utils.checkIfModelMatches("foo-group", "foo", "1.0", model));
        TestEnforcerRuleUtils.assertTrue((boolean)utils.checkIfModelMatches("foo-group", "", "1.0", model));
        TestEnforcerRuleUtils.assertFalse((boolean)utils.checkIfModelMatches("foo-group", null, "1.0", model));
    }

    public void testGetModelsRecursivelyBottom() throws ArtifactResolutionException, ArtifactNotFoundException, IOException, XmlPullParserException {
        String path = "target/test-classes/requirePluginVersions/getPomRecursively/b/c";
        StringUtils.replace((String)path, (String)"/", (String)File.separator);
        File pom = new File(TestEnforcerRuleUtils.getBasedir() + File.separator + path, "pom.xml");
        EnforcerRuleUtils utils = new EnforcerRuleUtils(EnforcerTestUtils.getHelper());
        List models = utils.getModelsRecursively("group", "c", "1.0", pom);
        TestEnforcerRuleUtils.assertEquals((int)3, (int)models.size());
        Model m = new Model();
        m.setGroupId("group");
        m.setVersion("1.0");
        m.setArtifactId("c");
        models.contains(m);
        m.setArtifactId("b");
        models.contains(m);
        m.setArtifactId("a");
        models.contains(m);
    }

    public void testGetModelsRecursivelyTop() throws ArtifactResolutionException, ArtifactNotFoundException, IOException, XmlPullParserException {
        String path = "target/test-classes/requirePluginVersions/getPomRecursively";
        StringUtils.replace((String)path, (String)"/", (String)File.separator);
        File pom = new File(TestEnforcerRuleUtils.getBasedir() + File.separator + path, "pom.xml");
        EnforcerRuleUtils utils = new EnforcerRuleUtils(EnforcerTestUtils.getHelper());
        List models = utils.getModelsRecursively("group", "a", "1.0", pom);
        TestEnforcerRuleUtils.assertEquals((int)1, (int)models.size());
        Model m = new Model();
        m.setGroupId("group");
        m.setVersion("1.0");
        m.setArtifactId("a");
        models.contains(m);
    }

    public void testGetModelsRecursivelyParentExpression() throws ArtifactResolutionException, ArtifactNotFoundException, IOException, XmlPullParserException {
        String path = "target/test-classes/requirePluginVersions/parentExpression/child";
        StringUtils.replace((String)path, (String)"/", (String)File.separator);
        File pom = new File(TestEnforcerRuleUtils.getBasedir() + File.separator + path, "pom.xml");
        MockProject parent = new MockProject();
        parent.setGroupId("org.apache.maven.plugins.enforcer.test");
        parent.setArtifactId("parent");
        parent.setVersion("1.0-SNAPSHOT");
        MockProject project = new MockProject();
        project.setParent(parent);
        EnforcerRuleUtils utils = new EnforcerRuleUtils(EnforcerTestUtils.getHelper(project));
        List models = utils.getModelsRecursively("org.apache.maven.plugins.enforcer.test", "child", "1.0-SNAPSHOT", pom);
        TestEnforcerRuleUtils.assertEquals((int)2, (int)models.size());
    }

    public void testGetModelsRecursivelyParentRelativePath() throws ArtifactResolutionException, ArtifactNotFoundException, IOException, XmlPullParserException {
        String path = "target/test-classes/requirePluginVersions/parentRelativePath";
        StringUtils.replace((String)path, (String)"/", (String)File.separator);
        File pom = new File(TestEnforcerRuleUtils.getBasedir() + File.separator + path, "pom.xml");
        MockProject parent = new MockProject();
        parent.setGroupId("org.apache.maven.plugins.enforcer.test");
        parent.setArtifactId("parent");
        parent.setVersion("1.0-SNAPSHOT");
        MockProject project = new MockProject();
        project.setParent(parent);
        EnforcerRuleUtils utils = new EnforcerRuleUtils(EnforcerTestUtils.getHelper(project));
        List models = utils.getModelsRecursively("org.apache.maven.plugins.enforcer.test", "aggregate", "1.0-SNAPSHOT", pom);
        TestEnforcerRuleUtils.assertEquals((int)2, (int)models.size());
    }

    public void testGetModelsRecursivelyParentRelativePathDirectory() throws ArtifactResolutionException, ArtifactNotFoundException, IOException, XmlPullParserException {
        String path = "target/test-classes/requirePluginVersions/parentRelativePathDirectory";
        StringUtils.replace((String)path, (String)"/", (String)File.separator);
        File pom = new File(TestEnforcerRuleUtils.getBasedir() + File.separator + path, "pom.xml");
        MockProject parent = new MockProject();
        parent.setGroupId("org.apache.maven.plugins.enforcer.test");
        parent.setArtifactId("parent");
        parent.setVersion("1.0-SNAPSHOT");
        MockProject project = new MockProject();
        project.setParent(parent);
        EnforcerRuleUtils utils = new EnforcerRuleUtils(EnforcerTestUtils.getHelper(project));
        List models = utils.getModelsRecursively("org.apache.maven.plugins.enforcer.test", "aggregate", "1.0-SNAPSHOT", pom);
        TestEnforcerRuleUtils.assertEquals((int)2, (int)models.size());
    }

    public static void execute(EnforcerRule rule, EnforcerRuleHelper helper, boolean shouldFail) {
        try {
            rule.execute(helper);
            if (shouldFail) {
                TestEnforcerRuleUtils.fail((String)"Exception expected.");
            }
        }
        catch (EnforcerRuleException e) {
            if (!shouldFail) {
                TestEnforcerRuleUtils.fail((String)("No Exception expected:" + e.getLocalizedMessage()));
            }
            helper.getLog().debug((CharSequence)e.getMessage());
        }
    }
}

