/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer.utils;

import junit.framework.TestCase;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.enforcer.EnforcerExpressionEvaluator;
import org.apache.maven.plugins.enforcer.EnforcerTestUtils;
import org.apache.maven.plugins.enforcer.MockPathTranslator;
import org.apache.maven.plugins.enforcer.MockProject;
import org.apache.maven.plugins.enforcer.utils.MockEnforcerExpressionEvaluator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public class TestMockEnforcerExpressionEvaluator
extends TestCase {
    public void testEvaluate() {
        MavenSession session = EnforcerTestUtils.getMavenSession();
        MockEnforcerExpressionEvaluator ev = new MockEnforcerExpressionEvaluator(session, new MockPathTranslator(), new MockProject());
        this.assertMatch(ev, "SNAPSHOT");
        this.assertMatch(ev, "RELEASE");
        this.assertMatch(ev, "SNAPSHOT");
        this.assertMatch(ev, "LATEST");
        this.assertMatch(ev, "1.0");
    }

    public void assertMatch(EnforcerExpressionEvaluator ev, String exp) {
        try {
            TestMockEnforcerExpressionEvaluator.assertEquals((Object)exp, (Object)ev.evaluate("${" + exp + "}"));
        }
        catch (ExpressionEvaluationException e) {
            TestMockEnforcerExpressionEvaluator.fail((String)e.getLocalizedMessage());
        }
    }
}

