/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.testing.ArtifactStubFactory;
import org.apache.maven.plugins.enforcer.BannedDependencies;
import org.apache.maven.plugins.enforcer.EnforcerTestUtils;
import org.apache.maven.plugins.enforcer.MockProject;
import org.apache.maven.project.MavenProject;

public class TestBannedDependencies
extends TestCase {
    public void testRule() throws IOException {
        ArtifactStubFactory factory = new ArtifactStubFactory();
        MockProject project = new MockProject();
        EnforcerRuleHelper helper = EnforcerTestUtils.getHelper(project);
        project.setArtifacts(factory.getMixedArtifacts());
        project.setDependencyArtifacts(factory.getScopedArtifacts());
        BannedDependencies rule = this.newBannedDependenciesRule();
        ArrayList<String> excludes = new ArrayList<String>();
        rule.setSearchTransitive(false);
        excludes.add("testGroupId:release:1.0");
        rule.setExcludes(excludes);
        this.execute(rule, helper, false);
        excludes.clear();
        excludes.add("testGroupId:release");
        this.execute(rule, helper, false);
        excludes.clear();
        excludes.add("testGroupId");
        this.execute(rule, helper, false);
        excludes.clear();
        excludes.add("g:compile:1.0");
        this.execute(rule, helper, true);
        rule.setSearchTransitive(true);
        excludes.clear();
        excludes.add("testGroupId:release:1.0");
        this.execute(rule, helper, true);
        excludes.clear();
        excludes.add("testGroupId:release");
        this.execute(rule, helper, true);
        excludes.clear();
        excludes.add("testGroupId");
        this.execute(rule, helper, true);
        excludes.clear();
        excludes.add("*:release");
        this.execute(rule, helper, true);
        excludes.clear();
        excludes.add("*:*:1.0");
        this.execute(rule, helper, true);
        excludes.clear();
        excludes.add("*:release:*");
        this.execute(rule, helper, true);
        excludes.clear();
        excludes.add("*:release:1.2");
        this.execute(rule, helper, false);
        excludes.add("*:release:*");
        this.execute(rule, helper, true);
        excludes.clear();
        excludes.add("  testGroupId  :  release   :   1.0    ");
        this.execute(rule, helper, true);
        excludes.clear();
        excludes.add(":::");
        this.execute(rule, helper, false);
    }

    public void testIncludes() throws IOException {
        ArtifactStubFactory factory = new ArtifactStubFactory();
        MockProject project = new MockProject();
        EnforcerRuleHelper helper = EnforcerTestUtils.getHelper(project);
        project.setArtifacts(factory.getMixedArtifacts());
        project.setDependencyArtifacts(factory.getScopedArtifacts());
        BannedDependencies rule = this.newBannedDependenciesRule();
        ArrayList<String> excludes = new ArrayList<String>();
        ArrayList<String> includes = new ArrayList<String>();
        rule.setSearchTransitive(false);
        excludes.add("*");
        includes.add("*");
        rule.setExcludes(excludes);
        rule.setIncludes(includes);
        this.execute(rule, helper, false);
        excludes.clear();
        excludes.add("*:runtime");
        rule.setExcludes(excludes);
        this.execute(rule, helper, false);
        includes.clear();
        includes.add("*:test");
        rule.setIncludes(includes);
        this.execute(rule, helper, true);
    }

    private BannedDependencies newBannedDependenciesRule() {
        BannedDependencies rule = new BannedDependencies(){

            protected Set<Artifact> getDependenciesToCheck(MavenProject project) {
                return this.isSearchTransitive() ? project.getArtifacts() : project.getDependencyArtifacts();
            }
        };
        return rule;
    }

    private void execute(BannedDependencies rule, EnforcerRuleHelper helper, boolean shouldFail) {
        block3: {
            try {
                rule.setMessage(null);
                rule.execute(helper);
                if (shouldFail) {
                    TestBannedDependencies.fail((String)"Exception expected.");
                }
            }
            catch (EnforcerRuleException e) {
                if (shouldFail) break block3;
                TestBannedDependencies.fail((String)("No Exception expected:" + e.getLocalizedMessage()));
            }
        }
    }
}

