/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.io.IOException;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.testing.ArtifactStubFactory;
import org.apache.maven.plugins.enforcer.EnforcerTestUtils;
import org.apache.maven.plugins.enforcer.MockProject;
import org.apache.maven.plugins.enforcer.NoSnapshots;
import org.apache.maven.plugins.enforcer.utils.TestEnforcerRuleUtils;
import org.apache.maven.project.MavenProject;

public class TestNoSnapshots
extends TestCase {
    public void testRule() throws IOException {
        ArtifactStubFactory factory = new ArtifactStubFactory();
        MockProject project = new MockProject();
        EnforcerRuleHelper helper = EnforcerTestUtils.getHelper(project);
        project.setArtifacts(factory.getMixedArtifacts());
        project.setDependencyArtifacts(factory.getScopedArtifacts());
        NoSnapshots rule = this.newNoSnapshots();
        rule.setSearchTransitive(false);
        TestEnforcerRuleUtils.execute((EnforcerRule)rule, helper, false);
        rule.setSearchTransitive(true);
        TestEnforcerRuleUtils.execute((EnforcerRule)rule, helper, true);
        project.setArtifact(factory.getSnapshotArtifact());
        TestEnforcerRuleUtils.execute((EnforcerRule)rule, helper, true);
    }

    private NoSnapshots newNoSnapshots() {
        NoSnapshots rule = new NoSnapshots(){

            protected Set<Artifact> getDependenciesToCheck(MavenProject project) {
                return this.isSearchTransitive() ? project.getArtifacts() : project.getDependencyArtifacts();
            }
        };
        return rule;
    }

    public void testId() {
        NoSnapshots rule = this.newNoSnapshots();
        rule.getCacheId();
    }
}

