/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.plugins.enforcer.EnforcerTestUtils;
import org.apache.maven.plugins.enforcer.RequireFilesDontExist;

public class TestRequireFilesDontExist
extends TestCase {
    RequireFilesDontExist rule = new RequireFilesDontExist();

    public void testFileExists() throws EnforcerRuleException, IOException {
        File f = File.createTempFile("enforcer", "tmp");
        f.deleteOnExit();
        this.rule.files = new File[]{f};
        try {
            this.rule.execute(EnforcerTestUtils.getHelper());
            TestRequireFilesDontExist.fail((String)"Expected an Exception.");
        }
        catch (EnforcerRuleException e) {
            TestRequireFilesDontExist.assertTrue((boolean)true);
        }
        f.delete();
    }

    public void testEmptyFile() throws EnforcerRuleException, IOException {
        this.rule.files = new File[]{null};
        try {
            this.rule.execute(EnforcerTestUtils.getHelper());
            TestRequireFilesDontExist.fail((String)"Should get exception");
        }
        catch (EnforcerRuleException e) {
            TestRequireFilesDontExist.assertTrue((boolean)true);
        }
    }

    public void testEmptyFileAllowNull() throws EnforcerRuleException, IOException {
        this.rule.files = new File[]{null};
        this.rule.allowNulls = true;
        try {
            this.rule.execute(EnforcerTestUtils.getHelper());
        }
        catch (EnforcerRuleException e) {
            TestRequireFilesDontExist.fail((String)("Unexpected Exception:" + e.getLocalizedMessage()));
        }
    }

    public void testEmptyFileList() throws EnforcerRuleException, IOException {
        this.rule.files = new File[0];
        TestRequireFilesDontExist.assertEquals((int)0, (int)this.rule.files.length);
        try {
            this.rule.execute(EnforcerTestUtils.getHelper());
            TestRequireFilesDontExist.fail((String)"Should get exception");
        }
        catch (EnforcerRuleException e) {
            TestRequireFilesDontExist.assertTrue((boolean)true);
        }
    }

    public void testEmptyFileListAllowNull() throws EnforcerRuleException, IOException {
        this.rule.files = new File[0];
        TestRequireFilesDontExist.assertEquals((int)0, (int)this.rule.files.length);
        this.rule.allowNulls = true;
        try {
            this.rule.execute(EnforcerTestUtils.getHelper());
        }
        catch (EnforcerRuleException e) {
            TestRequireFilesDontExist.fail((String)("Unexpected Exception:" + e.getLocalizedMessage()));
        }
    }

    public void testFileDoesNotExist() throws EnforcerRuleException, IOException {
        File f = File.createTempFile("enforcer", "tmp");
        f.delete();
        TestRequireFilesDontExist.assertTrue((!f.exists() ? 1 : 0) != 0);
        this.rule.files = new File[]{f};
        this.rule.execute(EnforcerTestUtils.getHelper());
    }

    public void testId() {
        this.rule.getCacheId();
    }
}

