/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import junit.framework.TestCase;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugins.enforcer.EnforcerTestUtils;
import org.apache.maven.plugins.enforcer.RequireJavaVersion;

public class TestRequireJavaVersion
extends TestCase {
    public void testFixJDKVersion() {
        TestRequireJavaVersion.assertEquals((String)"1.5.0-11", (String)RequireJavaVersion.normalizeJDKVersion((String)"1.5.0_11"));
        TestRequireJavaVersion.assertEquals((String)"1.5.1", (String)RequireJavaVersion.normalizeJDKVersion((String)"1.5.1"));
        TestRequireJavaVersion.assertEquals((String)"1.5.2-1", (String)RequireJavaVersion.normalizeJDKVersion((String)"1.5.2-1.b11"));
        TestRequireJavaVersion.assertEquals((String)"1.5.3-11", (String)RequireJavaVersion.normalizeJDKVersion((String)"1.5.3_11"));
        TestRequireJavaVersion.assertEquals((String)"1.5.4-5", (String)RequireJavaVersion.normalizeJDKVersion((String)"1.5.4.5_11"));
        TestRequireJavaVersion.assertEquals((String)"1.5.5-6", (String)RequireJavaVersion.normalizeJDKVersion((String)"1.5.5.6_11.2"));
        TestRequireJavaVersion.assertEquals((String)"1.5.0-11", (String)RequireJavaVersion.normalizeJDKVersion((String)"1-5-0-11"));
        TestRequireJavaVersion.assertEquals((String)"1.5.0-11", (String)RequireJavaVersion.normalizeJDKVersion((String)"1-_5-_0-_11"));
        TestRequireJavaVersion.assertEquals((String)"1.5.0-11", (String)RequireJavaVersion.normalizeJDKVersion((String)"1_5_0_11"));
        TestRequireJavaVersion.assertEquals((String)"1.5.0-7", (String)RequireJavaVersion.normalizeJDKVersion((String)"1.5.0-07"));
        TestRequireJavaVersion.assertEquals((String)"1.5.0-7", (String)RequireJavaVersion.normalizeJDKVersion((String)"1.5.0-b7"));
        TestRequireJavaVersion.assertEquals((String)"1.5.0-7", (String)RequireJavaVersion.normalizeJDKVersion((String)"1.5.0-;7"));
        TestRequireJavaVersion.assertEquals((String)"1.6.0", (String)RequireJavaVersion.normalizeJDKVersion((String)"1.6.0-dp"));
        TestRequireJavaVersion.assertEquals((String)"1.6.0-2", (String)RequireJavaVersion.normalizeJDKVersion((String)"1.6.0-dp2"));
    }

    public void testRule() throws EnforcerRuleException {
        String thisVersion = RequireJavaVersion.normalizeJDKVersion((String)SystemUtils.JAVA_VERSION_TRIMMED);
        RequireJavaVersion rule = new RequireJavaVersion();
        rule.setVersion(thisVersion);
        EnforcerRuleHelper helper = EnforcerTestUtils.getHelper();
        rule.execute(helper);
        rule.setVersion("(" + thisVersion);
        try {
            rule.execute(helper);
            TestRequireJavaVersion.fail((String)"Expected an exception.");
        }
        catch (EnforcerRuleException e) {
            // empty catch block
        }
        rule.setVersion(SystemUtils.JAVA_VERSION_TRIMMED);
        rule.execute(helper);
    }

    public void testId() {
        RequireJavaVersion rule = new RequireJavaVersion();
        rule.getCacheId();
    }
}

