/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.plugins.enforcer.EnforcerTestUtils;
import org.apache.maven.plugins.enforcer.RequireOS;
import org.codehaus.plexus.util.Os;

public class TestRequireOS
extends TestCase {
    public void testOS() {
        SystemStreamLog log = new SystemStreamLog();
        RequireOS rule = new RequireOS();
        rule.displayOSInfo((Log)log, true);
        Iterator iter = Os.getValidFamilies().iterator();
        String validFamily = null;
        String invalidFamily = null;
        while (iter.hasNext()) {
            String fam = (String)iter.next();
            if (Os.isFamily((String)fam)) continue;
            invalidFamily = fam;
            break;
        }
        validFamily = Os.OS_FAMILY;
        log.info((CharSequence)("Testing Mojo Using Valid Family: " + validFamily + " Invalid Family: " + invalidFamily));
        rule.setFamily(validFamily);
        TestRequireOS.assertTrue((boolean)rule.isAllowed());
        rule.setFamily(invalidFamily);
        TestRequireOS.assertFalse((boolean)rule.isAllowed());
        rule.setFamily("!" + invalidFamily);
        TestRequireOS.assertTrue((boolean)rule.isAllowed());
        rule.setFamily("junk");
        try {
            rule.execute(EnforcerTestUtils.getHelper());
            TestRequireOS.fail((String)"Expected MojoExecution Exception becuase of invalid family type");
        }
        catch (EnforcerRuleException e) {
            log.info((CharSequence)("Caught Expected Exception:" + e.getLocalizedMessage()));
        }
        rule.setFamily(null);
        rule.setArch(Os.OS_ARCH);
        TestRequireOS.assertTrue((boolean)rule.isAllowed());
        rule.setArch("somecrazyarch");
        TestRequireOS.assertFalse((boolean)rule.isAllowed());
        rule.setArch("!somecrazyarch");
        TestRequireOS.assertTrue((boolean)rule.isAllowed());
        rule.setArch(null);
        rule.setName(Os.OS_NAME);
        TestRequireOS.assertTrue((boolean)rule.isAllowed());
        rule.setName("somecrazyname");
        TestRequireOS.assertFalse((boolean)rule.isAllowed());
        rule.setName("!somecrazyname");
        TestRequireOS.assertTrue((boolean)rule.isAllowed());
        rule.setName(null);
        rule.setVersion(Os.OS_VERSION);
        TestRequireOS.assertTrue((boolean)rule.isAllowed());
        rule.setVersion("somecrazyversion");
        TestRequireOS.assertFalse((boolean)rule.isAllowed());
        rule.setVersion("!somecrazyversion");
        TestRequireOS.assertTrue((boolean)rule.isAllowed());
    }

    public void testId() {
        RequireOS rule = new RequireOS();
        rule.getCacheId();
    }
}

