/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.versions.UpdateParentMojo;
import org.codehaus.mojo.versions.api.DisplayParentUpdateReport;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.ObjectToXmlWriter;

public class DisplayParentUpdateMojo
extends UpdateParentMojo {
    private File xmlReport;

    public void setXmlReport(File xmlReport) {
        this.xmlReport = xmlReport;
    }

    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        if (this.hasParentPom() && !this.isPartOfReactorProject()) {
            ArtifactVersion latestVersion;
            VersionRange versionRange;
            String currentVersion;
            String version = currentVersion = this.getProject().getParent().getVersion();
            if (this.parentVersion != null) {
                version = this.parentVersion;
            }
            try {
                versionRange = VersionRange.createFromVersionSpec((String)version);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new MojoExecutionException("Invalid version range specification: " + version, (Exception)((Object)e));
            }
            Artifact artifact = this.artifactFactory.createDependencyArtifact(this.getProject().getParent().getGroupId(), this.getProject().getParent().getArtifactId(), versionRange, "pom", null, null);
            try {
                latestVersion = this.findLatestVersion(artifact, versionRange, null, false);
            }
            catch (ArtifactMetadataRetrievalException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            Artifact parentArtifact = this.getProject().getParentArtifact();
            DisplayParentUpdateReport report = new DisplayParentUpdateReport(parentArtifact, currentVersion, latestVersion.toString());
            ObjectToXmlWriter.writeXmlReport(this.xmlReport, report);
        }
    }

    private boolean isPartOfReactorProject() {
        return this.reactorProjects.contains(this.getProject().getParent());
    }

    private boolean hasParentPom() {
        return this.getProject().getParent() != null;
    }
}

