/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.UpdateScope;
import org.codehaus.mojo.versions.report.ArtifactUpdate;
import org.codehaus.mojo.versions.report.Dependency;
import org.codehaus.mojo.versions.report.DisplayDependencyUpdatesReport;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.DependencyComparator;
import org.codehaus.mojo.versions.utils.ObjectToXmlWriter;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayDependencyUpdatesMojo
extends AbstractVersionsUpdaterMojo {
    private static final int INFO_PAD_SIZE = 72;
    protected Boolean processDependencyManagement = Boolean.TRUE;
    protected Boolean processDependencies = Boolean.TRUE;
    protected Boolean verbose = Boolean.FALSE;
    private File xmlReport;
    private DisplayDependencyUpdatesReport report = new DisplayDependencyUpdatesReport();

    public void setXmlReport(File xmlReport) {
        this.xmlReport = xmlReport;
    }

    private static Set removeDependencyManagment(Set dependencies, Set dependencyManagement) {
        TreeSet<org.apache.maven.model.Dependency> result = new TreeSet<org.apache.maven.model.Dependency>(new DependencyComparator());
        for (org.apache.maven.model.Dependency c : dependencies) {
            boolean matched = false;
            Iterator j = dependencyManagement.iterator();
            while (!matched && j.hasNext()) {
                org.apache.maven.model.Dependency t = (org.apache.maven.model.Dependency)j.next();
                if (!StringUtils.equals((String)t.getGroupId(), (String)c.getGroupId()) || !StringUtils.equals((String)t.getArtifactId(), (String)c.getArtifactId()) || t.getScope() != null && !StringUtils.equals((String)t.getScope(), (String)c.getScope()) || t.getClassifier() != null && !StringUtils.equals((String)t.getClassifier(), (String)c.getClassifier()) || c.getVersion() != null && t.getVersion() != null && !StringUtils.equals((String)t.getVersion(), (String)c.getVersion())) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            result.add(c);
        }
        return result;
    }

    public boolean isProcessingDependencyManagement() {
        return !Boolean.FALSE.equals(this.processDependencyManagement);
    }

    public boolean isProcessingDependencies() {
        return !Boolean.FALSE.equals(this.processDependencies);
    }

    public boolean isVerbose() {
        return !Boolean.FALSE.equals(this.verbose);
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        TreeSet<org.apache.maven.model.Dependency> dependencyManagement = new TreeSet<org.apache.maven.model.Dependency>(new DependencyComparator());
        dependencyManagement.addAll(this.getProject().getDependencyManagement() == null ? Collections.EMPTY_LIST : this.getProject().getDependencyManagement().getDependencies());
        Set<Object> dependencies = new TreeSet<org.apache.maven.model.Dependency>(new DependencyComparator());
        dependencies.addAll(this.getProject().getDependencies());
        if (this.isProcessingDependencyManagement()) {
            dependencies = DisplayDependencyUpdatesMojo.removeDependencyManagment(dependencies, dependencyManagement);
        }
        try {
            if (this.isProcessingDependencyManagement()) {
                this.logUpdates(this.getHelper().lookupDependenciesUpdates(dependencyManagement, false), "Dependency Management");
            }
            if (this.isProcessingDependencies()) {
                this.logUpdates(this.getHelper().lookupDependenciesUpdates(dependencies, false), "Dependencies");
            }
            ObjectToXmlWriter.writeXmlReport(this.xmlReport, this.report);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void logUpdates(Map updates, String section) {
        Iterator<Object> i;
        ArrayList withUpdates = new ArrayList();
        ArrayList<String> usingCurrent = new ArrayList<String>();
        for (ArtifactVersions versions : updates.values()) {
            ArrayList<String> t;
            ArtifactVersion latest;
            String current;
            String left = "  " + ArtifactUtils.versionlessKey((Artifact)versions.getArtifact()) + " ";
            if (versions.isCurrentVersionDefined()) {
                current = versions.getCurrentVersion().toString();
                latest = versions.getNewestUpdate(UpdateScope.ANY, Boolean.TRUE.equals(this.allowSnapshots));
            } else {
                ArtifactVersion newestVersion = versions.getNewestVersion(versions.getArtifact().getVersionRange(), Boolean.TRUE.equals(this.allowSnapshots));
                current = versions.getArtifact().getVersionRange().toString();
                ArtifactVersion artifactVersion = latest = newestVersion == null ? null : versions.getNewestUpdate(newestVersion, UpdateScope.ANY, Boolean.TRUE.equals(this.allowSnapshots));
                if (latest != null && ArtifactVersions.isVersionInRange(latest, versions.getArtifact().getVersionRange())) {
                    latest = null;
                }
            }
            String right = " " + (latest == null ? current : current + " -> " + latest.toString());
            ArrayList<String> arrayList = t = latest == null ? usingCurrent : withUpdates;
            if (right.length() + left.length() + 3 > 72) {
                t.add(left + "...");
                t.add(StringUtils.leftPad((String)right, (int)72));
                continue;
            }
            t.add(StringUtils.rightPad((String)left, (int)(72 - right.length()), (String)".") + right);
        }
        if (this.isVerbose() && usingCurrent.isEmpty() && !withUpdates.isEmpty()) {
            this.getLog().info((CharSequence)("No dependencies in " + section + " are using the newest version."));
            this.getLog().info((CharSequence)"");
        } else if (this.isVerbose() && !usingCurrent.isEmpty()) {
            this.getLog().info((CharSequence)("The following dependencies in " + section + " are using the newest version:"));
            i = usingCurrent.iterator();
            while (i.hasNext()) {
                this.getLog().info((CharSequence)((String)i.next()));
            }
            this.getLog().info((CharSequence)"");
        }
        if (withUpdates.isEmpty() && !usingCurrent.isEmpty()) {
            this.getLog().info((CharSequence)("No dependencies in " + section + " have newer versions."));
            this.getLog().info((CharSequence)"");
        } else if (!withUpdates.isEmpty()) {
            this.getLog().info((CharSequence)("The following dependencies in " + section + " have newer versions:"));
            i = withUpdates.iterator();
            while (i.hasNext()) {
                this.getLog().info((CharSequence)((String)i.next()));
            }
            this.getLog().info((CharSequence)"");
        }
        this.reportUpdatesToFile(updates, section);
    }

    private void reportUpdatesToFile(Map<org.apache.maven.model.Dependency, ArtifactVersions> updates, String section) {
        if (null == this.xmlReport) {
            return;
        }
        ArrayList artiFactUpdates = new ArrayList(updates.size());
        for (Map.Entry<org.apache.maven.model.Dependency, ArtifactVersions> entry : updates.entrySet()) {
            ArtifactVersions versions = entry.getValue();
            ArtifactVersion latest = null;
            if (versions.isCurrentVersionDefined()) {
                latest = versions.getNewestUpdate(UpdateScope.ANY, Boolean.TRUE.equals(this.allowSnapshots));
            } else {
                ArtifactVersion newestVersion = versions.getNewestVersion(versions.getArtifact().getVersionRange(), Boolean.TRUE.equals(this.allowSnapshots));
                if (newestVersion != null && ArtifactVersions.isVersionInRange(latest = versions.getNewestUpdate(newestVersion, UpdateScope.ANY, Boolean.TRUE.equals(this.allowSnapshots)), versions.getArtifact().getVersionRange())) continue;
            }
            ArtifactUpdate update = new ArtifactUpdate();
            Dependency dependency = new Dependency();
            dependency.setGroupId(entry.getKey().getGroupId());
            dependency.setArtifactId(entry.getKey().getArtifactId());
            dependency.setScope(entry.getKey().getScope());
            dependency.setVersion(entry.getKey().getVersion());
            dependency.setType(entry.getKey().getType());
            dependency.setProjectId(this.getProject().getId());
            for (String key : new String[]{"", "groupId", "artifactId", "version"}) {
                dependency.addInputLocation(key, entry.getKey().getLocation((Object)key));
            }
            update.setDependency(dependency);
            update.setVersionUpdate(null == latest ? null : latest.toString());
            this.report.addUpdate(section, update);
        }
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
    }
}

