/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.maven.BuildFailureException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.InvalidPluginException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.version.PluginVersionNotFoundException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.DefaultProjectBuilderConfiguration;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.project.interpolation.ModelInterpolator;
import org.apache.maven.settings.Settings;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.ordering.MavenVersionComparator;
import org.codehaus.mojo.versions.report.ArtifactUpdate;
import org.codehaus.mojo.versions.report.Dependency;
import org.codehaus.mojo.versions.report.DisplayPluginUpdatesReport;
import org.codehaus.mojo.versions.report.IncompatibleParentAndProjectMavenVersion;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.ObjectToXmlWriter;
import org.codehaus.mojo.versions.utils.PluginComparator;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayPluginUpdatesMojo
extends AbstractVersionsUpdaterMojo {
    private static final int WARN_PAD_SIZE = 65;
    private static final int INFO_PAD_SIZE = 68;
    private static final String FROM_SUPER_POM = "(from super-pom) ";
    private LifecycleExecutor lifecycleExecutor;
    private ModelInterpolator modelInterpolator;
    private PluginManager pluginManager;
    private RuntimeInformation runtimeInformation;
    private DisplayPluginUpdatesReport report = new DisplayPluginUpdatesReport();
    private File xmlReport;

    public void setXmlReport(File xmlReport) {
        this.xmlReport = xmlReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getSuperPomPluginManagement() throws MojoExecutionException {
        if (new DefaultArtifactVersion("3.0").compareTo((Object)this.runtimeInformation.getApplicationVersion()) <= 0) {
            this.getLog().debug((CharSequence)"Using Maven 3.x strategy to determine superpom defined plugins");
            try {
                Method getPluginsBoundByDefaultToAllLifecycles = LifecycleExecutor.class.getMethod("getPluginsBoundByDefaultToAllLifecycles", String.class);
                Set plugins = (Set)getPluginsBoundByDefaultToAllLifecycles.invoke((Object)this.lifecycleExecutor, this.getProject().getPackaging());
                LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(plugins.size());
                for (Plugin plugin : plugins) {
                    result.put(DisplayPluginUpdatesMojo.getPluginCoords(plugin), DisplayPluginUpdatesMojo.getPluginVersion(plugin));
                }
                URL superPom = ((Object)((Object)this)).getClass().getClassLoader().getResource("org/apache/maven/model/pom-4.0.0.xml");
                if (superPom != null) {
                    try {
                        XmlStreamReader reader = ReaderFactory.newXmlReader((URL)superPom);
                        try {
                            StringBuilder buf = new StringBuilder(IOUtil.toString((Reader)reader));
                            ModifiedPomXMLEventReader pom = this.newModifiedPomXER(buf);
                            Pattern pathRegex = Pattern.compile("/project(/profiles/profile)?((/build(/pluginManagement)?)|(/reporting))/plugins/plugin");
                            Stack<StackState> pathStack = new Stack<StackState>();
                            StackState curState = null;
                            while (pom.hasNext()) {
                                XMLEvent event = pom.nextEvent();
                                if (event.isStartDocument()) {
                                    curState = new StackState("");
                                    pathStack.clear();
                                    continue;
                                }
                                if (event.isStartElement()) {
                                    String elementName = event.asStartElement().getName().getLocalPart();
                                    if (curState != null && pathRegex.matcher(curState.path).matches()) {
                                        if ("groupId".equals(elementName)) {
                                            curState.groupId = pom.getElementText().trim();
                                            continue;
                                        }
                                        if ("artifactId".equals(elementName)) {
                                            curState.artifactId = pom.getElementText().trim();
                                            continue;
                                        }
                                        if ("version".equals(elementName)) {
                                            curState.version = pom.getElementText().trim();
                                            continue;
                                        }
                                    }
                                    pathStack.push(curState);
                                    curState = new StackState(curState.path + "/" + elementName);
                                    continue;
                                }
                                if (!event.isEndElement()) continue;
                                if (curState != null && pathRegex.matcher(curState.path).matches() && curState.artifactId != null) {
                                    Plugin plugin = new Plugin();
                                    plugin.setArtifactId(curState.artifactId);
                                    plugin.setGroupId(curState.groupId == null ? "org.apache.maven.plugins" : curState.groupId);
                                    plugin.setVersion(curState.version);
                                    if (!result.containsKey(DisplayPluginUpdatesMojo.getPluginCoords(plugin))) {
                                        result.put(DisplayPluginUpdatesMojo.getPluginCoords(plugin), DisplayPluginUpdatesMojo.getPluginVersion(plugin));
                                    }
                                }
                                curState = (StackState)pathStack.pop();
                            }
                        }
                        finally {
                            IOUtil.close((Reader)reader);
                        }
                    }
                    catch (IOException e) {
                    }
                    catch (XMLStreamException e) {
                        // empty catch block
                    }
                }
                return result;
            }
            catch (NoSuchMethodException e1) {
            }
            catch (InvocationTargetException e1) {
            }
            catch (IllegalAccessException e1) {
                // empty catch block
            }
        }
        this.getLog().debug((CharSequence)"Using Maven 2.x strategy to determine superpom defined plugins");
        HashMap<String, String> superPomPluginManagement = new HashMap<String, String>();
        try {
            MavenProject superProject = this.projectBuilder.buildStandaloneSuperProject((ProjectBuilderConfiguration)new DefaultProjectBuilderConfiguration());
            superPomPluginManagement.putAll(this.getPluginManagement(superProject.getOriginalModel()));
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("Could not determine the super pom.xml", (Exception)((Object)e));
        }
        return superPomPluginManagement;
    }

    private Map<String, String> getPluginManagement(Model model) {
        HashMap<String, String> pluginManagement = new HashMap<String, String>();
        try {
            for (Plugin plugin : model.getBuild().getPluginManagement().getPlugins()) {
                String coord = DisplayPluginUpdatesMojo.getPluginCoords(plugin);
                String version = DisplayPluginUpdatesMojo.getPluginVersion(plugin);
                if (version == null) continue;
                pluginManagement.put(coord, version);
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            for (Profile profile : model.getProfiles()) {
                try {
                    for (Plugin plugin : profile.getBuild().getPluginManagement().getPlugins()) {
                        String coord = DisplayPluginUpdatesMojo.getPluginCoords(plugin);
                        String version = DisplayPluginUpdatesMojo.getPluginVersion(plugin);
                        if (version == null) continue;
                        pluginManagement.put(coord, version);
                    }
                }
                catch (NullPointerException e) {
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return pluginManagement;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean noExplicitMavenMinVersion;
        Set<String> pluginsWithVersionsSpecified;
        try {
            pluginsWithVersionsSpecified = this.findPluginsWithVersionsSpecified(this.getProject());
        }
        catch (XMLStreamException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        Map<String, String> superPomPluginManagement = this.getSuperPomPluginManagement();
        this.getLog().debug((CharSequence)("superPom plugins = " + superPomPluginManagement));
        HashMap<String, String> parentPluginManagement = new HashMap<String, String>();
        HashMap<String, String> parentBuildPlugins = new HashMap<String, String>();
        HashMap<String, String> parentReportPlugins = new HashMap<String, String>();
        List<MavenProject> parents = this.getParentProjects(this.getProject());
        for (MavenProject parentProject : parents) {
            Model interpolatedModel;
            this.getLog().debug((CharSequence)("Processing parent: " + parentProject.getGroupId() + ":" + parentProject.getArtifactId() + ":" + parentProject.getVersion() + " -> " + parentProject.getFile()));
            StringWriter writer = new StringWriter();
            boolean havePom = false;
            try {
                Model originalModel = parentProject.getOriginalModel();
                if (originalModel == null) {
                    this.getLog().warn((CharSequence)("project.getOriginalModel()==null for  " + parentProject.getGroupId() + ":" + parentProject.getArtifactId() + ":" + parentProject.getVersion() + " is null, substituting project.getModel()"));
                    originalModel = parentProject.getModel();
                }
                try {
                    new MavenXpp3Writer().write((Writer)writer, originalModel);
                    writer.close();
                    havePom = true;
                }
                catch (IOException e) {
                    // empty catch block
                }
                interpolatedModel = this.modelInterpolator.interpolate(originalModel, null, new DefaultProjectBuilderConfiguration().setExecutionProperties(this.getProject().getProperties()), false);
            }
            catch (ModelInterpolationException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            if (havePom) {
                try {
                    Set<String> withVersionSpecified = this.findPluginsWithVersionsSpecified(new StringBuilder(writer.toString()));
                    Map<String, String> map = this.getPluginManagement(interpolatedModel);
                    map.keySet().retainAll(withVersionSpecified);
                    parentPluginManagement.putAll(map);
                    map = this.getBuildPlugins(interpolatedModel, true);
                    map.keySet().retainAll(withVersionSpecified);
                    parentPluginManagement.putAll(map);
                    map = this.getReportPlugins(interpolatedModel, true);
                    map.keySet().retainAll(withVersionSpecified);
                    parentPluginManagement.putAll(map);
                    continue;
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
                catch (XMLStreamException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
            parentPluginManagement.putAll(this.getPluginManagement(interpolatedModel));
            parentPluginManagement.putAll(this.getBuildPlugins(interpolatedModel, true));
            parentPluginManagement.putAll(this.getReportPlugins(interpolatedModel, true));
        }
        Set<Plugin> plugins = this.getProjectPlugins(superPomPluginManagement, parentPluginManagement, parentBuildPlugins, parentReportPlugins, pluginsWithVersionsSpecified);
        ArrayList<String> updates = new ArrayList<String>();
        ArrayList<String> lockdowns = new ArrayList<String>();
        TreeMap upgrades = new TreeMap(new MavenVersionComparator());
        ArtifactVersion curMavenVersion = this.runtimeInformation.getApplicationVersion();
        DefaultArtifactVersion specMavenVersion = new DefaultArtifactVersion(this.getRequiredMavenVersion(this.getProject(), "2.0"));
        DefaultArtifactVersion minMavenVersion = null;
        boolean superPomDrivingMinVersion = false;
        for (Plugin plugin : plugins) {
            StringBuilder buf;
            String newVersion;
            Object artifactVersion;
            Artifact artifact;
            String effectiveVersion;
            String coords;
            String version;
            String artifactId;
            String groupId;
            block65: {
                VersionRange versionRange;
                groupId = DisplayPluginUpdatesMojo.getPluginGroupId(plugin);
                artifactId = DisplayPluginUpdatesMojo.getPluginArtifactId(plugin);
                version = DisplayPluginUpdatesMojo.getPluginVersion(plugin);
                coords = ArtifactUtils.versionlessKey((String)groupId, (String)artifactId);
                if (version == null) {
                    version = (String)parentPluginManagement.get(coords);
                }
                this.getLog().debug((CharSequence)("Checking " + coords + " for updates newer than " + version));
                effectiveVersion = version;
                boolean unspecified = version == null;
                try {
                    versionRange = unspecified ? VersionRange.createFromVersionSpec((String)"[0,)") : VersionRange.createFromVersionSpec((String)version);
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new MojoExecutionException("Invalid version range specification: " + version, (Exception)((Object)e));
                }
                artifact = this.artifactFactory.createPluginArtifact(groupId, artifactId, versionRange);
                artifactVersion = null;
                try {
                    DefaultArtifactVersion requires;
                    MavenProject mavenProject;
                    Artifact probe;
                    ArtifactVersions artifactVersions = this.getHelper().lookupArtifactVersions(artifact, true);
                    ArtifactVersion[] newerVersions = artifactVersions.getVersions(Boolean.TRUE.equals(this.allowSnapshots));
                    DefaultArtifactVersion minRequires = null;
                    for (int j = newerVersions.length - 1; j >= 0; --j) {
                        probe = this.artifactFactory.createDependencyArtifact(groupId, artifactId, VersionRange.createFromVersion((String)newerVersions[j].toString()), "pom", null, "runtime");
                        try {
                            String upgradePluginKey;
                            this.getHelper().resolveArtifact(probe, true);
                            mavenProject = this.projectBuilder.buildFromRepository(probe, this.remotePluginRepositories, this.localRepository);
                            requires = new DefaultArtifactVersion(this.getRequiredMavenVersion(mavenProject, "2.0"));
                            if (specMavenVersion.compareTo((Object)requires) >= 0 && artifactVersion == null) {
                                artifactVersion = newerVersions[j];
                            }
                            if (effectiveVersion == null && curMavenVersion.compareTo((Object)requires) >= 0) {
                                effectiveVersion = newerVersions[j].toString();
                            }
                            if (artifactVersion != null && effectiveVersion != null) break;
                            if (minRequires != null && minRequires.compareTo((Object)requires) <= 0) continue;
                            LinkedHashMap<String, String> upgradePlugins = (LinkedHashMap<String, String>)upgrades.get(requires);
                            if (upgradePlugins == null) {
                                upgradePlugins = new LinkedHashMap<String, String>();
                                upgrades.put((ArtifactVersion)requires, upgradePlugins);
                            }
                            if (!upgradePlugins.containsKey(upgradePluginKey = this.compactKey(groupId, artifactId))) {
                                upgradePlugins.put(upgradePluginKey, newerVersions[j].toString());
                            }
                            minRequires = requires;
                            continue;
                        }
                        catch (ArtifactResolutionException e) {
                            continue;
                        }
                        catch (ArtifactNotFoundException e) {
                            continue;
                        }
                        catch (ProjectBuildingException e) {
                            // empty catch block
                        }
                    }
                    if (effectiveVersion == null) break block65;
                    VersionRange currentVersionRange = VersionRange.createFromVersion((String)effectiveVersion);
                    probe = this.artifactFactory.createDependencyArtifact(groupId, artifactId, currentVersionRange, "pom", null, "runtime");
                    try {
                        this.getHelper().resolveArtifact(probe, true);
                        mavenProject = this.projectBuilder.buildFromRepository(probe, this.remotePluginRepositories, this.localRepository);
                        requires = new DefaultArtifactVersion(this.getRequiredMavenVersion(mavenProject, "2.0"));
                        if (minMavenVersion == null || minMavenVersion.compareTo((Object)requires) < 0) {
                            minMavenVersion = requires;
                        }
                    }
                    catch (ArtifactResolutionException e) {
                    }
                    catch (ArtifactNotFoundException e) {
                    }
                    catch (ProjectBuildingException e) {}
                }
                catch (ArtifactMetadataRetrievalException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
                }
            }
            if (version == null && pluginsWithVersionsSpecified.contains(coords)) {
                version = artifactVersion != null ? artifactVersion.toString() : null;
            }
            this.getLog().debug((CharSequence)("[" + coords + "].version=" + version));
            this.getLog().debug((CharSequence)("[" + coords + "].artifactVersion=" + artifactVersion));
            this.getLog().debug((CharSequence)("[" + coords + "].effectiveVersion=" + effectiveVersion));
            this.getLog().debug((CharSequence)("[" + coords + "].specified=" + pluginsWithVersionsSpecified.contains(coords)));
            if (version == null || !pluginsWithVersionsSpecified.contains(coords)) {
                version = superPomPluginManagement.get(ArtifactUtils.versionlessKey((Artifact)artifact));
                this.getLog().debug((CharSequence)("[" + coords + "].superPom.version=" + version));
                newVersion = artifactVersion != null ? artifactVersion.toString() : (version != null ? version : (effectiveVersion != null ? effectiveVersion : "(unknown)"));
                buf = new StringBuilder(this.compactKey(groupId, artifactId));
                buf.append(' ');
                int padding = 65 - effectiveVersion.length() - (version != null ? FROM_SUPER_POM.length() : 0);
                while (buf.length() < padding) {
                    buf.append('.');
                }
                buf.append(' ');
                if (version != null) {
                    buf.append(FROM_SUPER_POM);
                    superPomDrivingMinVersion = true;
                }
                buf.append(effectiveVersion);
                lockdowns.add(buf.toString());
                this.addMissingVersionPlugin(groupId, artifactId, version);
            } else {
                newVersion = artifactVersion != null ? artifactVersion.toString() : null;
            }
            if (version == null || artifactVersion == null || newVersion == null || new DefaultArtifactVersion(effectiveVersion).compareTo((Object)new DefaultArtifactVersion(newVersion)) >= 0) continue;
            buf = new StringBuilder(this.compactKey(groupId, artifactId));
            buf.append(' ');
            int padding = 68 - version.length() - newVersion.length() - 4;
            while (buf.length() < padding) {
                buf.append('.');
            }
            buf.append(' ');
            buf.append(effectiveVersion);
            buf.append(" -> ");
            buf.append(newVersion);
            updates.add(buf.toString());
            this.addUpdate(groupId, artifactId, version, (ArtifactVersion)artifactVersion);
        }
        this.getLog().info((CharSequence)"");
        if (updates.isEmpty()) {
            this.getLog().info((CharSequence)"All plugins with a version specified are using the latest versions.");
        } else {
            this.getLog().info((CharSequence)"The following plugin updates are available:");
            for (String update : updates) {
                this.getLog().info((CharSequence)("  " + update));
            }
        }
        this.getLog().info((CharSequence)"");
        if (lockdowns.isEmpty()) {
            this.getLog().info((CharSequence)"All plugins have a version specified.");
        } else {
            this.getLog().warn((CharSequence)"The following plugins do not have their version specified:");
            for (String lockdown : lockdowns) {
                this.getLog().warn((CharSequence)("  " + lockdown));
            }
        }
        this.getLog().info((CharSequence)"");
        boolean noMavenMinVersion = this.getRequiredMavenVersion(this.getProject(), null) == null;
        boolean bl = noExplicitMavenMinVersion = this.getProject().getPrerequisites() == null || this.getProject().getPrerequisites().getMaven() == null;
        if (noMavenMinVersion) {
            this.getLog().warn((CharSequence)"Project does not define minimum Maven version, default is: 2.0");
            this.report.warnNoMinimumVersion();
        } else if (noExplicitMavenMinVersion) {
            this.getLog().info((CharSequence)("Project inherits minimum Maven version as: " + specMavenVersion));
        } else {
            DefaultArtifactVersion explicitMavenVersion = new DefaultArtifactVersion(this.getProject().getPrerequisites().getMaven());
            if (explicitMavenVersion.compareTo((Object)specMavenVersion) < 0) {
                this.getLog().error((CharSequence)("Project's effective minimum Maven (from parent) is: " + specMavenVersion));
                this.getLog().error((CharSequence)("Project defines minimum Maven version as: " + explicitMavenVersion));
                IncompatibleParentAndProjectMavenVersion incompatibleParentAndProjectMavenVersion = new IncompatibleParentAndProjectMavenVersion();
                incompatibleParentAndProjectMavenVersion.setParentVersion(specMavenVersion.toString());
                incompatibleParentAndProjectMavenVersion.setProjectVersion(explicitMavenVersion.toString());
                this.report.warn(incompatibleParentAndProjectMavenVersion);
            } else {
                this.getLog().info((CharSequence)("Project defines minimum Maven version as: " + specMavenVersion));
            }
        }
        this.getLog().info((CharSequence)("Plugins require minimum Maven version of: " + minMavenVersion));
        if (superPomDrivingMinVersion) {
            this.getLog().info((CharSequence)("Note: the super-pom from Maven " + curMavenVersion + " defines some of the plugin"));
            this.getLog().info((CharSequence)"      versions and may be influencing the plugins required minimum Maven");
            this.getLog().info((CharSequence)"      version.");
        }
        this.getLog().info((CharSequence)"");
        if ("maven-plugin".equals(this.getProject().getPackaging())) {
            if (noMavenMinVersion) {
                this.getLog().warn((CharSequence)"Project (which is a Maven Plugin) does not define required minimum version of Maven.");
                this.getLog().warn((CharSequence)"Update the pom.xml to contain");
                this.getLog().warn((CharSequence)"    <prerequisites>");
                this.getLog().warn((CharSequence)"      <maven><!-- minimum version of Maven that the plugin works with --></maven>");
                this.getLog().warn((CharSequence)"    </prerequisites>");
                this.getLog().warn((CharSequence)("To build this plugin you need at least Maven " + minMavenVersion));
                this.getLog().warn((CharSequence)"A Maven Enforcer rule can be used to enforce this if you have not already set one up");
            } else if (minMavenVersion != null && specMavenVersion.compareTo(minMavenVersion) < 0) {
                this.getLog().warn((CharSequence)("Project (which is a Maven Plugin) targets Maven " + specMavenVersion + " or newer"));
                this.getLog().warn((CharSequence)("but requires Maven " + minMavenVersion + " or newer to build."));
                this.getLog().warn((CharSequence)"This may or may not be a problem. A Maven Enforcer rule can help ");
                this.getLog().warn((CharSequence)"enforce that the correct version of Maven is used to build this plugin.");
            } else {
                this.getLog().info((CharSequence)"No plugins require a newer version of Maven than specified by the pom.");
            }
        } else if (noMavenMinVersion) {
            this.getLog().error((CharSequence)"Project does not define required minimum version of Maven.");
            this.getLog().error((CharSequence)"Update the pom.xml to contain");
            this.getLog().error((CharSequence)"    <prerequisites>");
            this.getLog().error((CharSequence)("      <maven>" + minMavenVersion + "</maven>"));
            this.getLog().error((CharSequence)"    </prerequisites>");
        } else if (minMavenVersion != null && specMavenVersion.compareTo(minMavenVersion) < 0) {
            this.getLog().error((CharSequence)"Project requires an incorrect minimum version of Maven.");
            this.getLog().error((CharSequence)("Either change plugin versions to those compatible with " + specMavenVersion));
            this.getLog().error((CharSequence)"or update the pom.xml to contain");
            this.getLog().error((CharSequence)"    <prerequisites>");
            this.getLog().error((CharSequence)("      <maven>" + minMavenVersion + "</maven>"));
            this.getLog().error((CharSequence)"    </prerequisites>");
            IncompatibleParentAndProjectMavenVersion incompatibleParentAndProjectMavenVersion = new IncompatibleParentAndProjectMavenVersion();
            incompatibleParentAndProjectMavenVersion.setParentVersion(specMavenVersion.toString());
            incompatibleParentAndProjectMavenVersion.setProjectVersion(minMavenVersion.toString());
            this.report.warn(incompatibleParentAndProjectMavenVersion);
        } else {
            this.getLog().info((CharSequence)"No plugins require a newer version of Maven than specified by the pom.");
        }
        for (Map.Entry mavenUpgrade : upgrades.entrySet()) {
            ArtifactVersion mavenUpgradeVersion = (ArtifactVersion)mavenUpgrade.getKey();
            Map upgradePlugins = (Map)mavenUpgrade.getValue();
            if (upgradePlugins.isEmpty() || specMavenVersion.compareTo((Object)mavenUpgradeVersion) >= 0) continue;
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("Require Maven " + mavenUpgradeVersion + " to use the following plugin updates:"));
            for (Map.Entry entry : upgradePlugins.entrySet()) {
                StringBuilder buf = new StringBuilder("  ");
                buf.append((String)entry.getKey());
                buf.append(' ');
                String s = (String)entry.getValue();
                int padding = 68 - s.length() + 2;
                while (buf.length() < padding) {
                    buf.append('.');
                }
                buf.append(' ');
                buf.append(s);
                this.getLog().info((CharSequence)buf.toString());
            }
        }
        this.getLog().info((CharSequence)"");
        ObjectToXmlWriter.writeXmlReport(this.xmlReport, this.report);
    }

    private void addUpdate(String groupId, String artifactId, String version, ArtifactVersion artifactVersion) {
        ArtifactUpdate update = new ArtifactUpdate();
        Dependency dependency = new Dependency();
        dependency.setGroupId(groupId);
        dependency.setArtifactId(artifactId);
        dependency.setVersion(version);
        update.setDependency(dependency);
        update.setVersionUpdate(artifactVersion.toString());
        this.report.addPluginUpdate(update);
    }

    private void addMissingVersionPlugin(String groupId, String artifactId, String version) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(groupId);
        dependency.setArtifactId(artifactId);
        dependency.setVersion(version);
        this.report.addMissingVersionPlugin(dependency);
    }

    private String compactKey(String groupId, String artifactId) {
        if ("org.apache.maven.plugins".equals(groupId)) {
            return artifactId;
        }
        return groupId + ":" + artifactId;
    }

    private String getRequiredMavenVersion(MavenProject mavenProject, String defaultValue) {
        Object requiredMavenVersion = null;
        while (mavenProject != null) {
            String mavenVersion;
            Prerequisites prerequisites = mavenProject.getPrerequisites();
            String string = mavenVersion = prerequisites == null ? null : prerequisites.getMaven();
            if (mavenVersion != null) {
                DefaultArtifactVersion v = new DefaultArtifactVersion(mavenVersion);
                if (requiredMavenVersion == null || requiredMavenVersion.compareTo((Object)v) < 0) {
                    requiredMavenVersion = v;
                }
            }
            mavenProject = mavenProject.getParent();
        }
        return requiredMavenVersion == null ? defaultValue : requiredMavenVersion.toString();
    }

    private Set<String> findPluginsWithVersionsSpecified(MavenProject project) throws IOException, XMLStreamException {
        return this.findPluginsWithVersionsSpecified(PomHelper.readXmlFile(project.getFile()));
    }

    private Set<String> findPluginsWithVersionsSpecified(StringBuilder pomContents) throws IOException, XMLStreamException {
        HashSet<String> result = new HashSet<String>();
        ModifiedPomXMLEventReader pom = this.newModifiedPomXER(pomContents);
        Pattern pathRegex = Pattern.compile("/project(/profiles/profile)?((/build(/pluginManagement)?)|(/reporting))/plugins/plugin");
        Stack<StackState> pathStack = new Stack<StackState>();
        StackState curState = null;
        while (pom.hasNext()) {
            XMLEvent event = pom.nextEvent();
            if (event.isStartDocument()) {
                curState = new StackState("");
                pathStack.clear();
                continue;
            }
            if (event.isStartElement()) {
                String elementName = event.asStartElement().getName().getLocalPart();
                if (curState != null && pathRegex.matcher(curState.path).matches()) {
                    if ("groupId".equals(elementName)) {
                        curState.groupId = pom.getElementText().trim();
                        continue;
                    }
                    if ("artifactId".equals(elementName)) {
                        curState.artifactId = pom.getElementText().trim();
                        continue;
                    }
                    if ("version".equals(elementName)) {
                        curState.version = pom.getElementText().trim();
                        continue;
                    }
                }
                pathStack.push(curState);
                curState = new StackState(curState.path + "/" + elementName);
                continue;
            }
            if (!event.isEndElement()) continue;
            if (curState != null && pathRegex.matcher(curState.path).matches() && curState.artifactId != null && curState.version != null) {
                if (curState.groupId == null) {
                    curState.groupId = "org.apache.maven.plugins";
                }
                result.add(curState.groupId + ":" + curState.artifactId);
            }
            curState = (StackState)pathStack.pop();
        }
        return result;
    }

    private Map<String, String> getBuildPlugins(Model model, boolean onlyIncludeInherited) {
        HashMap<String, String> buildPlugins = new HashMap<String, String>();
        try {
            for (Plugin plugin : model.getBuild().getPlugins()) {
                String coord = DisplayPluginUpdatesMojo.getPluginCoords(plugin);
                String version = DisplayPluginUpdatesMojo.getPluginVersion(plugin);
                if (version == null || onlyIncludeInherited && !DisplayPluginUpdatesMojo.getPluginInherited(plugin)) continue;
                buildPlugins.put(coord, version);
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            for (Profile profile : model.getProfiles()) {
                try {
                    for (Plugin plugin : profile.getBuild().getPlugins()) {
                        String coord = DisplayPluginUpdatesMojo.getPluginCoords(plugin);
                        String version = DisplayPluginUpdatesMojo.getPluginVersion(plugin);
                        if (version == null || onlyIncludeInherited && !DisplayPluginUpdatesMojo.getPluginInherited(plugin)) continue;
                        buildPlugins.put(coord, version);
                    }
                }
                catch (NullPointerException e) {
                }
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        return buildPlugins;
    }

    private static boolean getPluginInherited(Object plugin) {
        return "true".equalsIgnoreCase(plugin instanceof ReportPlugin ? ((ReportPlugin)plugin).getInherited() : ((Plugin)plugin).getInherited());
    }

    private Map<String, Plugin> getLifecyclePlugins(MavenProject project) throws MojoExecutionException {
        HashMap<String, Plugin> lifecyclePlugins = new HashMap<String, Plugin>();
        try {
            Set<Plugin> plugins = this.getBoundPlugins(project, "clean,deploy,site");
            for (Plugin plugin : plugins) {
                lifecyclePlugins.put(DisplayPluginUpdatesMojo.getPluginCoords(plugin), plugin);
            }
        }
        catch (PluginNotFoundException e) {
            throw new MojoExecutionException("Could not find plugin", (Exception)((Object)e));
        }
        catch (LifecycleExecutionException e) {
            throw new MojoExecutionException("Could not determine lifecycle", (Exception)((Object)e));
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Could not determine lifecycles", (Exception)e);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return lifecyclePlugins;
    }

    private Set<Plugin> getBoundPlugins(MavenProject project, String thePhases) throws PluginNotFoundException, LifecycleExecutionException, IllegalAccessException {
        if (new DefaultArtifactVersion("3.0").compareTo((Object)this.runtimeInformation.getApplicationVersion()) <= 0) {
            this.getLog().debug((CharSequence)"Using Maven 3.0+ strategy to determine lifecycle defined plugins");
            try {
                Method getPluginsBoundByDefaultToAllLifecycles = LifecycleExecutor.class.getMethod("getPluginsBoundByDefaultToAllLifecycles", String.class);
                Set plugins = (Set)getPluginsBoundByDefaultToAllLifecycles.invoke((Object)this.lifecycleExecutor, project.getPackaging() == null ? "jar" : project.getPackaging());
                LinkedHashSet<Plugin> result = new LinkedHashSet<Plugin>(plugins.size());
                for (Plugin plugin : plugins) {
                    Plugin dup = new Plugin();
                    dup.setGroupId(plugin.getGroupId());
                    dup.setArtifactId(plugin.getArtifactId());
                    result.add(dup);
                }
                return result;
            }
            catch (NoSuchMethodException e1) {
            }
            catch (InvocationTargetException e1) {
            }
            catch (IllegalAccessException e1) {
                // empty catch block
            }
        }
        List lifecycles = null;
        this.getLog().debug((CharSequence)"Using Maven 2.0.10+ strategy to determine lifecycle defined plugins");
        try {
            Method getLifecycles = LifecycleExecutor.class.getMethod("getLifecycles", new Class[0]);
            lifecycles = (List)getLifecycles.invoke((Object)this.lifecycleExecutor, new Object[0]);
        }
        catch (NoSuchMethodException e1) {
        }
        catch (InvocationTargetException e1) {
        }
        catch (IllegalAccessException e1) {
            // empty catch block
        }
        HashSet<Plugin> allPlugins = new HashSet<Plugin>();
        for (String lifecyclePhase : thePhases.split(",")) {
            if (!StringUtils.isNotEmpty((String)lifecyclePhase)) continue;
            try {
                Lifecycle lifecycle = this.getLifecycleForPhase(lifecycles, lifecyclePhase);
                allPlugins.addAll(this.getAllPlugins(project, lifecycle));
            }
            catch (BuildFailureException e) {
                // empty catch block
            }
        }
        return allPlugins;
    }

    private Lifecycle getLifecycleForPhase(List lifecycles, String phase) throws BuildFailureException, LifecycleExecutionException {
        Lifecycle lifecycle = (Lifecycle)this.getPhaseToLifecycleMap(lifecycles).get(phase);
        if (lifecycle == null) {
            throw new BuildFailureException("Unable to find lifecycle for phase '" + phase + "'");
        }
        return lifecycle;
    }

    private Set<Plugin> getAllPlugins(MavenProject project, Lifecycle lifecycle) throws PluginNotFoundException, LifecycleExecutionException {
        Plugin plugin;
        String[] tokens;
        HashSet<Plugin> plugins = new HashSet<Plugin>();
        Map mappings = this.findMappingsForLifecycle(project, lifecycle);
        for (Map.Entry entry : mappings.entrySet()) {
            String value = (String)entry.getValue();
            tokens = value.split(":");
            plugin = new Plugin();
            plugin.setGroupId(tokens[0]);
            plugin.setArtifactId(tokens[1]);
            plugins.add(plugin);
        }
        for (String value : this.findOptionalMojosForLifecycle(project, lifecycle)) {
            tokens = value.split(":");
            plugin = new Plugin();
            plugin.setGroupId(tokens[0]);
            plugin.setArtifactId(tokens[1]);
            plugins.add(plugin);
        }
        plugins.addAll(project.getBuildPlugins());
        return plugins;
    }

    private Map findMappingsForLifecycle(MavenProject project, Lifecycle lifecycle) throws LifecycleExecutionException, PluginNotFoundException {
        Map defaultMappings;
        Map mappings;
        String packaging;
        block6: {
            packaging = project.getPackaging();
            mappings = null;
            LifecycleMapping m = (LifecycleMapping)this.findExtension(project, LifecycleMapping.ROLE, packaging, this.session.getSettings(), this.session.getLocalRepository());
            if (m != null) {
                mappings = m.getPhases(lifecycle.getId());
            }
            defaultMappings = lifecycle.getDefaultPhases();
            if (mappings == null) {
                try {
                    m = (LifecycleMapping)this.session.lookup(LifecycleMapping.ROLE, packaging);
                    mappings = m.getPhases(lifecycle.getId());
                }
                catch (ComponentLookupException e) {
                    if (defaultMappings != null) break block6;
                    throw new LifecycleExecutionException("Cannot find lifecycle mapping for packaging: '" + packaging + "'.", (Throwable)e);
                }
            }
        }
        if (mappings == null) {
            if (defaultMappings == null) {
                throw new LifecycleExecutionException("Cannot find lifecycle mapping for packaging: '" + packaging + "', and there is no default");
            }
            mappings = defaultMappings;
        }
        return mappings;
    }

    private List<String> findOptionalMojosForLifecycle(MavenProject project, Lifecycle lifecycle) throws LifecycleExecutionException, PluginNotFoundException {
        String packaging = project.getPackaging();
        List optionalMojos = null;
        LifecycleMapping m = (LifecycleMapping)this.findExtension(project, LifecycleMapping.ROLE, packaging, this.session.getSettings(), this.session.getLocalRepository());
        if (m != null) {
            optionalMojos = m.getOptionalMojos(lifecycle.getId());
        }
        if (optionalMojos == null) {
            try {
                m = (LifecycleMapping)this.session.lookup(LifecycleMapping.ROLE, packaging);
                optionalMojos = m.getOptionalMojos(lifecycle.getId());
            }
            catch (ComponentLookupException e) {
                this.getLog().debug((CharSequence)("Error looking up lifecycle mapping to retrieve optional mojos. Lifecycle ID: " + lifecycle.getId() + ". Error: " + e.getMessage()), (Throwable)e);
            }
        }
        if (optionalMojos == null) {
            optionalMojos = Collections.emptyList();
        }
        return optionalMojos;
    }

    private Object findExtension(MavenProject project, String role, String roleHint, Settings settings, ArtifactRepository localRepository) throws LifecycleExecutionException, PluginNotFoundException {
        Object pluginComponent = null;
        Iterator i = project.getBuildPlugins().iterator();
        while (i.hasNext() && pluginComponent == null) {
            Plugin plugin = (Plugin)i.next();
            if (!plugin.isExtensions()) continue;
            this.loadPluginDescriptor(plugin, project, this.session);
            try {
                pluginComponent = this.pluginManager.getPluginComponent(plugin, role, roleHint);
            }
            catch (ComponentLookupException e) {
                this.getLog().debug((CharSequence)"Unable to find the lifecycle component in the extension", (Throwable)e);
            }
            catch (PluginManagerException e) {
                throw new LifecycleExecutionException("Error getting extensions from the plugin '" + plugin.getKey() + "': " + e.getMessage(), (Throwable)e);
            }
        }
        return pluginComponent;
    }

    private PluginDescriptor loadPluginDescriptor(Plugin plugin, MavenProject project, MavenSession session) throws LifecycleExecutionException, PluginNotFoundException {
        PluginDescriptor pluginDescriptor;
        try {
            pluginDescriptor = this.pluginManager.loadPluginDescriptor(plugin, project, session);
        }
        catch (PluginManagerException e) {
            throw new LifecycleExecutionException("Internal error in the plugin manager getting plugin '" + plugin.getKey() + "': " + e.getMessage(), (Throwable)e);
        }
        catch (PluginVersionResolutionException e) {
            throw new LifecycleExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new LifecycleExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidPluginException e) {
            throw new LifecycleExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            throw new LifecycleExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (ArtifactResolutionException e) {
            throw new LifecycleExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (PluginVersionNotFoundException e) {
            throw new LifecycleExecutionException(e.getMessage(), (Throwable)e);
        }
        return pluginDescriptor;
    }

    private List<MavenProject> getParentProjects(MavenProject project) throws MojoExecutionException {
        ArrayList<MavenProject> parents = new ArrayList<MavenProject>();
        while (project.getParent() != null) {
            project = project.getParent();
            parents.add(0, project);
        }
        return parents;
    }

    public Map getPhaseToLifecycleMap(List lifecycles) throws LifecycleExecutionException {
        HashMap<String, Lifecycle> phaseToLifecycleMap = new HashMap<String, Lifecycle>();
        for (Lifecycle lifecycle : lifecycles) {
            for (String phase : lifecycle.getPhases()) {
                if (phaseToLifecycleMap.containsKey(phase)) {
                    Lifecycle prevLifecycle = (Lifecycle)phaseToLifecycleMap.get(phase);
                    throw new LifecycleExecutionException("Phase '" + phase + "' is defined in more than one lifecycle: '" + lifecycle.getId() + "' and '" + prevLifecycle.getId() + "'");
                }
                phaseToLifecycleMap.put(phase, lifecycle);
            }
        }
        return phaseToLifecycleMap;
    }

    private Set<Plugin> getProjectPlugins(Map<String, String> superPomPluginManagement, Map<String, String> parentPluginManagement, Map<String, String> parentBuildPlugins, Map<String, String> parentReportPlugins, Set<String> pluginsWithVersionsSpecified) throws MojoExecutionException {
        String parentVersion;
        Iterator i;
        Model originalModel;
        HashMap<String, Plugin> plugins = new HashMap<String, Plugin>();
        this.getLog().debug((CharSequence)"Building list of project plugins...");
        if (this.getLog().isDebugEnabled()) {
            StringWriter origModel = new StringWriter();
            try {
                origModel.write("Original model:\n");
                this.getProject().writeOriginalModel((Writer)origModel);
                this.getLog().debug((CharSequence)origModel.toString());
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.debugVersionMap("super-pom version map", superPomPluginManagement);
        this.debugVersionMap("parent version map", parentPluginManagement);
        HashMap<String, String> excludePluginManagement = new HashMap<String, String>(superPomPluginManagement);
        excludePluginManagement.putAll(parentPluginManagement);
        this.debugVersionMap("aggregate version map", excludePluginManagement);
        excludePluginManagement.keySet().removeAll(pluginsWithVersionsSpecified);
        this.debugVersionMap("final aggregate version map", excludePluginManagement);
        try {
            originalModel = this.modelInterpolator.interpolate(this.getProject().getOriginalModel(), this.getProject().getBasedir(), new DefaultProjectBuilderConfiguration().setExecutionProperties(this.getProject().getProperties()), true);
        }
        catch (ModelInterpolationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        try {
            this.addProjectPlugins(plugins, originalModel.getBuild().getPluginManagement().getPlugins(), excludePluginManagement);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        this.debugPluginMap("after adding local pluginManagement", plugins);
        try {
            ArrayList<Plugin> lifecyclePlugins = new ArrayList<Plugin>(this.getLifecyclePlugins(this.getProject()).values());
            i = lifecyclePlugins.iterator();
            while (i.hasNext()) {
                Plugin lifecyclePlugin = (Plugin)i.next();
                if (DisplayPluginUpdatesMojo.getPluginVersion(lifecyclePlugin) != null) {
                    i.remove();
                    continue;
                }
                parentVersion = parentPluginManagement.get(DisplayPluginUpdatesMojo.getPluginCoords(lifecyclePlugin));
                if (parentVersion == null) continue;
                i.remove();
            }
            this.addProjectPlugins(plugins, lifecyclePlugins, parentPluginManagement);
            this.debugPluginMap("after adding lifecycle plugins", plugins);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            ArrayList<Plugin> buildPlugins = new ArrayList<Plugin>(originalModel.getBuild().getPlugins());
            i = buildPlugins.iterator();
            while (i.hasNext()) {
                Plugin buildPlugin = (Plugin)i.next();
                if (DisplayPluginUpdatesMojo.getPluginVersion(buildPlugin) != null || (parentVersion = parentPluginManagement.get(DisplayPluginUpdatesMojo.getPluginCoords(buildPlugin))) == null) continue;
                i.remove();
            }
            this.addProjectPlugins(plugins, buildPlugins, parentBuildPlugins);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        this.debugPluginMap("after adding build plugins", plugins);
        try {
            ArrayList<ReportPlugin> reportPlugins = new ArrayList<ReportPlugin>(originalModel.getReporting().getPlugins());
            i = reportPlugins.iterator();
            while (i.hasNext()) {
                ReportPlugin reportPlugin = (ReportPlugin)i.next();
                if (DisplayPluginUpdatesMojo.getPluginVersion(reportPlugin) != null || (parentVersion = parentPluginManagement.get(DisplayPluginUpdatesMojo.getPluginCoords(reportPlugin))) == null) continue;
                i.remove();
            }
            this.addProjectPlugins(plugins, DisplayPluginUpdatesMojo.toPlugins(reportPlugins), parentReportPlugins);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        this.debugPluginMap("after adding reporting plugins", plugins);
        for (Profile profile : originalModel.getProfiles()) {
            try {
                this.addProjectPlugins(plugins, profile.getBuild().getPluginManagement().getPlugins(), excludePluginManagement);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            this.debugPluginMap("after adding build pluginManagement for profile " + profile.getId(), plugins);
            try {
                this.addProjectPlugins(plugins, profile.getBuild().getPlugins(), parentBuildPlugins);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            this.debugPluginMap("after adding build plugins for profile " + profile.getId(), plugins);
            try {
                this.addProjectPlugins(plugins, DisplayPluginUpdatesMojo.toPlugins(profile.getReporting().getPlugins()), parentReportPlugins);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            this.debugPluginMap("after adding reporting plugins for profile " + profile.getId(), plugins);
        }
        TreeSet<Plugin> result = new TreeSet<Plugin>(new PluginComparator());
        result.addAll(plugins.values());
        return result;
    }

    private void addProjectPlugins(Map<String, Plugin> plugins, Collection<Plugin> projectPlugins, Map<String, String> parentDefinitions) {
        for (Plugin plugin : projectPlugins) {
            String coord = DisplayPluginUpdatesMojo.getPluginCoords(plugin);
            String version = DisplayPluginUpdatesMojo.getPluginVersion(plugin);
            String parentVersion = parentDefinitions.get(coord);
            if (!(version != null || plugins.containsKey(coord) && DisplayPluginUpdatesMojo.getPluginVersion(plugins.get(coord)) != null || parentVersion == null)) {
                Plugin parentPlugin = new Plugin();
                parentPlugin.setGroupId(DisplayPluginUpdatesMojo.getPluginGroupId(plugin));
                parentPlugin.setArtifactId(DisplayPluginUpdatesMojo.getPluginArtifactId(plugin));
                parentPlugin.setVersion(parentVersion);
                plugins.put(coord, parentPlugin);
            } else if (!(parentVersion != null && parentVersion.equals(version) || plugins.containsKey(coord) && DisplayPluginUpdatesMojo.getPluginVersion(plugins.get(coord)) != null)) {
                plugins.put(coord, plugin);
            }
            if (plugins.containsKey(coord)) continue;
            plugins.put(coord, plugin);
        }
    }

    private void debugPluginMap(String description, Map plugins) {
        if (this.getLog().isDebugEnabled()) {
            TreeSet sorted = new TreeSet(new PluginComparator());
            sorted.addAll(plugins.values());
            StringBuilder buf = new StringBuilder(description);
            for (Object plugin : sorted) {
                buf.append("\n    ");
                buf.append(DisplayPluginUpdatesMojo.getPluginCoords(plugin));
                buf.append(":");
                buf.append(DisplayPluginUpdatesMojo.getPluginVersion(plugin));
            }
            this.getLog().debug((CharSequence)buf.toString());
        }
    }

    private void debugVersionMap(String description, Map plugins) {
        if (this.getLog().isDebugEnabled()) {
            StringBuilder buf = new StringBuilder(description);
            for (Map.Entry plugin : plugins.entrySet()) {
                buf.append("\n    ");
                buf.append(plugin.getKey());
                buf.append(":");
                buf.append(plugin.getValue());
            }
            this.getLog().debug((CharSequence)buf.toString());
        }
    }

    private static String getPluginCoords(Object plugin) {
        return DisplayPluginUpdatesMojo.getPluginGroupId(plugin) + ":" + DisplayPluginUpdatesMojo.getPluginArtifactId(plugin);
    }

    private static String getPluginArtifactId(Object plugin) {
        return plugin instanceof ReportPlugin ? ((ReportPlugin)plugin).getArtifactId() : ((Plugin)plugin).getArtifactId();
    }

    private static Plugin toPlugin(ReportPlugin reportPlugin) {
        Plugin plugin = new Plugin();
        plugin.setGroupId(reportPlugin.getGroupId());
        plugin.setArtifactId(reportPlugin.getArtifactId());
        plugin.setVersion(reportPlugin.getVersion());
        return plugin;
    }

    private static ReportPlugin toReportPlugin(Plugin plugin) {
        ReportPlugin reportPlugin = new ReportPlugin();
        reportPlugin.setGroupId(plugin.getGroupId());
        reportPlugin.setArtifactId(plugin.getArtifactId());
        reportPlugin.setVersion(plugin.getVersion());
        return reportPlugin;
    }

    private static Set<Plugin> toPlugins(Set<ReportPlugin> reportPlugins) {
        AbstractSet result;
        if (reportPlugins instanceof LinkedHashSet) {
            result = new LinkedHashSet(reportPlugins.size());
        } else if (reportPlugins instanceof SortedSet) {
            final Comparator comparator = ((SortedSet)reportPlugins).comparator();
            result = new TreeSet<Plugin>(new Comparator<Plugin>(){

                @Override
                public int compare(Plugin o1, Plugin o2) {
                    return comparator.compare(DisplayPluginUpdatesMojo.toReportPlugin(o1), DisplayPluginUpdatesMojo.toReportPlugin(o2));
                }
            });
        } else {
            result = new HashSet(reportPlugins.size());
        }
        for (ReportPlugin reportPlugin : reportPlugins) {
            result.add(DisplayPluginUpdatesMojo.toPlugin(reportPlugin));
        }
        return result;
    }

    private static List<Plugin> toPlugins(List<ReportPlugin> reportPlugins) {
        ArrayList<Plugin> result = new ArrayList<Plugin>(reportPlugins.size());
        for (ReportPlugin reportPlugin : reportPlugins) {
            result.add(DisplayPluginUpdatesMojo.toPlugin(reportPlugin));
        }
        return result;
    }

    private static Collection<Plugin> toPlugins(Collection<ReportPlugin> reportPlugins) {
        if (reportPlugins instanceof Set) {
            return DisplayPluginUpdatesMojo.toPlugins((Set)reportPlugins);
        }
        if (reportPlugins instanceof List) {
            return DisplayPluginUpdatesMojo.toPlugins((List)reportPlugins);
        }
        return DisplayPluginUpdatesMojo.toPlugins(new ArrayList<ReportPlugin>(reportPlugins));
    }

    private static String getPluginGroupId(Object plugin) {
        return plugin instanceof ReportPlugin ? ((ReportPlugin)plugin).getGroupId() : ((Plugin)plugin).getGroupId();
    }

    private static String getPluginVersion(Object plugin) {
        return plugin instanceof ReportPlugin ? ((ReportPlugin)plugin).getVersion() : ((Plugin)plugin).getVersion();
    }

    private Map<String, String> getReportPlugins(Model model, boolean onlyIncludeInherited) {
        HashMap<String, String> reportPlugins = new HashMap<String, String>();
        try {
            for (ReportPlugin plugin : model.getReporting().getPlugins()) {
                String coord = DisplayPluginUpdatesMojo.getPluginCoords(plugin);
                String version = DisplayPluginUpdatesMojo.getPluginVersion(plugin);
                if (version == null || onlyIncludeInherited && !DisplayPluginUpdatesMojo.getPluginInherited(plugin)) continue;
                reportPlugins.put(coord, version);
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            for (Profile profile : model.getProfiles()) {
                try {
                    for (ReportPlugin plugin : profile.getReporting().getPlugins()) {
                        String coord = DisplayPluginUpdatesMojo.getPluginCoords(plugin);
                        String version = DisplayPluginUpdatesMojo.getPluginVersion(plugin);
                        if (version == null || onlyIncludeInherited && !DisplayPluginUpdatesMojo.getPluginInherited(plugin)) continue;
                        reportPlugins.put(coord, version);
                    }
                }
                catch (NullPointerException e) {
                }
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        return reportPlugins;
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
    }

    private static final class StackState {
        private final String path;
        private String groupId;
        private String artifactId;
        private String version;

        public StackState(String path) {
            this.path = path;
        }

        public String toString() {
            return this.path + "[groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + "]";
        }
    }
}

