/*
 * Decompiled with CFR 0.152.
 */
package de.lolhens.http4s.jwt;

import cats.ApplicativeError;
import cats.Functor;
import cats.MonadError;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.package;
import de.lolhens.http4s.jwt.Jwt;
import de.lolhens.http4s.jwt.JwtCodec$;
import io.circe.HCursor;
import io.circe.Json;
import io.circe.jawn.package$;
import java.io.Serializable;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.Clock;
import javax.crypto.SecretKey;
import pdi.jwt.JwtAlgorithm;
import pdi.jwt.JwtBase64$;
import pdi.jwt.JwtCirceParser;
import pdi.jwt.JwtClaim;
import pdi.jwt.JwtCore;
import pdi.jwt.JwtHeader;
import pdi.jwt.JwtJsonCommon;
import pdi.jwt.JwtOptions;
import pdi.jwt.JwtUtils$;
import pdi.jwt.algorithms.JwtAsymmetricAlgorithm;
import pdi.jwt.algorithms.JwtHmacAlgorithm;
import pdi.jwt.exceptions.JwtEmptyAlgorithmException;
import pdi.jwt.exceptions.JwtEmptySignatureException;
import pdi.jwt.exceptions.JwtLengthException;
import pdi.jwt.exceptions.JwtValidationException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005-f\u0001B\t\u0013\u0001mA\u0001b\f\u0001\u0003\u0006\u0004%\t\u0005\r\u0005\ts\u0001\u0011\t\u0011)A\u0005c!)!\b\u0001C\u0001w!)q\b\u0001C)\u0001\")a\n\u0001C)\u001f\")!\u000b\u0001C)'\")a\f\u0001C!?\")Q\u000f\u0001C!m\")Q\u0010\u0001C\t}\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-qaBAE%!\u0005\u00111\u0012\u0004\u0007#IA\t!!$\t\ribA\u0011AAH\u0011\u001d\t\t\n\u0004C\u0001\u0003'Cq!a&\r\t\u0013\tI\nC\u0004\u0002\"2!I!a)\u0003\u0011);HoQ8eK\u000eT!a\u0005\u000b\u0002\u0007)<HO\u0003\u0002\u0016-\u00051\u0001\u000e\u001e;qiMT!a\u0006\r\u0002\u000f1|G\u000e[3og*\t\u0011$\u0001\u0002eK\u000e\u00011c\u0001\u0001\u001dEA\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\u0004BaI\u0014*Y5\tAE\u0003\u0002\u0014K)\ta%A\u0002qI&L!\u0001\u000b\u0013\u0003\u001d);HoQ5sG\u0016\u0004\u0016M]:feB\u00111EK\u0005\u0003W\u0011\u0012\u0011BS<u\u0011\u0016\fG-\u001a:\u0011\u0005\rj\u0013B\u0001\u0018%\u0005!Qu\u000f^\"mC&l\u0017!B2m_\u000e\\W#A\u0019\u0011\u0005I:T\"A\u001a\u000b\u0005Q*\u0014\u0001\u0002;j[\u0016T\u0011AN\u0001\u0005U\u00064\u0018-\u0003\u00029g\t)1\t\\8dW\u000611\r\\8dW\u0002\na\u0001P5oSRtDC\u0001\u001f?!\ti\u0004!D\u0001\u0013\u0011\u0015y3\u00011\u00012\u0003-\u0001\u0018M]:f\u0011\u0016\fG-\u001a:\u0015\u0005%\n\u0005\"\u0002\"\u0005\u0001\u0004\u0019\u0015A\u00025fC\u0012,'\u000f\u0005\u0002E\u0017:\u0011Q)\u0013\t\u0003\rzi\u0011a\u0012\u0006\u0003\u0011j\ta\u0001\u0010:p_Rt\u0014B\u0001&\u001f\u0003\u0019\u0001&/\u001a3fM&\u0011A*\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005)s\u0012A\u00039beN,7\t\\1j[R\u0011A\u0006\u0015\u0005\u0006#\u0016\u0001\raQ\u0001\u0006G2\f\u0017.\\\u0001\u0006a\u0006\u00148/\u001a\u000b\u0003)r\u0003\"!\u0016.\u000e\u0003YS!a\u0016-\u0002\u000b\rL'oY3\u000b\u0003e\u000b!![8\n\u0005m3&\u0001\u0002&t_:DQ!\u0018\u0004A\u0002\r\u000bQA^1mk\u0016\fQC^1mS\u0012\fG/\u001a%nC\u000e\fEnZ8sSRDW\u000eF\u0002aG.\u0004\"!H1\n\u0005\tt\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006I\u001e\u0001\r!Z\u0001\nC2<wN]5uQ6\u0004\"AZ5\u000e\u0003\u001dT!\u0001\u001b\u0013\u0002\u0015\u0005dwm\u001c:ji\"l7/\u0003\u0002kO\n\u0001\"j\u001e;I[\u0006\u001c\u0017\t\\4pe&$\b.\u001c\u0005\u0006Q\u001e\u0001\r\u0001\u001c\t\u0004[J,gB\u00018q\u001d\t1u.C\u0001 \u0013\t\th$A\u0004qC\u000e\\\u0017mZ3\n\u0005M$(aA*fc*\u0011\u0011OH\u0001\u001cm\u0006d\u0017\u000eZ1uK\u0006\u001b\u00180\\7fiJL7-\u00117h_JLG\u000f[7\u0015\u0007\u0001<8\u0010C\u0003e\u0011\u0001\u0007\u0001\u0010\u0005\u0002gs&\u0011!p\u001a\u0002\u0017\u0015^$\u0018i]=n[\u0016$(/[2BY\u001e|'/\u001b;i[\")\u0001\u000e\u0003a\u0001yB\u0019QN\u001d=\u0002\u0015M\u0004H.\u001b;U_.,g\u000eF\u0002\u0000\u0003\u000b\u0001\u0002\"HA\u0001\u0007\u000e\u001b5iQ\u0005\u0004\u0003\u0007q\"A\u0002+va2,W\u0007\u0003\u0004\u0002\b%\u0001\raQ\u0001\u0006i>\\WM\\\u0001\u0013I\u0016\u001cw\u000eZ3BY2\fe\u000e\u001a,fe&4\u00170\u0006\u0004\u0002\u000e\u0005U\u00111\u000b\u000b\t\u0003\u001f\t\t(a\u001d\u0002~Q!\u0011\u0011CA,!\u0019\t\u0019\"!\u0006\u0002.1\u0001AaBA\f\u0015\t\u0007\u0011\u0011\u0004\u0002\u0002\rV!\u00111DA\u0015#\u0011\ti\"a\t\u0011\u0007u\ty\"C\u0002\u0002\"y\u0011qAT8uQ&tw\rE\u0002\u001e\u0003KI1!a\n\u001f\u0005\r\te.\u001f\u0003\t\u0003W\t)B1\u0001\u0002\u001c\t!q\f\n\u00132!\u0019\ty#!\u000e\u0002:5\u0011\u0011\u0011\u0007\u0006\u0004\u0003gq\u0012\u0001B;uS2LA!a\u000e\u00022\t\u0019AK]=\u0011\u000fu\tY$a\u0010\u0002L%\u0019\u0011Q\b\u0010\u0003\rQ+\b\u000f\\33!\u0015i\u0014\u0011IA#\u0013\r\t\u0019E\u0005\u0002\u0004\u0015^$\bcA\u0012\u0002H%\u0019\u0011\u0011\n\u0013\u0003\u0019);H/\u00117h_JLG\u000f[7\u0011\u000bu\ti%!\u0015\n\u0007\u0005=cD\u0001\u0004PaRLwN\u001c\t\u0005\u0003'\t\u0019\u0006B\u0004\u0002V)\u0011\r!a\u0007\u0003\u0003\u0005Cq!!\u0017\u000b\u0001\b\tY&A\u0001G!\u0019\ti&!\u001b\u0002p9!\u0011qLA3\u001d\r1\u0015\u0011M\u0005\u0003\u0003G\nAaY1ug&\u0019\u0011/a\u001a\u000b\u0005\u0005\r\u0014\u0002BA6\u0003[\u0012!\"T8oC\u0012$\u0006N]8x\u0015\r\t\u0018q\r\t\u0005\u0003'\t)\u0002\u0003\u0004\u0002\b)\u0001\ra\u0011\u0005\b\u0003kR\u0001\u0019AA<\u0003\u001dy\u0007\u000f^5p]N\u00042aIA=\u0013\r\tY\b\n\u0002\u000b\u0015^$x\n\u001d;j_:\u001c\bbBA@\u0015\u0001\u0007\u0011\u0011Q\u0001\u0007m\u0016\u0014\u0018NZ=\u0011\u000fu\t\u0019)a\u0010\u0002\b&\u0019\u0011Q\u0011\u0010\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CBA\n\u0003+\tY%\u0001\u0005KoR\u001cu\u000eZ3d!\tiDb\u0005\u0002\ryQ\u0011\u00111R\u0001\u0006CB\u0004H.\u001f\u000b\u0004y\u0005U\u0005\"B\u0018\u000f\u0001\u0004\t\u0014a\u00049beN,\u0007*Z1eKJDU\r\u001c9\u0015\t\u0005m\u0015q\u0014\u000b\u0004S\u0005u\u0005\"B\u0018\u0010\u0001\b\t\u0004\"\u0002\"\u0010\u0001\u0004\u0019\u0015A\u00049beN,7\t\\1j[\"+G\u000e\u001d\u000b\u0005\u0003K\u000bI\u000bF\u0002-\u0003OCQa\f\tA\u0004EBQ!\u0015\tA\u0002\r\u0003")
public class JwtCodec
implements JwtCirceParser<JwtHeader, JwtClaim> {
    private final Clock clock;

    public static JwtCodec apply(Clock clock) {
        return JwtCodec$.MODULE$.apply(clock);
    }

    public String stringify(Json value) {
        return JwtCirceParser.stringify$((JwtCirceParser)this, (Json)value);
    }

    public Option<JwtAlgorithm> getAlgorithm(Json header) {
        return JwtCirceParser.getAlgorithm$((JwtCirceParser)this, (Json)header);
    }

    public Option<JwtAlgorithm> getAlg(HCursor cursor) {
        return JwtCirceParser.getAlg$((JwtCirceParser)this, (HCursor)cursor);
    }

    public Option<JwtAlgorithm> extractAlgorithm(JwtHeader header) {
        return JwtJsonCommon.extractAlgorithm$((JwtJsonCommon)this, (JwtHeader)header);
    }

    public Option<Object> extractExpiration(JwtClaim claim) {
        return JwtJsonCommon.extractExpiration$((JwtJsonCommon)this, (JwtClaim)claim);
    }

    public Option<Object> extractNotBefore(JwtClaim claim) {
        return JwtJsonCommon.extractNotBefore$((JwtJsonCommon)this, (JwtClaim)claim);
    }

    public String encode(Object header, Object claim) {
        return JwtJsonCommon.encode$((JwtJsonCommon)this, (Object)header, (Object)claim);
    }

    public String encode(Object header, Object claim, String key) {
        return JwtJsonCommon.encode$((JwtJsonCommon)this, (Object)header, (Object)claim, (String)key);
    }

    public String encode(Object header, Object claim, Key key) {
        return JwtJsonCommon.encode$((JwtJsonCommon)this, (Object)header, (Object)claim, (Key)key);
    }

    public String encode(Object claim) {
        return JwtJsonCommon.encode$((JwtJsonCommon)this, (Object)claim);
    }

    public String encode(Object claim, String key, JwtAlgorithm algorithm) {
        return JwtJsonCommon.encode$((JwtJsonCommon)this, (Object)claim, (String)key, (JwtAlgorithm)algorithm);
    }

    public String encode(Object claim, SecretKey key, JwtHmacAlgorithm algorithm) {
        return JwtJsonCommon.encode$((JwtJsonCommon)this, (Object)claim, (SecretKey)key, (JwtHmacAlgorithm)algorithm);
    }

    public String encode(Object claim, PrivateKey key, JwtAsymmetricAlgorithm algorithm) {
        return JwtJsonCommon.encode$((JwtJsonCommon)this, (Object)claim, (PrivateKey)key, (JwtAsymmetricAlgorithm)algorithm);
    }

    public Try<Tuple3<Json, Json, String>> decodeJsonAll(String token, JwtOptions options) {
        return JwtJsonCommon.decodeJsonAll$((JwtJsonCommon)this, (String)token, (JwtOptions)options);
    }

    public Try<Tuple3<Json, Json, String>> decodeJsonAll(String token) {
        return JwtJsonCommon.decodeJsonAll$((JwtJsonCommon)this, (String)token);
    }

    public Try<Tuple3<Json, Json, String>> decodeJsonAll(String token, String key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return JwtJsonCommon.decodeJsonAll$((JwtJsonCommon)this, (String)token, (String)key, algorithms, (JwtOptions)options);
    }

    public Try<Tuple3<Json, Json, String>> decodeJsonAll(String token, String key, Seq<JwtHmacAlgorithm> algorithms) {
        return JwtJsonCommon.decodeJsonAll$((JwtJsonCommon)this, (String)token, (String)key, algorithms);
    }

    public Try<Tuple3<Json, Json, String>> decodeJsonAll(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms, JwtOptions options) {
        return JwtJsonCommon.decodeJsonAll$((JwtJsonCommon)this, (String)token, (String)key, algorithms, (JwtOptions)options);
    }

    public Try<Tuple3<Json, Json, String>> decodeJsonAll(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms) {
        return JwtJsonCommon.decodeJsonAll$((JwtJsonCommon)this, (String)token, (String)key, algorithms);
    }

    public Try<Tuple3<Json, Json, String>> decodeJsonAll(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return JwtJsonCommon.decodeJsonAll$((JwtJsonCommon)this, (String)token, (SecretKey)key, algorithms, (JwtOptions)options);
    }

    public Try<Tuple3<Json, Json, String>> decodeJsonAll(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms) {
        return JwtJsonCommon.decodeJsonAll$((JwtJsonCommon)this, (String)token, (SecretKey)key, algorithms);
    }

    public Try<Tuple3<Json, Json, String>> decodeJsonAll(String token, SecretKey key, JwtOptions options) {
        return JwtJsonCommon.decodeJsonAll$((JwtJsonCommon)this, (String)token, (SecretKey)key, (JwtOptions)options);
    }

    public Try<Tuple3<Json, Json, String>> decodeJsonAll(String token, SecretKey key) {
        return JwtJsonCommon.decodeJsonAll$((JwtJsonCommon)this, (String)token, (SecretKey)key);
    }

    public Try<Tuple3<Json, Json, String>> decodeJsonAll(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms, JwtOptions options) {
        return JwtJsonCommon.decodeJsonAll$((JwtJsonCommon)this, (String)token, (PublicKey)key, algorithms, (JwtOptions)options);
    }

    public Try<Tuple3<Json, Json, String>> decodeJsonAll(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms) {
        return JwtJsonCommon.decodeJsonAll$((JwtJsonCommon)this, (String)token, (PublicKey)key, algorithms);
    }

    public Try<Tuple3<Json, Json, String>> decodeJsonAll(String token, PublicKey key, JwtOptions options) {
        return JwtJsonCommon.decodeJsonAll$((JwtJsonCommon)this, (String)token, (PublicKey)key, (JwtOptions)options);
    }

    public Try<Tuple3<Json, Json, String>> decodeJsonAll(String token, PublicKey key) {
        return JwtJsonCommon.decodeJsonAll$((JwtJsonCommon)this, (String)token, (PublicKey)key);
    }

    public Try<Json> decodeJson(String token, JwtOptions options) {
        return JwtJsonCommon.decodeJson$((JwtJsonCommon)this, (String)token, (JwtOptions)options);
    }

    public Try<Json> decodeJson(String token) {
        return JwtJsonCommon.decodeJson$((JwtJsonCommon)this, (String)token);
    }

    public Try<Json> decodeJson(String token, String key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return JwtJsonCommon.decodeJson$((JwtJsonCommon)this, (String)token, (String)key, algorithms, (JwtOptions)options);
    }

    public Try<Json> decodeJson(String token, String key, Seq<JwtHmacAlgorithm> algorithms) {
        return JwtJsonCommon.decodeJson$((JwtJsonCommon)this, (String)token, (String)key, algorithms);
    }

    public Try<Json> decodeJson(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms, JwtOptions options) {
        return JwtJsonCommon.decodeJson$((JwtJsonCommon)this, (String)token, (String)key, algorithms, (JwtOptions)options);
    }

    public Try<Json> decodeJson(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms) {
        return JwtJsonCommon.decodeJson$((JwtJsonCommon)this, (String)token, (String)key, algorithms);
    }

    public Try<Json> decodeJson(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return JwtJsonCommon.decodeJson$((JwtJsonCommon)this, (String)token, (SecretKey)key, algorithms, (JwtOptions)options);
    }

    public Try<Json> decodeJson(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms) {
        return JwtJsonCommon.decodeJson$((JwtJsonCommon)this, (String)token, (SecretKey)key, algorithms);
    }

    public Try<Json> decodeJson(String token, SecretKey key, JwtOptions options) {
        return JwtJsonCommon.decodeJson$((JwtJsonCommon)this, (String)token, (SecretKey)key, (JwtOptions)options);
    }

    public Try<Json> decodeJson(String token, SecretKey key) {
        return JwtJsonCommon.decodeJson$((JwtJsonCommon)this, (String)token, (SecretKey)key);
    }

    public Try<Json> decodeJson(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms, JwtOptions options) {
        return JwtJsonCommon.decodeJson$((JwtJsonCommon)this, (String)token, (PublicKey)key, algorithms, (JwtOptions)options);
    }

    public Try<Json> decodeJson(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms) {
        return JwtJsonCommon.decodeJson$((JwtJsonCommon)this, (String)token, (PublicKey)key, algorithms);
    }

    public Try<Json> decodeJson(String token, PublicKey key, JwtOptions options) {
        return JwtJsonCommon.decodeJson$((JwtJsonCommon)this, (String)token, (PublicKey)key, (JwtOptions)options);
    }

    public Try<Json> decodeJson(String token, PublicKey key) {
        return JwtJsonCommon.decodeJson$((JwtJsonCommon)this, (String)token, (PublicKey)key);
    }

    public String encode(String header, String claim) {
        return JwtCore.encode$((JwtCore)this, (String)header, (String)claim);
    }

    public String encode(String header, String claim, String key, JwtAlgorithm algorithm) {
        return JwtCore.encode$((JwtCore)this, (String)header, (String)claim, (String)key, (JwtAlgorithm)algorithm);
    }

    public String encode(String header, String claim, SecretKey key, JwtHmacAlgorithm algorithm) {
        return JwtCore.encode$((JwtCore)this, (String)header, (String)claim, (SecretKey)key, (JwtHmacAlgorithm)algorithm);
    }

    public String encode(String header, String claim, PrivateKey key, JwtAsymmetricAlgorithm algorithm) {
        return JwtCore.encode$((JwtCore)this, (String)header, (String)claim, (PrivateKey)key, (JwtAsymmetricAlgorithm)algorithm);
    }

    public String encode(String claim) {
        return JwtCore.encode$((JwtCore)this, (String)claim);
    }

    public String encode(String claim, String key, JwtAlgorithm algorithm) {
        return JwtCore.encode$((JwtCore)this, (String)claim, (String)key, (JwtAlgorithm)algorithm);
    }

    public String encode(String claim, SecretKey key, JwtHmacAlgorithm algorithm) {
        return JwtCore.encode$((JwtCore)this, (String)claim, (SecretKey)key, (JwtHmacAlgorithm)algorithm);
    }

    public String encode(String claim, PrivateKey key, JwtAsymmetricAlgorithm algorithm) {
        return JwtCore.encode$((JwtCore)this, (String)claim, (PrivateKey)key, (JwtAsymmetricAlgorithm)algorithm);
    }

    public String encode(JwtClaim claim) {
        return JwtCore.encode$((JwtCore)this, (JwtClaim)claim);
    }

    public String encode(JwtClaim claim, String key, JwtAlgorithm algorithm) {
        return JwtCore.encode$((JwtCore)this, (JwtClaim)claim, (String)key, (JwtAlgorithm)algorithm);
    }

    public String encode(JwtClaim claim, SecretKey key, JwtHmacAlgorithm algorithm) {
        return JwtCore.encode$((JwtCore)this, (JwtClaim)claim, (SecretKey)key, (JwtHmacAlgorithm)algorithm);
    }

    public String encode(JwtClaim claim, PrivateKey key, JwtAsymmetricAlgorithm algorithm) {
        return JwtCore.encode$((JwtCore)this, (JwtClaim)claim, (PrivateKey)key, (JwtAsymmetricAlgorithm)algorithm);
    }

    public String encode(JwtHeader header, JwtClaim claim) {
        return JwtCore.encode$((JwtCore)this, (JwtHeader)header, (JwtClaim)claim);
    }

    public String encode(JwtHeader header, JwtClaim claim, String key) {
        return JwtCore.encode$((JwtCore)this, (JwtHeader)header, (JwtClaim)claim, (String)key);
    }

    public String encode(JwtHeader header, JwtClaim claim, Key key) {
        return JwtCore.encode$((JwtCore)this, (JwtHeader)header, (JwtClaim)claim, (Key)key);
    }

    public Try<Tuple3<String, String, String>> decodeRawAll(String token, JwtOptions options) {
        return JwtCore.decodeRawAll$((JwtCore)this, (String)token, (JwtOptions)options);
    }

    public Try<Tuple3<String, String, String>> decodeRawAll(String token) {
        return JwtCore.decodeRawAll$((JwtCore)this, (String)token);
    }

    public Try<Tuple3<String, String, String>> decodeRawAll(String token, String key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.decodeRawAll$((JwtCore)this, (String)token, (String)key, algorithms, (JwtOptions)options);
    }

    public Try<Tuple3<String, String, String>> decodeRawAll(String token, String key, Seq<JwtHmacAlgorithm> algorithms) {
        return JwtCore.decodeRawAll$((JwtCore)this, (String)token, (String)key, algorithms);
    }

    public Try<Tuple3<String, String, String>> decodeRawAll(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms, JwtOptions options) {
        return JwtCore.decodeRawAll$((JwtCore)this, (String)token, (String)key, algorithms, (JwtOptions)options);
    }

    public Try<Tuple3<String, String, String>> decodeRawAll(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms) {
        return JwtCore.decodeRawAll$((JwtCore)this, (String)token, (String)key, algorithms);
    }

    public Try<Tuple3<String, String, String>> decodeRawAll(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.decodeRawAll$((JwtCore)this, (String)token, (SecretKey)key, algorithms, (JwtOptions)options);
    }

    public Try<Tuple3<String, String, String>> decodeRawAll(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms) {
        return JwtCore.decodeRawAll$((JwtCore)this, (String)token, (SecretKey)key, algorithms);
    }

    public Try<Tuple3<String, String, String>> decodeRawAll(String token, SecretKey key, JwtOptions options) {
        return JwtCore.decodeRawAll$((JwtCore)this, (String)token, (SecretKey)key, (JwtOptions)options);
    }

    public Try<Tuple3<String, String, String>> decodeRawAll(String token, SecretKey key) {
        return JwtCore.decodeRawAll$((JwtCore)this, (String)token, (SecretKey)key);
    }

    public Try<Tuple3<String, String, String>> decodeRawAll(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.decodeRawAll$((JwtCore)this, (String)token, (PublicKey)key, algorithms, (JwtOptions)options);
    }

    public Try<Tuple3<String, String, String>> decodeRawAll(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms) {
        return JwtCore.decodeRawAll$((JwtCore)this, (String)token, (PublicKey)key, algorithms);
    }

    public Try<Tuple3<String, String, String>> decodeRawAll(String token, PublicKey key, JwtOptions options) {
        return JwtCore.decodeRawAll$((JwtCore)this, (String)token, (PublicKey)key, (JwtOptions)options);
    }

    public Try<Tuple3<String, String, String>> decodeRawAll(String token, PublicKey key) {
        return JwtCore.decodeRawAll$((JwtCore)this, (String)token, (PublicKey)key);
    }

    public Try<String> decodeRaw(String token, JwtOptions options) {
        return JwtCore.decodeRaw$((JwtCore)this, (String)token, (JwtOptions)options);
    }

    public Try<String> decodeRaw(String token) {
        return JwtCore.decodeRaw$((JwtCore)this, (String)token);
    }

    public Try<String> decodeRaw(String token, String key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.decodeRaw$((JwtCore)this, (String)token, (String)key, algorithms, (JwtOptions)options);
    }

    public Try<String> decodeRaw(String token, String key, Seq<JwtHmacAlgorithm> algorithms) {
        return JwtCore.decodeRaw$((JwtCore)this, (String)token, (String)key, algorithms);
    }

    public Try<String> decodeRaw(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms, JwtOptions options) {
        return JwtCore.decodeRaw$((JwtCore)this, (String)token, (String)key, algorithms, (JwtOptions)options);
    }

    public Try<String> decodeRaw(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms) {
        return JwtCore.decodeRaw$((JwtCore)this, (String)token, (String)key, algorithms);
    }

    public Try<String> decodeRaw(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.decodeRaw$((JwtCore)this, (String)token, (SecretKey)key, algorithms, (JwtOptions)options);
    }

    public Try<String> decodeRaw(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms) {
        return JwtCore.decodeRaw$((JwtCore)this, (String)token, (SecretKey)key, algorithms);
    }

    public Try<String> decodeRaw(String token, SecretKey key, JwtOptions options) {
        return JwtCore.decodeRaw$((JwtCore)this, (String)token, (SecretKey)key, (JwtOptions)options);
    }

    public Try<String> decodeRaw(String token, SecretKey key) {
        return JwtCore.decodeRaw$((JwtCore)this, (String)token, (SecretKey)key);
    }

    public Try<String> decodeRaw(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.decodeRaw$((JwtCore)this, (String)token, (PublicKey)key, algorithms, (JwtOptions)options);
    }

    public Try<String> decodeRaw(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms) {
        return JwtCore.decodeRaw$((JwtCore)this, (String)token, (PublicKey)key, algorithms);
    }

    public Try<String> decodeRaw(String token, PublicKey key, JwtOptions options) {
        return JwtCore.decodeRaw$((JwtCore)this, (String)token, (PublicKey)key, (JwtOptions)options);
    }

    public Try<String> decodeRaw(String token, PublicKey key) {
        return JwtCore.decodeRaw$((JwtCore)this, (String)token, (PublicKey)key);
    }

    public Try<Tuple3<JwtHeader, JwtClaim, String>> decodeAll(String token, JwtOptions options) {
        return JwtCore.decodeAll$((JwtCore)this, (String)token, (JwtOptions)options);
    }

    public Try<Tuple3<JwtHeader, JwtClaim, String>> decodeAll(String token) {
        return JwtCore.decodeAll$((JwtCore)this, (String)token);
    }

    public Try<Tuple3<JwtHeader, JwtClaim, String>> decodeAll(String token, String key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.decodeAll$((JwtCore)this, (String)token, (String)key, algorithms, (JwtOptions)options);
    }

    public Try<Tuple3<JwtHeader, JwtClaim, String>> decodeAll(String token, String key, Seq<JwtHmacAlgorithm> algorithms) {
        return JwtCore.decodeAll$((JwtCore)this, (String)token, (String)key, algorithms);
    }

    public Try<Tuple3<JwtHeader, JwtClaim, String>> decodeAll(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms, JwtOptions options) {
        return JwtCore.decodeAll$((JwtCore)this, (String)token, (String)key, algorithms, (JwtOptions)options);
    }

    public Try<Tuple3<JwtHeader, JwtClaim, String>> decodeAll(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms) {
        return JwtCore.decodeAll$((JwtCore)this, (String)token, (String)key, algorithms);
    }

    public Try<Tuple3<JwtHeader, JwtClaim, String>> decodeAll(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.decodeAll$((JwtCore)this, (String)token, (SecretKey)key, algorithms, (JwtOptions)options);
    }

    public Try<Tuple3<JwtHeader, JwtClaim, String>> decodeAll(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms) {
        return JwtCore.decodeAll$((JwtCore)this, (String)token, (SecretKey)key, algorithms);
    }

    public Try<Tuple3<JwtHeader, JwtClaim, String>> decodeAll(String token, SecretKey key, JwtOptions options) {
        return JwtCore.decodeAll$((JwtCore)this, (String)token, (SecretKey)key, (JwtOptions)options);
    }

    public Try<Tuple3<JwtHeader, JwtClaim, String>> decodeAll(String token, SecretKey key) {
        return JwtCore.decodeAll$((JwtCore)this, (String)token, (SecretKey)key);
    }

    public Try<Tuple3<JwtHeader, JwtClaim, String>> decodeAll(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.decodeAll$((JwtCore)this, (String)token, (PublicKey)key, algorithms, (JwtOptions)options);
    }

    public Try<Tuple3<JwtHeader, JwtClaim, String>> decodeAll(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms) {
        return JwtCore.decodeAll$((JwtCore)this, (String)token, (PublicKey)key, algorithms);
    }

    public Try<Tuple3<JwtHeader, JwtClaim, String>> decodeAll(String token, PublicKey key, JwtOptions options) {
        return JwtCore.decodeAll$((JwtCore)this, (String)token, (PublicKey)key, (JwtOptions)options);
    }

    public Try<Tuple3<JwtHeader, JwtClaim, String>> decodeAll(String token, PublicKey key) {
        return JwtCore.decodeAll$((JwtCore)this, (String)token, (PublicKey)key);
    }

    public Try<JwtClaim> decode(String token, JwtOptions options) {
        return JwtCore.decode$((JwtCore)this, (String)token, (JwtOptions)options);
    }

    public Try<JwtClaim> decode(String token) {
        return JwtCore.decode$((JwtCore)this, (String)token);
    }

    public Try<JwtClaim> decode(String token, String key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.decode$((JwtCore)this, (String)token, (String)key, algorithms, (JwtOptions)options);
    }

    public Try<JwtClaim> decode(String token, String key, Seq<JwtHmacAlgorithm> algorithms) {
        return JwtCore.decode$((JwtCore)this, (String)token, (String)key, algorithms);
    }

    public Try<JwtClaim> decode(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms, JwtOptions options) {
        return JwtCore.decode$((JwtCore)this, (String)token, (String)key, algorithms, (JwtOptions)options);
    }

    public Try<JwtClaim> decode(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms) {
        return JwtCore.decode$((JwtCore)this, (String)token, (String)key, algorithms);
    }

    public Try<JwtClaim> decode(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.decode$((JwtCore)this, (String)token, (SecretKey)key, algorithms, (JwtOptions)options);
    }

    public Try<JwtClaim> decode(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms) {
        return JwtCore.decode$((JwtCore)this, (String)token, (SecretKey)key, algorithms);
    }

    public Try<JwtClaim> decode(String token, SecretKey key, JwtOptions options) {
        return JwtCore.decode$((JwtCore)this, (String)token, (SecretKey)key, (JwtOptions)options);
    }

    public Try<JwtClaim> decode(String token, SecretKey key) {
        return JwtCore.decode$((JwtCore)this, (String)token, (SecretKey)key);
    }

    public Try<JwtClaim> decode(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.decode$((JwtCore)this, (String)token, (PublicKey)key, algorithms, (JwtOptions)options);
    }

    public Try<JwtClaim> decode(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms) {
        return JwtCore.decode$((JwtCore)this, (String)token, (PublicKey)key, algorithms);
    }

    public Try<JwtClaim> decode(String token, PublicKey key, JwtOptions options) {
        return JwtCore.decode$((JwtCore)this, (String)token, (PublicKey)key, (JwtOptions)options);
    }

    public Try<JwtClaim> decode(String token, PublicKey key) {
        return JwtCore.decode$((JwtCore)this, (String)token, (PublicKey)key);
    }

    public Try validateTiming(Object claim, JwtOptions options) {
        return JwtCore.validateTiming$((JwtCore)this, (Object)claim, (JwtOptions)options);
    }

    public void validate(Object header, Object claim, String signature, JwtOptions options) {
        JwtCore.validate$((JwtCore)this, (Object)header, (Object)claim, (String)signature, (JwtOptions)options);
    }

    public void validate(String header64, Object header, String claim64, Object claim, String signature, JwtOptions options, Function3 verify) {
        JwtCore.validate$((JwtCore)this, (String)header64, (Object)header, (String)claim64, (Object)claim, (String)signature, (JwtOptions)options, (Function3)verify);
    }

    public void validate(String header64, Object header, String claim64, Object claim, String signature, String key, Seq algorithms, JwtOptions options) {
        JwtCore.validate$((JwtCore)this, (String)header64, (Object)header, (String)claim64, (Object)claim, (String)signature, (String)key, (Seq)algorithms, (JwtOptions)options);
    }

    public void validate(String header64, Object header, String claim64, Object claim, String signature, String key, Function0 algorithms, JwtOptions options) {
        JwtCore.validate$((JwtCore)this, (String)header64, (Object)header, (String)claim64, (Object)claim, (String)signature, (String)key, (Function0)algorithms, (JwtOptions)options);
    }

    public void validate(String header64, Object header, String claim64, Object claim, String signature, SecretKey key, Seq algorithms, JwtOptions options) {
        JwtCore.validate$((JwtCore)this, (String)header64, (Object)header, (String)claim64, (Object)claim, (String)signature, (SecretKey)key, (Seq)algorithms, (JwtOptions)options);
    }

    public void validate(String header64, Object header, String claim64, Object claim, String signature, PublicKey key, Seq algorithms, JwtOptions options) {
        JwtCore.validate$((JwtCore)this, (String)header64, (Object)header, (String)claim64, (Object)claim, (String)signature, (PublicKey)key, (Seq)algorithms, (JwtOptions)options);
    }

    public void validate(String token, JwtOptions options) {
        JwtCore.validate$((JwtCore)this, (String)token, (JwtOptions)options);
    }

    public void validate(String token) {
        JwtCore.validate$((JwtCore)this, (String)token);
    }

    public void validate(String token, String key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        JwtCore.validate$((JwtCore)this, (String)token, (String)key, algorithms, (JwtOptions)options);
    }

    public void validate(String token, String key, Seq<JwtHmacAlgorithm> algorithms) {
        JwtCore.validate$((JwtCore)this, (String)token, (String)key, algorithms);
    }

    public void validate(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms, JwtOptions options) {
        JwtCore.validate$((JwtCore)this, (String)token, (String)key, algorithms, (JwtOptions)options);
    }

    public void validate(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms) {
        JwtCore.validate$((JwtCore)this, (String)token, (String)key, algorithms);
    }

    public void validate(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        JwtCore.validate$((JwtCore)this, (String)token, (SecretKey)key, algorithms, (JwtOptions)options);
    }

    public void validate(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms) {
        JwtCore.validate$((JwtCore)this, (String)token, (SecretKey)key, algorithms);
    }

    public void validate(String token, SecretKey key, JwtOptions options) {
        JwtCore.validate$((JwtCore)this, (String)token, (SecretKey)key, (JwtOptions)options);
    }

    public void validate(String token, SecretKey key) {
        JwtCore.validate$((JwtCore)this, (String)token, (SecretKey)key);
    }

    public void validate(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms, JwtOptions options) {
        JwtCore.validate$((JwtCore)this, (String)token, (PublicKey)key, algorithms, (JwtOptions)options);
    }

    public void validate(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms) {
        JwtCore.validate$((JwtCore)this, (String)token, (PublicKey)key, algorithms);
    }

    public void validate(String token, PublicKey key, JwtOptions options) {
        JwtCore.validate$((JwtCore)this, (String)token, (PublicKey)key, (JwtOptions)options);
    }

    public void validate(String token, PublicKey key) {
        JwtCore.validate$((JwtCore)this, (String)token, (PublicKey)key);
    }

    public boolean isValid(String token, JwtOptions options) {
        return JwtCore.isValid$((JwtCore)this, (String)token, (JwtOptions)options);
    }

    public boolean isValid(String token) {
        return JwtCore.isValid$((JwtCore)this, (String)token);
    }

    public boolean isValid(String token, String key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.isValid$((JwtCore)this, (String)token, (String)key, algorithms, (JwtOptions)options);
    }

    public boolean isValid(String token, String key, Seq<JwtHmacAlgorithm> algorithms) {
        return JwtCore.isValid$((JwtCore)this, (String)token, (String)key, algorithms);
    }

    public boolean isValid(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms, JwtOptions options) {
        return JwtCore.isValid$((JwtCore)this, (String)token, (String)key, algorithms, (JwtOptions)options);
    }

    public boolean isValid(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms) {
        return JwtCore.isValid$((JwtCore)this, (String)token, (String)key, algorithms);
    }

    public boolean isValid(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.isValid$((JwtCore)this, (String)token, (SecretKey)key, algorithms, (JwtOptions)options);
    }

    public boolean isValid(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms) {
        return JwtCore.isValid$((JwtCore)this, (String)token, (SecretKey)key, algorithms);
    }

    public boolean isValid(String token, SecretKey key, JwtOptions options) {
        return JwtCore.isValid$((JwtCore)this, (String)token, (SecretKey)key, (JwtOptions)options);
    }

    public boolean isValid(String token, SecretKey key) {
        return JwtCore.isValid$((JwtCore)this, (String)token, (SecretKey)key);
    }

    public boolean isValid(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.isValid$((JwtCore)this, (String)token, (PublicKey)key, algorithms, (JwtOptions)options);
    }

    public boolean isValid(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms) {
        return JwtCore.isValid$((JwtCore)this, (String)token, (PublicKey)key, algorithms);
    }

    public boolean isValid(String token, PublicKey key, JwtOptions options) {
        return JwtCore.isValid$((JwtCore)this, (String)token, (PublicKey)key, (JwtOptions)options);
    }

    public boolean isValid(String token, PublicKey key) {
        return JwtCore.isValid$((JwtCore)this, (String)token, (PublicKey)key);
    }

    public Clock clock() {
        return this.clock;
    }

    public JwtHeader parseHeader(String header) {
        return JwtCodec$.MODULE$.de$lolhens$http4s$jwt$JwtCodec$$parseHeaderHelp(header, this.clock());
    }

    public JwtClaim parseClaim(String claim) {
        return JwtCodec$.MODULE$.de$lolhens$http4s$jwt$JwtCodec$$parseClaimHelp(claim, this.clock());
    }

    public Json parse(String value) {
        return (Json)package$.MODULE$.parse(value).toTry((.less.colon.less)$less$colon$less$.MODULE$.refl()).get();
    }

    public boolean validateHmacAlgorithm(JwtHmacAlgorithm algorithm, Seq<JwtHmacAlgorithm> algorithms) {
        return JwtCore.validateHmacAlgorithm$((JwtCore)this, (JwtHmacAlgorithm)algorithm, algorithms);
    }

    public boolean validateAsymmetricAlgorithm(JwtAsymmetricAlgorithm algorithm, Seq<JwtAsymmetricAlgorithm> algorithms) {
        return JwtCore.validateAsymmetricAlgorithm$((JwtCore)this, (JwtAsymmetricAlgorithm)algorithm, algorithms);
    }

    public Tuple5<String, String, String, String, String> splitToken(String token) {
        String string;
        String[] parts = token.split("\\.");
        int n = parts.length;
        switch (n) {
            case 2: {
                string = "";
                break;
            }
            case 3: {
                string = parts[2];
                break;
            }
            default: {
                throw new JwtLengthException(new StringBuilder(67).append("Expected token [").append(token).append("] to be composed of 2 or 3 parts separated by dots.").toString());
            }
        }
        String signature = string;
        return new Tuple5((Object)parts[0], (Object)JwtBase64$.MODULE$.decodeString(parts[0]), (Object)parts[1], (Object)JwtBase64$.MODULE$.decodeString(parts[1]), (Object)signature);
    }

    public <F, A> F decodeAllAndVerify(String token, JwtOptions options, Function1<Jwt<JwtAlgorithm>, F> verify, MonadError<F, Throwable> F) {
        Try verified = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Tuple5<String, String, String, String, String> tuple5 = this.splitToken(token);
            if (tuple5 == null) {
                throw new MatchError(tuple5);
            }
            String header64 = (String)tuple5._1();
            String header = (String)tuple5._2();
            String claim64 = (String)tuple5._3();
            String claim = (String)tuple5._4();
            String signature64 = (String)tuple5._5();
            Tuple5 tuple52 = new Tuple5((Object)header64, (Object)header, (Object)claim64, (Object)claim, (Object)signature64);
            String header642 = (String)tuple52._1();
            String header2 = (String)tuple52._2();
            String claim642 = (String)tuple52._3();
            String claim2 = (String)tuple52._4();
            String signature642 = (String)tuple52._5();
            JwtHeader h = this.parseHeader(header2);
            JwtClaim c = this.parseClaim(claim2);
            byte[] data = JwtUtils$.MODULE$.bytify(new StringBuilder(1).append(header642).append(".").append(claim642).toString());
            byte[] signature = JwtBase64$.MODULE$.decode(signature642);
            Jwt jwt = new Jwt(h, c, data, signature);
            if (options.signature()) {
                Option<JwtAlgorithm> maybeAlgo = this.extractAlgorithm(h);
                if (options.signature() && signature642.isEmpty()) {
                    throw new JwtEmptySignatureException();
                }
                if (maybeAlgo.isEmpty()) {
                    throw new JwtEmptyAlgorithmException();
                }
                return package.functor$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(package.applicativeError$.MODULE$.catsSyntaxApplicativeError(verify.apply(jwt), (ApplicativeError)F), (ApplicativeError)F), (Functor)F).map((Function1 & Serializable)x0$1 -> {
                    Option option;
                    boolean bl = false;
                    Right right = null;
                    Either either = x0$1;
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        Throwable error = (Throwable)left.value();
                        return new Failure(error);
                    }
                    if (either instanceof Right) {
                        bl = true;
                        right = (Right)either;
                        Option option2 = (Option)right.value();
                        if (None$.MODULE$.equals(option2)) {
                            return new Failure((Throwable)new JwtValidationException("Invalid signature for this token or wrong algorithm."));
                        }
                    }
                    if (bl && (option = (Option)right.value()) instanceof Some) {
                        Some some = (Some)option;
                        Object verified = some.value();
                        return this.validateTiming(c, options).map((Function1 & Serializable)x$2 -> new Tuple2((Object)jwt, (Object)new Some(verified)));
                    }
                    throw new MatchError((Object)either);
                });
            }
            return F.pure((Object)new Success((Object)new Tuple2(jwt, (Object)None$.MODULE$)));
        });
        return (F)verified.fold((Function1 & Serializable)e -> F.pure((Object)new Failure(e)), (Function1 & Serializable)x -> Predef$.MODULE$.identity(x));
    }

    public JwtCodec(Clock clock) {
        this.clock = clock;
        JwtCore.$init$((JwtCore)this);
        JwtJsonCommon.$init$((JwtJsonCommon)this);
        JwtCirceParser.$init$((JwtCirceParser)this);
    }
}

