/*
 * Decompiled with CFR 0.152.
 */
package de.lolhens.http4s.jwt;

import cats.MonadError;
import de.lolhens.http4s.jwt.Jwt;
import de.lolhens.http4s.jwt.JwtVerifier;
import java.security.PublicKey;
import javax.crypto.SecretKey;
import pdi.jwt.JwtAlgorithm;
import pdi.jwt.JwtAlgorithm$;
import pdi.jwt.algorithms.JwtAsymmetricAlgorithm;
import pdi.jwt.algorithms.JwtECDSAAlgorithm;
import pdi.jwt.algorithms.JwtHmacAlgorithm;
import pdi.jwt.algorithms.JwtRSAAlgorithm;
import scala.None$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;

public final class JwtVerifier$ {
    public static final JwtVerifier$ MODULE$ = new JwtVerifier$();
    private static final Seq<JwtAlgorithm> allAlgorithms = (Seq)((IterableOps)JwtAlgorithm$.MODULE$.allHmac().$plus$plus((IterableOnce)JwtAlgorithm$.MODULE$.allRSA())).$plus$plus((IterableOnce)JwtAlgorithm$.MODULE$.allECDSA());

    public Seq<JwtAlgorithm> allAlgorithms() {
        return allAlgorithms;
    }

    public <F> JwtVerifier<F, JwtAlgorithm, BoxedUnit> apply(String key, Seq<JwtAlgorithm> algorithms, MonadError<F, Throwable> F) {
        return new JwtVerifier<F, JwtAlgorithm, BoxedUnit>(algorithms, F, key){
            private final MonadError F$1;
            private final String key$1;

            public F verified(Jwt<JwtAlgorithm> jwt) {
                return (F)this.F$1.pure(this.verify(jwt, this.key$1) ? new Some((Object)BoxedUnit.UNIT) : None$.MODULE$);
            }
            {
                this.F$1 = F$1;
                this.key$1 = key$1;
                super(algorithms$1, F$1);
            }
        };
    }

    public <F> Seq<JwtAlgorithm> apply$default$2() {
        return this.allAlgorithms();
    }

    public <F> JwtVerifier<F, JwtHmacAlgorithm, BoxedUnit> hmac(SecretKey key, Seq<JwtHmacAlgorithm> algorithms, MonadError<F, Throwable> F) {
        return new JwtVerifier<F, JwtHmacAlgorithm, BoxedUnit>(algorithms, F, key){
            private final MonadError F$2;
            private final SecretKey key$2;

            public F verified(Jwt<JwtHmacAlgorithm> jwt) {
                return (F)this.F$2.pure(this.verifyHmac(jwt, this.key$2) ? new Some((Object)BoxedUnit.UNIT) : None$.MODULE$);
            }
            {
                this.F$2 = F$2;
                this.key$2 = key$2;
                super(algorithms$2, F$2);
            }
        };
    }

    public <F> Seq<JwtHmacAlgorithm> hmac$default$2() {
        return JwtAlgorithm$.MODULE$.allHmac();
    }

    public <F, Algorithm extends JwtAsymmetricAlgorithm> JwtVerifier<F, Algorithm, BoxedUnit> asymmetric(PublicKey key, Seq<Algorithm> algorithms, MonadError<F, Throwable> F) {
        return new JwtVerifier<F, Algorithm, BoxedUnit>(algorithms, F, key){
            private final MonadError F$3;
            private final PublicKey key$3;

            public F verified(Jwt<Algorithm> jwt) {
                return (F)this.F$3.pure(this.verifyAsymmetric(jwt, this.key$3) ? new Some((Object)BoxedUnit.UNIT) : None$.MODULE$);
            }
            {
                this.F$3 = F$3;
                this.key$3 = key$3;
                super(algorithms$3, F$3);
            }
        };
    }

    public <F> JwtVerifier<F, JwtAsymmetricAlgorithm, BoxedUnit> asymmetric(PublicKey key, MonadError<F, Throwable> F) {
        return this.asymmetric(key, JwtAlgorithm$.MODULE$.allAsymmetric(), F);
    }

    public <F> JwtVerifier<F, JwtRSAAlgorithm, BoxedUnit> rsa(PublicKey key, Seq<JwtRSAAlgorithm> algorithms, MonadError<F, Throwable> F) {
        return this.asymmetric(key, algorithms, F);
    }

    public <F> Seq<JwtRSAAlgorithm> rsa$default$2() {
        return JwtAlgorithm$.MODULE$.allRSA();
    }

    public <F> JwtVerifier<F, JwtECDSAAlgorithm, BoxedUnit> ecdsa(PublicKey key, Seq<JwtECDSAAlgorithm> algorithms, MonadError<F, Throwable> F) {
        return this.asymmetric(key, algorithms, F);
    }

    public <F> Seq<JwtECDSAAlgorithm> ecdsa$default$2() {
        return JwtAlgorithm$.MODULE$.allECDSA();
    }

    private JwtVerifier$() {
    }
}

