/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.metrics.otel;

import cats.Apply;
import cats.effect.kernel.Sync;
import cats.syntax.ApplyOps$;
import cats.syntax.package;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Status;
import org.http4s.metrics.MetricsOps;
import org.http4s.metrics.TerminationType;
import org.http4s.metrics.otel.AbnormalTermination$;
import org.http4s.metrics.otel.AbnormalTermination$Abnormal$;
import org.http4s.metrics.otel.AbnormalTermination$Canceled$;
import org.http4s.metrics.otel.AbnormalTermination$Error$;
import org.http4s.metrics.otel.AbnormalTermination$Timeout$;
import org.http4s.metrics.otel.MetricsCollection;
import org.http4s.metrics.otel.MetricsCollection$;
import org.http4s.metrics.otel.Phase$;
import org.http4s.metrics.otel.Phase$Body$;
import org.http4s.metrics.otel.Phase$Headers$;
import org.typelevel.otel4s.Attribute;
import org.typelevel.otel4s.Attribute$;
import org.typelevel.otel4s.metrics.Counter;
import org.typelevel.otel4s.metrics.Histogram;
import org.typelevel.otel4s.metrics.Meter;
import org.typelevel.otel4s.metrics.Meter$;
import org.typelevel.otel4s.metrics.UpDownCounter;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Tuple4$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class Http4sOtel$
implements Serializable {
    private static final List ResponseDurationDefaultHistogramBuckets;
    public static final Http4sOtel$ MODULE$;

    private Http4sOtel$() {
    }

    static {
        MODULE$ = new Http4sOtel$();
        ResponseDurationDefaultHistogramBuckets = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Http4sOtel$.class);
    }

    public <F> Object metricsOps(String prefix, Sync<F> evidence$1, Meter<F> evidence$2) {
        return package.all$.MODULE$.toFunctorOps(this.createMetricsCollection(prefix, evidence$1, evidence$2), evidence$1).map((Function1 & Serializable)metrics -> this.createMetricsOps((MetricsCollection)metrics, evidence$1));
    }

    public <F> String metricsOps$default$1() {
        return "org.http4s.server";
    }

    private <F> MetricsOps<F> createMetricsOps(MetricsCollection<F> metrics, Sync<F> evidence$1) {
        return new MetricsOps<F>(metrics, evidence$1, this){
            private final MetricsCollection metrics$1;
            private final Sync evidence$1$2;
            {
                this.metrics$1 = metrics$2;
                this.evidence$1$2 = evidence$1$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public Object increaseActiveRequests(Option classifier) {
                UpDownCounter<F, Object> UpDownCounterMacro_this = this.metrics$1.activeRequests();
                if (UpDownCounterMacro_this.backend().meta().isEnabled()) {
                    return UpDownCounterMacro_this.backend().inc((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{Attribute$.MODULE$.apply("classifier", (Object)this.label(classifier), Attribute.KeySelect$.MODULE$.stringKey())}));
                }
                return UpDownCounterMacro_this.backend().meta().unit();
            }

            public Object decreaseActiveRequests(Option classifier) {
                UpDownCounter<F, Object> UpDownCounterMacro_this = this.metrics$1.activeRequests();
                if (UpDownCounterMacro_this.backend().meta().isEnabled()) {
                    return UpDownCounterMacro_this.backend().dec((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{Attribute$.MODULE$.apply("classifier", (Object)this.label(classifier), Attribute.KeySelect$.MODULE$.stringKey())}));
                }
                return UpDownCounterMacro_this.backend().meta().unit();
            }

            public Object recordHeadersTime(Method method, long elapsed, Option classifier) {
                Histogram<F, Object> HistogramMacro_this = this.metrics$1.responseDuration();
                if (HistogramMacro_this.backend().meta().isEnabled()) {
                    return HistogramMacro_this.backend().record((Object)BoxesRunTime.boxToDouble((double)this.secondsFromNanos(elapsed)), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{Attribute$.MODULE$.apply("classifier", (Object)this.label(classifier), Attribute.KeySelect$.MODULE$.stringKey()), Attribute$.MODULE$.apply("method", (Object)this.reportMethod(method), Attribute.KeySelect$.MODULE$.stringKey()), Attribute$.MODULE$.apply("phase", (Object)Phase$.MODULE$.report(Phase$Headers$.MODULE$), Attribute.KeySelect$.MODULE$.stringKey())}));
                }
                return HistogramMacro_this.backend().meta().unit();
            }

            public Object recordTotalTime(Method method, Status status, long elapsed, Option classifier) {
                Histogram<F, Object> HistogramMacro_this = this.metrics$1.responseDuration();
                Object object = package.all$.MODULE$.catsSyntaxApplyOps(HistogramMacro_this.backend().meta().isEnabled() ? HistogramMacro_this.backend().record((Object)BoxesRunTime.boxToDouble((double)this.secondsFromNanos(elapsed)), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{Attribute$.MODULE$.apply("classifier", (Object)this.label(classifier), Attribute.KeySelect$.MODULE$.stringKey()), Attribute$.MODULE$.apply("method", (Object)this.reportMethod(method), Attribute.KeySelect$.MODULE$.stringKey()), Attribute$.MODULE$.apply("phase", (Object)Phase$.MODULE$.report(Phase$Body$.MODULE$), Attribute.KeySelect$.MODULE$.stringKey())})) : HistogramMacro_this.backend().meta().unit());
                Counter<F, Object> CounterMacro_this = this.metrics$1.requests();
                return ApplyOps$.MODULE$.$times$greater$extension(object, CounterMacro_this.backend().meta().isEnabled() ? CounterMacro_this.backend().inc((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{Attribute$.MODULE$.apply("classifier", (Object)this.label(classifier), Attribute.KeySelect$.MODULE$.stringKey()), Attribute$.MODULE$.apply("method", (Object)this.reportMethod(method), Attribute.KeySelect$.MODULE$.stringKey()), Attribute$.MODULE$.apply("status", (Object)this.reportStatus(status), Attribute.KeySelect$.MODULE$.stringKey())})) : CounterMacro_this.backend().meta().unit(), (Apply)this.evidence$1$2);
            }

            public Object recordAbnormalTermination(long elapsed, TerminationType terminationType, Option classifier) {
                TerminationType terminationType2 = terminationType;
                if (terminationType2 instanceof TerminationType.Abnormal) {
                    Throwable throwable;
                    TerminationType.Abnormal abnormal = TerminationType.Abnormal$.MODULE$.unapply((TerminationType.Abnormal)terminationType2);
                    Throwable e = throwable = abnormal._1();
                    return this.recordAbnormal(elapsed, classifier, e);
                }
                if (terminationType2 instanceof TerminationType.Error) {
                    Throwable throwable;
                    TerminationType.Error error = TerminationType.Error$.MODULE$.unapply((TerminationType.Error)terminationType2);
                    Throwable e = throwable = error._1();
                    return this.recordError(elapsed, classifier, e);
                }
                if (TerminationType.Canceled$.MODULE$.equals(terminationType2)) {
                    return this.recordCanceled(elapsed, classifier);
                }
                if (TerminationType.Timeout$.MODULE$.equals(terminationType2)) {
                    return this.recordTimeout(elapsed, classifier);
                }
                throw new MatchError((Object)terminationType2);
            }

            private Object recordCanceled(long elapsed, Option classifier) {
                Histogram<F, Object> HistogramMacro_this = this.metrics$1.abnormalTerminations();
                if (HistogramMacro_this.backend().meta().isEnabled()) {
                    return HistogramMacro_this.backend().record((Object)BoxesRunTime.boxToDouble((double)this.secondsFromNanos(elapsed)), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{Attribute$.MODULE$.apply("classifier", (Object)this.label(classifier), Attribute.KeySelect$.MODULE$.stringKey()), Attribute$.MODULE$.apply("termination_type", (Object)AbnormalTermination$.MODULE$.report(AbnormalTermination$Canceled$.MODULE$), Attribute.KeySelect$.MODULE$.stringKey()), Attribute$.MODULE$.apply("cause", (Object)this.label(Option$.MODULE$.empty()), Attribute.KeySelect$.MODULE$.stringKey())}));
                }
                return HistogramMacro_this.backend().meta().unit();
            }

            private Object recordAbnormal(long elapsed, Option classifier, Throwable cause) {
                Histogram<F, Object> HistogramMacro_this = this.metrics$1.abnormalTerminations();
                if (HistogramMacro_this.backend().meta().isEnabled()) {
                    return HistogramMacro_this.backend().record((Object)BoxesRunTime.boxToDouble((double)this.secondsFromNanos(elapsed)), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{Attribute$.MODULE$.apply("classifier", (Object)this.label(classifier), Attribute.KeySelect$.MODULE$.stringKey()), Attribute$.MODULE$.apply("termination_type", (Object)AbnormalTermination$.MODULE$.report(AbnormalTermination$Abnormal$.MODULE$), Attribute.KeySelect$.MODULE$.stringKey()), Attribute$.MODULE$.apply("cause", (Object)this.label(Option$.MODULE$.apply((Object)cause.getClass().getName())), Attribute.KeySelect$.MODULE$.stringKey())}));
                }
                return HistogramMacro_this.backend().meta().unit();
            }

            private Object recordError(long elapsed, Option classifier, Throwable cause) {
                Histogram<F, Object> HistogramMacro_this = this.metrics$1.abnormalTerminations();
                if (HistogramMacro_this.backend().meta().isEnabled()) {
                    return HistogramMacro_this.backend().record((Object)BoxesRunTime.boxToDouble((double)this.secondsFromNanos(elapsed)), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{Attribute$.MODULE$.apply("classifier", (Object)this.label(classifier), Attribute.KeySelect$.MODULE$.stringKey()), Attribute$.MODULE$.apply("termination_type", (Object)AbnormalTermination$.MODULE$.report(AbnormalTermination$Error$.MODULE$), Attribute.KeySelect$.MODULE$.stringKey()), Attribute$.MODULE$.apply("cause", (Object)this.label(Option$.MODULE$.apply((Object)cause.getClass().getName())), Attribute.KeySelect$.MODULE$.stringKey())}));
                }
                return HistogramMacro_this.backend().meta().unit();
            }

            private Object recordTimeout(long elapsed, Option classifier) {
                Histogram<F, Object> HistogramMacro_this = this.metrics$1.abnormalTerminations();
                if (HistogramMacro_this.backend().meta().isEnabled()) {
                    return HistogramMacro_this.backend().record((Object)BoxesRunTime.boxToDouble((double)this.secondsFromNanos(elapsed)), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{Attribute$.MODULE$.apply("classifier", (Object)this.label(classifier), Attribute.KeySelect$.MODULE$.stringKey()), Attribute$.MODULE$.apply("termination_type", (Object)AbnormalTermination$.MODULE$.report(AbnormalTermination$Timeout$.MODULE$), Attribute.KeySelect$.MODULE$.stringKey()), Attribute$.MODULE$.apply("cause", (Object)this.label(Option$.MODULE$.empty()), Attribute.KeySelect$.MODULE$.stringKey())}));
                }
                return HistogramMacro_this.backend().meta().unit();
            }

            private double secondsFromNanos(long nanos) {
                return (double)nanos / 1.0E9;
            }

            private String label(Option value) {
                return (String)value.getOrElse(Http4sOtel$::org$http4s$metrics$otel$Http4sOtel$$anon$1$$_$label$$anonfun$1);
            }

            private String reportStatus(Status status) {
                int n = status.code();
                int hundreds = n;
                if (hundreds < 200) {
                    return "1xx";
                }
                int twohundreds = n;
                if (twohundreds < 300) {
                    return "2xx";
                }
                int threehundreds = n;
                if (threehundreds < 400) {
                    return "3xx";
                }
                int fourhundreds = n;
                if (fourhundreds < 500) {
                    return "4xx";
                }
                return "5xx";
            }

            private String reportMethod(Method m) {
                Method method = m;
                Method method2 = Method$.MODULE$.GET();
                Method method3 = method;
                if (!(method2 != null ? !method2.equals(method3) : method3 != null)) {
                    return "get";
                }
                Method method4 = Method$.MODULE$.PUT();
                Method method5 = method;
                if (!(method4 != null ? !method4.equals(method5) : method5 != null)) {
                    return "put";
                }
                Method method6 = Method$.MODULE$.POST();
                Method method7 = method;
                if (!(method6 != null ? !method6.equals(method7) : method7 != null)) {
                    return "post";
                }
                Method method8 = Method$.MODULE$.PATCH();
                Method method9 = method;
                if (!(method8 != null ? !method8.equals(method9) : method9 != null)) {
                    return "patch";
                }
                Method method10 = Method$.MODULE$.HEAD();
                Method method11 = method;
                if (!(method10 != null ? !method10.equals(method11) : method11 != null)) {
                    return "head";
                }
                Method method12 = Method$.MODULE$.MOVE();
                Method method13 = method;
                if (!(method12 != null ? !method12.equals(method13) : method13 != null)) {
                    return "move";
                }
                Method method14 = Method$.MODULE$.OPTIONS();
                Method method15 = method;
                if (!(method14 != null ? !method14.equals(method15) : method15 != null)) {
                    return "options";
                }
                Method method16 = Method$.MODULE$.TRACE();
                Method method17 = method;
                if (!(method16 != null ? !method16.equals(method17) : method17 != null)) {
                    return "trace";
                }
                Method method18 = Method$.MODULE$.CONNECT();
                Method method19 = method;
                if (!(method18 != null ? !method18.equals(method19) : method19 != null)) {
                    return "connect";
                }
                Method method20 = Method$.MODULE$.DELETE();
                Method method21 = method;
                if (!(method20 != null ? !method20.equals(method21) : method21 != null)) {
                    return "delete";
                }
                return "other";
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$http4s$metrics$otel$Http4sOtel$$anon$1$$_$label$$anonfun$1()}, serializedLambda);
            }
        };
    }

    private <F> Object createMetricsCollection(String prefix, Sync<F> evidence$1, Meter<F> evidence$2) {
        Object responseDuration2 = Meter$.MODULE$.apply(evidence$2).histogram(new StringBuilder(18).append(prefix).append(".response.duration").toString()).withUnit("seconds").withDescription("Response Duration in seconds.").create();
        Object activeRequests2 = Meter$.MODULE$.apply(evidence$2).upDownCounter(new StringBuilder(21).append(prefix).append(".active_request.count").toString()).withDescription("Total Active Requests.").create();
        Object requests2 = Meter$.MODULE$.apply(evidence$2).counter(new StringBuilder(14).append(prefix).append(".request.count").toString()).withDescription("Total Requests.").create();
        Object abnormalTerminations2 = Meter$.MODULE$.apply(evidence$2).histogram(new StringBuilder(22).append(prefix).append(".abnormal_terminations").toString()).withDescription("Total Abnormal Terminations.").create();
        return package.all$.MODULE$.catsSyntaxTuple4Semigroupal(Tuple4$.MODULE$.apply(responseDuration2, activeRequests2, requests2, abnormalTerminations2)).mapN((Function4 & Serializable)(responseDuration, activeRequests, requests, abnormalTerminations) -> MetricsCollection$.MODULE$.apply(responseDuration, activeRequests, requests, abnormalTerminations), evidence$1, evidence$1);
    }

    public List<Object> ResponseDurationDefaultHistogramBuckets() {
        return ResponseDurationDefaultHistogramBuckets;
    }

    public static final String org$http4s$metrics$otel$Http4sOtel$$anon$1$$_$label$$anonfun$1() {
        return "";
    }
}

