/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.metrics.otel;

import cats.Apply;
import cats.arrow.FunctionK;
import cats.effect.kernel.Sync;
import cats.syntax.ApplyOps$;
import cats.syntax.package;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Status;
import org.http4s.metrics.MetricsOps;
import org.http4s.metrics.TerminationType;
import org.http4s.metrics.otel.AbnormalTermination$;
import org.http4s.metrics.otel.AbnormalTermination$Abnormal$;
import org.http4s.metrics.otel.AbnormalTermination$Canceled$;
import org.http4s.metrics.otel.AbnormalTermination$Error$;
import org.http4s.metrics.otel.AbnormalTermination$Timeout$;
import org.http4s.metrics.otel.MetricsCollection;
import org.http4s.metrics.otel.Phase$;
import org.http4s.metrics.otel.Phase$Body$;
import org.http4s.metrics.otel.Phase$Headers$;
import org.typelevel.otel4s.Attribute;
import org.typelevel.otel4s.Attribute$;
import org.typelevel.otel4s.metrics.BucketBoundaries;
import org.typelevel.otel4s.metrics.BucketBoundaries$;
import org.typelevel.otel4s.metrics.MeasurementValue$;
import org.typelevel.otel4s.metrics.Meter;
import org.typelevel.otel4s.metrics.Meter$;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Tuple4;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

public final class Http4sOtel$ {
    public static final Http4sOtel$ MODULE$ = new Http4sOtel$();
    private static final BucketBoundaries DefaultHistogramBuckets = BucketBoundaries$.MODULE$.apply((Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0})));

    public <F> F metricsOps(String prefix, BucketBoundaries responseDurationSecondsHistogramBuckets, Sync<F> evidence$1, Meter<F> evidence$2) {
        return (F)package.all$.MODULE$.toFunctorOps(this.createMetricsCollection(prefix, responseDurationSecondsHistogramBuckets, evidence$1, evidence$2), evidence$1).map((Function1 & Serializable)metrics -> MODULE$.createMetricsOps((MetricsCollection)metrics, evidence$1));
    }

    public <F> String metricsOps$default$1() {
        return "org.http4s.server";
    }

    public <F> BucketBoundaries metricsOps$default$2() {
        return this.DefaultHistogramBuckets();
    }

    private <F> MetricsOps<F> createMetricsOps(MetricsCollection<F> metrics, Sync<F> evidence$3) {
        return new MetricsOps<F>(metrics, evidence$3){
            private final MetricsCollection metrics$1;
            private final Sync evidence$3$1;

            public <G> MetricsOps<G> mapK(FunctionK<F, G> fk) {
                return MetricsOps.mapK$((MetricsOps)this, fk);
            }

            public F increaseActiveRequests(Option<String> classifier) {
                if (this.metrics$1.activeRequests().backend().meta().isEnabled()) {
                    return (F)this.metrics$1.activeRequests().backend().inc((Iterable)new .colon.colon((Object)Attribute$.MODULE$.apply("classifier", (Object)this.label(classifier), Attribute.KeySelect$.MODULE$.stringKey()), (List)Nil$.MODULE$));
                }
                return (F)this.metrics$1.activeRequests().backend().meta().unit();
            }

            public F decreaseActiveRequests(Option<String> classifier) {
                if (this.metrics$1.activeRequests().backend().meta().isEnabled()) {
                    return (F)this.metrics$1.activeRequests().backend().dec((Iterable)new .colon.colon((Object)Attribute$.MODULE$.apply("classifier", (Object)this.label(classifier), Attribute.KeySelect$.MODULE$.stringKey()), (List)Nil$.MODULE$));
                }
                return (F)this.metrics$1.activeRequests().backend().meta().unit();
            }

            public F recordHeadersTime(Method method, long elapsed, Option<String> classifier) {
                if (this.metrics$1.responseDuration().backend().meta().isEnabled()) {
                    return (F)this.metrics$1.responseDuration().backend().record((Object)BoxesRunTime.boxToDouble((double)this.secondsFromNanos(elapsed)), (Iterable)new .colon.colon((Object)Attribute$.MODULE$.apply("classifier", (Object)this.label(classifier), Attribute.KeySelect$.MODULE$.stringKey()), (List)new .colon.colon((Object)Attribute$.MODULE$.apply("method", (Object)this.reportMethod(method), Attribute.KeySelect$.MODULE$.stringKey()), (List)new .colon.colon((Object)Attribute$.MODULE$.apply("phase", (Object)Phase$.MODULE$.report(Phase$Headers$.MODULE$), Attribute.KeySelect$.MODULE$.stringKey()), (List)Nil$.MODULE$))));
                }
                return (F)this.metrics$1.responseDuration().backend().meta().unit();
            }

            public F recordTotalTime(Method method, Status status, long elapsed, Option<String> classifier) {
                return (F)ApplyOps$.MODULE$.$times$greater$extension(package.all$.MODULE$.catsSyntaxApplyOps(this.metrics$1.responseDuration().backend().meta().isEnabled() ? this.metrics$1.responseDuration().backend().record((Object)BoxesRunTime.boxToDouble((double)this.secondsFromNanos(elapsed)), (Iterable)new .colon.colon((Object)Attribute$.MODULE$.apply("classifier", (Object)this.label(classifier), Attribute.KeySelect$.MODULE$.stringKey()), (List)new .colon.colon((Object)Attribute$.MODULE$.apply("method", (Object)this.reportMethod(method), Attribute.KeySelect$.MODULE$.stringKey()), (List)new .colon.colon((Object)Attribute$.MODULE$.apply("phase", (Object)Phase$.MODULE$.report(Phase$Body$.MODULE$), Attribute.KeySelect$.MODULE$.stringKey()), (List)Nil$.MODULE$)))) : this.metrics$1.responseDuration().backend().meta().unit()), this.metrics$1.requests().backend().meta().isEnabled() ? this.metrics$1.requests().backend().inc((Iterable)new .colon.colon((Object)Attribute$.MODULE$.apply("classifier", (Object)this.label(classifier), Attribute.KeySelect$.MODULE$.stringKey()), (List)new .colon.colon((Object)Attribute$.MODULE$.apply("method", (Object)this.reportMethod(method), Attribute.KeySelect$.MODULE$.stringKey()), (List)new .colon.colon((Object)Attribute$.MODULE$.apply("status", (Object)this.reportStatus(status), Attribute.KeySelect$.MODULE$.stringKey()), (List)Nil$.MODULE$)))) : this.metrics$1.requests().backend().meta().unit(), (Apply)this.evidence$3$1);
            }

            public F recordAbnormalTermination(long elapsed, TerminationType terminationType, Option<String> classifier) {
                TerminationType terminationType2 = terminationType;
                if (terminationType2 instanceof TerminationType.Abnormal) {
                    TerminationType.Abnormal abnormal = (TerminationType.Abnormal)terminationType2;
                    Throwable e = abnormal.rootCause();
                    return this.recordAbnormal(elapsed, classifier, e);
                }
                if (terminationType2 instanceof TerminationType.Error) {
                    TerminationType.Error error = (TerminationType.Error)terminationType2;
                    Throwable e = error.rootCause();
                    return this.recordError(elapsed, classifier, e);
                }
                if (TerminationType.Canceled$.MODULE$.equals(terminationType2)) {
                    return this.recordCanceled(elapsed, classifier);
                }
                if (TerminationType.Timeout$.MODULE$.equals(terminationType2)) {
                    return this.recordTimeout(elapsed, classifier);
                }
                throw new MatchError((Object)terminationType2);
            }

            private F recordCanceled(long elapsed, Option<String> classifier) {
                if (this.metrics$1.abnormalTerminations().backend().meta().isEnabled()) {
                    return (F)this.metrics$1.abnormalTerminations().backend().record((Object)BoxesRunTime.boxToDouble((double)this.secondsFromNanos(elapsed)), (Iterable)new .colon.colon((Object)Attribute$.MODULE$.apply("classifier", (Object)this.label(classifier), Attribute.KeySelect$.MODULE$.stringKey()), (List)new .colon.colon((Object)Attribute$.MODULE$.apply("termination_type", (Object)AbnormalTermination$.MODULE$.report(AbnormalTermination$Canceled$.MODULE$), Attribute.KeySelect$.MODULE$.stringKey()), (List)new .colon.colon((Object)Attribute$.MODULE$.apply("cause", (Object)this.label((Option<String>)Option$.MODULE$.empty()), Attribute.KeySelect$.MODULE$.stringKey()), (List)Nil$.MODULE$))));
                }
                return (F)this.metrics$1.abnormalTerminations().backend().meta().unit();
            }

            private F recordAbnormal(long elapsed, Option<String> classifier, Throwable cause) {
                if (this.metrics$1.abnormalTerminations().backend().meta().isEnabled()) {
                    return (F)this.metrics$1.abnormalTerminations().backend().record((Object)BoxesRunTime.boxToDouble((double)this.secondsFromNanos(elapsed)), (Iterable)new .colon.colon((Object)Attribute$.MODULE$.apply("classifier", (Object)this.label(classifier), Attribute.KeySelect$.MODULE$.stringKey()), (List)new .colon.colon((Object)Attribute$.MODULE$.apply("termination_type", (Object)AbnormalTermination$.MODULE$.report(AbnormalTermination$Abnormal$.MODULE$), Attribute.KeySelect$.MODULE$.stringKey()), (List)new .colon.colon((Object)Attribute$.MODULE$.apply("cause", (Object)this.label((Option<String>)Option$.MODULE$.apply((Object)cause.getClass().getName())), Attribute.KeySelect$.MODULE$.stringKey()), (List)Nil$.MODULE$))));
                }
                return (F)this.metrics$1.abnormalTerminations().backend().meta().unit();
            }

            private F recordError(long elapsed, Option<String> classifier, Throwable cause) {
                if (this.metrics$1.abnormalTerminations().backend().meta().isEnabled()) {
                    return (F)this.metrics$1.abnormalTerminations().backend().record((Object)BoxesRunTime.boxToDouble((double)this.secondsFromNanos(elapsed)), (Iterable)new .colon.colon((Object)Attribute$.MODULE$.apply("classifier", (Object)this.label(classifier), Attribute.KeySelect$.MODULE$.stringKey()), (List)new .colon.colon((Object)Attribute$.MODULE$.apply("termination_type", (Object)AbnormalTermination$.MODULE$.report(AbnormalTermination$Error$.MODULE$), Attribute.KeySelect$.MODULE$.stringKey()), (List)new .colon.colon((Object)Attribute$.MODULE$.apply("cause", (Object)this.label((Option<String>)Option$.MODULE$.apply((Object)cause.getClass().getName())), Attribute.KeySelect$.MODULE$.stringKey()), (List)Nil$.MODULE$))));
                }
                return (F)this.metrics$1.abnormalTerminations().backend().meta().unit();
            }

            private F recordTimeout(long elapsed, Option<String> classifier) {
                if (this.metrics$1.abnormalTerminations().backend().meta().isEnabled()) {
                    return (F)this.metrics$1.abnormalTerminations().backend().record((Object)BoxesRunTime.boxToDouble((double)this.secondsFromNanos(elapsed)), (Iterable)new .colon.colon((Object)Attribute$.MODULE$.apply("classifier", (Object)this.label(classifier), Attribute.KeySelect$.MODULE$.stringKey()), (List)new .colon.colon((Object)Attribute$.MODULE$.apply("termination_type", (Object)AbnormalTermination$.MODULE$.report(AbnormalTermination$Timeout$.MODULE$), Attribute.KeySelect$.MODULE$.stringKey()), (List)new .colon.colon((Object)Attribute$.MODULE$.apply("cause", (Object)this.label((Option<String>)Option$.MODULE$.empty()), Attribute.KeySelect$.MODULE$.stringKey()), (List)Nil$.MODULE$))));
                }
                return (F)this.metrics$1.abnormalTerminations().backend().meta().unit();
            }

            private double secondsFromNanos(long nanos) {
                return (double)nanos / 1.0E9;
            }

            private String label(Option<String> value) {
                return (String)value.getOrElse((Function0 & Serializable)() -> "");
            }

            private String reportStatus(Status status) {
                int n = status.code();
                switch (n) {
                    default: 
                }
                if (n < 200) {
                    return "1xx";
                }
                if (n < 300) {
                    return "2xx";
                }
                if (n < 400) {
                    return "3xx";
                }
                if (n < 500) {
                    return "4xx";
                }
                return "5xx";
            }

            private String reportMethod(Method m) {
                Method method = m;
                Method method2 = Method$.MODULE$.GET();
                Method method3 = method;
                if (!(method2 != null ? !method2.equals(method3) : method3 != null)) {
                    return "get";
                }
                Method method4 = Method$.MODULE$.PUT();
                Method method5 = method;
                if (!(method4 != null ? !method4.equals(method5) : method5 != null)) {
                    return "put";
                }
                Method method6 = Method$.MODULE$.POST();
                Method method7 = method;
                if (!(method6 != null ? !method6.equals(method7) : method7 != null)) {
                    return "post";
                }
                Method method8 = Method$.MODULE$.PATCH();
                Method method9 = method;
                if (!(method8 != null ? !method8.equals(method9) : method9 != null)) {
                    return "patch";
                }
                Method method10 = Method$.MODULE$.HEAD();
                Method method11 = method;
                if (!(method10 != null ? !method10.equals(method11) : method11 != null)) {
                    return "head";
                }
                Method method12 = Method$.MODULE$.MOVE();
                Method method13 = method;
                if (!(method12 != null ? !method12.equals(method13) : method13 != null)) {
                    return "move";
                }
                Method method14 = Method$.MODULE$.OPTIONS();
                Method method15 = method;
                if (!(method14 != null ? !method14.equals(method15) : method15 != null)) {
                    return "options";
                }
                Method method16 = Method$.MODULE$.TRACE();
                Method method17 = method;
                if (!(method16 != null ? !method16.equals(method17) : method17 != null)) {
                    return "trace";
                }
                Method method18 = Method$.MODULE$.CONNECT();
                Method method19 = method;
                if (!(method18 != null ? !method18.equals(method19) : method19 != null)) {
                    return "connect";
                }
                Method method20 = Method$.MODULE$.DELETE();
                Method method21 = method;
                if (!(method20 != null ? !method20.equals(method21) : method21 != null)) {
                    return "delete";
                }
                return "other";
            }
            {
                this.metrics$1 = metrics$1;
                this.evidence$3$1 = evidence$3$1;
                MetricsOps.$init$((MetricsOps)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$label$1()}, serializedLambda);
            }
        };
    }

    private <F> F createMetricsCollection(String prefix, BucketBoundaries responseDurationSecondsHistogramBuckets, Sync<F> evidence$4, Meter<F> evidence$5) {
        Object responseDuration2 = Meter$.MODULE$.apply(evidence$5).histogram(new StringBuilder(18).append(prefix).append(".response.duration").toString(), MeasurementValue$.MODULE$.doubleMeasurementValue()).withUnit("seconds").withDescription("Response Duration in seconds.").create();
        Object activeRequests2 = Meter$.MODULE$.apply(evidence$5).upDownCounter(new StringBuilder(21).append(prefix).append(".active_request.count").toString(), MeasurementValue$.MODULE$.longMeasurementValue()).withDescription("Total Active Requests.").create();
        Object requests2 = Meter$.MODULE$.apply(evidence$5).counter(new StringBuilder(14).append(prefix).append(".request.count").toString(), MeasurementValue$.MODULE$.longMeasurementValue()).withDescription("Total Requests.").create();
        Object abnormalTerminations2 = Meter$.MODULE$.apply(evidence$5).histogram(new StringBuilder(22).append(prefix).append(".abnormal_terminations").toString(), MeasurementValue$.MODULE$.doubleMeasurementValue()).withDescription("Total Abnormal Terminations.").withExplicitBucketBoundaries(responseDurationSecondsHistogramBuckets).create();
        return (F)package.all$.MODULE$.catsSyntaxTuple4Semigroupal(new Tuple4(responseDuration2, activeRequests2, requests2, abnormalTerminations2)).mapN((Function4 & Serializable)(responseDuration, activeRequests, requests, abnormalTerminations) -> new MetricsCollection(responseDuration, activeRequests, requests, abnormalTerminations), evidence$4, evidence$4);
    }

    private BucketBoundaries DefaultHistogramBuckets() {
        return DefaultHistogramBuckets;
    }

    private Http4sOtel$() {
    }
}

