/*
 * Decompiled with CFR 0.152.
 */
package de.lhns.jwt.jwtscala;

import cats.effect.kernel.Sync;
import cats.kernel.Semigroup;
import cats.syntax.package;
import de.lhns.jwt.Jwt;
import de.lhns.jwt.JwtAlgorithm;
import de.lhns.jwt.JwtSigner;
import de.lhns.jwt.JwtSigner$;
import de.lhns.jwt.JwtValidationException;
import de.lhns.jwt.JwtValidationOptions;
import de.lhns.jwt.JwtValidationOptions$;
import de.lhns.jwt.JwtVerifier;
import de.lhns.jwt.JwtVerifier$;
import de.lhns.jwt.SignedJwt;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.SecretKey;
import pdi.jwt.JwtAlgorithm;
import pdi.jwt.JwtUtils$;
import pdi.jwt.algorithms.JwtAsymmetricAlgorithm;
import pdi.jwt.algorithms.JwtHmacAlgorithm;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.java8.JFunction0;

public final class JwtScala$ {
    public static final JwtScala$ MODULE$ = new JwtScala$();

    public <F> JwtSigner<F> hmacSigner(JwtAlgorithm.JwtHmacAlgorithm algorithm, SecretKey key, Sync<F> evidence$1) {
        return JwtSigner$.MODULE$.delay((Function1 & Serializable)jwt -> {
            Jwt jwtAlg = jwt.modifyHeader((Function1 & Serializable)x$1 -> (Jwt.JwtHeader)x$1.withAlgorithm((Option)new Some((Object)algorithm)));
            byte[] signature = JwtUtils$.MODULE$.sign(jwtAlg.encode().getBytes(StandardCharsets.UTF_8), key, MODULE$.jwtHmacAlgorithm(algorithm));
            return new SignedJwt(jwtAlg, signature);
        }, evidence$1);
    }

    public <F> JwtSigner<F> asymmetricSigner(JwtAlgorithm.JwtAsymmetricAlgorithm algorithm, PrivateKey key, Sync<F> evidence$2) {
        return JwtSigner$.MODULE$.delay((Function1 & Serializable)jwt -> {
            Jwt jwtAlg = jwt.modifyHeader((Function1 & Serializable)x$2 -> (Jwt.JwtHeader)x$2.withAlgorithm((Option)new Some((Object)algorithm)));
            byte[] signature = JwtUtils$.MODULE$.sign(jwtAlg.encode().getBytes(StandardCharsets.UTF_8), key, MODULE$.jwtAsymmetricAlgorithm(algorithm));
            return new SignedJwt(jwtAlg, signature);
        }, evidence$2);
    }

    public <F> JwtVerifier<F> hmacVerifier(SecretKey key, Seq<JwtAlgorithm.JwtHmacAlgorithm> algorithms, JwtValidationOptions options, Sync<F> evidence$3) {
        return (JwtVerifier)package.all$.MODULE$.catsSyntaxSemigroup((Object)JwtVerifier$.MODULE$.basicVerifier(algorithms, options, evidence$3, evidence$3), (Semigroup)JwtVerifier$.MODULE$.monoid(evidence$3)).$bar$plus$bar((Object)JwtVerifier$.MODULE$.delay((Function1 & Serializable)signedJwt -> {
            Some some;
            JwtAlgorithm algorithm;
            Option option = signedJwt.header().algorithm();
            if (!(option instanceof Some) || !((algorithm = (JwtAlgorithm)(some = (Some)option).value()) instanceof JwtAlgorithm.JwtHmacAlgorithm)) {
                throw new IllegalStateException();
            }
            JwtAlgorithm.JwtHmacAlgorithm jwtHmacAlgorithm = (JwtAlgorithm.JwtHmacAlgorithm)algorithm;
            boolean verified = JwtUtils$.MODULE$.verify(signedJwt.jwt().encode().getBytes(StandardCharsets.UTF_8), signedJwt.signature(), key, MODULE$.jwtHmacAlgorithm(jwtHmacAlgorithm));
            return package$.MODULE$.Either().cond(verified, (Function0)(JFunction0.mcV.sp & Serializable)() -> {}, (Function0 & Serializable)() -> new JwtValidationException.JwtInvalidSignatureException());
        }, evidence$3));
    }

    public <F> Seq<JwtAlgorithm.JwtHmacAlgorithm> hmacVerifier$default$2() {
        return JwtAlgorithm.JwtHmacAlgorithm$.MODULE$.values();
    }

    public <F> JwtValidationOptions hmacVerifier$default$3() {
        return JwtValidationOptions$.MODULE$.default();
    }

    public <F> JwtVerifier<F> asymmetricVerifier(PublicKey key, Seq<JwtAlgorithm.JwtAsymmetricAlgorithm> algorithms, JwtValidationOptions options, Sync<F> evidence$4) {
        return (JwtVerifier)package.all$.MODULE$.catsSyntaxSemigroup((Object)JwtVerifier$.MODULE$.basicVerifier(algorithms, options, evidence$4, evidence$4), (Semigroup)JwtVerifier$.MODULE$.monoid(evidence$4)).$bar$plus$bar((Object)JwtVerifier$.MODULE$.delay((Function1 & Serializable)signedJwt -> {
            Some some;
            JwtAlgorithm algorithm;
            Option option = signedJwt.header().algorithm();
            if (!(option instanceof Some) || !((algorithm = (JwtAlgorithm)(some = (Some)option).value()) instanceof JwtAlgorithm.JwtAsymmetricAlgorithm)) {
                throw new IllegalStateException();
            }
            JwtAlgorithm.JwtAsymmetricAlgorithm jwtAsymmetricAlgorithm = (JwtAlgorithm.JwtAsymmetricAlgorithm)algorithm;
            boolean verified = JwtUtils$.MODULE$.verify(signedJwt.jwt().encode().getBytes(StandardCharsets.UTF_8), signedJwt.signature(), key, MODULE$.jwtAsymmetricAlgorithm(jwtAsymmetricAlgorithm));
            return package$.MODULE$.Either().cond(verified, (Function0)(JFunction0.mcV.sp & Serializable)() -> {}, (Function0 & Serializable)() -> new JwtValidationException.JwtInvalidSignatureException());
        }, evidence$4));
    }

    public <F> Seq<JwtAlgorithm.JwtAsymmetricAlgorithm> asymmetricVerifier$default$2() {
        return JwtAlgorithm.JwtAsymmetricAlgorithm$.MODULE$.values();
    }

    public <F> JwtValidationOptions asymmetricVerifier$default$3() {
        return JwtValidationOptions$.MODULE$.default();
    }

    private JwtHmacAlgorithm jwtHmacAlgorithm(JwtAlgorithm.JwtHmacAlgorithm algorithm) {
        JwtAlgorithm.JwtHmacAlgorithm jwtHmacAlgorithm = algorithm;
        if (JwtAlgorithm.HS256$.MODULE$.equals(jwtHmacAlgorithm)) {
            return JwtAlgorithm.HS256$.MODULE$;
        }
        if (JwtAlgorithm.HS384$.MODULE$.equals(jwtHmacAlgorithm)) {
            return JwtAlgorithm.HS384$.MODULE$;
        }
        if (JwtAlgorithm.HS512$.MODULE$.equals(jwtHmacAlgorithm)) {
            return JwtAlgorithm.HS512$.MODULE$;
        }
        throw new MatchError((Object)jwtHmacAlgorithm);
    }

    private JwtAsymmetricAlgorithm jwtAsymmetricAlgorithm(JwtAlgorithm.JwtAsymmetricAlgorithm algorithm) {
        JwtAlgorithm.JwtAsymmetricAlgorithm jwtAsymmetricAlgorithm = algorithm;
        if (JwtAlgorithm.RS256$.MODULE$.equals(jwtAsymmetricAlgorithm)) {
            return JwtAlgorithm.RS256$.MODULE$;
        }
        if (JwtAlgorithm.RS384$.MODULE$.equals(jwtAsymmetricAlgorithm)) {
            return JwtAlgorithm.RS384$.MODULE$;
        }
        if (JwtAlgorithm.RS512$.MODULE$.equals(jwtAsymmetricAlgorithm)) {
            return JwtAlgorithm.RS512$.MODULE$;
        }
        if (JwtAlgorithm.ES256$.MODULE$.equals(jwtAsymmetricAlgorithm)) {
            return JwtAlgorithm.ES256$.MODULE$;
        }
        if (JwtAlgorithm.ES384$.MODULE$.equals(jwtAsymmetricAlgorithm)) {
            return JwtAlgorithm.ES384$.MODULE$;
        }
        if (JwtAlgorithm.ES512$.MODULE$.equals(jwtAsymmetricAlgorithm)) {
            return JwtAlgorithm.ES512$.MODULE$;
        }
        throw new MatchError((Object)jwtAsymmetricAlgorithm);
    }

    private JwtScala$() {
    }
}

