/*
 * Decompiled with CFR 0.152.
 */
package de.lhns.jwt.jwtscala;

import cats.effect.kernel.Sync;
import cats.kernel.Semigroup;
import cats.syntax.package;
import de.lhns.jwt.Jwt;
import de.lhns.jwt.JwtAlgorithm;
import de.lhns.jwt.JwtCertPath$;
import de.lhns.jwt.JwtSigner;
import de.lhns.jwt.JwtSigner$;
import de.lhns.jwt.JwtValidationException;
import de.lhns.jwt.JwtValidationOptions;
import de.lhns.jwt.JwtValidationOptions$;
import de.lhns.jwt.JwtVerifier;
import de.lhns.jwt.JwtVerifier$;
import de.lhns.jwt.SignedJwt$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.PKIXParameters;
import javax.crypto.SecretKey;
import pdi.jwt.JwtAlgorithm;
import pdi.jwt.JwtUtils$;
import pdi.jwt.algorithms.JwtAsymmetricAlgorithm;
import pdi.jwt.algorithms.JwtHmacAlgorithm;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;

public final class JwtScala$
implements Serializable {
    public static final JwtScala$ MODULE$ = new JwtScala$();

    private JwtScala$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JwtScala$.class);
    }

    public <F> JwtSigner<F> hmacSigner(JwtAlgorithm.JwtHmacAlgorithm algorithm, SecretKey key, Sync<F> evidence$1) {
        return JwtSigner$.MODULE$.delay((Function1 & Serializable)jwt -> {
            Jwt jwtAlg = jwt.modifyHeader((Function1 & Serializable)_$2 -> (Jwt.JwtHeader)_$2.withAlgorithm((Option)Some$.MODULE$.apply((Object)algorithm)));
            byte[] signature = JwtUtils$.MODULE$.sign(jwtAlg.encode().getBytes(StandardCharsets.UTF_8), key, this.jwtHmacAlgorithm(algorithm));
            return SignedJwt$.MODULE$.apply(jwtAlg, signature);
        }, evidence$1);
    }

    public <F> JwtSigner<F> asymmetricSigner(JwtAlgorithm.JwtAsymmetricAlgorithm algorithm, PrivateKey key, Sync<F> evidence$1) {
        return JwtSigner$.MODULE$.delay((Function1 & Serializable)jwt -> {
            Jwt jwtAlg = jwt.modifyHeader((Function1 & Serializable)_$4 -> (Jwt.JwtHeader)_$4.withAlgorithm((Option)Some$.MODULE$.apply((Object)algorithm)));
            byte[] signature = JwtUtils$.MODULE$.sign(jwtAlg.encode().getBytes(StandardCharsets.UTF_8), key, this.jwtAsymmetricAlgorithm(algorithm));
            return SignedJwt$.MODULE$.apply(jwtAlg, signature);
        }, evidence$1);
    }

    public <F> JwtSigner<F> certPathSigner(JwtAlgorithm.JwtAsymmetricAlgorithm algorithm, PrivateKey key, CertPath certPath, Sync<F> evidence$1) {
        return JwtCertPath$.MODULE$.signer(certPath, this.asymmetricSigner(algorithm, key, evidence$1));
    }

    public <F> JwtVerifier<F> hmacVerifier(SecretKey key, Seq<JwtAlgorithm.JwtHmacAlgorithm> algorithms, JwtValidationOptions options, Sync<F> evidence$1) {
        return (JwtVerifier)package.all$.MODULE$.catsSyntaxSemigroup((Object)JwtVerifier$.MODULE$.basicVerifier(algorithms, options, evidence$1, evidence$1), (Semigroup)JwtVerifier$.MODULE$.monoid(evidence$1)).$bar$plus$bar((Object)JwtVerifier$.MODULE$.delay((Function1 & Serializable)signedJwt -> {
            JwtAlgorithm jwtAlgorithm;
            Option option = signedJwt.header().algorithm();
            if (!(option instanceof Some) || !((jwtAlgorithm = (JwtAlgorithm)((Some)option).value()) instanceof JwtAlgorithm.JwtHmacAlgorithm)) {
                throw new IllegalStateException();
            }
            JwtAlgorithm.JwtHmacAlgorithm algorithm = (JwtAlgorithm.JwtHmacAlgorithm)jwtAlgorithm;
            boolean verified = JwtUtils$.MODULE$.verify(signedJwt.jwt().encode().getBytes(StandardCharsets.UTF_8), signedJwt.signature(), key, this.jwtHmacAlgorithm(algorithm));
            return package$.MODULE$.Either().cond(verified, (Function0 & Serializable)() -> {
                this.hmacVerifier$$anonfun$1$$anonfun$1();
                return BoxedUnit.UNIT;
            }, this::hmacVerifier$$anonfun$1$$anonfun$2);
        }, evidence$1));
    }

    public <F> Seq<JwtAlgorithm.JwtHmacAlgorithm> hmacVerifier$default$2() {
        return JwtAlgorithm.JwtHmacAlgorithm$.MODULE$.values();
    }

    public <F> JwtValidationOptions hmacVerifier$default$3() {
        return JwtValidationOptions$.MODULE$.default();
    }

    public <F> JwtVerifier<F> asymmetricVerifier(PublicKey key, Seq<JwtAlgorithm.JwtAsymmetricAlgorithm> algorithms, JwtValidationOptions options, Sync<F> evidence$1) {
        return (JwtVerifier)package.all$.MODULE$.catsSyntaxSemigroup((Object)JwtVerifier$.MODULE$.basicVerifier(algorithms, options, evidence$1, evidence$1), (Semigroup)JwtVerifier$.MODULE$.monoid(evidence$1)).$bar$plus$bar((Object)JwtVerifier$.MODULE$.delay((Function1 & Serializable)signedJwt -> {
            JwtAlgorithm jwtAlgorithm;
            Option option = signedJwt.header().algorithm();
            if (!(option instanceof Some) || !((jwtAlgorithm = (JwtAlgorithm)((Some)option).value()) instanceof JwtAlgorithm.JwtAsymmetricAlgorithm)) {
                throw new IllegalStateException();
            }
            JwtAlgorithm.JwtAsymmetricAlgorithm algorithm = (JwtAlgorithm.JwtAsymmetricAlgorithm)jwtAlgorithm;
            boolean verified = JwtUtils$.MODULE$.verify(signedJwt.jwt().encode().getBytes(StandardCharsets.UTF_8), signedJwt.signature(), key, this.jwtAsymmetricAlgorithm(algorithm));
            return package$.MODULE$.Either().cond(verified, (Function0 & Serializable)() -> {
                this.asymmetricVerifier$$anonfun$1$$anonfun$1();
                return BoxedUnit.UNIT;
            }, this::asymmetricVerifier$$anonfun$1$$anonfun$2);
        }, evidence$1));
    }

    public <F> Seq<JwtAlgorithm.JwtAsymmetricAlgorithm> asymmetricVerifier$default$2() {
        return JwtAlgorithm.JwtAsymmetricAlgorithm$.MODULE$.values();
    }

    public <F> JwtValidationOptions asymmetricVerifier$default$3() {
        return JwtValidationOptions$.MODULE$.default();
    }

    public <F> JwtVerifier<F> certPathVerifier(KeyStore keyStore, Seq<JwtAlgorithm.JwtAsymmetricAlgorithm> algorithms, JwtValidationOptions options, Function1<PKIXParameters, BoxedUnit> pkixParameters, Sync<F> evidence$1) {
        return JwtCertPath$.MODULE$.verifier(keyStore, (Function1 & Serializable)_$9 -> this.asymmetricVerifier((PublicKey)_$9, algorithms, options, evidence$1), pkixParameters, evidence$1);
    }

    public <F> Seq<JwtAlgorithm.JwtAsymmetricAlgorithm> certPathVerifier$default$2() {
        return JwtAlgorithm.JwtAsymmetricAlgorithm$.MODULE$.values();
    }

    public <F> JwtValidationOptions certPathVerifier$default$3() {
        return JwtValidationOptions$.MODULE$.default();
    }

    public <F> Function1<PKIXParameters, BoxedUnit> certPathVerifier$default$4() {
        return JwtCertPath$.MODULE$.defaultPkixParameters();
    }

    private JwtHmacAlgorithm jwtHmacAlgorithm(JwtAlgorithm.JwtHmacAlgorithm algorithm) {
        JwtAlgorithm.HS256$ hS256$;
        JwtAlgorithm.JwtHmacAlgorithm jwtHmacAlgorithm = algorithm;
        if (JwtAlgorithm.HS256$.MODULE$.equals(jwtHmacAlgorithm)) {
            hS256$ = JwtAlgorithm.HS256$.MODULE$;
        } else if (JwtAlgorithm.HS384$.MODULE$.equals(jwtHmacAlgorithm)) {
            hS256$ = JwtAlgorithm.HS384$.MODULE$;
        } else if (JwtAlgorithm.HS512$.MODULE$.equals(jwtHmacAlgorithm)) {
            hS256$ = JwtAlgorithm.HS512$.MODULE$;
        } else {
            throw new MatchError((Object)jwtHmacAlgorithm);
        }
        return (JwtHmacAlgorithm)hS256$;
    }

    private JwtAsymmetricAlgorithm jwtAsymmetricAlgorithm(JwtAlgorithm.JwtAsymmetricAlgorithm algorithm) {
        JwtAlgorithm.RS256$ rS256$;
        JwtAlgorithm.JwtAsymmetricAlgorithm jwtAsymmetricAlgorithm = algorithm;
        if (JwtAlgorithm.RS256$.MODULE$.equals(jwtAsymmetricAlgorithm)) {
            rS256$ = JwtAlgorithm.RS256$.MODULE$;
        } else if (JwtAlgorithm.RS384$.MODULE$.equals(jwtAsymmetricAlgorithm)) {
            rS256$ = JwtAlgorithm.RS384$.MODULE$;
        } else if (JwtAlgorithm.RS512$.MODULE$.equals(jwtAsymmetricAlgorithm)) {
            rS256$ = JwtAlgorithm.RS512$.MODULE$;
        } else if (JwtAlgorithm.ES256$.MODULE$.equals(jwtAsymmetricAlgorithm)) {
            rS256$ = JwtAlgorithm.ES256$.MODULE$;
        } else if (JwtAlgorithm.ES384$.MODULE$.equals(jwtAsymmetricAlgorithm)) {
            rS256$ = JwtAlgorithm.ES384$.MODULE$;
        } else if (JwtAlgorithm.ES512$.MODULE$.equals(jwtAsymmetricAlgorithm)) {
            rS256$ = JwtAlgorithm.ES512$.MODULE$;
        } else {
            throw new MatchError((Object)jwtAsymmetricAlgorithm);
        }
        return (JwtAsymmetricAlgorithm)rS256$;
    }

    private final void hmacVerifier$$anonfun$1$$anonfun$1() {
    }

    private final JwtValidationException.JwtInvalidSignatureException hmacVerifier$$anonfun$1$$anonfun$2() {
        return new JwtValidationException.JwtInvalidSignatureException();
    }

    private final void asymmetricVerifier$$anonfun$1$$anonfun$1() {
    }

    private final JwtValidationException.JwtInvalidSignatureException asymmetricVerifier$$anonfun$1$$anonfun$2() {
        return new JwtValidationException.JwtInvalidSignatureException();
    }
}

