/*
 * Decompiled with CFR 0.152.
 */
package de.lhns.jwt;

import cats.Functor;
import cats.Monad;
import cats.Monad$;
import cats.NotNull$;
import cats.data.EitherT;
import cats.effect.kernel.Clock;
import cats.effect.kernel.Sync;
import cats.kernel.Eq;
import cats.kernel.Monoid;
import cats.kernel.Semigroup;
import cats.syntax.EitherObjectOps$;
import cats.syntax.EitherSyntax;
import cats.syntax.package;
import de.lhns.jwt.Jwt;
import de.lhns.jwt.JwtAlgorithm;
import de.lhns.jwt.JwtValidationException;
import de.lhns.jwt.JwtValidationOptions;
import de.lhns.jwt.JwtVerifier;
import de.lhns.jwt.JwtVerifier$;
import de.lhns.jwt.SignedJwt;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Right;

public final class JwtVerifier$ {
    public static final JwtVerifier$ MODULE$ = new JwtVerifier$();

    public <F> Monoid<JwtVerifier<F>> monoid(Monad<F> evidence$1) {
        return new Monoid<JwtVerifier<F>>(evidence$1){
            public final Monad evidence$1$1;

            public double empty$mcD$sp() {
                return Monoid.empty$mcD$sp$((Monoid)this);
            }

            public float empty$mcF$sp() {
                return Monoid.empty$mcF$sp$((Monoid)this);
            }

            public int empty$mcI$sp() {
                return Monoid.empty$mcI$sp$((Monoid)this);
            }

            public long empty$mcJ$sp() {
                return Monoid.empty$mcJ$sp$((Monoid)this);
            }

            public boolean isEmpty(Object a, Eq ev) {
                return Monoid.isEmpty$((Monoid)this, (Object)a, (Eq)ev);
            }

            public boolean isEmpty$mcD$sp(double a, Eq<Object> ev) {
                return Monoid.isEmpty$mcD$sp$((Monoid)this, (double)a, ev);
            }

            public boolean isEmpty$mcF$sp(float a, Eq<Object> ev) {
                return Monoid.isEmpty$mcF$sp$((Monoid)this, (float)a, ev);
            }

            public boolean isEmpty$mcI$sp(int a, Eq<Object> ev) {
                return Monoid.isEmpty$mcI$sp$((Monoid)this, (int)a, ev);
            }

            public boolean isEmpty$mcJ$sp(long a, Eq<Object> ev) {
                return Monoid.isEmpty$mcJ$sp$((Monoid)this, (long)a, ev);
            }

            public Object combineN(Object a, int n) {
                return Monoid.combineN$((Monoid)this, (Object)a, (int)n);
            }

            public double combineN$mcD$sp(double a, int n) {
                return Monoid.combineN$mcD$sp$((Monoid)this, (double)a, (int)n);
            }

            public float combineN$mcF$sp(float a, int n) {
                return Monoid.combineN$mcF$sp$((Monoid)this, (float)a, (int)n);
            }

            public int combineN$mcI$sp(int a, int n) {
                return Monoid.combineN$mcI$sp$((Monoid)this, (int)a, (int)n);
            }

            public long combineN$mcJ$sp(long a, int n) {
                return Monoid.combineN$mcJ$sp$((Monoid)this, (long)a, (int)n);
            }

            public Object combineAll(IterableOnce as) {
                return Monoid.combineAll$((Monoid)this, (IterableOnce)as);
            }

            public double combineAll$mcD$sp(IterableOnce<Object> as) {
                return Monoid.combineAll$mcD$sp$((Monoid)this, as);
            }

            public float combineAll$mcF$sp(IterableOnce<Object> as) {
                return Monoid.combineAll$mcF$sp$((Monoid)this, as);
            }

            public int combineAll$mcI$sp(IterableOnce<Object> as) {
                return Monoid.combineAll$mcI$sp$((Monoid)this, as);
            }

            public long combineAll$mcJ$sp(IterableOnce<Object> as) {
                return Monoid.combineAll$mcJ$sp$((Monoid)this, as);
            }

            public Option<JwtVerifier<F>> combineAllOption(IterableOnce<JwtVerifier<F>> as) {
                return Monoid.combineAllOption$((Monoid)this, as);
            }

            public Monoid<JwtVerifier<F>> reverse() {
                return Monoid.reverse$((Monoid)this);
            }

            public Monoid<Object> reverse$mcD$sp() {
                return Monoid.reverse$mcD$sp$((Monoid)this);
            }

            public Monoid<Object> reverse$mcF$sp() {
                return Monoid.reverse$mcF$sp$((Monoid)this);
            }

            public Monoid<Object> reverse$mcI$sp() {
                return Monoid.reverse$mcI$sp$((Monoid)this);
            }

            public Monoid<Object> reverse$mcJ$sp() {
                return Monoid.reverse$mcJ$sp$((Monoid)this);
            }

            public double combine$mcD$sp(double x, double y) {
                return Semigroup.combine$mcD$sp$((Semigroup)this, (double)x, (double)y);
            }

            public float combine$mcF$sp(float x, float y) {
                return Semigroup.combine$mcF$sp$((Semigroup)this, (float)x, (float)y);
            }

            public int combine$mcI$sp(int x, int y) {
                return Semigroup.combine$mcI$sp$((Semigroup)this, (int)x, (int)y);
            }

            public long combine$mcJ$sp(long x, long y) {
                return Semigroup.combine$mcJ$sp$((Semigroup)this, (long)x, (long)y);
            }

            public Object repeatedCombineN(Object a, int n) {
                return Semigroup.repeatedCombineN$((Semigroup)this, (Object)a, (int)n);
            }

            public double repeatedCombineN$mcD$sp(double a, int n) {
                return Semigroup.repeatedCombineN$mcD$sp$((Semigroup)this, (double)a, (int)n);
            }

            public float repeatedCombineN$mcF$sp(float a, int n) {
                return Semigroup.repeatedCombineN$mcF$sp$((Semigroup)this, (float)a, (int)n);
            }

            public int repeatedCombineN$mcI$sp(int a, int n) {
                return Semigroup.repeatedCombineN$mcI$sp$((Semigroup)this, (int)a, (int)n);
            }

            public long repeatedCombineN$mcJ$sp(long a, int n) {
                return Semigroup.repeatedCombineN$mcJ$sp$((Semigroup)this, (long)a, (int)n);
            }

            public Semigroup intercalate(Object middle) {
                return Semigroup.intercalate$((Semigroup)this, (Object)middle);
            }

            public Semigroup<Object> intercalate$mcD$sp(double middle) {
                return Semigroup.intercalate$mcD$sp$((Semigroup)this, (double)middle);
            }

            public Semigroup<Object> intercalate$mcF$sp(float middle) {
                return Semigroup.intercalate$mcF$sp$((Semigroup)this, (float)middle);
            }

            public Semigroup<Object> intercalate$mcI$sp(int middle) {
                return Semigroup.intercalate$mcI$sp$((Semigroup)this, (int)middle);
            }

            public Semigroup<Object> intercalate$mcJ$sp(long middle) {
                return Semigroup.intercalate$mcJ$sp$((Semigroup)this, (long)middle);
            }

            public JwtVerifier<F> empty() {
                return new JwtVerifier<F>(this){
                    private final /* synthetic */ anon.1 $outer;

                    public F verify(SignedJwt signedJwt) {
                        return (F)Monad$.MODULE$.apply(this.$outer.evidence$1$1).pure((Object)new Right((Object)BoxedUnit.UNIT));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
            }

            public JwtVerifier<F> combine(JwtVerifier<F> x, JwtVerifier<F> y) {
                return new JwtVerifier<F>(this, x, y){
                    private final /* synthetic */ anon.1 $outer;
                    private final JwtVerifier x$2;
                    private final JwtVerifier y$1;

                    public F verify(SignedJwt signedJwt) {
                        return (F)new EitherT(this.x$2.verify(signedJwt)).flatMapF((Function1 & Serializable)x$1 -> $this.y$1.verify(signedJwt), this.$outer.evidence$1$1).value();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.x$2 = x$2;
                        this.y$1 = y$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$verify$1(de.lhns.jwt.JwtVerifier$$anon$1$$anon$3 de.lhns.jwt.SignedJwt scala.runtime.BoxedUnit )}, serializedLambda);
                    }
                };
            }
            {
                this.evidence$1$1 = evidence$1$1;
                Semigroup.$init$((Semigroup)this);
                Monoid.$init$((Monoid)this);
            }
        };
    }

    public <F> JwtVerifier<F> apply(Function1<SignedJwt, F> verifier, Monad<F> evidence$2) {
        return new JwtVerifier<F>(verifier){
            private final Function1 verifier$1;

            public F verify(SignedJwt signedJwt) {
                return (F)this.verifier$1.apply((Object)signedJwt);
            }
            {
                this.verifier$1 = verifier$1;
            }
        };
    }

    public <F> JwtVerifier<F> delay(Function1<SignedJwt, Either<Throwable, BoxedUnit>> verifier, Sync<F> evidence$3) {
        return new JwtVerifier<F>(evidence$3, verifier){
            private final Sync evidence$3$1;
            private final Function1 verifier$2;

            public F verify(SignedJwt signedJwt) {
                return (F)cats.effect.package$.MODULE$.Sync().apply(this.evidence$3$1).delay((Function0 & Serializable)() -> (Either)$this.verifier$2.apply((Object)signedJwt));
            }
            {
                this.evidence$3$1 = evidence$3$1;
                this.verifier$2 = verifier$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$verify$2(de.lhns.jwt.JwtVerifier$$anon$5 de.lhns.jwt.SignedJwt )}, serializedLambda);
            }
        };
    }

    public <F> JwtVerifier<F> basicVerifier(Seq<JwtAlgorithm> algorithms, JwtValidationOptions options, Monad<F> evidence$4, Clock<F> evidence$5) {
        return this.apply((Function1 & Serializable)signedJwt -> package.all$.MODULE$.toFunctorOps(((Clock)Predef$.MODULE$.implicitly((Object)evidence$5)).realTime(), (Functor)evidence$4).map((Function1 & Serializable)now -> EitherSyntax.CatchOnlyPartiallyApplied$.MODULE$.apply$extension(EitherObjectOps$.MODULE$.catchOnly$extension(package.all$.MODULE$.catsSyntaxEitherObject(package$.MODULE$.Either())), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            MODULE$.validateRequired(signedJwt.payload(), options);
            MODULE$.validateTiming(signedJwt.payload(), Instant.ofEpochMilli(now.toMillis()), options);
            MODULE$.validateAlgorithm(signedJwt.header(), algorithms);
        }, ClassTag$.MODULE$.apply(JwtValidationException.class), NotNull$.MODULE$.catsNotNullForA())), evidence$4);
    }

    private void validateRequired(Jwt.JwtPayload payload, JwtValidationOptions options) {
        if (options.requireIssuer() && payload.issuer().isEmpty()) {
            throw new JwtValidationException.JwtEmptyIssuerException();
        }
        if (options.requireSubject() && payload.subject().isEmpty()) {
            throw new JwtValidationException.JwtEmptySubjectException();
        }
        if (options.requireAudience() && payload.audience().isEmpty()) {
            throw new JwtValidationException.JwtEmptyAudienceException();
        }
        if (options.requireExpiration() && payload.expiration().isEmpty()) {
            throw new JwtValidationException.JwtEmptyExpirationException();
        }
        if (options.requireNotBefore() && payload.notBefore().isEmpty()) {
            throw new JwtValidationException.JwtEmptyNotBeforeException();
        }
        if (options.requireIssuedAt() && payload.issuedAt().isEmpty()) {
            throw new JwtValidationException.JwtEmptyIssuedAtException();
        }
        if (options.requireJwtId() && payload.jwtId().isEmpty()) {
            throw new JwtValidationException.JwtEmptyJwtIdException();
        }
    }

    private void validateTiming(Jwt.JwtPayload payload, Instant now, JwtValidationOptions options) {
        long leewayMillis = options.leeway().toMillis();
        if (options.validateExpiration()) {
            payload.expiration().filterNot((Function1 & Serializable)expiration -> BoxesRunTime.boxToBoolean((boolean)now.isBefore(expiration.plusMillis(leewayMillis)))).foreach((Function1 & Serializable)expiration -> {
                throw new JwtValidationException.JwtExpirationException((Instant)expiration);
            });
        }
        if (options.validateNotBefore()) {
            payload.notBefore().filter((Function1 & Serializable)notBefore -> BoxesRunTime.boxToBoolean((boolean)now.isAfter(notBefore.minusMillis(leewayMillis)))).foreach((Function1 & Serializable)notBefore -> {
                throw new JwtValidationException.JwtNotBeforeException((Instant)notBefore);
            });
            return;
        }
    }

    private void validateAlgorithm(Jwt.JwtHeader header, Seq<JwtAlgorithm> algorithms) {
        if (!header.algorithm().exists((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)algorithms.contains(elem)))) {
            throw new JwtValidationException.JwtInvalidAlgorithmException(header.algorithm());
        }
    }

    private JwtVerifier$() {
    }
}

