/*
 * Decompiled with CFR 0.152.
 */
package de.lhns.jwt;

import cats.Monad;
import cats.Monad$;
import cats.NotNull$;
import cats.syntax.EitherObjectOps$;
import cats.syntax.EitherOps$;
import cats.syntax.EitherSyntax;
import cats.syntax.package;
import de.lhns.jwt.Jwt;
import de.lhns.jwt.JwtSigner;
import de.lhns.jwt.JwtSigner$;
import de.lhns.jwt.JwtVerifier;
import de.lhns.jwt.JwtVerifier$;
import de.lhns.jwt.SignedJwt;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class JwtCertPath$ {
    public static final JwtCertPath$ MODULE$ = new JwtCertPath$();
    private static final Function1<PKIXParameters, BoxedUnit> defaultPkixParameters = (Function1 & Serializable)x$3 -> {
        x$3.setRevocationEnabled(false);
        return BoxedUnit.UNIT;
    };

    public <F> JwtVerifier<F> verifier(KeyStore keyStore, Function1<PublicKey, JwtVerifier<F>> verifier, Function1<PKIXParameters, BoxedUnit> pkixParameters, Monad<F> evidence$1) {
        return JwtVerifier$.MODULE$.apply((Function1 & Serializable)signedJwt -> {
            Either either;
            boolean bl = false;
            Some some = null;
            Option option = signedJwt.header().x509CertificateChain().map((Function1 & Serializable)x$1 -> MODULE$.validateCertPath((CertPath)x$1, keyStore, pkixParameters));
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                Either either2 = (Either)some.value();
                if (either2 instanceof Right) {
                    Right right = (Right)either2;
                    PKIXCertPathValidatorResult result = (PKIXCertPathValidatorResult)right.value();
                    return ((JwtVerifier)verifier.apply((Object)result.getPublicKey())).verify((SignedJwt)signedJwt);
                }
            }
            if (bl && (either = (Either)some.value()) instanceof Left) {
                Left left = (Left)either;
                CertPathValidatorException throwable = (CertPathValidatorException)left.value();
                return Monad$.MODULE$.apply(evidence$1).pure((Object)new Left((Object)throwable));
            }
            if (None$.MODULE$.equals(option)) {
                return Monad$.MODULE$.apply(evidence$1).pure((Object)new Left((Object)new IllegalArgumentException("x5c claim required for cert validation")));
            }
            throw new MatchError((Object)option);
        }, evidence$1);
    }

    public <F> Function1<PKIXParameters, BoxedUnit> verifier$default$3() {
        return this.defaultPkixParameters();
    }

    public <F> JwtSigner<F> signer(CertPath certPath, JwtSigner<F> signer) {
        return JwtSigner$.MODULE$.apply((Function1 & Serializable)jwt -> signer.sign(jwt.modifyHeader((Function1<Jwt.JwtHeader, Jwt.JwtHeader>)(Function1 & Serializable)x$2 -> (Jwt.JwtHeader)x$2.withX509CertificateChain((Option<CertPath>)new Some((Object)certPath)))));
    }

    public Function1<PKIXParameters, BoxedUnit> defaultPkixParameters() {
        return defaultPkixParameters;
    }

    private Either<CertPathValidatorException, PKIXCertPathValidatorResult> validateCertPath(CertPath certPath, KeyStore keyStore, Function1<PKIXParameters, BoxedUnit> pkixParameters) {
        CertPathValidator validator = CertPathValidator.getInstance("PKIX");
        return EitherOps$.MODULE$.leftMap$extension(package.all$.MODULE$.catsSyntaxEither(EitherSyntax.CatchOnlyPartiallyApplied$.MODULE$.apply$extension(EitherObjectOps$.MODULE$.catchOnly$extension(package.all$.MODULE$.catsSyntaxEitherObject(package$.MODULE$.Either())), (Function0 & Serializable)() -> new PKIXParameters(keyStore), ClassTag$.MODULE$.apply(InvalidAlgorithmParameterException.class), NotNull$.MODULE$.catsNotNullForA())), (Function1 & Serializable)x$4 -> new CertPathValidatorException((Throwable)x$4)).flatMap((Function1 & Serializable)params -> {
            pkixParameters.apply(params);
            return EitherSyntax.CatchOnlyPartiallyApplied$.MODULE$.apply$extension(EitherObjectOps$.MODULE$.catchOnly$extension(package.all$.MODULE$.catsSyntaxEitherObject(package$.MODULE$.Either())), (Function0 & Serializable)() -> (PKIXCertPathValidatorResult)validator.validate(certPath, (CertPathParameters)params), ClassTag$.MODULE$.apply(CertPathValidatorException.class), NotNull$.MODULE$.catsNotNullForA());
        });
    }

    private Function1<PKIXParameters, BoxedUnit> validateCertPath$default$3() {
        return this.defaultPkixParameters();
    }

    private JwtCertPath$() {
    }
}

