/*
 * Decompiled with CFR 0.152.
 */
package de.lhns.jwt;

import de.lhns.jwt.JwtAlgorithm;
import de.lhns.jwt.JwtAlgorithm$;
import java.time.Instant;
import java.time.ZoneId;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005-c\u0001\u0002\u0012$\u0001)B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\")a\t\u0001C\u0001\u000f\")a\t\u0001C\u0001\u0019\u001e)aj\tE\u0001\u001f\u001a)!e\tE\u0001!\")aI\u0002C\u0001;\u001a!aL\u0002\u0001`\u0011!\u0001\u0007B!A!\u0002\u0013\t\u0007\"\u0002$\t\t\u00039g\u0001B6\u0007\u00011DQAR\u0006\u0005\u000254Aa\u001c\u0004\u0001a\")a)\u0004C\u0001c\u001a!1O\u0002\u0001u\u0011\u00151u\u0002\"\u0001v\r\u00119h\u0001\u0001=\t\u000b\u0019\u000bB\u0011A=\u0007\tm4\u0001\u0001 \u0005\u0006\rN!\t! \u0004\u0006\u007f\u001a\u0001\u0011\u0011\u0001\u0005\u0007\rV!\t!a\u0001\u0007\r\u0005\u001da\u0001AA\u0005\u0011\u00191u\u0003\"\u0001\u0002\f\u00191\u0011q\u0002\u0004\u0001\u0003#A!\"a\u0005\u001a\u0005\u0003\u0005\u000b\u0011BA\u000b\u0011\u00191\u0015\u0004\"\u0001\u0002\"\u00191\u0011q\u0005\u0004\u0001\u0003SA!\"a\u000b\u001d\u0005\u0003\u0005\u000b\u0011BA\u000b\u0011\u00191E\u0004\"\u0001\u0002.\u00191\u00111\u0007\u0004\u0001\u0003kAaAR\u0010\u0005\u0002\u0005]\u0002\"CA\u001e\r\u0005\u0005I\u0011BA\u001f\u0005YQu\u000f\u001e,bY&$\u0017\r^5p]\u0016C8-\u001a9uS>t'B\u0001\u0013&\u0003\rQw\u000f\u001e\u0006\u0003M\u001d\nA\u0001\u001c5og*\t\u0001&\u0001\u0002eK\u000e\u00011C\u0001\u0001,!\tacG\u0004\u0002.g9\u0011a&M\u0007\u0002_)\u0011\u0001'K\u0001\u0007yI|w\u000e\u001e \n\u0003I\nQa]2bY\u0006L!\u0001N\u001b\u0002\u000fA\f7m[1hK*\t!'\u0003\u00028q\t\u0001\"+\u001e8uS6,W\t_2faRLwN\u001c\u0006\u0003iU\nq!\\3tg\u0006<W\r\u0005\u0002<\u007f9\u0011A(\u0010\t\u0003]UJ!AP\u001b\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0015I\u0001\u0004TiJLgn\u001a\u0006\u0003}U\nQaY1vg\u0016\u0004\"\u0001\f#\n\u0005\u0015C$!\u0003+ie><\u0018M\u00197f\u0003\u0019a\u0014N\\5u}Q\u0019\u0001JS&\u0011\u0005%\u0003Q\"A\u0012\t\u000be\u001a\u0001\u0019\u0001\u001e\t\u000b\t\u001b\u0001\u0019A\"\u0015\u0005!k\u0005\"B\u001d\u0005\u0001\u0004Q\u0014A\u0006&xiZ\u000bG.\u001b3bi&|g.\u0012=dKB$\u0018n\u001c8\u0011\u0005%31c\u0001\u0004R+B\u0011!kU\u0007\u0002k%\u0011A+\u000e\u0002\u0007\u0003:L(+\u001a4\u0011\u0005Y[V\"A,\u000b\u0005aK\u0016AA5p\u0015\u0005Q\u0016\u0001\u00026bm\u0006L!\u0001X,\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0003=\u0013ADS<u\u0013:4\u0018\r\\5e\u00032<wN]5uQ6,\u0005pY3qi&|gn\u0005\u0002\t\u0011\u0006I\u0011\r\\4pe&$\b.\u001c\t\u0004%\n$\u0017BA26\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011*Z\u0005\u0003M\u000e\u0012ABS<u\u00032<wN]5uQ6$\"\u0001\u001b6\u0011\u0005%DQ\"\u0001\u0004\t\u000b\u0001T\u0001\u0019A1\u0003/);H/R7qifL5o];fe\u0016C8-\u001a9uS>t7CA\u0006I)\u0005q\u0007CA5\f\u0005aQu\u000f^#naRL8+\u001e2kK\u000e$X\t_2faRLwN\\\n\u0003\u001b!#\u0012A\u001d\t\u0003S6\u0011\u0011DS<u\u000b6\u0004H/_!vI&,gnY3Fq\u000e,\u0007\u000f^5p]N\u0011q\u0002\u0013\u000b\u0002mB\u0011\u0011n\u0004\u0002\u001c\u0015^$X)\u001c9us\u0016C\b/\u001b:bi&|g.\u0012=dKB$\u0018n\u001c8\u0014\u0005EAE#\u0001>\u0011\u0005%\f\"A\u0007&xi\u0016k\u0007\u000f^=O_R\u0014UMZ8sK\u0016C8-\u001a9uS>t7CA\nI)\u0005q\bCA5\u0014\u0005eQu\u000f^#naRL\u0018j]:vK\u0012\fE/\u0012=dKB$\u0018n\u001c8\u0014\u0005UAECAA\u0003!\tIWC\u0001\fKoR,U\u000e\u001d;z\u0015^$\u0018\nZ#yG\u0016\u0004H/[8o'\t9\u0002\n\u0006\u0002\u0002\u000eA\u0011\u0011n\u0006\u0002\u0017\u0015^$X\t\u001f9je\u0006$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]N\u0011\u0011\u0004S\u0001\u000bKb\u0004\u0018N]1uS>t\u0007\u0003BA\f\u0003;i!!!\u0007\u000b\u0007\u0005m\u0011,\u0001\u0003uS6,\u0017\u0002BA\u0010\u00033\u0011q!\u00138ti\u0006tG\u000f\u0006\u0003\u0002$\u0005\u0015\u0002CA5\u001a\u0011\u001d\t\u0019b\u0007a\u0001\u0003+\u0011QCS<u\u001d>$()\u001a4pe\u0016,\u0005pY3qi&|gn\u0005\u0002\u001d\u0011\u0006Ian\u001c;CK\u001a|'/\u001a\u000b\u0005\u0003_\t\t\u0004\u0005\u0002j9!9\u00111\u0006\u0010A\u0002\u0005U!\u0001\b&xi&sg/\u00197jINKwM\\1ukJ,W\t_2faRLwN\\\n\u0003?!#\"!!\u000f\u0011\u0005%|\u0012\u0001D<sSR,'+\u001a9mC\u000e,GCAA !\u0011\t\t%a\u0012\u000e\u0005\u0005\r#bAA#3\u0006!A.\u00198h\u0013\u0011\tI%a\u0011\u0003\r=\u0013'.Z2u\u0001")
public class JwtValidationException
extends RuntimeException {
    public JwtValidationException(String message, Throwable cause) {
        super(message, cause);
    }

    public JwtValidationException(String message) {
        this(message, null);
    }

    public static class JwtEmptyAudienceException
    extends JwtValidationException {
        public JwtEmptyAudienceException() {
            super("The token does not contain an audience.");
        }
    }

    public static class JwtEmptyExpirationException
    extends JwtValidationException {
        public JwtEmptyExpirationException() {
            super("The token does not contain an expiration.");
        }
    }

    public static class JwtEmptyIssuedAtException
    extends JwtValidationException {
        public JwtEmptyIssuedAtException() {
            super("The token does not contain when it was issued.");
        }
    }

    public static class JwtEmptyIssuerException
    extends JwtValidationException {
        public JwtEmptyIssuerException() {
            super("The token does not contain an issuer.");
        }
    }

    public static class JwtEmptyJwtIdException
    extends JwtValidationException {
        public JwtEmptyJwtIdException() {
            super("The token does not contain a jwt id.");
        }
    }

    public static class JwtEmptyNotBeforeException
    extends JwtValidationException {
        public JwtEmptyNotBeforeException() {
            super("The token does not contain when it will be valid.");
        }
    }

    public static class JwtEmptySubjectException
    extends JwtValidationException {
        public JwtEmptySubjectException() {
            super("The token does not contain a subject.");
        }
    }

    public static class JwtExpirationException
    extends JwtValidationException {
        public JwtExpirationException(Instant expiration) {
            super(new StringBuilder(27).append("The token is expired since ").append(expiration.atZone(ZoneId.systemDefault())).toString());
        }
    }

    public static class JwtInvalidAlgorithmException
    extends JwtValidationException {
        public JwtInvalidAlgorithmException(Option<JwtAlgorithm> algorithm) {
            super(new StringBuilder(36).append("The token has an invalid algorithm: ").append(JwtAlgorithm$.MODULE$.toString(algorithm)).toString());
        }
    }

    public static class JwtInvalidSignatureException
    extends JwtValidationException {
        public JwtInvalidSignatureException() {
            super("The token signature is not valid.");
        }
    }

    public static class JwtNotBeforeException
    extends JwtValidationException {
        public JwtNotBeforeException(Instant notBefore) {
            super(new StringBuilder(35).append("The token will only be valid after ").append(notBefore.atZone(ZoneId.systemDefault())).toString());
        }
    }
}

