/*
 * Decompiled with CFR 0.152.
 */
package de.lhns.jwt;

import cats.Functor;
import cats.Invariant$;
import cats.Monad;
import cats.syntax.package;
import de.lhns.jwt.Jwt;
import de.lhns.jwt.JwtVerifier;
import de.lhns.jwt.SignedJwt$;
import de.lhns.jwt.package$;
import io.circe.Codec;
import java.io.Serializable;
import scala.Function1;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class SignedJwt
implements Product,
Serializable {
    private final Jwt jwt;
    private final byte[] signature;

    public static SignedJwt apply(Jwt jwt, byte[] byArray) {
        return SignedJwt$.MODULE$.apply(jwt, byArray);
    }

    public static SignedJwt apply(Jwt.JwtHeader jwtHeader, Jwt.JwtPayload jwtPayload, byte[] byArray) {
        return SignedJwt$.MODULE$.apply(jwtHeader, jwtPayload, byArray);
    }

    public static Codec<SignedJwt> codec() {
        return SignedJwt$.MODULE$.codec();
    }

    public static Either<Throwable, SignedJwt> decode(String string) {
        return SignedJwt$.MODULE$.decode(string);
    }

    public static Either<Throwable, SignedJwt> decodeComponents(String string, String string2, String string3) {
        return SignedJwt$.MODULE$.decodeComponents(string, string2, string3);
    }

    public static SignedJwt fromProduct(Product product) {
        return SignedJwt$.MODULE$.fromProduct(product);
    }

    public static SignedJwt unapply(SignedJwt signedJwt) {
        return SignedJwt$.MODULE$.unapply(signedJwt);
    }

    public SignedJwt(Jwt jwt, byte[] signature) {
        this.jwt = jwt;
        this.signature = signature;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof SignedJwt)) return false;
        SignedJwt signedJwt = (SignedJwt)object;
        Jwt jwt = this.jwt();
        Jwt jwt2 = signedJwt.jwt();
        if (jwt == null) {
            if (jwt2 != null) {
                return false;
            }
        } else if (!((Object)jwt).equals(jwt2)) return false;
        if (this.signature() != signedJwt.signature()) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof SignedJwt;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "SignedJwt";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "jwt";
        }
        if (1 == n2) {
            return "signature";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Jwt jwt() {
        return this.jwt;
    }

    public byte[] signature() {
        return this.signature;
    }

    public Jwt.JwtHeader header() {
        return this.jwt().header();
    }

    public Jwt.JwtPayload payload() {
        return this.jwt().payload();
    }

    private SignedJwt copy(Jwt jwt, byte[] signature) {
        throw new UnsupportedOperationException();
    }

    public SignedJwt copy(Jwt.JwtHeader header, Jwt.JwtPayload payload, byte[] signature) {
        return SignedJwt$.MODULE$.apply(header, payload, signature);
    }

    public Jwt.JwtHeader copy$default$1() {
        return this.jwt().header();
    }

    public Jwt.JwtPayload copy$default$2() {
        return this.jwt().payload();
    }

    public byte[] copy$default$3() {
        return this.signature();
    }

    public SignedJwt withHeader(Jwt.JwtHeader header) {
        return this.copy(header, this.copy$default$2(), this.copy$default$3());
    }

    public SignedJwt withPayload(Jwt.JwtPayload payload) {
        return this.copy(this.copy$default$1(), payload, this.copy$default$3());
    }

    public SignedJwt withSignature(byte[] signature) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), signature);
    }

    public SignedJwt modifyHeader(Function1<Jwt.JwtHeader, Jwt.JwtHeader> f) {
        return this.withHeader((Jwt.JwtHeader)f.apply((Object)this.header()));
    }

    public SignedJwt modifyPayload(Function1<Jwt.JwtPayload, Jwt.JwtPayload> f) {
        return this.withPayload((Jwt.JwtPayload)f.apply((Object)this.payload()));
    }

    public SignedJwt modifySignature(Function1<byte[], byte[]> f) {
        return this.withSignature((byte[])f.apply((Object)this.signature()));
    }

    public SignedJwt reencode() {
        return this.copy(this.header().reencode(), this.payload().reencode(), this.copy$default$3());
    }

    public String encode() {
        return new StringBuilder(1).append(this.jwt().encode()).append(".").append(package$.MODULE$.encodeBase64Url(this.signature())).toString();
    }

    public <F> Object verify(JwtVerifier<F> jwtVerifier, Monad<F> evidence$1) {
        return package.all$.MODULE$.toFunctorOps(jwtVerifier.verify(this), evidence$1).map((Function1 & Serializable)_$2 -> (Either)package.all$.MODULE$.toFunctorOps(_$2, (Functor)Invariant$.MODULE$.catsMonadErrorForEither()).as((Object)this.jwt()));
    }

    public Jwt _1() {
        return this.jwt();
    }

    public byte[] _2() {
        return this.signature();
    }
}

