/*
 * Decompiled with CFR 0.152.
 */
package de.lhns.jwt;

import cats.syntax.EitherOps$;
import cats.syntax.package;
import de.lhns.jwt.Jwt$;
import de.lhns.jwt.Jwt$JwtHeader$;
import de.lhns.jwt.Jwt$JwtPayload$;
import de.lhns.jwt.JwtAlgorithm;
import de.lhns.jwt.JwtAlgorithm$;
import de.lhns.jwt.JwtSigner;
import de.lhns.jwt.package$;
import io.circe.Codec;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.syntax.package;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertPath;
import java.security.cert.CertificateFactory;
import java.time.Instant;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.ListMap;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class Jwt
implements Product,
Serializable {
    private final JwtHeader header;
    private final JwtPayload payload;

    public static Jwt apply(JwtHeader jwtHeader, JwtPayload jwtPayload) {
        return Jwt$.MODULE$.apply(jwtHeader, jwtPayload);
    }

    public static Codec<Jwt> codec() {
        return Jwt$.MODULE$.codec();
    }

    public static Either<Throwable, Jwt> decode(String string) {
        return Jwt$.MODULE$.decode(string);
    }

    public static Either<Throwable, Jwt> decodeComponents(String string, String string2) {
        return Jwt$.MODULE$.decodeComponents(string, string2);
    }

    public static Jwt fromProduct(Product product) {
        return Jwt$.MODULE$.fromProduct(product);
    }

    public static Jwt unapply(Jwt jwt) {
        return Jwt$.MODULE$.unapply(jwt);
    }

    public static JwtHeader $lessinit$greater$default$1() {
        return Jwt$.MODULE$.$lessinit$greater$default$1();
    }

    public static JwtPayload $lessinit$greater$default$2() {
        return Jwt$.MODULE$.$lessinit$greater$default$2();
    }

    public Jwt(JwtHeader header, JwtPayload payload) {
        this.header = header;
        this.payload = payload;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Jwt)) return false;
        Jwt jwt = (Jwt)object;
        JwtHeader jwtHeader = this.header();
        JwtHeader jwtHeader2 = jwt.header();
        if (jwtHeader == null) {
            if (jwtHeader2 != null) {
                return false;
            }
        } else if (!((Object)jwtHeader).equals(jwtHeader2)) return false;
        JwtPayload jwtPayload = this.payload();
        JwtPayload jwtPayload2 = jwt.payload();
        if (jwtPayload == null) {
            if (jwtPayload2 == null) return true;
            return false;
        } else {
            if (!((Object)jwtPayload).equals(jwtPayload2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Jwt;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "Jwt";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "header";
        }
        if (1 == n2) {
            return "payload";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public JwtHeader header() {
        return this.header;
    }

    public JwtPayload payload() {
        return this.payload;
    }

    public Jwt withHeader(JwtHeader header) {
        return this.copy(header, this.copy$default$2());
    }

    public Jwt withPayload(JwtPayload payload) {
        return this.copy(this.copy$default$1(), payload);
    }

    public Jwt modifyHeader(Function1<JwtHeader, JwtHeader> f) {
        return this.withHeader((JwtHeader)f.apply((Object)this.header()));
    }

    public Jwt modifyPayload(Function1<JwtPayload, JwtPayload> f) {
        return this.withPayload((JwtPayload)f.apply((Object)this.payload()));
    }

    public Jwt reencode() {
        return this.copy(this.header().reencode(), this.payload().reencode());
    }

    public String encode() {
        return new StringBuilder(1).append(this.header().encode()).append(".").append(this.payload().encode()).toString();
    }

    public <F> Object sign(JwtSigner<F> jwtSigner) {
        return jwtSigner.sign(this);
    }

    public Jwt copy(JwtHeader header, JwtPayload payload) {
        return new Jwt(header, payload);
    }

    public JwtHeader copy$default$1() {
        return this.header();
    }

    public JwtPayload copy$default$2() {
        return this.payload();
    }

    public JwtHeader _1() {
        return this.header();
    }

    public JwtPayload _2() {
        return this.payload();
    }

    public static interface JwtComponent {
        public ListMap<String, Json> claims();

        public JwtComponent withClaims(ListMap<String, Json> var1);

        public static JwtComponent modifyClaims$(JwtComponent $this, Function1 f) {
            return $this.modifyClaims((Function1<ListMap<String, Json>, ListMap<String, Json>>)f);
        }

        default public JwtComponent modifyClaims(Function1<ListMap<String, Json>, ListMap<String, Json>> f) {
            return this.withClaims((ListMap<String, Json>)((ListMap)f.apply(this.claims())));
        }

        public static Option claim$(JwtComponent $this, String name, Decoder evidence$1) {
            return $this.claim(name, evidence$1);
        }

        default public <A> Option<A> claim(String name, Decoder<A> evidence$1) {
            return this.claims().get((Object)name).map((Function1 & Serializable)_$2 -> _$2.as(evidence$1).toTry((.less.colon.less)$less$colon$less$.MODULE$.refl()).get());
        }

        public static JwtComponent withClaim$(JwtComponent $this, String name, Option valueOption, Encoder evidence$1) {
            return $this.withClaim(name, valueOption, evidence$1);
        }

        default public <A> JwtComponent withClaim(String name, Option<A> valueOption, Encoder<A> evidence$1) {
            return this.withClaims((ListMap<String, Json>)((ListMap)valueOption.fold(() -> this.withClaim$$anonfun$1(name), (Function1 & Serializable)value -> {
                Object object = io.circe.syntax.package$.MODULE$.EncoderOps(value);
                return this.claims().updated((Object)name, (Object)package.EncoderOps$.MODULE$.asJson$extension(object, evidence$1));
            })));
        }

        public JwtComponent reencode();

        public String encode();

        private ListMap withClaim$$anonfun$1(String name$1) {
            return (ListMap)this.claims().filterNot((Function1 & Serializable)_$3 -> {
                Object object = _$3._1();
                String string = name$1;
                return !(object != null ? !object.equals(string) : string != null);
            });
        }
    }

    public static class JwtHeader
    implements JwtComponent,
    JwtHeaderClaims,
    Product,
    Serializable {
        private Option typOption$lzy1;
        private boolean typOptionbitmap$1;
        private Option algorithm$lzy1;
        private boolean algorithmbitmap$1;
        private Option contentType$lzy1;
        private boolean contentTypebitmap$1;
        private Option keyId$lzy1;
        private boolean keyIdbitmap$1;
        private Option x509Url$lzy1;
        private boolean x509Urlbitmap$1;
        private Option x509CertificateChain$lzy1;
        private boolean x509CertificateChainbitmap$1;
        private Option x509CertificateSha1Thumbprint$lzy1;
        private boolean x509CertificateSha1Thumbprintbitmap$1;
        private Option x509CertificateSha256Thumbprint$lzy1;
        private boolean x509CertificateSha256Thumbprintbitmap$1;
        private final ListMap claims;
        private final Option encoded;

        public static JwtHeader apply(ListMap<String, Json> listMap) {
            return Jwt$JwtHeader$.MODULE$.apply(listMap);
        }

        public static Codec<JwtHeader> codec() {
            return Jwt$JwtHeader$.MODULE$.codec();
        }

        public static JwtHeader fromProduct(Product product) {
            return Jwt$JwtHeader$.MODULE$.fromProduct(product);
        }

        public static JwtHeader unapply(JwtHeader jwtHeader) {
            return Jwt$JwtHeader$.MODULE$.unapply(jwtHeader);
        }

        public static ListMap<String, Json> apply$default$1() {
            return Jwt$JwtHeader$.MODULE$.apply$default$1();
        }

        public JwtHeader(ListMap<String, Json> claims, Option<String> encoded) {
            this.claims = claims;
            this.encoded = encoded;
            JwtHeaderClaims.$init$(this);
        }

        public Option typOption() {
            if (!this.typOptionbitmap$1) {
                this.typOption$lzy1 = JwtHeaderClaims.typOption$(this);
                this.typOptionbitmap$1 = true;
            }
            return this.typOption$lzy1;
        }

        public Option algorithm() {
            if (!this.algorithmbitmap$1) {
                this.algorithm$lzy1 = JwtHeaderClaims.algorithm$(this);
                this.algorithmbitmap$1 = true;
            }
            return this.algorithm$lzy1;
        }

        public Option contentType() {
            if (!this.contentTypebitmap$1) {
                this.contentType$lzy1 = JwtHeaderClaims.contentType$(this);
                this.contentTypebitmap$1 = true;
            }
            return this.contentType$lzy1;
        }

        public Option keyId() {
            if (!this.keyIdbitmap$1) {
                this.keyId$lzy1 = JwtHeaderClaims.keyId$(this);
                this.keyIdbitmap$1 = true;
            }
            return this.keyId$lzy1;
        }

        public Option x509Url() {
            if (!this.x509Urlbitmap$1) {
                this.x509Url$lzy1 = JwtHeaderClaims.x509Url$(this);
                this.x509Urlbitmap$1 = true;
            }
            return this.x509Url$lzy1;
        }

        public Option x509CertificateChain() {
            if (!this.x509CertificateChainbitmap$1) {
                this.x509CertificateChain$lzy1 = JwtHeaderClaims.x509CertificateChain$(this);
                this.x509CertificateChainbitmap$1 = true;
            }
            return this.x509CertificateChain$lzy1;
        }

        public Option x509CertificateSha1Thumbprint() {
            if (!this.x509CertificateSha1Thumbprintbitmap$1) {
                this.x509CertificateSha1Thumbprint$lzy1 = JwtHeaderClaims.x509CertificateSha1Thumbprint$(this);
                this.x509CertificateSha1Thumbprintbitmap$1 = true;
            }
            return this.x509CertificateSha1Thumbprint$lzy1;
        }

        public Option x509CertificateSha256Thumbprint() {
            if (!this.x509CertificateSha256Thumbprintbitmap$1) {
                this.x509CertificateSha256Thumbprint$lzy1 = JwtHeaderClaims.x509CertificateSha256Thumbprint$(this);
                this.x509CertificateSha256Thumbprintbitmap$1 = true;
            }
            return this.x509CertificateSha256Thumbprint$lzy1;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof JwtHeader)) return false;
            JwtHeader jwtHeader = (JwtHeader)object;
            ListMap<String, Json> listMap = this.claims();
            ListMap<String, Json> listMap2 = jwtHeader.claims();
            if (listMap == null) {
                if (listMap2 != null) {
                    return false;
                }
            } else if (!listMap.equals(listMap2)) return false;
            Option<String> option = this.encoded();
            Option<String> option2 = jwtHeader.encoded();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!jwtHeader.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof JwtHeader;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "JwtHeader";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "claims";
            }
            if (1 == n2) {
                return "encoded";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public ListMap<String, Json> claims() {
            return this.claims;
        }

        public Option<String> encoded() {
            return this.encoded;
        }

        @Override
        public JwtHeader withClaims(ListMap<String, Json> claims) {
            ListMap<String, Json> listMap = claims;
            ListMap<String, Json> listMap2 = this.claims();
            if (!(listMap != null ? !listMap.equals(listMap2) : listMap2 != null)) {
                return this;
            }
            return Jwt$JwtHeader$.MODULE$.apply(claims);
        }

        public JwtHeader withEncoded(String encoded) {
            return new JwtHeader(this.claims(), (Option<String>)Some$.MODULE$.apply((Object)encoded));
        }

        private JwtHeader copy(ListMap<String, Json> claims, Option<String> encoded) {
            throw new UnsupportedOperationException();
        }

        public JwtHeader copy(ListMap<String, Json> claims) {
            return this.withClaims((ListMap)claims);
        }

        public ListMap<String, Json> copy$default$1() {
            return this.claims();
        }

        @Override
        public JwtHeader reencode() {
            return Jwt$JwtHeader$.MODULE$.apply(this.claims());
        }

        @Override
        public String encode() {
            return (String)this.encoded().getOrElse(this::encode$$anonfun$1);
        }

        private Option<String> copy$default$2() {
            return this.encoded();
        }

        public ListMap<String, Json> _1() {
            return this.claims();
        }

        public Option<String> _2() {
            return this.encoded();
        }

        private final String encode$$anonfun$1() {
            JwtHeader jwtHeader = (JwtHeader)io.circe.syntax.package$.MODULE$.EncoderOps((Object)this);
            return package$.MODULE$.encodeBase64Url(package.EncoderOps$.MODULE$.asJson$extension((Object)jwtHeader, Jwt$JwtHeader$.MODULE$.codec()).noSpaces().getBytes(StandardCharsets.UTF_8));
        }
    }

    public static interface JwtHeaderClaims
    extends JwtComponent {
        public static void $init$(JwtHeaderClaims $this) {
        }

        public static Option typOption$(JwtHeaderClaims $this) {
            return $this.typOption();
        }

        default public Option<String> typOption() {
            return this.claim("typ", Decoder$.MODULE$.decodeString());
        }

        public static String typ$(JwtHeaderClaims $this) {
            return $this.typ();
        }

        default public String typ() {
            return (String)this.typOption().get();
        }

        public static Option algorithm$(JwtHeaderClaims $this) {
            return $this.algorithm();
        }

        default public Option<JwtAlgorithm> algorithm() {
            return this.claim("alg", Decoder$.MODULE$.decodeString()).flatMap((Function1 & Serializable)name -> JwtAlgorithm$.MODULE$.fromString((String)name));
        }

        public static JwtComponent withAlgorithm$(JwtHeaderClaims $this, Option algorithm) {
            return $this.withAlgorithm((Option<JwtAlgorithm>)algorithm);
        }

        default public JwtComponent withAlgorithm(Option<JwtAlgorithm> algorithm) {
            return this.withClaim("alg", Some$.MODULE$.apply((Object)JwtAlgorithm$.MODULE$.toString(algorithm)), Encoder$.MODULE$.encodeString());
        }

        public static Option contentType$(JwtHeaderClaims $this) {
            return $this.contentType();
        }

        default public Option<String> contentType() {
            return this.claim("cty", Decoder$.MODULE$.decodeString());
        }

        public static JwtComponent withContentType$(JwtHeaderClaims $this, Option contentType) {
            return $this.withContentType((Option<String>)contentType);
        }

        default public JwtComponent withContentType(Option<String> contentType) {
            return this.withClaim("cty", contentType, Encoder$.MODULE$.encodeString());
        }

        public static Option keyId$(JwtHeaderClaims $this) {
            return $this.keyId();
        }

        default public Option<String> keyId() {
            return this.claim("kid", Decoder$.MODULE$.decodeString());
        }

        public static JwtComponent withKeyId$(JwtHeaderClaims $this, Option keyId) {
            return $this.withKeyId((Option<String>)keyId);
        }

        default public JwtComponent withKeyId(Option<String> keyId) {
            return this.withClaim("kid", keyId, Encoder$.MODULE$.encodeString());
        }

        public static Option x509Url$(JwtHeaderClaims $this) {
            return $this.x509Url();
        }

        default public Option<String> x509Url() {
            return this.claim("x5u", Decoder$.MODULE$.decodeString());
        }

        public static JwtComponent withX509Url$(JwtHeaderClaims $this, Option x509Url) {
            return $this.withX509Url((Option<String>)x509Url);
        }

        default public JwtComponent withX509Url(Option<String> x509Url) {
            return this.withClaim("x5u", x509Url, Encoder$.MODULE$.encodeString());
        }

        public static Option x509CertificateChain$(JwtHeaderClaims $this) {
            return $this.x509CertificateChain();
        }

        default public Option<CertPath> x509CertificateChain() {
            LazyRef lazyRef = new LazyRef();
            return this.claim("x5c", Decoder$.MODULE$.decodeSeq(Decoder$.MODULE$.decodeString())).map((Function1 & Serializable)elems -> {
                scala.collection.immutable.Seq certs = (scala.collection.immutable.Seq)elems.map((Function1 & Serializable)certBase64 -> {
                    Either either = package.either$.MODULE$.catsSyntaxEither(package$.MODULE$.decodeBase64((String)certBase64));
                    byte[] certBytes = (byte[])EitherOps$.MODULE$.valueOr$extension(either, (Function1 & Serializable)_$4 -> {
                        throw _$4;
                    });
                    return this.certificateFactory$1(lazyRef).generateCertificate(new ByteArrayInputStream(certBytes));
                });
                return this.certificateFactory$1(lazyRef).generateCertPath(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)certs).asJava());
            });
        }

        public static JwtComponent withX509CertificateChain$(JwtHeaderClaims $this, Option x509CertificateChain) {
            return $this.withX509CertificateChain((Option<CertPath>)x509CertificateChain);
        }

        default public JwtComponent withX509CertificateChain(Option<CertPath> x509CertificateChain) {
            return this.withClaim("x5c", x509CertificateChain.map((Function1 & Serializable)_$5 -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(_$5.getCertificates()).asScala().map((Function1 & Serializable)cert -> package$.MODULE$.encodeBase64Padded(cert.getEncoded()))).toSeq()), Encoder$.MODULE$.encodeSeq(Encoder$.MODULE$.encodeString()));
        }

        public static Option x509CertificateSha1Thumbprint$(JwtHeaderClaims $this) {
            return $this.x509CertificateSha1Thumbprint();
        }

        default public Option<byte[]> x509CertificateSha1Thumbprint() {
            return this.claim("x5t", Decoder$.MODULE$.decodeString()).map((Function1 & Serializable)_$6 -> {
                Either either = package.either$.MODULE$.catsSyntaxEither(package$.MODULE$.decodeBase64Url((String)_$6));
                return (byte[])EitherOps$.MODULE$.valueOr$extension(either, (Function1 & Serializable)_$7 -> {
                    throw _$7;
                });
            });
        }

        public static JwtComponent withX509CertificateSha1Thumbprint$(JwtHeaderClaims $this, Option x509CertificateSha1Thumbprint) {
            return $this.withX509CertificateSha1Thumbprint((Option<byte[]>)x509CertificateSha1Thumbprint);
        }

        default public JwtComponent withX509CertificateSha1Thumbprint(Option<byte[]> x509CertificateSha1Thumbprint) {
            return this.withClaim("x5t", x509CertificateSha1Thumbprint.map((Function1 & Serializable)bytes -> package$.MODULE$.encodeBase64Url((byte[])bytes)), Encoder$.MODULE$.encodeString());
        }

        public static Option x509CertificateSha256Thumbprint$(JwtHeaderClaims $this) {
            return $this.x509CertificateSha256Thumbprint();
        }

        default public Option<byte[]> x509CertificateSha256Thumbprint() {
            return this.claim("x5t#S256", Decoder$.MODULE$.decodeString()).map((Function1 & Serializable)_$8 -> {
                Either either = package.either$.MODULE$.catsSyntaxEither(package$.MODULE$.decodeBase64Url((String)_$8));
                return (byte[])EitherOps$.MODULE$.valueOr$extension(either, (Function1 & Serializable)_$9 -> {
                    throw _$9;
                });
            });
        }

        public static JwtComponent withX509CertificateSha256Thumbprint$(JwtHeaderClaims $this, Option x509CertificateSha256Thumbprint) {
            return $this.withX509CertificateSha256Thumbprint((Option<byte[]>)x509CertificateSha256Thumbprint);
        }

        default public JwtComponent withX509CertificateSha256Thumbprint(Option<byte[]> x509CertificateSha256Thumbprint) {
            return this.withClaim("x5t#S256", x509CertificateSha256Thumbprint.map((Function1 & Serializable)bytes -> package$.MODULE$.encodeBase64Url((byte[])bytes)), Encoder$.MODULE$.encodeString());
        }

        private CertificateFactory certificateFactory$lzyINIT1$1(LazyRef certificateFactory$lzy1$1) {
            CertificateFactory certificateFactory;
            LazyRef lazyRef = certificateFactory$lzy1$1;
            synchronized (lazyRef) {
                certificateFactory = (CertificateFactory)(certificateFactory$lzy1$1.initialized() ? certificateFactory$lzy1$1.value() : certificateFactory$lzy1$1.initialize((Object)CertificateFactory.getInstance("X509")));
            }
            return certificateFactory;
        }

        private CertificateFactory certificateFactory$1(LazyRef certificateFactory$lzy1$2) {
            return (CertificateFactory)(certificateFactory$lzy1$2.initialized() ? certificateFactory$lzy1$2.value() : this.certificateFactory$lzyINIT1$1(certificateFactory$lzy1$2));
        }
    }

    public static class JwtPayload
    implements JwtComponent,
    JwtPayloadClaims,
    Product,
    Serializable {
        private Option issuer$lzy1;
        private boolean issuerbitmap$1;
        private Option subject$lzy1;
        private boolean subjectbitmap$1;
        private Option audience$lzy1;
        private boolean audiencebitmap$1;
        private Option expiration$lzy1;
        private boolean expirationbitmap$1;
        private Option notBefore$lzy1;
        private boolean notBeforebitmap$1;
        private Option issuedAt$lzy1;
        private boolean issuedAtbitmap$1;
        private Option jwtId$lzy1;
        private boolean jwtIdbitmap$1;
        private Option actor$lzy1;
        private boolean actorbitmap$1;
        private final ListMap claims;
        private final Option encoded;

        public static JwtPayload apply(ListMap<String, Json> listMap) {
            return Jwt$JwtPayload$.MODULE$.apply(listMap);
        }

        public static Codec<JwtPayload> codec() {
            return Jwt$JwtPayload$.MODULE$.codec();
        }

        public static JwtPayload fromProduct(Product product) {
            return Jwt$JwtPayload$.MODULE$.fromProduct(product);
        }

        public static JwtPayload unapply(JwtPayload jwtPayload) {
            return Jwt$JwtPayload$.MODULE$.unapply(jwtPayload);
        }

        public static ListMap<String, Json> apply$default$1() {
            return Jwt$JwtPayload$.MODULE$.apply$default$1();
        }

        public JwtPayload(ListMap<String, Json> claims, Option<String> encoded) {
            this.claims = claims;
            this.encoded = encoded;
            JwtPayloadClaims.$init$(this);
        }

        public Option issuer() {
            if (!this.issuerbitmap$1) {
                this.issuer$lzy1 = JwtPayloadClaims.issuer$(this);
                this.issuerbitmap$1 = true;
            }
            return this.issuer$lzy1;
        }

        public Option subject() {
            if (!this.subjectbitmap$1) {
                this.subject$lzy1 = JwtPayloadClaims.subject$(this);
                this.subjectbitmap$1 = true;
            }
            return this.subject$lzy1;
        }

        public Option audience() {
            if (!this.audiencebitmap$1) {
                this.audience$lzy1 = JwtPayloadClaims.audience$(this);
                this.audiencebitmap$1 = true;
            }
            return this.audience$lzy1;
        }

        public Option expiration() {
            if (!this.expirationbitmap$1) {
                this.expiration$lzy1 = JwtPayloadClaims.expiration$(this);
                this.expirationbitmap$1 = true;
            }
            return this.expiration$lzy1;
        }

        public Option notBefore() {
            if (!this.notBeforebitmap$1) {
                this.notBefore$lzy1 = JwtPayloadClaims.notBefore$(this);
                this.notBeforebitmap$1 = true;
            }
            return this.notBefore$lzy1;
        }

        public Option issuedAt() {
            if (!this.issuedAtbitmap$1) {
                this.issuedAt$lzy1 = JwtPayloadClaims.issuedAt$(this);
                this.issuedAtbitmap$1 = true;
            }
            return this.issuedAt$lzy1;
        }

        public Option jwtId() {
            if (!this.jwtIdbitmap$1) {
                this.jwtId$lzy1 = JwtPayloadClaims.jwtId$(this);
                this.jwtIdbitmap$1 = true;
            }
            return this.jwtId$lzy1;
        }

        public Option actor() {
            if (!this.actorbitmap$1) {
                this.actor$lzy1 = JwtPayloadClaims.actor$(this);
                this.actorbitmap$1 = true;
            }
            return this.actor$lzy1;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof JwtPayload)) return false;
            JwtPayload jwtPayload = (JwtPayload)object;
            ListMap<String, Json> listMap = this.claims();
            ListMap<String, Json> listMap2 = jwtPayload.claims();
            if (listMap == null) {
                if (listMap2 != null) {
                    return false;
                }
            } else if (!listMap.equals(listMap2)) return false;
            Option<String> option = this.encoded();
            Option<String> option2 = jwtPayload.encoded();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!jwtPayload.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof JwtPayload;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "JwtPayload";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "claims";
            }
            if (1 == n2) {
                return "encoded";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public ListMap<String, Json> claims() {
            return this.claims;
        }

        public Option<String> encoded() {
            return this.encoded;
        }

        @Override
        public JwtPayload withClaims(ListMap<String, Json> claims) {
            ListMap<String, Json> listMap = claims;
            ListMap<String, Json> listMap2 = this.claims();
            if (!(listMap != null ? !listMap.equals(listMap2) : listMap2 != null)) {
                return this;
            }
            return Jwt$JwtPayload$.MODULE$.apply(claims);
        }

        public JwtPayload withEncoded(String encoded) {
            return new JwtPayload(this.claims(), (Option<String>)Some$.MODULE$.apply((Object)encoded));
        }

        private JwtPayload copy(ListMap<String, Json> claims, Option<String> encoded) {
            throw new UnsupportedOperationException();
        }

        public JwtPayload copy(ListMap<String, Json> claims) {
            return this.withClaims((ListMap)claims);
        }

        public ListMap<String, Json> copy$default$1() {
            return this.claims();
        }

        @Override
        public JwtPayload reencode() {
            return Jwt$JwtPayload$.MODULE$.apply(this.claims());
        }

        @Override
        public String encode() {
            return (String)this.encoded().getOrElse(this::encode$$anonfun$2);
        }

        private Option<String> copy$default$2() {
            return this.encoded();
        }

        public ListMap<String, Json> _1() {
            return this.claims();
        }

        public Option<String> _2() {
            return this.encoded();
        }

        private final String encode$$anonfun$2() {
            JwtPayload jwtPayload = (JwtPayload)io.circe.syntax.package$.MODULE$.EncoderOps((Object)this);
            return package$.MODULE$.encodeBase64Url(package.EncoderOps$.MODULE$.asJson$extension((Object)jwtPayload, Jwt$JwtPayload$.MODULE$.codec()).noSpaces().getBytes(StandardCharsets.UTF_8));
        }
    }

    public static interface JwtPayloadClaims
    extends JwtComponent {
        public static void $init$(JwtPayloadClaims $this) {
        }

        public static Option issuer$(JwtPayloadClaims $this) {
            return $this.issuer();
        }

        default public Option<String> issuer() {
            return this.claim("iss", Decoder$.MODULE$.decodeString());
        }

        public static JwtComponent withIssuer$(JwtPayloadClaims $this, Option issuer) {
            return $this.withIssuer((Option<String>)issuer);
        }

        default public JwtComponent withIssuer(Option<String> issuer) {
            return this.withClaim("iss", issuer, Encoder$.MODULE$.encodeString());
        }

        public static Option subject$(JwtPayloadClaims $this) {
            return $this.subject();
        }

        default public Option<String> subject() {
            return this.claim("sub", Decoder$.MODULE$.decodeString());
        }

        public static JwtComponent withSubject$(JwtPayloadClaims $this, Option subject) {
            return $this.withSubject((Option<String>)subject);
        }

        default public JwtComponent withSubject(Option<String> subject) {
            return this.withClaim("sub", subject, Encoder$.MODULE$.encodeString());
        }

        public static Option audience$(JwtPayloadClaims $this) {
            return $this.audience();
        }

        default public Option<String> audience() {
            return this.claim("aud", Decoder$.MODULE$.decodeString());
        }

        public static JwtComponent withAudience$(JwtPayloadClaims $this, Option audience) {
            return $this.withAudience((Option<String>)audience);
        }

        default public JwtComponent withAudience(Option<String> audience) {
            return this.withClaim("aud", audience, Encoder$.MODULE$.encodeString());
        }

        public static Option expiration$(JwtPayloadClaims $this) {
            return $this.expiration();
        }

        default public Option<Instant> expiration() {
            return this.claim("exp", Decoder$.MODULE$.decodeLong()).map((Function1 & Serializable)x$0 -> this.expiration$$anonfun$1(BoxesRunTime.unboxToLong((Object)x$0)));
        }

        public static JwtComponent withExpiration$(JwtPayloadClaims $this, Option expiration) {
            return $this.withExpiration((Option<Instant>)expiration);
        }

        default public JwtComponent withExpiration(Option<Instant> expiration) {
            return this.withClaim("exp", expiration.map((Function1 & Serializable)_$12 -> _$12.getEpochSecond()), Encoder$.MODULE$.encodeLong());
        }

        public static Option notBefore$(JwtPayloadClaims $this) {
            return $this.notBefore();
        }

        default public Option<Instant> notBefore() {
            return this.claim("nbf", Decoder$.MODULE$.decodeLong()).map((Function1 & Serializable)x$0 -> this.notBefore$$anonfun$1(BoxesRunTime.unboxToLong((Object)x$0)));
        }

        public static JwtComponent withNotBefore$(JwtPayloadClaims $this, Option notBefore) {
            return $this.withNotBefore((Option<Instant>)notBefore);
        }

        default public JwtComponent withNotBefore(Option<Instant> notBefore) {
            return this.withClaim("nbf", notBefore.map((Function1 & Serializable)_$13 -> _$13.getEpochSecond()), Encoder$.MODULE$.encodeLong());
        }

        public static Option issuedAt$(JwtPayloadClaims $this) {
            return $this.issuedAt();
        }

        default public Option<Instant> issuedAt() {
            return this.claim("iat", Decoder$.MODULE$.decodeLong()).map((Function1 & Serializable)x$0 -> this.issuedAt$$anonfun$1(BoxesRunTime.unboxToLong((Object)x$0)));
        }

        public static JwtComponent withIssuedAt$(JwtPayloadClaims $this, Option issuedAt) {
            return $this.withIssuedAt((Option<Instant>)issuedAt);
        }

        default public JwtComponent withIssuedAt(Option<Instant> issuedAt) {
            return this.withClaim("iat", issuedAt.map((Function1 & Serializable)_$14 -> _$14.getEpochSecond()), Encoder$.MODULE$.encodeLong());
        }

        public static Option jwtId$(JwtPayloadClaims $this) {
            return $this.jwtId();
        }

        default public Option<String> jwtId() {
            return this.claim("jti", Decoder$.MODULE$.decodeString());
        }

        public static JwtComponent withJwtId$(JwtPayloadClaims $this, Option jwtId) {
            return $this.withJwtId((Option<String>)jwtId);
        }

        default public JwtComponent withJwtId(Option<String> jwtId) {
            return this.withClaim("jti", jwtId, Encoder$.MODULE$.encodeString());
        }

        public static Option actor$(JwtPayloadClaims $this) {
            return $this.actor();
        }

        default public Option<JwtPayload> actor() {
            return this.claim("act", Jwt$JwtPayload$.MODULE$.codec());
        }

        public static JwtComponent withActor$(JwtPayloadClaims $this, Option actor) {
            return $this.withActor((Option<JwtPayload>)actor);
        }

        default public JwtComponent withActor(Option<JwtPayload> actor) {
            return this.withClaim("act", actor, Jwt$JwtPayload$.MODULE$.codec());
        }

        private /* synthetic */ Instant expiration$$anonfun$1(long x$0) {
            return Instant.ofEpochSecond(x$0);
        }

        private /* synthetic */ Instant notBefore$$anonfun$1(long x$0) {
            return Instant.ofEpochSecond(x$0);
        }

        private /* synthetic */ Instant issuedAt$$anonfun$1(long x$0) {
            return Instant.ofEpochSecond(x$0);
        }
    }
}

