/*
 * Decompiled with CFR 0.152.
 */
package de.lhns.jwt;

import de.lhns.jwt.JwtAlgorithm;
import de.lhns.jwt.JwtAlgorithm$;
import java.time.Instant;
import java.time.ZoneId;
import scala.Option;

public class JwtValidationException
extends RuntimeException {
    public JwtValidationException(String message, Throwable cause) {
        super(message, cause);
    }

    public JwtValidationException(String message) {
        this(message, null);
    }

    public static class JwtEmptyAudienceException
    extends JwtValidationException {
        public JwtEmptyAudienceException() {
            super("The token does not contain an audience.");
        }
    }

    public static class JwtEmptyExpirationException
    extends JwtValidationException {
        public JwtEmptyExpirationException() {
            super("The token does not contain an expiration.");
        }
    }

    public static class JwtEmptyIssuedAtException
    extends JwtValidationException {
        public JwtEmptyIssuedAtException() {
            super("The token does not contain when it was issued.");
        }
    }

    public static class JwtEmptyIssuerException
    extends JwtValidationException {
        public JwtEmptyIssuerException() {
            super("The token does not contain an issuer.");
        }
    }

    public static class JwtEmptyJwtIdException
    extends JwtValidationException {
        public JwtEmptyJwtIdException() {
            super("The token does not contain a jwt id.");
        }
    }

    public static class JwtEmptyNotBeforeException
    extends JwtValidationException {
        public JwtEmptyNotBeforeException() {
            super("The token does not contain when it will be valid.");
        }
    }

    public static class JwtEmptySubjectException
    extends JwtValidationException {
        public JwtEmptySubjectException() {
            super("The token does not contain a subject.");
        }
    }

    public static class JwtExpirationException
    extends JwtValidationException {
        public JwtExpirationException(Instant expiration) {
            super(new StringBuilder(27).append("The token is expired since ").append(expiration.atZone(ZoneId.systemDefault())).toString());
        }
    }

    public static class JwtInvalidAlgorithmException
    extends JwtValidationException {
        public JwtInvalidAlgorithmException(Option<JwtAlgorithm> algorithm) {
            super(new StringBuilder(36).append("The token has an invalid algorithm: ").append(JwtAlgorithm$.MODULE$.toString(algorithm)).toString());
        }
    }

    public static class JwtInvalidSignatureException
    extends JwtValidationException {
        public JwtInvalidSignatureException() {
            super("The token signature is not valid.");
        }
    }

    public static class JwtNotBeforeException
    extends JwtValidationException {
        public JwtNotBeforeException(Instant notBefore) {
            super(new StringBuilder(35).append("The token will only be valid after ").append(notBefore.atZone(ZoneId.systemDefault())).toString());
        }
    }
}

