/*
 * Decompiled with CFR 0.152.
 */
package de.lhns.jwt;

import cats.Functor;
import cats.Monad;
import cats.Monad$;
import cats.NotNull$;
import cats.data.EitherT$;
import cats.effect.kernel.Clock;
import cats.effect.kernel.Sync;
import cats.kernel.Monoid;
import cats.syntax.EitherObjectOps$;
import cats.syntax.EitherSyntax;
import cats.syntax.package;
import de.lhns.jwt.Jwt;
import de.lhns.jwt.JwtAlgorithm;
import de.lhns.jwt.JwtValidationException;
import de.lhns.jwt.JwtValidationOptions;
import de.lhns.jwt.JwtValidationOptions$;
import de.lhns.jwt.JwtVerifier;
import de.lhns.jwt.JwtVerifier$;
import de.lhns.jwt.SignedJwt;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;

public final class JwtVerifier$
implements Serializable {
    public static final JwtVerifier$ MODULE$ = new JwtVerifier$();

    private JwtVerifier$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JwtVerifier$.class);
    }

    public <F> Monoid<JwtVerifier<F>> monoid(Monad<F> evidence$1) {
        return new Monoid<JwtVerifier<F>>(evidence$1, this){
            public final Monad de$lhns$jwt$JwtVerifier$$anon$1$$evidence$1$1;
            {
                this.de$lhns$jwt$JwtVerifier$$anon$1$$evidence$1$1 = evidence$1$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public JwtVerifier empty() {
                return new JwtVerifier<F>(this){
                    private final /* synthetic */ anon.1 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public Object verify(SignedJwt signedJwt) {
                        return Monad$.MODULE$.apply(this.$outer.de$lhns$jwt$JwtVerifier$$anon$1$$evidence$1$1).pure((Object)package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
                    }
                };
            }

            public JwtVerifier combine(JwtVerifier x, JwtVerifier y) {
                return new JwtVerifier<F>(x, y, this){
                    private final JwtVerifier x$1;
                    private final JwtVerifier y$1;
                    private final /* synthetic */ anon.1 $outer;
                    {
                        this.x$1 = x$2;
                        this.y$1 = y$2;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public Object verify(SignedJwt signedJwt) {
                        return EitherT$.MODULE$.apply(this.x$1.verify(signedJwt)).flatMapF((Function1 & Serializable)_$3 -> this.y$1.verify(signedJwt), this.$outer.de$lhns$jwt$JwtVerifier$$anon$1$$evidence$1$1).value();
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{verify$$anonfun$1(de.lhns.jwt.SignedJwt scala.runtime.BoxedUnit )}, serializedLambda);
                    }
                };
            }
        };
    }

    public <F> JwtVerifier<F> apply(Function1<SignedJwt, Object> verifier, Monad<F> evidence$1) {
        return new JwtVerifier<F>(verifier, this){
            private final Function1 verifier$1;
            {
                this.verifier$1 = verifier$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public Object verify(SignedJwt signedJwt) {
                return this.verifier$1.apply((Object)signedJwt);
            }
        };
    }

    public <F> JwtVerifier<F> delay(Function1<SignedJwt, Either<Throwable, BoxedUnit>> verifier, Sync<F> evidence$1) {
        return new JwtVerifier<F>(evidence$1, verifier, this){
            private final Sync evidence$1$2;
            private final Function1 verifier$2;
            {
                this.evidence$1$2 = evidence$1$5;
                this.verifier$2 = verifier$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public Object verify(SignedJwt signedJwt) {
                return cats.effect.package$.MODULE$.Sync().apply(this.evidence$1$2).delay(() -> this.verify$$anonfun$2(signedJwt));
            }

            private final Either verify$$anonfun$2(SignedJwt signedJwt$2) {
                return (Either)this.verifier$2.apply((Object)signedJwt$2);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{verify$$anonfun$2(de.lhns.jwt.SignedJwt )}, serializedLambda);
            }
        };
    }

    public <F> JwtVerifier<F> basicVerifier(Seq<JwtAlgorithm> algorithms, JwtValidationOptions options, Monad<F> evidence$1, Clock<F> evidence$2) {
        return this.apply((Function1<SignedJwt, Object>)(Function1 & Serializable)signedJwt -> package.all$.MODULE$.toFunctorOps(((Clock)Predef$.MODULE$.implicitly((Object)evidence$2)).realTime(), (Functor)evidence$1).map((Function1 & Serializable)now -> {
            boolean bl = EitherObjectOps$.MODULE$.catchOnly$extension(package.all$.MODULE$.catsSyntaxEitherObject(package$.MODULE$.Either()));
            return EitherSyntax.CatchOnlyPartiallyApplied$.MODULE$.apply$extension(bl, (Function0 & Serializable)() -> {
                this.basicVerifier$$anonfun$1$$anonfun$1$$anonfun$1((SignedJwt)signedJwt, options, (FiniteDuration)now, (Seq)algorithms);
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.apply(JwtValidationException.class), NotNull$.MODULE$.catsNotNullForA());
        }), evidence$1);
    }

    public <F> JwtValidationOptions basicVerifier$default$2() {
        return JwtValidationOptions$.MODULE$.default();
    }

    private void validateRequired(Jwt.JwtPayload payload, JwtValidationOptions options) {
        if (options.requireIssuer() && payload.issuer().isEmpty()) {
            throw new JwtValidationException.JwtEmptyIssuerException();
        }
        if (options.requireSubject() && payload.subject().isEmpty()) {
            throw new JwtValidationException.JwtEmptySubjectException();
        }
        if (options.requireAudience() && payload.audience().isEmpty()) {
            throw new JwtValidationException.JwtEmptyAudienceException();
        }
        if (options.requireExpiration() && payload.expiration().isEmpty()) {
            throw new JwtValidationException.JwtEmptyExpirationException();
        }
        if (options.requireNotBefore() && payload.notBefore().isEmpty()) {
            throw new JwtValidationException.JwtEmptyNotBeforeException();
        }
        if (options.requireIssuedAt() && payload.issuedAt().isEmpty()) {
            throw new JwtValidationException.JwtEmptyIssuedAtException();
        }
        if (options.requireJwtId() && payload.jwtId().isEmpty()) {
            throw new JwtValidationException.JwtEmptyJwtIdException();
        }
    }

    private void validateTiming(Jwt.JwtPayload payload, Instant now, JwtValidationOptions options) {
        long leewayMillis = options.leeway().toMillis();
        if (options.validateExpiration()) {
            payload.expiration().filterNot((Function1 & Serializable)expiration -> now.isBefore(expiration.plusMillis(leewayMillis))).foreach((Function1 & Serializable)expiration -> {
                throw new JwtValidationException.JwtExpirationException((Instant)expiration);
            });
        }
        if (options.validateNotBefore()) {
            payload.notBefore().filter((Function1 & Serializable)notBefore -> now.isBefore(notBefore.minusMillis(leewayMillis))).foreach((Function1 & Serializable)notBefore -> {
                throw new JwtValidationException.JwtNotBeforeException((Instant)notBefore);
            });
            return;
        }
    }

    private void validateAlgorithm(Jwt.JwtHeader header, Seq<JwtAlgorithm> algorithms, JwtValidationOptions options) {
        if (!this.isEmptyAlgorithmValid$1(options, header) && !this.isAlgorithmValid$1(header, algorithms)) {
            throw new JwtValidationException.JwtInvalidAlgorithmException((Option<JwtAlgorithm>)header.algorithm());
        }
    }

    private final void basicVerifier$$anonfun$1$$anonfun$1$$anonfun$1(SignedJwt signedJwt$4, JwtValidationOptions options$3, FiniteDuration now$1, Seq algorithms$3) {
        this.validateRequired(signedJwt$4.payload(), options$3);
        this.validateTiming(signedJwt$4.payload(), Instant.ofEpochMilli(now$1.toMillis()), options$3);
        this.validateAlgorithm(signedJwt$4.header(), (Seq<JwtAlgorithm>)algorithms$3, options$3);
    }

    private final boolean isEmptyAlgorithmValid$1(JwtValidationOptions options$4, Jwt.JwtHeader header$1) {
        return !options$4.requireAlgorithm() && header$1.algorithm().isEmpty();
    }

    private final boolean isAlgorithmValid$1(Jwt.JwtHeader header$2, Seq algorithms$4) {
        return header$2.algorithm().exists((Function1 & Serializable)elem -> algorithms$4.contains(elem));
    }
}

