/*
 * Decompiled with CFR 0.152.
 */
package de.lhns.jwt;

import cats.Monad;
import cats.Monad$;
import cats.NotNull$;
import cats.syntax.EitherObjectOps$;
import cats.syntax.EitherOps$;
import cats.syntax.EitherSyntax;
import cats.syntax.package;
import de.lhns.jwt.Jwt;
import de.lhns.jwt.JwtSigner;
import de.lhns.jwt.JwtSigner$;
import de.lhns.jwt.JwtVerifier;
import de.lhns.jwt.JwtVerifier$;
import de.lhns.jwt.SignedJwt;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class JwtCertPath$
implements Serializable {
    private static final Function1 defaultPkixParameters;
    public static final JwtCertPath$ MODULE$;

    private JwtCertPath$() {
    }

    static {
        MODULE$ = new JwtCertPath$();
        defaultPkixParameters = (Function1 & Serializable)_$5 -> {
            this.$init$$$anonfun$1((PKIXParameters)_$5);
            return BoxedUnit.UNIT;
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JwtCertPath$.class);
    }

    public <F> JwtVerifier<F> verifier(KeyStore keyStore, Function1<PublicKey, JwtVerifier<F>> verifier, Function1<PKIXParameters, BoxedUnit> pkixParameters, Monad<F> evidence$1) {
        return JwtVerifier$.MODULE$.apply((Function1<SignedJwt, Object>)(Function1 & Serializable)signedJwt -> {
            Option option = signedJwt.header().x509CertificateChain().map((Function1 & Serializable)_$2 -> MODULE$.validateCertPath((CertPath)_$2, keyStore, pkixParameters));
            if (option instanceof Some) {
                Either either = (Either)((Some)option).value();
                if (either instanceof Right) {
                    PKIXCertPathValidatorResult result = (PKIXCertPathValidatorResult)((Right)either).value();
                    return ((JwtVerifier)verifier.apply((Object)result.getPublicKey())).verify((SignedJwt)signedJwt);
                }
                if (either instanceof Left) {
                    CertPathValidatorException throwable = (CertPathValidatorException)((Left)either).value();
                    return Monad$.MODULE$.apply(evidence$1).pure((Object)package$.MODULE$.Left().apply((Object)throwable));
                }
            }
            if (None$.MODULE$.equals(option)) {
                return Monad$.MODULE$.apply(evidence$1).pure((Object)package$.MODULE$.Left().apply((Object)new IllegalArgumentException("x5c claim required for cert validation")));
            }
            throw new MatchError((Object)option);
        }, evidence$1);
    }

    public <F> Function1<PKIXParameters, BoxedUnit> verifier$default$3() {
        return this.defaultPkixParameters();
    }

    public <F> JwtSigner<F> signer(CertPath certPath, JwtSigner<F> signer) {
        return JwtSigner$.MODULE$.apply((Function1<Jwt, Object>)(Function1 & Serializable)jwt -> signer.sign(jwt.modifyHeader((Function1<Jwt.JwtHeader, Jwt.JwtHeader>)(Function1 & Serializable)_$4 -> (Jwt.JwtHeader)_$4.withX509CertificateChain((Option)Some$.MODULE$.apply((Object)certPath)))));
    }

    public Function1<PKIXParameters, BoxedUnit> defaultPkixParameters() {
        return defaultPkixParameters;
    }

    private Either<CertPathValidatorException, PKIXCertPathValidatorResult> validateCertPath(CertPath certPath, KeyStore keyStore, Function1<PKIXParameters, BoxedUnit> pkixParameters) {
        CertPathValidator validator = CertPathValidator.getInstance("PKIX");
        boolean bl = EitherObjectOps$.MODULE$.catchOnly$extension(package.all$.MODULE$.catsSyntaxEitherObject(package$.MODULE$.Either()));
        Either either = package.all$.MODULE$.catsSyntaxEither(EitherSyntax.CatchOnlyPartiallyApplied$.MODULE$.apply$extension(bl, () -> JwtCertPath$.validateCertPath$$anonfun$1(keyStore), ClassTag$.MODULE$.apply(InvalidAlgorithmParameterException.class), NotNull$.MODULE$.catsNotNullForA()));
        return EitherOps$.MODULE$.leftMap$extension(either, (Function1 & Serializable)_$6 -> new CertPathValidatorException((Throwable)_$6)).flatMap((Function1 & Serializable)params -> {
            pkixParameters.apply(params);
            boolean bl = EitherObjectOps$.MODULE$.catchOnly$extension(package.all$.MODULE$.catsSyntaxEitherObject(package$.MODULE$.Either()));
            return EitherSyntax.CatchOnlyPartiallyApplied$.MODULE$.apply$extension(bl, () -> JwtCertPath$.validateCertPath$$anonfun$3$$anonfun$1(validator, certPath, params), ClassTag$.MODULE$.apply(CertPathValidatorException.class), NotNull$.MODULE$.catsNotNullForA());
        });
    }

    private Function1<PKIXParameters, BoxedUnit> validateCertPath$default$3() {
        return this.defaultPkixParameters();
    }

    private final /* synthetic */ void $init$$$anonfun$1(PKIXParameters _$5) {
        _$5.setRevocationEnabled(false);
    }

    private static final PKIXParameters validateCertPath$$anonfun$1(KeyStore keyStore$3) {
        return new PKIXParameters(keyStore$3);
    }

    private static final PKIXCertPathValidatorResult validateCertPath$$anonfun$3$$anonfun$1(CertPathValidator validator$2, CertPath certPath$4, PKIXParameters params$1) {
        return (PKIXCertPathValidatorResult)validator$2.validate(certPath$4, params$1);
    }
}

